/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.web.basedata.fetchconfig;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.swc.hsbp.business.cal.helper.FormulaHelper;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;
import kd.swc.hsbs.opplugin.validator.basedata.fetchconfig.FetchItemValidator;
import kd.swc.hsbs.opplugin.validator.migrationtpl.MigrationQuoteCheckValidator;

public class FetchItemSaveOp
extends SWCDataBaseOp {
    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new FetchItemValidator());
        args.addValidator((AbstractValidator)new MigrationQuoteCheckValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("uniquecode");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        DynamicObject[] dynamicObjects;
        for (DynamicObject dynamicObject : dynamicObjects = args.getDataEntities()) {
            String number = dynamicObject.getString("number");
            String uniqueCode = "FT_" + number;
            dynamicObject.set("uniquecode", (Object)uniqueCode);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        DynamicObject[] datas = args.getDataEntities();
        Map<Long, String> dataMap = Arrays.stream(datas).filter(data -> data.getLong("id") != 0L).collect(Collectors.toMap(data -> data.getLong("id"), data -> data.getString("name")));
        HashMap uniqueCodeRelMap = new HashMap(16);
        Map changeMap = FormulaHelper.getChangeMap(dataMap, (String)"FT", uniqueCodeRelMap);
        if (!changeMap.isEmpty()) {
            FormulaHelper.updateCalElementName((Map)changeMap, uniqueCodeRelMap, (String)"FT");
        }
    }
}

