/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.web.basedata.paysubject;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.swc.hsbp.business.paysubject.PaySubjectLawHelper;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;
import kd.swc.hsbs.opplugin.validator.basedata.paysubject.PaySubjectPayOrgValidator;
import kd.swc.hsbs.opplugin.validator.basedata.paysubject.PaySubjectSaveValidator;

public class PaySubjectSaveOp
extends SWCDataBaseOp {
    private static final String LAW_ENTITY = "lawentity";
    private static final String CASHINTERGRATION = "cashintergration";

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("payorgent.applicationscope");
        fieldKeys.add("payorgent.salaryitemmul");
        fieldKeys.add("payorgent.paymethodmul");
        fieldKeys.add("payorgent.currencymul");
        fieldKeys.add("payorgent.bankpurposemul");
        fieldKeys.add("payorgent.agentpayorg");
        fieldKeys.add("payorgent.isdefault");
        fieldKeys.add("payorgent.agentpayaccount");
        fieldKeys.add("payorgent.agentpaybank");
        fieldKeys.add("payorgent.seq");
        fieldKeys.add(CASHINTERGRATION);
        fieldKeys.add(LAW_ENTITY);
        fieldKeys.add("boid");
        fieldKeys.add("bsed");
        fieldKeys.add("bsled");
        fieldKeys.add(LAW_ENTITY);
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new PaySubjectSaveValidator());
        args.addValidator((AbstractValidator)new PaySubjectPayOrgValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        DynamicObject[] entities;
        String opKey = args.getOperationKey();
        DynamicObject[] dataEntities = args.getDataEntities();
        if ("confirmchange".equals(opKey)) {
            try {
                this.invokeService(dataEntities);
            }
            catch (Exception exception) {
                this.dealWithErrorMsg(opKey, args, "EnterpriseRelCorporateOrgOp exception:" + exception.getMessage());
                return;
            }
        }
        for (DynamicObject entity : entities = args.getDataEntities()) {
            DynamicObjectCollection payorgents = entity.getDynamicObjectCollection("payorgent");
            for (DynamicObject payorgentInfo : payorgents) {
                boolean isDefault = payorgentInfo.getBoolean("isdefault");
                if (!isDefault) continue;
                payorgentInfo.set("applicationscope", null);
                payorgentInfo.set("salaryitemmul", null);
                payorgentInfo.set("paymethodmul", null);
                payorgentInfo.set("currencymul", null);
                payorgentInfo.set("bankpurposemul", null);
            }
        }
    }

    private void invokeService(DynamicObject[] dataEntities) {
        ArrayList<Long> ids = new ArrayList<Long>(10);
        for (DynamicObject dataEntity : dataEntities) {
            ids.add(dataEntity.getLong("boid"));
        }
        PaySubjectLawHelper.relLawEntity((DynamicObject[])dataEntities, ids);
    }

    private void dealWithErrorMsg(String opKey, BeforeOperationArgs args, String msg) {
        if ("confirmchange".equals(opKey)) {
            String errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u652f\u4ed8\u4e3b\u4f53\u786e\u8ba4\u53d8\u66f4\u64cd\u4f5c\u5931\u8d25\uff1a\u201c%s\u201d", (String)"PaySubjectCorporateOrgOp_0", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), msg);
            this.operationResult.setMessage(errorMsg);
        }
        this.operationResult.setShowMessage(true);
        this.operationResult.setSuccess(false);
        args.setCancel(true);
    }
}

