/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.web.basedata.salaryparameter;

import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCSalaryParameterServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;

public class SalarySlipParameterSaveOp
extends SWCDataBaseOp {
    private static final String FAIL = "fail";
    private static final String NORMAL = "0";

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        String operationKey = args.getOperationKey();
        if ("save".equals(operationKey)) {
            OperateOption option = this.getOption();
            Long nodeId = Long.parseLong(option.getVariableValue("id"));
            HashMap<String, String> paramMap = SWCSalaryParameterServiceHelper.getSalaryParam((long)nodeId);
            if (paramMap == null) {
                paramMap = new HashMap<String, String>(16);
            }
            DynamicObject dynamicObject = args.getDataEntities()[0];
            String encryptLevel = dynamicObject.getString("encryptlevelgroup");
            paramMap.put("encryptlevel", encryptLevel);
            if (NORMAL.equals(encryptLevel)) {
                this.clearSecretKey();
            }
            SWCSalaryParameterServiceHelper.setSalaryParam((long)nodeId, paramMap);
            this.deleteHSPPSalarySlipData(args);
        }
    }

    private void clearSecretKey() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_secretkey");
        DynamicObject dynamicObject = helper.queryOne("secretkey,modifytime", new QFilter[0]);
        if (dynamicObject != null) {
            helper.deleteOne((Object)dynamicObject);
        }
    }

    private void deleteHSPPSalarySlipData(BeginOperationTransactionArgs args) {
        String resultString = (String)SWCMServiceUtils.invokeSWCService((String)"hspp", (String)"IHSPPService", (String)"clearSalaryByFieldParam", (Object[])new Object[0]);
        if (resultString.equals(FAIL)) {
            args.setCancelOperation(true);
            return;
        }
        this.setReleaseCancel();
        String updateSalarySlipSql = "update T_HSAS_SALARYSLIP set FISSEND = '4' , FMODIFYTIME = ? where FISSEND = '1';";
        SWCDbUtil.update((DBRoute)SWCConstants.SWC_ROUETE, (String)updateSalarySlipSql, (Object[])new Object[]{new Date()});
        String updateCalTableSql = "update T_HSAS_CALPERSON_S set FSALARYSTATUS = '5' where FSALARYSTATUS = '4'";
        SWCDbUtil.update((DBRoute)SWCConstants.SWC_ROUETE, (String)updateCalTableSql, (Object[])new Object[0]);
    }

    private void setReleaseCancel() {
        DynamicObject[] dyobjs;
        SWCDataServiceHelper calRecordHelper = new SWCDataServiceHelper("hsas_calsalarysliprecord");
        QFilter filter = new QFilter("salarystatus", "=", (Object)"1");
        for (DynamicObject dynamicObject : dyobjs = calRecordHelper.query("id", new QFilter[]{filter})) {
            Long recordId = dynamicObject.getLong("id");
            ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CAL_SALARY_%s", recordId));
            appCache.put(String.format(Locale.ROOT, "isCancel_%s", recordId), (Object)Boolean.TRUE);
        }
    }
}

