/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.web.basedata.salaryparameter;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.swc.hsbp.business.servicehelper.SWCSalaryParameterServiceHelper;
import kd.swc.hsbp.common.util.SWCInteDateTimeUtil;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;

public class SalaryTaxParamSaveOp
extends SWCDataBaseOp {
    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        RefObject id;
        OperateOption option;
        super.beginOperationTransaction(args);
        String operationKey = args.getOperationKey();
        if ("save".equals(operationKey) && (option = this.getOption()).tryGetVariableValue("id", id = new RefObject())) {
            Long nodeId = Long.parseLong((String)id.getValue());
            this.saveCountryTaxInfo(args, nodeId);
        }
    }

    private void saveCountryTaxInfo(BeginOperationTransactionArgs args, Long nodeId) {
        DynamicObject dynamicObject = args.getDataEntities()[0];
        DynamicObjectCollection countryDatas = dynamicObject.getDynamicObjectCollection("countryentryentity");
        HashMap paramMap = new HashMap(16);
        if (countryDatas == null || countryDatas.size() == 0) {
            SWCSalaryParameterServiceHelper.setSalaryParam((long)nodeId, paramMap);
            return;
        }
        Map oldDataMap = SWCSalaryParameterServiceHelper.getSalaryParam((long)nodeId);
        ArrayList<HashMap<String, Object>> countryList = new ArrayList<HashMap<String, Object>>(countryDatas.size());
        for (DynamicObject countryObj : countryDatas) {
            HashMap<String, Object> countryMap = new HashMap<String, Object>(16);
            long countryId = countryObj.getLong("countryid");
            countryMap.put("countryId", countryId);
            String countryNumber = countryObj.getString("countrynumber");
            countryMap.put("countryNumber", countryNumber);
            String countryName = countryObj.getString("countryname");
            countryMap.put("countryName", countryName);
            boolean enableTaxCal = countryObj.getBoolean("opentaxcal");
            countryMap.put("enableTaxCal", enableTaxCal);
            this.setOperatorInfo(oldDataMap, countryMap, countryObj);
            countryMap.put("taxCalModel", "0");
            countryList.add(countryMap);
        }
        paramMap.put("countryInfo", countryList);
        SWCSalaryParameterServiceHelper.setSalaryParam((long)nodeId, paramMap);
    }

    private void setOperatorInfo(Map<String, Object> oldDataMap, Map<String, Object> countryMap, DynamicObject countryObj) {
        if (oldDataMap == null || oldDataMap.size() == 0) {
            countryMap.put("operatorId", RequestContext.get().getCurrUserId());
            countryMap.put("operateTime", SWCInteDateTimeUtil.formatTimeWithUserZone((Date)new Date()));
            return;
        }
        List oldDataList = (List)oldDataMap.get("countryInfo");
        if (oldDataList == null || oldDataList.size() == 0) {
            countryMap.put("operatorId", RequestContext.get().getCurrUserId());
            countryMap.put("operateTime", SWCInteDateTimeUtil.formatTimeWithUserZone((Date)new Date()));
            return;
        }
        boolean newEnableTaxCal = countryObj.getBoolean("opentaxcal");
        long countryId = countryObj.getLong("countryid");
        Map<String, Object> oldCountryMap = this.getOldCountryDataByCountryId(countryId, oldDataList);
        if (oldCountryMap == null || oldCountryMap.size() == 0) {
            countryMap.put("operatorId", RequestContext.get().getCurrUserId());
            countryMap.put("operateTime", SWCInteDateTimeUtil.formatTimeWithUserZone((Date)new Date()));
            return;
        }
        boolean oldEnableTaxCal = (Boolean)oldCountryMap.get("enableTaxCal");
        boolean isChange = this.judgementBooleanEquals(newEnableTaxCal, oldEnableTaxCal);
        if (isChange) {
            countryMap.put("operatorId", oldCountryMap.get("operatorId"));
            countryMap.put("operateTime", oldCountryMap.get("operateTime"));
        } else {
            countryMap.put("operatorId", RequestContext.get().getCurrUserId());
            countryMap.put("operateTime", SWCInteDateTimeUtil.formatTimeWithUserZone((Date)new Date()));
        }
    }

    private boolean judgementBooleanEquals(boolean newEnableTaxCal, boolean oldEnableTaxCal) {
        if (newEnableTaxCal) {
            return oldEnableTaxCal;
        }
        return !oldEnableTaxCal;
    }

    private Map<String, Object> getOldCountryDataByCountryId(long newCountryId, List<Map<String, Object>> oldDataList) {
        for (Map<String, Object> oldDataMap : oldDataList) {
            Object oldCountryIdObj = oldDataMap.get("countryId");
            long oldCountryId = 0L;
            if (oldCountryIdObj instanceof Long) {
                oldCountryId = (Long)oldCountryIdObj;
            } else if (oldCountryIdObj instanceof Integer) {
                oldCountryId = Long.parseLong(String.valueOf(oldCountryIdObj));
            }
            if (oldCountryId != newCountryId) continue;
            return oldDataMap;
        }
        return null;
    }
}

