/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.web.basedata.schedule;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;
import kd.swc.hsbs.opplugin.validator.basedata.schedule.SchConfigValidator;

public class SchConfigAuditOp
extends SWCDataBaseOp {
    private static final String KEY_SCHEDULE = "schedule";
    private static final String SCH_SCHEDULE = "sch_schedule";
    private static final Log logger = LogFactory.getLog(SchConfigAuditOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        List fieldKeys = evt.getFieldKeys();
        fieldKeys.add(KEY_SCHEDULE);
        fieldKeys.add("status");
        fieldKeys.add("enable");
    }

    public void onAddValidators(AddValidatorsEventArgs evt) {
        evt.addValidator((AbstractValidator)new SchConfigValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs evt) {
        DynamicObject[] dataEntities = evt.getDataEntities();
        if (dataEntities == null) {
            return;
        }
        String operationKey = evt.getOperationKey();
        if ("audit".equals(operationKey)) {
            for (DynamicObject dataEntity : dataEntities) {
                dataEntity.set("enable", (Object)"1");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterExecuteOperationTransaction(AfterOperationArgs evt) {
        boolean isEnableSch;
        super.afterExecuteOperationTransaction(evt);
        String operationKey = evt.getOperationKey();
        DynamicObject[] dataEntities = evt.getDataEntities();
        if (dataEntities == null) {
            return;
        }
        Set<String> scheduleIds = new HashSet(dataEntities.length);
        boolean bl = isEnableSch = "audit".equals(operationKey) || "enable".equals(operationKey);
        if (isEnableSch) {
            for (DynamicObject dataEntity2 : dataEntities) {
                if (!"C".equals(dataEntity2.getString("status")) || !"1".equals(dataEntity2.getString("enable"))) continue;
                scheduleIds.add(dataEntity2.getString(KEY_SCHEDULE));
            }
        } else {
            scheduleIds = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getString(KEY_SCHEDULE)).collect(Collectors.toCollection(() -> new HashSet(16)));
        }
        try (TXHandle txHandle = TX.requiresNew();){
            SWCDataServiceHelper helper = new SWCDataServiceHelper(SCH_SCHEDULE);
            DynamicObject[] schDys = helper.query("id, status", new QFilter[]{new QFilter("id", "in", scheduleIds)});
            if (isEnableSch) {
                Arrays.stream(schDys).forEach(schDy -> schDy.set("status", (Object)"1"));
            } else if ("unaudit".equals(operationKey) || "disable".equals(operationKey)) {
                Arrays.stream(schDys).forEach(schDy -> schDy.set("status", (Object)"0"));
            }
            helper.save(schDys);
        }
    }
}

