/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.web.basedata.schedule;

import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;

public class SchConfigDeleteOp
extends SWCDataBaseOp {
    private static final Log logger = LogFactory.getLog(SchConfigDeleteOp.class);
    private static final String KEY_SCHEDULE = "schedule";

    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        List fieldKeys = evt.getFieldKeys();
        fieldKeys.add(KEY_SCHEDULE);
        fieldKeys.add("enable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterExecuteOperationTransaction(AfterOperationArgs evt) {
        super.afterExecuteOperationTransaction(evt);
        DynamicObject[] dataEntities = evt.getDataEntities();
        HashSet<String> scheduleIds = new HashSet<String>(16);
        for (DynamicObject dataEntity : dataEntities) {
            scheduleIds.add(dataEntity.getString(KEY_SCHEDULE));
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("sch_schedule");
        DynamicObjectCollection schDyColl = helper.queryOriginalCollection("id,job.id", new QFilter[]{new QFilter("id", "in", scheduleIds)});
        HashSet<String> jobIds = new HashSet<String>(16);
        if (schDyColl != null && !schDyColl.isEmpty()) {
            for (DynamicObject schDy : schDyColl) {
                jobIds.add(schDy.getString("job.id"));
            }
        }
        try (TXHandle txHandle = TX.requiresNew();){
            helper.delete(scheduleIds.toArray());
            new SWCDataServiceHelper("sch_job").delete(jobIds.toArray());
        }
    }
}

