/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.web.basedata.statisticstag;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;
import kd.swc.hsbs.business.statistictag.StatisticsTagHelper;
import kd.swc.hsbs.opplugin.validator.basedata.statisticstag.StatisticsTagSaveValidator;

public class StatisticsTagSaveOp
extends SWCDataBaseOp {
    private static final String KEY_LONG_NUMBER = "longnumber";
    private static final String KEY_FULL_NAME = "fullname";
    private static final String KEY_PARENT_TAG = "parent";
    private static final String KEY_IS_LEAF = "isleaf";

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add(KEY_LONG_NUMBER);
        fieldKeys.add("taglevel.level");
        fieldKeys.add("level");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new StatisticsTagSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        super.beforeExecuteOperationTransaction(args);
        DynamicObject[] dataEntities = args.getDataEntities();
        if ("save".equals(args.getOperationKey())) {
            for (DynamicObject dynamicObject : dataEntities) {
                if (dynamicObject.getInt("taglevel.level") == 1) {
                    dynamicObject.set(KEY_PARENT_TAG, null);
                }
                dynamicObject.set("level", (Object)dynamicObject.getInt("taglevel.level"));
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        if ("save".equals(args.getOperationKey())) {
            this.setParentTag(args);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        if ("delete".equals(args.getOperationKey())) {
            for (DynamicObject data : args.getDataEntities()) {
                StatisticsTagHelper.removeCache((String)data.getString(KEY_LONG_NUMBER));
            }
        }
    }

    private void setParentTag(EndOperationTransactionArgs args) {
        DynamicObject[] affectedTags;
        HashMap<Long, String> parentNumberMap = new HashMap<Long, String>(args.getDataEntities().length);
        for (DynamicObject data2 : args.getDataEntities()) {
            if (data2.getInt("taglevel.level") == 1 || !SWCStringUtils.isNotEmpty((String)data2.getString("parenttagnumber"))) continue;
            parentNumberMap.put(data2.getLong("id"), data2.getString("parenttagnumber"));
        }
        if (parentNumberMap.size() == 0) {
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_statisticstag");
        QFilter filter = new QFilter("number", "in", parentNumberMap.values());
        filter.or(new QFilter("id", "in", parentNumberMap.keySet()));
        DynamicObject[] tags = helper.query("id,parent.id,number,isleaf,longnumber,fullname", new QFilter[]{filter}, "taglevel.level asc");
        HashSet<Long> affectedIdSet = new HashSet<Long>(tags.length);
        Map<String, DynamicObject> parentTagMap = Arrays.stream(tags).collect(Collectors.toMap(data -> data.getString("number"), data -> data));
        for (DynamicObject tag : tags) {
            DynamicObject parentTag;
            String parentNumber = (String)parentNumberMap.get(tag.getLong("id"));
            if (SWCStringUtils.isEmpty((String)parentNumber) || (parentTag = parentTagMap.get(parentNumber)) == null) continue;
            if (tag.getLong("parent.id") != 0L) {
                affectedIdSet.add(tag.getLong("parent.id"));
            }
            tag.set(KEY_PARENT_TAG, (Object)parentTag.getLong("id"));
            tag.set(KEY_LONG_NUMBER, (Object)(parentTag.getString(KEY_LONG_NUMBER) + '.' + tag.getString("number")));
            tag.set(KEY_FULL_NAME, (Object)(parentTag.getString(KEY_FULL_NAME) + '.' + tag.getString("name")));
            affectedIdSet.add(parentTag.getLong("id"));
        }
        helper.update(tags);
        if (CollectionUtils.isEmpty(affectedIdSet)) {
            return;
        }
        DynamicObjectCollection othersTags = helper.queryOriginalCollection("parent.id", new QFilter[]{new QFilter(KEY_PARENT_TAG, "in", affectedIdSet)});
        Set refIdSet = othersTags.stream().map(othersTag -> othersTag.getLong("parent.id")).collect(Collectors.toSet());
        for (DynamicObject affectedTag : affectedTags = helper.query("id,isleaf", new QFilter[]{new QFilter("id", "in", affectedIdSet)})) {
            if (refIdSet.contains(affectedTag.getLong("id"))) {
                affectedTag.set(KEY_IS_LEAF, (Object)"0");
                continue;
            }
            affectedTag.set(KEY_IS_LEAF, (Object)"1");
        }
        helper.update(affectedTags);
    }
}

