/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.web.relatepanel;

import java.util.HashSet;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.SWCAppCache;

public class FileDetailDisplaySetDeleteOp
extends AbstractOperationServicePlugIn {
    private static final String APPID_HSBP = "hsbp";
    private static final String RELATEPAGE_PRE = "relatePage_";

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("enable");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        Object[] selectedRows = e.getDataEntities();
        if (ArrayUtils.isEmpty((Object[])selectedRows)) {
            return;
        }
        HashSet<String> waitDeletePageNumbers = new HashSet<String>(16);
        for (Object dataEntity : selectedRows) {
            waitDeletePageNumbers.add(dataEntity.getString("pagenumber"));
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_relatepanelset");
        QFilter qFilter = new QFilter("pageinfo.number", "in", waitDeletePageNumbers);
        helper.deleteByFilter(qFilter.toArray());
        this.refreshCache();
    }

    private void refreshCache() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_entitytype");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection coll = helper.queryOriginalCollection("id", new QFilter[]{statusFilter, enableFilter});
        for (DynamicObject dynamicObject : coll) {
            Long entityTypeId = dynamicObject.getLong("id");
            String lang = RequestContext.get().getLang().getLocale().toString();
            String cacheKey = RELATEPAGE_PRE + entityTypeId + lang;
            SWCAppCache.get((String)APPID_HSBP).remove(cacheKey);
        }
    }
}

