/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.web.taxmap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;
import kd.swc.hsbs.opplugin.validator.taxmap.TaxItemMappingSchemeValidator;

public class TaxItemMappingSchemeOp
extends SWCDataBaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("number");
        fieldKeys.add("org");
        fieldKeys.add("country");
        fieldKeys.add("salarymapentry");
        fieldKeys.add("salarymapentry.seq");
        fieldKeys.add("salarymapentry.pretaxitem");
        fieldKeys.add("salarymapentry.presalaryitem");
        fieldKeys.add("salarymapentry.pretaxcategory");
        fieldKeys.add("salarymapentry.pretaxcategory.name");
        fieldKeys.add("salarymapentry.pretaxcategory.taxpayertype");
        fieldKeys.add("salarymapentry.pretaxitem.name");
        fieldKeys.add("salarymapentry.presalaryitem.name");
        fieldKeys.add("salarymapentry.pretaxitem.number");
        fieldKeys.add("salarymapentry.presalaryitem.number");
        fieldKeys.add("salarymapentry.pretaxitem.status");
        fieldKeys.add("salarymapentry.presalaryitem.status");
        fieldKeys.add("salarymapentry.pretaxitem.enable");
        fieldKeys.add("salarymapentry.presalaryitem.enable");
        fieldKeys.add("taxmapentry");
        fieldKeys.add("taxmapentry.seq");
        fieldKeys.add("taxmapentry.aftertaxitem");
        fieldKeys.add("taxmapentry.aftersalaryitem");
        fieldKeys.add("taxmapentry.aftertaxitem.name");
        fieldKeys.add("taxmapentry.aftersalaryitem.name");
        fieldKeys.add("taxmapentry.aftertaxitem.number");
        fieldKeys.add("taxmapentry.aftersalaryitem.number");
        fieldKeys.add("taxmapentry.aftertaxitem.status");
        fieldKeys.add("taxmapentry.aftersalaryitem.status");
        fieldKeys.add("taxmapentry.aftertaxitem.enable");
        fieldKeys.add("taxmapentry.aftersalaryitem.enable");
        fieldKeys.add("taxmapentry.aftertaxcategory");
        fieldKeys.add("taxmapentry.aftertaxcategory.name");
        fieldKeys.add("taxmapentry.aftertaxcategory.taxpayertype");
        fieldKeys.add("salarymapentry.pretaxitem.datatype.id");
        fieldKeys.add("salarymapentry.pretaxitem.taxcategories.fbasedataid_id");
        fieldKeys.add("salarymapentry.presalaryitem.datatype.id");
        fieldKeys.add("taxmapentry.aftertaxitem.datatype.id");
        fieldKeys.add("taxmapentry.aftertaxitem.taxcategories.fbasedataid_id");
        fieldKeys.add("taxmapentry.aftersalaryitem.datatype.id");
        fieldKeys.add("salarymapentry.pretaxitem.countrytype");
        fieldKeys.add("salarymapentry.presalaryitem.areatype");
        fieldKeys.add("taxmapentry.aftertaxitem.countrytype");
        fieldKeys.add("taxmapentry.aftersalaryitem.areatype");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new TaxItemMappingSchemeValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        String operationKey = args.getOperationKey();
        if ("save".equals(operationKey) || "submit".equals(operationKey)) {
            DynamicObject[] datas;
            for (DynamicObject data : datas = args.getDataEntities()) {
                DynamicObjectCollection salaryMapEntry = data.getDynamicObjectCollection("salarymapentry");
                this.orderEntrySeq(salaryMapEntry);
            }
        }
    }

    private void orderEntrySeq(DynamicObjectCollection salaryMapEntry) {
        HashMap<Long, List> salaryEntryMap = new HashMap<Long, List>(salaryMapEntry.size());
        List salaryEntryList = null;
        for (int index = 0; index < salaryMapEntry.size(); ++index) {
            DynamicObject salaryMapObj = (DynamicObject)salaryMapEntry.get(index);
            Long salaryItem = salaryMapObj.getLong("presalaryitem.id");
            salaryEntryList = salaryEntryMap.getOrDefault(salaryItem, new ArrayList(10));
            salaryEntryList.add(salaryMapObj);
            salaryEntryMap.put(salaryItem, salaryEntryList);
        }
        int seq = 0;
        for (Map.Entry salaryEntrys : salaryEntryMap.entrySet()) {
            salaryEntryList = (List)salaryEntrys.getValue();
            for (DynamicObject entry : salaryEntryList) {
                entry.set("seq", (Object)(++seq));
            }
        }
    }
}

