/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.servicehelper;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;

public class ServiceFactory {
    private static Map<String, String> serviceMap = new HashMap<String, String>(16);

    public static <T> T getService(Class<T> clazz) {
        return (T)ServiceFactory.getService(clazz.getSimpleName());
    }

    public static Object getService(String serviceName) {
        String className = serviceMap.get(serviceName);
        if (className == null) {
            throw new RuntimeException(String.format(Locale.ROOT, "%s Service Not Found", serviceName));
        }
        return TypesContainer.getOrRegisterSingletonInstance((String)className);
    }

    static {
        serviceMap.put("IHSBSBizDataCodeService", "kd.swc.hsbs.mservice.HSBSBizDataCodeService");
        serviceMap.put("CertDetailUpdateService", "kd.swc.hsbs.mservice.update.CertDetailUpdateService");
        serviceMap.put("IHSBSService", "kd.swc.hsbs.mservice.HSBSService");
        serviceMap.put("EncodeUpdateService", "kd.swc.hsbs.mservice.update.EncodeUpdateService");
        serviceMap.put("TaxSwitchUpgradeService", "kd.swc.hsbs.mservice.update.TaxSwitchUpgradeService");
        serviceMap.put("CalRuleUpgradeService", "kd.swc.hsbs.mservice.update.CalRuleUpgradeService");
        serviceMap.put("SalaryItemUpgradeService", "kd.swc.hsbs.mservice.update.SalaryItemUpgradeService");
        serviceMap.put("PaySubjectPromptUpgradeService", "kd.swc.hsbs.mservice.update.PaySubjectPromptUpgradeService");
        serviceMap.put("IHSBSCandidateSalaryService", "kd.swc.hsbs.mservice.HSBSCandidateSalaryService");
        serviceMap.put("FetchConfigUpgradeService", "kd.swc.hsbs.mservice.update.FetchConfigUpgradeService");
        serviceMap.put("AdjFileRelateRemoveCacheService", "kd.swc.hsbs.mservice.update.AdjFileRelateRemoveCacheService");
        serviceMap.put("IHSBSSalaryParameterService", "kd.swc.hsbs.mservice.HSBSSalaryParameterService");
        serviceMap.put("SalarySlipQueryParamUpgradeService", "kd.swc.hsbs.mservice.update.SalarySlipQueryParamUpgradeService");
        serviceMap.put("PayrollActDataMigrateService", "kd.swc.hsbs.mservice.migrate.PayrollActDataMigrateService");
        serviceMap.put("CollaManageRoleUpgradeService", "kd.swc.hsbs.mservice.update.CollaManageRoleUpgradeService");
        serviceMap.put("SinsurCalPayerParamUpdateService", "kd.swc.hsbs.mservice.update.SinsurCalPayerParamUpdateService");
        serviceMap.put("IHSBSCollaService", "kd.swc.hsbs.mservice.HSBSCollaService");
    }
}

