/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.form.IPageCache;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class HSBSFixedFieldListPlugin
extends AbstractListPlugin {
    private Map<String, List<String>> FixFieldListMap;
    private static final String PARAM_ISFIXED = "param_isfixed";

    public void initialize() {
        super.initialize();
        this.initFixFieldListMap();
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        List<String> fixedFieldKeyList = this.getFixedFieldKeyList();
        if (null == fixedFieldKeyList || fixedFieldKeyList.size() < 1) {
            return;
        }
        IPageCache pageCache = this.getView().getPageCache();
        String isFixed = pageCache.get(PARAM_ISFIXED);
        if (SWCStringUtils.isNotEmpty((String)isFixed)) {
            return;
        }
        int index = 0;
        int size = fixedFieldKeyList.size();
        List columns = args.getListColumns();
        for (IListColumn iListColumn : columns) {
            if (index >= size) break;
            String listFieldKey = iListColumn.getListFieldKey();
            if (!fixedFieldKeyList.contains(listFieldKey)) continue;
            iListColumn.setFixed(true);
            ++index;
        }
        pageCache.put(PARAM_ISFIXED, "TRUE");
    }

    private List<String> getFixedFieldKeyList() {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String formId = listShowParameter.getBillFormId();
        List<String> fixFieldList = this.FixFieldListMap.get(formId);
        return fixFieldList;
    }

    private void initFixFieldListMap() {
        this.FixFieldListMap = new HashMap<String, List<String>>();
        ArrayList<String> salaryItemFixFieldList = new ArrayList<String>(3);
        salaryItemFixFieldList.add("createorg.name");
        salaryItemFixFieldList.add("number");
        salaryItemFixFieldList.add("name");
        this.FixFieldListMap.put("hsbs_salaryitem", salaryItemFixFieldList);
        ArrayList<String> paysubjectFixFieldList = new ArrayList<String>(3);
        paysubjectFixFieldList.add("createorg.name");
        paysubjectFixFieldList.add("number");
        paysubjectFixFieldList.add("name");
        this.FixFieldListMap.put("hsbs_paysubject", paysubjectFixFieldList);
        ArrayList<String> fetchConfigFixFieldList = new ArrayList<String>(3);
        fetchConfigFixFieldList.add("createorg.name");
        fetchConfigFixFieldList.add("number");
        fetchConfigFixFieldList.add("name");
        this.FixFieldListMap.put("hsbs_fetchconfig", fetchConfigFixFieldList);
        ArrayList<String> fetchItemFixFieldList = new ArrayList<String>(3);
        fetchItemFixFieldList.add("createorg.name");
        fetchItemFixFieldList.add("number");
        fetchItemFixFieldList.add("name");
        this.FixFieldListMap.put("hsbs_fetchitem", fetchItemFixFieldList);
    }
}

