/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.basedata.attinteg;

import com.google.common.collect.Lists;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;

public abstract class AbstractAttIntegBaseList
extends AbstractListPlugin {
    private static final String SEARCH_FILTERS_KEY = "searchFilters";
    private static final String COLUMN_FILTERS_KEY = "columnFilters";

    public void beforeBindData(EventObject eventObject) {
        BillList billList;
        super.beforeBindData(eventObject);
        Object source = eventObject.getSource();
        if (source instanceof BillList) {
            billList = (BillList)eventObject.getSource();
            FilterParameter queryFilterParameter = billList.getQueryFilterParameter();
            List qFilters = queryFilterParameter.getQFilters();
            this.setSearchQFilterCache(qFilters);
        }
        billList = (BillList)this.getControl("billlistap");
        AbstractGrid.GridState entryState = billList.getEntryState();
        String columnQFilter = entryState.getColumnQFilter();
        List qFilters = Lists.newArrayListWithExpectedSize((int)10);
        if (StringUtils.isNotBlank((CharSequence)columnQFilter)) {
            qFilters = (List)SerializationUtils.deSerializeFromBase64((String)columnQFilter);
        }
        this.setColumnQFilterCache(qFilters);
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        filterContainer.addSearchClickListener(searchClickEvent -> {
            List qFilters = searchClickEvent.getFastQFilters();
            this.setSearchQFilterCache(qFilters);
        });
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        final QFilter filters = this.getQFilter();
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                DynamicObjectCollection dObjectCollection = AbstractAttIntegBaseList.this.rpcQueryEntry(arg0, arg1, filters);
                int dataCount = AbstractAttIntegBaseList.this.rpcQueryCount(filters);
                this.getQueryResult().setCollection(dObjectCollection);
                this.getQueryResult().setDataCount(dataCount);
                this.getQueryResult().setBillDataCount(dataCount);
                return dObjectCollection;
            }
        });
        super.beforeCreateListDataProvider(args);
    }

    protected abstract DynamicObjectCollection rpcQueryEntry(int var1, int var2, QFilter var3);

    protected abstract int rpcQueryCount(QFilter var1);

    protected QFilter getQFilter() {
        return this.getQFilter(true);
    }

    protected QFilter getQFilter(boolean isContainSearchFilter) {
        String columnFilters;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String filters = (String)formShowParameter.getCustomParam("filters");
        QFilter qFilter = QFilter.fromSerializedString((String)filters);
        String searchFilters = this.getView().getPageCache().get(SEARCH_FILTERS_KEY);
        if (isContainSearchFilter && StringUtils.isNotBlank((CharSequence)searchFilters)) {
            List searchQFilters = (List)SerializationUtils.deSerializeFromBase64((String)searchFilters);
            for (QFilter searchQFilter : searchQFilters) {
                qFilter.and(searchQFilter);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(columnFilters = this.getView().getPageCache().get(COLUMN_FILTERS_KEY)))) {
            List columnQFilters = (List)SerializationUtils.deSerializeFromBase64((String)columnFilters);
            for (QFilter columnQFilter : columnQFilters) {
                qFilter.and(columnQFilter);
            }
        }
        return qFilter;
    }

    private void setSearchQFilterCache(List<QFilter> qFilters) {
        if (qFilters.size() == 0) {
            this.getView().getPageCache().remove(SEARCH_FILTERS_KEY);
        } else {
            this.getView().getPageCache().put(SEARCH_FILTERS_KEY, SerializationUtils.serializeToBase64(qFilters));
        }
    }

    private void setColumnQFilterCache(List<QFilter> qFilters) {
        if (qFilters.size() == 0) {
            this.getView().getPageCache().remove(COLUMN_FILTERS_KEY);
        } else {
            this.getView().getPageCache().put(COLUMN_FILTERS_KEY, SerializationUtils.serializeToBase64(qFilters));
        }
    }
}

