/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.basedata.attinteg;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.converter.util.CollectionUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;
import kd.swc.hsbs.formplugin.web.basedata.attinteg.AttPeriodBasedataEdit;

public class AttIntegMapScmEdit
extends SWCDataBaseEdit
implements BeforeF7SelectListener,
EntryGridBindDataListener,
ICloseCallBack {
    private static final String CAL_PERIOD_TYPE = "calperiodtype";
    private static final String COUNTRY = "country";
    private static final String ADD_ATT_ITEMS = "add_items";
    private static final String ATT_ITEM = "attitem";
    private static final String BIZ_ITEM = "bizitem";
    private static final String ATT_PERIOD = "attperiod";
    public static final String FIELD_AREATYPE = "areatype";
    public static final String FIELD_AREATYPE_GENERAL = "1";
    public static final String FIELD_AREATYPE_ASSIGN = "2";
    private static final String BIZ_ITEM_DATA_TYPE_NUMBER = "1010_S";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Container panelap = (Container)this.getView().getControl("fieldsetpanelap");
        this.replaceBasedataEdit(panelap.getItems());
        this.getView().createControlIndex(panelap.getItems());
        BasedataEdit calPeriodTypeEdit = (BasedataEdit)this.getView().getControl(CAL_PERIOD_TYPE);
        calPeriodTypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bizItemEdit = (BasedataEdit)this.getView().getControl(BIZ_ITEM);
        bizItemEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit attPeriodEdit = (BasedataEdit)this.getView().getControl(ATT_PERIOD);
        attPeriodEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{ADD_ATT_ITEMS});
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        Object org = this.getModel().getValue("org");
        if (org == null) {
            long orgID = RequestContext.get().getOrgId();
            this.getModel().setValue("org", (Object)orgID);
            this.getModel().setDataChanged(false);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name;
        switch (name = event.getProperty().getName()) {
            case "calperiodtype": {
                this.setF7Filter(event, this.buildF7Filter());
                break;
            }
            case "bizitem": {
                QFilter qFilter = this.buildF7Filter();
                qFilter.and(new QFilter("cycle", "=", (Object)"0"));
                qFilter.and(new QFilter("datatype.number", "=", (Object)BIZ_ITEM_DATA_TYPE_NUMBER));
                Set<Long> ignoreIds = this.getIgnoreIds("bizitem.id");
                if (CollectionUtils.isNotEmpty(ignoreIds)) {
                    qFilter.and(new QFilter("id", "not in", ignoreIds));
                }
                this.setF7Filter(event, qFilter);
                break;
            }
            case "attperiod": {
                this.showAttPeriodF7(event);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String key;
        switch (key = args.getProperty().getName()) {
            case "country": 
            case "org": {
                this.restField();
                break;
            }
        }
    }

    private void replaceBasedataEdit(List<Control> items) {
        for (int i = 0; i < items.size(); ++i) {
            Control lap2Item = items.get(i);
            if (!ATT_PERIOD.equals(lap2Item.getKey())) continue;
            BasedataEdit basedataEdit = (BasedataEdit)lap2Item;
            AttPeriodBasedataEdit attPeriodBasedataEdit = new AttPeriodBasedataEdit();
            attPeriodBasedataEdit.setKey(basedataEdit.getKey());
            items.set(i, (Control)attPeriodBasedataEdit);
            return;
        }
    }

    private void restField() {
        this.getModel().setValue(CAL_PERIOD_TYPE, null);
        this.getView().updateView(CAL_PERIOD_TYPE);
        DynamicObjectCollection datas = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isNotEmpty((Collection)datas)) {
            for (DynamicObject data : datas) {
                data.set(BIZ_ITEM, null);
            }
            this.getView().updateView("entryentity");
        }
    }

    private void setF7Filter(BeforeF7SelectEvent event, QFilter qFilter) {
        ListShowParameter param = (ListShowParameter)event.getFormShowParameter();
        param.getListFilterParameter().setFilter(qFilter);
    }

    private QFilter buildF7Filter() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long country = dataEntity.getLong("country.id");
        QFilter qFilter = new QFilter(COUNTRY, "=", (Object)country);
        qFilter.or(new QFilter(FIELD_AREATYPE, "=", (Object)FIELD_AREATYPE_GENERAL));
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("enable", "=", (Object)FIELD_AREATYPE_GENERAL));
        return qFilter;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (formOperate.getOperateKey()) {
            case "add_items": {
                this.showAttItemF7();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        switch (closedCallBackEvent.getActionId()) {
            case "add_items": {
                Object returnData;
                if (closedCallBackEvent.getReturnData() == null || !((returnData = closedCallBackEvent.getReturnData()) instanceof ListSelectedRowCollection)) break;
                ListSelectedRowCollection attItems = (ListSelectedRowCollection)returnData;
                List<Object> attItemIds = attItems.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
                this.newEntriesOperate(attItemIds);
                break;
            }
            case "attperiod": {
                Object returnData;
                if (closedCallBackEvent.getReturnData() == null || !((returnData = closedCallBackEvent.getReturnData()) instanceof ListSelectedRowCollection)) break;
                ListSelectedRowCollection periodIds = (ListSelectedRowCollection)returnData;
                ListSelectedRow periodId = periodIds.get(0);
                this.getModel().setValue(ATT_PERIOD, periodId.getPrimaryKeyValue());
                break;
            }
        }
    }

    private void newEntriesOperate(List<Object> attItemIds) {
        if (CollectionUtils.isEmpty(attItemIds)) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter values = new TableValueSetter(new String[0]);
        values.addField(ATT_ITEM, new Object[0]);
        for (Object attItemId : attItemIds) {
            values.addRow(new Object[]{attItemId});
        }
        model.beginInit();
        model.batchCreateNewEntryRow("entryentity", values);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void showAttItemF7() {
        QFilter filters = new QFilter("enable", "=", (Object)FIELD_AREATYPE_GENERAL);
        filters.and(new QFilter("status", "=", (Object)"C"));
        filters.and(new QFilter("iscurrentversion", "=", (Object)FIELD_AREATYPE_GENERAL));
        Set<Long> ignoreIds = this.getIgnoreIds("attitem.id");
        if (CollectionUtils.isNotEmpty(ignoreIds)) {
            filters.and(new QFilter("id", "not in", ignoreIds));
        }
        ListShowParameter showParameter = this.openF7("wtbd_attitem", "bos_listf7");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ADD_ATT_ITEMS));
        showParameter.setCustomParam("filters", (Object)filters.toSerializedString());
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showAttPeriodF7(BeforeF7SelectEvent event) {
        QFilter filters = new QFilter("enable", "=", (Object)FIELD_AREATYPE_GENERAL);
        filters.and(new QFilter("status", "=", (Object)"C"));
        AttPeriodBasedataEdit basedataEdit = (AttPeriodBasedataEdit)((Object)event.getSource());
        if ("getLookUpList".equals(event.getSourceMethod()) || "setItemByIdFromClient".equals(event.getSourceMethod()) || "setItemByNumber".equals(event.getSourceMethod())) {
            event.addCustomQFilter(filters);
            return;
        }
        if ("click".equals(event.getSourceMethod())) {
            event.setCancel(true);
            ListShowParameter showParameter = this.openF7("hsbs_attperiod", "bos_listf7");
            showParameter.setMultiSelect(false);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ATT_PERIOD));
            Map<String, List<Object>> searchValueMap = basedataEdit.getSearchValueMap();
            showParameter.setCustomParam("searchValueMap", searchValueMap);
            showParameter.setCustomParam("filters", (Object)filters.toSerializedString());
            this.getView().showForm((FormShowParameter)showParameter);
        }
        event.setCancel(true);
    }

    private Set<Long> getIgnoreIds(String propertyName) {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection entryentities = dataEntity.getDynamicObjectCollection("entryentity");
        HashSet ignoreIds = Sets.newHashSet();
        for (DynamicObject entryentity : entryentities) {
            Long attItemId = entryentity.getLong(propertyName);
            ignoreIds.add(attItemId);
        }
        return ignoreIds;
    }

    private ListShowParameter openF7(String billFormId, String f7FormId) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setBillFormId(billFormId);
        showParameter.setFormId(f7FormId);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("960px");
        styleCss.setHeight("580px");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        showParameter.setLookUp(true);
        showParameter.setMultiSelect(true);
        showParameter.setShowTitle(false);
        showParameter.setHasRight(true);
        return showParameter;
    }
}

