/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.basedata.bizdatadim;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCObjectUtils;

public class BizDataDimEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(BizDataDimEdit.class);
    private static final String KEY_PAYROLLGROUP = "payrollgroup";

    public void registerListener(EventObject event) {
        super.registerListener(event);
        BasedataEdit payrollGroup = (BasedataEdit)this.getControl(KEY_PAYROLLGROUP);
        payrollGroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject eventObject) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (SWCObjectUtils.isEmpty((Object)dataEntity)) {
            dataEntity.set("org", null);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String controlKey = args.getProperty().getName();
        if (KEY_PAYROLLGROUP.equals(controlKey)) {
            ChangeData changeData = args.getChangeSet()[0];
            if (SWCObjectUtils.isEmpty((Object)changeData.getNewValue())) {
                this.getModel().getDataEntity().set("org", null);
            } else {
                DynamicObject org = changeData.getDataEntity().getDynamicObject("payrollgroup.org");
                this.getModel().getDataEntity().set("org", (Object)org);
                this.getView().updateView("org");
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        switch (fieldKey) {
            case "payrollgroup": {
                QFilter orgFilter = SWCPermissionServiceHelper.getOrgFilterByOrgPerm((String)"/UHLXNRR9KPZ", (String)"hsbs_bizdatadim", (String)"47150e89000000ac", (String)"hsas_payrollgrp");
                Set payrollGrpIds = SWCPermissionServiceHelper.getPayrollGrpSetByPermItem((String)"/UHLXNRR9KPZ", (String)"hsbs_bizdatadim", (String)"47150e89000000ac");
                if (null != payrollGrpIds) {
                    QFilter prgFilter = new QFilter("id", "in", (Object)payrollGrpIds);
                    filters.add(prgFilter);
                }
                filters.add(orgFilter);
                break;
            }
        }
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        listShowParameter.getListFilterParameter().getQFilters().addAll(filters);
    }

    public void afterImportData(ImportDataEventArgs args) {
        super.afterImportData(args);
        BillModel billModel = (BillModel)args.getSource();
        DynamicObject dy = billModel.getDataEntity();
        DynamicObject payrollGroup = dy.getDynamicObject(KEY_PAYROLLGROUP);
        if (!SWCObjectUtils.isEmpty((Object)payrollGroup) && SWCObjectUtils.isEmpty((Object)dy.getDynamicObject("org"))) {
            dy.set("org", (Object)payrollGroup.getDynamicObject("org"));
        }
    }
}

