/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.basedata.bizdatadim;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.ListColumnCompareTypesSetEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.util.CollectionUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class BizDataDimList
extends AbstractListPlugin {
    private static final String KEY_PAYROLLGROUP = "payrollgroup";
    private static final String BATCH_ADD_CONFIRM = "batchAddConfirm";
    private static final String PAYROLLGRP_CLOSE = "payrollGrpClose";

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        String showColumnKeysStr = (String)this.getView().getFormShowParameter().getCustomParam("showColumnKeys");
        if (SWCStringUtils.isNotEmpty((String)showColumnKeysStr)) {
            Set showColumnKeys = Arrays.stream(showColumnKeysStr.split(",")).collect(Collectors.toSet());
            List listColumns = args.getListColumns();
            Iterator iterator = listColumns.iterator();
            while (iterator.hasNext()) {
                IListColumn column = (IListColumn)iterator.next();
                if (showColumnKeys.contains(column.getListFieldKey())) continue;
                iterator.remove();
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String key = args.getFieldName();
        if ("payrollgroup_name".equals(key)) {
            args.setCancel(true);
            Object pkId = ((ListView)this.getView()).getFocusRowPkId();
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_bizdatadim");
            DynamicObject bizDataDim = helper.queryOne("id, payrollgroup.id", pkId);
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setFormId("hsas_payrollgrp");
            showParameter.setPkId((Object)bizDataDim.getLong("payrollgroup.id"));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey = ((FormOperate)args.getSource()).getOperateKey();
        if ("donothing_batchadd".equals(opKey)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6279\u91cf\u9009\u62e9\u85aa\u8d44\u6838\u7b97\u7ec4\u8fdb\u884c\u65b0\u589e\uff0c\u65b0\u589e\u6570\u636e\u5c06\u4f1a\u81ea\u52a8\u5f15\u7528\u85aa\u8d44\u6838\u7b97\u7ec4\u7684\u7f16\u7801\u548c\u540d\u79f0\uff0c\u70b9\u51fb\u201c\u786e\u5b9a\u201d\u5f00\u59cb\u9009\u62e9\u3002", (String)"BizDataDimList_0", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(BATCH_ADD_CONFIRM));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (BATCH_ADD_CONFIRM.equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.showPayrollGrpF7();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (PAYROLLGRP_CLOSE.equals(actionId)) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (null == returnData) {
                return;
            }
            Object[] primaryKeys = returnData.getPrimaryKeyValues();
            if (SWCArrayUtils.isEmpty((Object[])primaryKeys)) {
                return;
            }
            this.dealReturnData(primaryKeys);
        }
    }

    public void listColumnCompareTypesSet(ListColumnCompareTypesSetEvent args) {
        String fieldKey;
        super.listColumnCompareTypesSet(args);
        switch (fieldKey = args.getListFieldKey()) {
            case "payrollgroup.enable": {
                List valueMapItems = args.getComboItems();
                ArrayList<ValueMapItem> waitDelValueMapItems = new ArrayList<ValueMapItem>(valueMapItems.size());
                for (ValueMapItem valueMapItem : valueMapItems) {
                    if ("0".equals(valueMapItem.getValue()) || "1".equals(valueMapItem.getValue())) continue;
                    ValueMapItem waitDeleteItem = valueMapItem;
                    waitDelValueMapItems.add(waitDeleteItem);
                }
                valueMapItems.removeAll(waitDelValueMapItems);
                break;
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String fieldName;
        super.filterContainerBeforeF7Select(args);
        switch (fieldName = args.getFieldName()) {
            case "payrollgroup.name": {
                List filters = args.getQfilters();
                QFilter orgFilter = SWCPermissionServiceHelper.getOrgFilterByOrgPerm((String)"/UHLXNRR9KPZ", (String)"hsbs_bizdatadim", (String)"47150e89000000ac", (String)"hsas_payrollgrp");
                Set payrollGrpIds = SWCPermissionServiceHelper.getPayrollGrpSetByPermItem((String)"/UHLXNRR9KPZ", (String)"hsbs_bizdatadim", (String)"47150e89000000ac");
                if (null != payrollGrpIds) {
                    QFilter prgFilter = new QFilter("id", "in", (Object)payrollGrpIds);
                    filters.add(prgFilter);
                }
                filters.add(orgFilter);
                break;
            }
        }
    }

    private void dealReturnData(Object[] primaryKeys) {
        DynamicObject[] payrollGrpArr = this.getPayrollGrpByIds(primaryKeys);
        DynamicObject[] bizDataDimArr = this.constructBizDataDims(payrollGrpArr);
        this.invokeSaveOperation(bizDataDimArr, primaryKeys.length);
        this.getView().invokeOperation("refresh");
    }

    private DynamicObject[] constructBizDataDims(DynamicObject[] payrollGrpArr) {
        ArrayList<DynamicObject> bizDataDimList = new ArrayList<DynamicObject>(payrollGrpArr.length);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_bizdatadim");
        long[] ids = DB.genLongIds((String)"hsbs_bizdatadim", (int)payrollGrpArr.length);
        int index = 0;
        for (DynamicObject payrollGrp : payrollGrpArr) {
            String number = payrollGrp.getString("number");
            String name = payrollGrp.getString("name");
            DynamicObject bizDataDim = helper.generateEmptyDynamicObject();
            bizDataDim.set("id", (Object)ids[index]);
            bizDataDim.set("number", (Object)number);
            bizDataDim.set("name", (Object)name);
            bizDataDim.set(KEY_PAYROLLGROUP, (Object)payrollGrp);
            bizDataDim.set("org", (Object)payrollGrp.getDynamicObject("org"));
            bizDataDim.set("creator", (Object)RequestContext.get().getCurrUserId());
            bizDataDimList.add(bizDataDim);
            ++index;
        }
        return bizDataDimList.toArray(new DynamicObject[0]);
    }

    private DynamicObject[] getPayrollGrpByIds(Object[] ids) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollgrp");
        QFilter filter = new QFilter("id", "in", (Object)ids);
        return helper.query("number,name,org", new QFilter[]{filter});
    }

    private void invokeSaveOperation(DynamicObject[] bizDataDimArr, int totalCount) {
        OperationServiceImpl operationService = new OperationServiceImpl();
        OperateOption opOption = OperateOption.create();
        OperationResult tempOpResult = operationService.localInvokeOperation("save", bizDataDimArr, opOption);
        if (tempOpResult.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"BizDataDimList_1", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
        } else {
            List allErrorOrValidateInfo = tempOpResult.getAllErrorOrValidateInfo();
            if (CollectionUtils.isEmpty((Collection)allErrorOrValidateInfo)) {
                this.getView().showErrorNotification(tempOpResult.getMessage());
                return;
            }
            this.showBatchAddFailModal(allErrorOrValidateInfo.stream().map(IOperateInfo::getMessage).collect(Collectors.toList()), totalCount, tempOpResult.getSuccessPkIds().size());
        }
    }

    private void showPayrollGrpF7() {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("hsas_payrollgrp");
        listShowParameter.setFormId("bos_listf7");
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss inlineStyleCss = new StyleCss();
        inlineStyleCss.setHeight("600");
        inlineStyleCss.setWidth("1000");
        listShowParameter.getOpenStyle().setInlineStyleCss(inlineStyleCss);
        listShowParameter.setShowTitle(false);
        listShowParameter.setMultiSelect(true);
        listShowParameter.setLookUp(true);
        listShowParameter.setShowApproved(true);
        listShowParameter.setShowUsed(true);
        listShowParameter.setHasRight(true);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, PAYROLLGRP_CLOSE));
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        QFilter orgFilter = SWCPermissionServiceHelper.getOrgFilterByOrgPerm((String)"/UHLXNRR9KPZ", (String)"hsbs_bizdatadim", (String)"47150e89000000ac", (String)"hsas_payrollgrp");
        Set payrollGrpIds = SWCPermissionServiceHelper.getPayrollGrpSetByPermItem((String)"/UHLXNRR9KPZ", (String)"hsbs_bizdatadim", (String)"47150e89000000ac");
        if (null != payrollGrpIds) {
            QFilter prgFilter = new QFilter("id", "in", (Object)payrollGrpIds);
            filters.add(prgFilter);
        }
        filters.add(orgFilter);
        listShowParameter.getListFilterParameter().getQFilters().addAll(filters);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void showBatchAddFailModal(List<String> errorMsgList, int totalCount, int successCount) {
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("bos_operationresult");
        parameters.setCustomParam("hasMore", (Object)Boolean.FALSE);
        parameters.setShowTitle(false);
        String title = MessageFormat.format(ResManager.loadKDString((String)"\u5171{0}\u6761\u6570\u636e\uff0c\u65b0\u589e\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761\u3002", (String)"BizDataDimList_2", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), totalCount, successCount, totalCount - successCount);
        parameters.setCustomParam("title", (Object)title);
        parameters.setCustomParam("errorMsg", errorMsgList);
        this.getView().showForm(parameters);
    }
}

