/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.basedata.bizitem;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FieldTip;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.util.StringUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class AttBizItemEdit
extends SWCDataBaseEdit {
    private static final String REGEX = "^(\\-|\\+)?\\d+(\\.\\d{1,10})?$";

    public void afterBindData(EventObject eventObject) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"inputminval", "scalelimit", "inputmaxval", "datalength", "country"});
        DynamicObject data = this.getModel().getDataEntity();
        this.checkDataType();
        this.initMaxValueAndMinEnable();
        this.checkAreaType();
        this.setConsumemethodSelectValue(data.getLong("datatype.id"));
        this.setFiledsEnable();
        this.initMaxValueAndMinValue();
        this.getModel().setDataChanged(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "unaudit": 
            case "unsubmit": {
                this.setFiledsEnable();
                this.getView().invokeOperation("refresh");
                break;
            }
            case "save": 
            case "submit": {
                OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
                if (!operationResult.isSuccess()) break;
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs changedArgs) {
        String fieldKey = changedArgs.getProperty().getName();
        ChangeData[] changeData = changedArgs.getChangeSet();
        switch (fieldKey) {
            case "datatype": {
                DynamicObject newValue = (DynamicObject)changeData[0].getNewValue();
                if (newValue == null || newValue.equals(changeData[0].getOldValue())) break;
                this.getModel().beginInit();
                this.getModel().setValue("inputminval", null);
                this.getModel().setValue("inputmaxval", null);
                this.getModel().setValue("datalength", null);
                this.getModel().setValue("scalelimit", null);
                this.getModel().setValue("earliestdate", null);
                this.getModel().setValue("lastdate", null);
                this.getModel().setValue("currency", null);
                this.getModel().setValue("consumemethod", null);
                this.checkDataType();
                this.initMaxValueAndMinEnable();
                this.setConsumemethodSelectValue(newValue.getLong("id"));
                this.getModel().endInit();
                this.getView().updateView();
                break;
            }
            case "datalength": {
                Integer dataLength = (Integer)this.getModel().getValue("datalength");
                if (dataLength == null || dataLength > 0) break;
                this.getModel().setValue("datalength", null);
                break;
            }
            case "areatype": {
                String newAreaType = (String)changeData[0].getNewValue();
                String oldAreaType = (String)changeData[0].getOldValue();
                if (SWCStringUtils.equals((String)newAreaType, (String)oldAreaType)) {
                    return;
                }
                this.checkAreaType();
                break;
            }
            case "inputminval": 
            case "inputmaxval": {
                String inputValue = (String)changeData[0].getNewValue();
                this.checkInputValue(fieldKey, inputValue);
                break;
            }
            case "scalelimit": {
                String scaleLimit = (String)changeData[0].getNewValue();
                this.initMaxValueAndMinEnable();
                this.checkMaxValueAndMinValue(scaleLimit);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (SWCStringUtils.equals((String)"save", (String)operateKey) || SWCStringUtils.equals((String)"submit", (String)operateKey)) {
            DynamicObject bizItemObj = this.getModel().getDataEntity();
            String minVal = bizItemObj.getString("inputminval");
            String maxVal = bizItemObj.getString("inputmaxval");
            if (SWCStringUtils.isEmpty((String)minVal)) {
                this.getModel().setValue("isminvalnull", (Object)"1");
            } else {
                BigDecimal minValue = null;
                try {
                    minValue = new BigDecimal(minVal);
                }
                catch (Exception e) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6700\u5c0f\u8f93\u5165\u503c\u201d\u3002", (String)"BizItemEdit_9", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                this.getModel().setValue("minvalue", (Object)minValue.toPlainString());
                this.getModel().setValue("isminvalnull", (Object)"0");
            }
            if (SWCStringUtils.isEmpty((String)maxVal)) {
                this.getModel().setValue("ismaxvalnull", (Object)"1");
            } else {
                BigDecimal maxValue = null;
                try {
                    maxValue = new BigDecimal(maxVal);
                }
                catch (Exception e) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6700\u5927\u8f93\u5165\u503c\u201d\u3002", (String)"BizItemEdit_10", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                this.getModel().setValue("maxvalue", (Object)maxValue.toPlainString());
                this.getModel().setValue("ismaxvalnull", (Object)"0");
            }
            source.getOption().setVariableValue("save", Boolean.TRUE.toString());
        }
    }

    private FieldTip showValidateTip(boolean isHide, String msg, String field) {
        FieldTip fieldTip = new FieldTip();
        fieldTip.setSuccess(isHide);
        fieldTip.setFieldKey(field);
        if (!isHide) {
            fieldTip.setTip(msg);
        }
        return fieldTip;
    }

    private void initMaxValueAndMinValue() {
        DynamicObject dataType = (DynamicObject)this.getModel().getValue("datatype");
        if (SWCObjectUtils.isEmpty((Object)dataType)) {
            return;
        }
        long dataTypeId = dataType.getLong("id");
        if (1010L == dataTypeId) {
            DynamicObject bizItemObj = this.getModel().getDataEntity();
            String scaleLimit = bizItemObj.getString("scalelimit");
            BigDecimal maxVal = bizItemObj.getBigDecimal("maxvalue");
            BigDecimal minVal = bizItemObj.getBigDecimal("minvalue");
            Boolean isMinValNull = bizItemObj.getBoolean("isminvalnull");
            boolean isMaxValNull = bizItemObj.getBoolean("ismaxvalnull");
            int scale = 10;
            if (StringUtils.isNotEmpty((String)scaleLimit)) {
                scale = Integer.parseInt(scaleLimit);
            }
            if (isMinValNull.booleanValue()) {
                this.getModel().setValue("inputminval", null);
            } else {
                this.getModel().setValue("inputminval", (Object)minVal.setScale(scale, 4).toPlainString());
            }
            if (isMaxValNull) {
                this.getModel().setValue("inputmaxval", null);
            } else {
                this.getModel().setValue("inputmaxval", (Object)maxVal.setScale(scale, 4).toPlainString());
            }
        }
    }

    private void setFiledsEnable() {
        String enable = (String)this.getModel().getValue("enable");
        if (!"10".equals(enable)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"datatype", "datalength", "number", "attitemtype", "consumemethod"});
        }
    }

    private void setConsumemethodSelectValue(long dataTypeId) {
        ComboEdit comboEdit = (ComboEdit)this.getControl("consumemethod");
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(10);
        if (1050L == dataTypeId || 1030L == dataTypeId) {
            data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6700\u65b0", (String)"BizItemEdit_0", (String)"swc-hsbs-formplugin", (Object[])new Object[0])), "1"));
            data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6700\u65e9", (String)"BizItemEdit_1", (String)"swc-hsbs-formplugin", (Object[])new Object[0])), "2"));
        } else if (1010L == dataTypeId || 1020L == dataTypeId) {
            data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6c47\u603b", (String)"BizItemEdit_4", (String)"swc-hsbs-formplugin", (Object[])new Object[0])), "5"));
            this.getModel().setValue("consumemethod", (Object)"5");
        }
        comboEdit.setComboItems(data);
    }

    private void checkDataType() {
        DynamicObject dataType = (DynamicObject)this.getModel().getValue("datatype");
        FieldEdit dataLengthField = (FieldEdit)this.getControl("datalength");
        dataLengthField.setMustInput(false);
        FieldEdit scaleLimitField = (FieldEdit)this.getControl("scalelimit");
        scaleLimitField.setMustInput(false);
        if (dataType == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"inputminval", "inputmaxval", "datalength", "earliestdate", "lastdate", "currency", "scalelimit"});
            return;
        }
        long dataTypeId = dataType.getLong("id");
        if (1010L == dataTypeId) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"inputminval", "inputmaxval", "scalelimit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"datalength", "earliestdate", "lastdate", "currency"});
            scaleLimitField.setMustInput(true);
        } else if (1030L == dataTypeId) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"inputminval", "inputmaxval", "earliestdate", "lastdate", "currency", "scalelimit"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"datalength"});
            dataLengthField.setMustInput(true);
        } else if (1020L == dataTypeId) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"currency"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"datalength", "earliestdate", "lastdate", "scalelimit", "inputminval", "inputmaxval"});
        } else if (1050L == dataTypeId) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"earliestdate", "lastdate"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"datalength", "inputminval", "inputmaxval", "currency", "scalelimit"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"inputminval", "inputmaxval", "datalength", "earliestdate", "lastdate", "currency", "scalelimit"});
        }
    }

    private void checkAreaType() {
        String areaType = (String)this.getModel().getValue("areatype");
        FieldEdit contryField = (FieldEdit)this.getControl("country");
        if ("2".equals(areaType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"country"});
            contryField.setMustInput(true);
        } else {
            this.getModel().setValue("country", null);
            this.getView().setVisible(Boolean.FALSE, new String[]{"country"});
            contryField.setMustInput(false);
        }
    }

    private void initMaxValueAndMinEnable() {
        String scaleLimit = (String)this.getModel().getValue("scalelimit");
        if (SWCStringUtils.isEmpty((String)scaleLimit)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"inputminval", "inputmaxval"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"inputminval", "inputmaxval"});
        }
    }

    private void checkInputValue(String fieldKey, String inputValue) {
        int scale;
        String msg = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6570\u503c\uff0810\u4f4d\u5c0f\u6570\u4ee5\u5185\uff09\u6216\u7a7a\u3002", (String)"BizItemEdit_6", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
        FieldTip tip = null;
        String scaleLimit = (String)this.getModel().getValue("scalelimit");
        if (SWCStringUtils.isNotEmpty((String)inputValue) && !inputValue.matches(REGEX)) {
            tip = "inputminval".equals(fieldKey) ? this.showValidateTip(false, msg, "inputminval") : this.showValidateTip(false, msg, "inputmaxval");
            this.getView().showFieldTip(tip);
            return;
        }
        tip = "inputminval".equals(fieldKey) ? this.showValidateTip(true, msg, "inputminval") : this.showValidateTip(true, msg, "inputmaxval");
        this.getView().showFieldTip(tip);
        if (SWCStringUtils.isNotEmpty((String)inputValue) && !SWCStringUtils.isEmpty((String)scaleLimit) && (scale = new BigDecimal(inputValue).scale()) > Integer.parseInt(scaleLimit)) {
            if ("inputminval".equals(fieldKey)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6700\u5c0f\u8f93\u5165\u503c\u4e0d\u7b26\u5408\u5c0f\u6570\u4f4d\u6570\u9650\u5236\u3002", (String)"BizItemEdit_7", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6700\u5927\u8f93\u5165\u503c\u4e0d\u7b26\u5408\u5c0f\u6570\u4f4d\u6570\u9650\u5236\u3002", (String)"BizItemEdit_8", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void checkMaxValueAndMinValue(String scaleLimit) {
        if (!SWCStringUtils.isEmpty((String)scaleLimit)) {
            String maxValue = (String)this.getModel().getValue("inputmaxval");
            this.checkInputValue("inputmaxval", maxValue);
            String minValue = (String)this.getModel().getValue("inputminval");
            this.checkInputValue("inputminval", minValue);
        }
    }
}

