/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.basedata.bizitem;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.TipsSupport;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;
import kd.swc.hsbs.service.BizItemService;

public class BizItemEdit
extends SWCDataBaseEdit {
    private static final String REGEX = "^(\\-|\\+)?\\d+(\\.\\d{1,10})?$";
    private static final String CYCLE_CHANGE_CALLBACK = "cycleChangeCallBack";
    private static final String EXTPROP_CHANGE_CALLBACK = "extPropChangeCallBack";
    private static final String BTN_ADDPROP = "addprop";
    private static final String BTN_DELPROP = "delprop";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void afterBindData(EventObject eventObject) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"inputminval", "scalelimit", "inputmaxval", "datalength", "country"});
        DynamicObject data = this.getModel().getDataEntity();
        this.checkDataType();
        this.initMaxValueAndMinEnable();
        this.checkAreaType();
        String cycle = data.getString("cycle");
        this.setConsumemethodSelectValue(cycle, data.getLong("datatype.id"), data.getString("multipleinput"), true);
        this.checkMultipleinput(data.getString("multipleinput"));
        this.setMultipleinputFiled(cycle, true);
        this.setIslistgenerateFiled(cycle);
        this.setIsSalaryStdFiled(cycle);
        this.setFiledsEnable();
        this.initMaxValueAndMinValue();
        this.initTips();
        this.setExtPropAndBizItemEntryStyle();
        this.bizItemPropEntryInputValSet();
        this.bizItemPropEntryDataLengthSet();
        this.showSelectCheckBox();
        this.getModel().setDataChanged(false);
    }

    private void showSelectCheckBox() {
        String status = (String)this.getModel().getValue("status");
        if (SWCStringUtils.equals((String)status, (String)"B") || SWCStringUtils.equals((String)status, (String)"C")) {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>(1);
            map.put("selchexkbox", false);
            this.getView().updateControlMetadata("bizitempropentry", map);
        } else {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>(1);
            map.put("selchexkbox", true);
            this.getView().updateControlMetadata("bizitempropentry", map);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "unaudit": 
            case "unsubmit": {
                this.setFiledsEnable();
                this.getView().invokeOperation("refresh");
                break;
            }
            case "save": 
            case "submit": {
                OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
                if (!operationResult.isSuccess()) break;
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs changedArgs) {
        String fieldKey = changedArgs.getProperty().getName();
        ChangeData[] changeData = changedArgs.getChangeSet();
        DynamicObject data = this.getModel().getDataEntity();
        switch (fieldKey) {
            case "datatype": {
                DynamicObject newValue = (DynamicObject)changeData[0].getNewValue();
                if (newValue == null || newValue.equals(changeData[0].getOldValue())) break;
                this.getModel().beginInit();
                this.getModel().setValue("inputminval", null);
                this.getModel().setValue("inputmaxval", null);
                this.getModel().setValue("datalength", null);
                this.getModel().setValue("scalelimit", null);
                this.getModel().setValue("earliestdate", null);
                this.getModel().setValue("lastdate", null);
                this.getModel().setValue("currency", null);
                this.getModel().setValue("consumemethod", null);
                this.checkDataType();
                this.initMaxValueAndMinEnable();
                this.setConsumemethodSelectValue(data.getString("cycle"), newValue.getLong("id"), data.getString("multipleinput"), false);
                this.getModel().endInit();
                this.getView().updateView();
                break;
            }
            case "datalength": {
                Integer dataLength = (Integer)this.getModel().getValue("datalength");
                if (dataLength == null || dataLength > 0) break;
                this.getModel().setValue("datalength", null);
                break;
            }
            case "areatype": {
                String newAreaType = (String)changeData[0].getNewValue();
                String oldAreaType = (String)changeData[0].getOldValue();
                if (SWCStringUtils.equals((String)newAreaType, (String)oldAreaType)) {
                    return;
                }
                this.checkAreaType();
                break;
            }
            case "multipleinput": {
                String multipleinput = (String)changeData[0].getNewValue();
                if (SWCStringUtils.isEmpty((String)multipleinput)) {
                    return;
                }
                this.checkMultipleinput(multipleinput);
                this.setConsumemethodSelectValue(data.getString("cycle"), data.getLong("datatype.id"), multipleinput, false);
                break;
            }
            case "oneoffconsume": {
                String oneOffConsume = (String)changeData[0].getNewValue();
                if (!SWCStringUtils.isEmpty((String)oneOffConsume)) break;
                return;
            }
            case "cycle": {
                ChangeData[] changeDatas = changedArgs.getChangeSet();
                String oldVal = (String)changeDatas[0].getOldValue();
                String newVal = (String)changeDatas[0].getNewValue();
                SWCPageCache pageCache = new SWCPageCache(this.getView());
                if (SWCStringUtils.equals((String)oldVal, (String)"1") && SWCStringUtils.equals((String)newVal, (String)"0")) {
                    pageCache.put("cycleNewVal", (Object)newVal);
                    pageCache.put("cycleOldVal", (Object)oldVal);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u975e\u5faa\u73af\u9879\u4e0d\u652f\u6301\u8bbe\u7f6e\u6269\u5c55\u5c5e\u6027\uff0c\u76f8\u5173\u8bbe\u7f6e\u5c06\u6e05\u7a7a\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BizItemEdit_11", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CYCLE_CHANGE_CALLBACK));
                    break;
                }
                pageCache.put("cycleCanDoChange", (Object)Boolean.TRUE);
                this.cycleChangeEvent(newVal);
                break;
            }
            case "inputminval": 
            case "inputmaxval": {
                String inputValue = (String)changeData[0].getNewValue();
                this.checkInputValue(fieldKey, inputValue);
                break;
            }
            case "scalelimit": {
                String scaleLimit = (String)changeData[0].getNewValue();
                this.initMaxValueAndMinEnable();
                this.checkMaxValueAndMinValue(scaleLimit);
                break;
            }
            case "isextprop": {
                this.extPropChangeEvent(changedArgs);
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String fieldKey = evt.getItemKey();
        if (SWCStringUtils.equals((String)BTN_ADDPROP, (String)fieldKey)) {
            this.openBizPropItemF7();
        } else if (SWCStringUtils.equals((String)BTN_DELPROP, (String)fieldKey)) {
            this.delBizPropItem();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String callBackValue = closedCallBackEvent.getActionId();
        if (SWCStringUtils.equals((String)callBackValue, (String)"hsbs_bizitemprop")) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            this.addBizItemPropDatas(rows);
            this.bizItemPropEntryInputValSet();
            this.bizItemPropEntryDataLengthSet();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        if (SWCStringUtils.equals((String)callBackId, (String)CYCLE_CHANGE_CALLBACK)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                String cycleNewVal = (String)pageCache.get("cycleNewVal", String.class);
                pageCache.put("cycleCanDoChange", (Object)Boolean.TRUE);
                this.cycleChangeEvent(cycleNewVal);
                this.getModel().deleteEntryData("bizitempropentry");
                Boolean isExtProp = (Boolean)this.getModel().getValue("isextprop");
                if (isExtProp != null && isExtProp.booleanValue()) {
                    pageCache.put("overExtPropChangeEvent", (Object)Boolean.TRUE);
                    this.getModel().setValue("isextprop", (Object)Boolean.FALSE);
                }
            } else {
                String cycleOldVal = (String)pageCache.get("cycleOldVal", String.class);
                this.getModel().setValue("cycle", (Object)cycleOldVal);
            }
        } else if (SWCStringUtils.equals((String)callBackId, (String)EXTPROP_CHANGE_CALLBACK)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                pageCache.put("extPropCanDoChange", (Object)Boolean.TRUE);
                this.setExtPropAndBizItemEntryStyle();
                this.getModel().deleteEntryData("bizitempropentry");
            } else {
                boolean extPropOldVal = (Boolean)pageCache.get("extPropOldVal", Boolean.class);
                this.getModel().setValue("isextprop", (Object)extPropOldVal);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (SWCStringUtils.equals((String)"save", (String)operateKey) || SWCStringUtils.equals((String)"submit", (String)operateKey)) {
            DynamicObject bizItemObj = this.getModel().getDataEntity();
            String minVal = bizItemObj.getString("inputminval");
            String maxVal = bizItemObj.getString("inputmaxval");
            if (SWCStringUtils.isEmpty((String)minVal)) {
                this.getModel().setValue("isminvalnull", (Object)"1");
            } else {
                BigDecimal minValue = null;
                try {
                    minValue = new BigDecimal(minVal);
                }
                catch (Exception e) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6700\u5c0f\u8f93\u5165\u503c\u201d\u3002", (String)"BizItemEdit_9", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                this.getModel().setValue("minvalue", (Object)minValue.toPlainString());
                this.getModel().setValue("isminvalnull", (Object)"0");
            }
            if (SWCStringUtils.isEmpty((String)maxVal)) {
                this.getModel().setValue("ismaxvalnull", (Object)"1");
            } else {
                BigDecimal maxValue = null;
                try {
                    maxValue = new BigDecimal(maxVal);
                }
                catch (Exception e) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6700\u5927\u8f93\u5165\u503c\u201d\u3002", (String)"BizItemEdit_10", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                this.getModel().setValue("maxvalue", (Object)maxValue.toPlainString());
                this.getModel().setValue("ismaxvalnull", (Object)"0");
            }
            source.getOption().setVariableValue("save", Boolean.TRUE.toString());
        }
    }

    private void extPropChangeEvent(PropertyChangedArgs event) {
        SWCPageCache newPageCache = new SWCPageCache(this.getView());
        boolean overExtPropChangeEvent = false;
        if (newPageCache.get("overExtPropChangeEvent", Boolean.class) != null) {
            overExtPropChangeEvent = (Boolean)newPageCache.get("overExtPropChangeEvent", Boolean.class);
        }
        if (overExtPropChangeEvent) {
            newPageCache.remove("overExtPropChangeEvent");
            return;
        }
        ChangeData[] extPropChangeDatas = event.getChangeSet();
        boolean extPropOldVal = false;
        if (extPropChangeDatas[0].getOldValue() != null) {
            extPropOldVal = (Boolean)extPropChangeDatas[0].getOldValue();
        }
        boolean extPropNewVal = false;
        if (extPropChangeDatas[0].getNewValue() != null) {
            extPropNewVal = (Boolean)extPropChangeDatas[0].getNewValue();
        }
        if (extPropOldVal && !extPropNewVal) {
            if (this.getUnAuditStatus()) {
                if (this.isExitAuditPropData()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u4fee\u6539\u4e1a\u52a1\u9879\u76ee\u5c5e\u6027\uff0c\u56e0\u4e3a\u5b58\u5728\u5df2\u5ba1\u6838\u8fc7\u7684\u6570\u636e\u3002", (String)"BizItemEdit_16", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                    newPageCache.put("overExtPropChangeEvent", (Object)Boolean.TRUE);
                    this.getModel().setValue("isextprop", (Object)extPropOldVal);
                } else {
                    newPageCache.put("extPropOldVal", (Object)extPropOldVal);
                    newPageCache.put("extPropNewVal", (Object)extPropNewVal);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5173\u95ed\u6269\u5c55\u5c5e\u6027\u5c06\u6e05\u7a7a\u4e1a\u52a1\u9879\u76ee\u5c5e\u6027\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BizItemEdit_12", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(EXTPROP_CHANGE_CALLBACK));
                }
            } else {
                newPageCache.put("extPropOldVal", (Object)extPropOldVal);
                newPageCache.put("extPropNewVal", (Object)extPropNewVal);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5173\u95ed\u6269\u5c55\u5c5e\u6027\u5c06\u6e05\u7a7a\u4e1a\u52a1\u9879\u76ee\u5c5e\u6027\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BizItemEdit_12", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(EXTPROP_CHANGE_CALLBACK));
            }
        } else {
            newPageCache.put("extPropCanDoChange", (Object)Boolean.TRUE);
            this.setExtPropAndBizItemEntryStyle();
        }
    }

    private boolean isExitAuditPropData() {
        boolean isExit = false;
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity("bizitempropentry");
        for (DynamicObject entryObj : entryColl) {
            String isAudit = entryObj.getString("propisaudit");
            if (!SWCStringUtils.equals((String)isAudit, (String)"1")) continue;
            return true;
        }
        return isExit;
    }

    private FieldTip showValidateTip(boolean isHide, String msg, String field) {
        FieldTip fieldTip = new FieldTip();
        fieldTip.setSuccess(isHide);
        fieldTip.setFieldKey(field);
        if (!isHide) {
            fieldTip.setTip(msg);
        }
        return fieldTip;
    }

    private void initMaxValueAndMinValue() {
        DynamicObject dataType = (DynamicObject)this.getModel().getValue("datatype");
        if (SWCObjectUtils.isEmpty((Object)dataType)) {
            return;
        }
        long dataTypeId = dataType.getLong("id");
        if (1010L == dataTypeId) {
            DynamicObject bizItemObj = this.getModel().getDataEntity();
            String scaleLimit = bizItemObj.getString("scalelimit");
            BigDecimal maxVal = bizItemObj.getBigDecimal("maxvalue");
            BigDecimal minVal = bizItemObj.getBigDecimal("minvalue");
            Boolean isMinValNull = bizItemObj.getBoolean("isminvalnull");
            boolean isMaxValNull = bizItemObj.getBoolean("ismaxvalnull");
            int scale = 10;
            if (StringUtils.isNotEmpty((String)scaleLimit)) {
                scale = Integer.parseInt(scaleLimit);
            }
            if (isMinValNull.booleanValue()) {
                this.getModel().setValue("inputminval", null);
            } else {
                this.getModel().setValue("inputminval", (Object)minVal.setScale(scale, 4).toPlainString());
            }
            if (isMaxValNull) {
                this.getModel().setValue("inputmaxval", null);
            } else {
                this.getModel().setValue("inputmaxval", (Object)maxVal.setScale(scale, 4).toPlainString());
            }
        }
    }

    private void setFiledsEnable() {
        String enable = (String)this.getModel().getValue("enable");
        if (!"10".equals(enable)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"datatype", "datalength", "cycle", "number"});
        }
    }

    private void setMultipleinputFiled(String cycle, boolean isInit) {
        Boolean isCycle;
        Boolean bl = isCycle = cycle.equals("1") ? Boolean.TRUE : Boolean.FALSE;
        if (isCycle.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"multipleinput", "consumemethod"});
            if (!isInit) {
                this.getModel().setValue("multipleinput", (Object)"0");
            }
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"multipleinput", "consumemethod"});
        }
    }

    private void setIslistgenerateFiled(String cycle) {
        Boolean isCycle;
        Boolean bl = isCycle = cycle.equals("1") ? Boolean.TRUE : Boolean.FALSE;
        if (isCycle.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"islistgenerate"});
            this.getModel().setValue("islistgenerate", (Object)"0");
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"islistgenerate"});
        }
    }

    private void setIsSalaryStdFiled(String cycle) {
        Boolean isCycle;
        Boolean bl = isCycle = SWCStringUtils.equals((String)cycle, (String)"1") ? Boolean.TRUE : Boolean.FALSE;
        if (isCycle.booleanValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"issalarystd"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"issalarystd"});
            this.getModel().setValue("issalarystd", (Object)"0");
        }
    }

    private void checkMultipleinput(String multipleinput) {
        DecimalEdit maxInputTime = (DecimalEdit)this.getControl("maxinputtime");
        if (SWCStringUtils.equals((String)"1", (String)multipleinput)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"maxinputtime"});
            maxInputTime.setMustInput(true);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"maxinputtime"});
            maxInputTime.setMustInput(false);
        }
    }

    private void setExtPropAndBizItemEntryStyle() {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        boolean extPropCanDoChange = true;
        if (pageCache.get("extPropCanDoChange", Boolean.class) != null) {
            extPropCanDoChange = (Boolean)pageCache.get("extPropCanDoChange", Boolean.class);
        }
        if (extPropCanDoChange) {
            String isCycle = (String)this.getModel().getValue("cycle");
            if (SWCStringUtils.equals((String)isCycle, (String)"1")) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"isextprop"});
                boolean isExtProp = (Boolean)this.getModel().getValue("isextprop");
                if (isExtProp) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"bizitempropset"});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"bizitempropset"});
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"isextprop", "bizitempropset"});
            }
            pageCache.remove("extPropCanDoChange");
        }
    }

    private void setConsumemethodSelectValue(String cycle, long dataTypeId, String multipleinput, boolean isInitFlag) {
        Boolean isCycle = cycle.equals("1") ? Boolean.TRUE : Boolean.FALSE;
        ComboEdit comboEdit = (ComboEdit)this.getControl("consumemethod");
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(10);
        String defaultValue = null;
        if (!isCycle.booleanValue()) {
            if (1050L == dataTypeId || 1030L == dataTypeId) {
                data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6700\u65b0", (String)"BizItemEdit_0", (String)"swc-hsbs-formplugin", (Object[])new Object[0])), "1"));
                data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6700\u65e9", (String)"BizItemEdit_1", (String)"swc-hsbs-formplugin", (Object[])new Object[0])), "2"));
                defaultValue = "1";
            } else if (1010L == dataTypeId || 1020L == dataTypeId) {
                data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6700\u65b0", (String)"BizItemEdit_0", (String)"swc-hsbs-formplugin", (Object[])new Object[0])), "1"));
                data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6700\u65e9", (String)"BizItemEdit_1", (String)"swc-hsbs-formplugin", (Object[])new Object[0])), "2"));
                data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6700\u5927", (String)"BizItemEdit_2", (String)"swc-hsbs-formplugin", (Object[])new Object[0])), "3"));
                data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6700\u5c0f", (String)"BizItemEdit_3", (String)"swc-hsbs-formplugin", (Object[])new Object[0])), "4"));
                data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6c47\u603b", (String)"BizItemEdit_4", (String)"swc-hsbs-formplugin", (Object[])new Object[0])), "5"));
                data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5e73\u5747", (String)"BizItemEdit_5", (String)"swc-hsbs-formplugin", (Object[])new Object[0])), "6"));
                defaultValue = "5";
            }
        } else {
            data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6700\u65b0", (String)"BizItemEdit_0", (String)"swc-hsbs-formplugin", (Object[])new Object[0])), "1"));
            data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6700\u65e9", (String)"BizItemEdit_1", (String)"swc-hsbs-formplugin", (Object[])new Object[0])), "2"));
            data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6700\u5927", (String)"BizItemEdit_2", (String)"swc-hsbs-formplugin", (Object[])new Object[0])), "3"));
            data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6700\u5c0f", (String)"BizItemEdit_3", (String)"swc-hsbs-formplugin", (Object[])new Object[0])), "4"));
            data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6c47\u603b", (String)"BizItemEdit_4", (String)"swc-hsbs-formplugin", (Object[])new Object[0])), "5"));
            data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5e73\u5747", (String)"BizItemEdit_5", (String)"swc-hsbs-formplugin", (Object[])new Object[0])), "6"));
            if (!isInitFlag) {
                this.getModel().setValue("consumemethod", (Object)"1");
            }
        }
        comboEdit.setComboItems(data);
        if (isInitFlag) {
            return;
        }
        if (SWCStringUtils.equals((String)multipleinput, (String)"1")) {
            this.getModel().setValue("consumemethod", defaultValue);
        }
    }

    private void checkDataType() {
        DynamicObject dataType = (DynamicObject)this.getModel().getValue("datatype");
        FieldEdit dataLengthField = (FieldEdit)this.getControl("datalength");
        dataLengthField.setMustInput(false);
        FieldEdit scaleLimitField = (FieldEdit)this.getControl("scalelimit");
        scaleLimitField.setMustInput(false);
        if (dataType == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"inputminval", "inputmaxval", "datalength", "earliestdate", "lastdate", "currency", "scalelimit"});
            return;
        }
        long dataTypeId = dataType.getLong("id");
        if (1010L == dataTypeId) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"inputminval", "inputmaxval", "scalelimit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"datalength", "earliestdate", "lastdate", "currency"});
            scaleLimitField.setMustInput(true);
        } else if (1030L == dataTypeId) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"inputminval", "inputmaxval", "earliestdate", "lastdate", "currency", "scalelimit"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"datalength"});
            dataLengthField.setMustInput(true);
        } else if (1020L == dataTypeId) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"currency"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"datalength", "earliestdate", "lastdate", "scalelimit", "inputminval", "inputmaxval"});
        } else if (1050L == dataTypeId) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"earliestdate", "lastdate"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"datalength", "inputminval", "inputmaxval", "currency", "scalelimit"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"inputminval", "inputmaxval", "datalength", "earliestdate", "lastdate", "currency", "scalelimit"});
        }
    }

    private void checkAreaType() {
        String areaType = (String)this.getModel().getValue("areatype");
        FieldEdit contryField = (FieldEdit)this.getControl("country");
        if ("2".equals(areaType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"country"});
            contryField.setMustInput(true);
        } else {
            this.getModel().setValue("country", null);
            this.getView().setVisible(Boolean.FALSE, new String[]{"country"});
            contryField.setMustInput(false);
        }
    }

    private void initMaxValueAndMinEnable() {
        String scaleLimit = (String)this.getModel().getValue("scalelimit");
        if (SWCStringUtils.isEmpty((String)scaleLimit)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"inputminval", "inputmaxval"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"inputminval", "inputmaxval"});
        }
    }

    private void checkInputValue(String fieldKey, String inputValue) {
        int scale;
        String msg = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6570\u503c\uff0810\u4f4d\u5c0f\u6570\u4ee5\u5185\uff09\u6216\u7a7a\u3002", (String)"BizItemEdit_6", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
        FieldTip tip = null;
        String scaleLimit = (String)this.getModel().getValue("scalelimit");
        if (SWCStringUtils.isNotEmpty((String)inputValue) && !inputValue.matches(REGEX)) {
            tip = "inputminval".equals(fieldKey) ? this.showValidateTip(false, msg, "inputminval") : this.showValidateTip(false, msg, "inputmaxval");
            this.getView().showFieldTip(tip);
            return;
        }
        tip = "inputminval".equals(fieldKey) ? this.showValidateTip(true, msg, "inputminval") : this.showValidateTip(true, msg, "inputmaxval");
        this.getView().showFieldTip(tip);
        if (SWCStringUtils.isNotEmpty((String)inputValue) && !SWCStringUtils.isEmpty((String)scaleLimit) && (scale = new BigDecimal(inputValue).scale()) > Integer.parseInt(scaleLimit)) {
            if ("inputminval".equals(fieldKey)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6700\u5c0f\u8f93\u5165\u503c\u4e0d\u7b26\u5408\u5c0f\u6570\u4f4d\u6570\u9650\u5236\u3002", (String)"BizItemEdit_7", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6700\u5927\u8f93\u5165\u503c\u4e0d\u7b26\u5408\u5c0f\u6570\u4f4d\u6570\u9650\u5236\u3002", (String)"BizItemEdit_8", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void checkMaxValueAndMinValue(String scaleLimit) {
        if (!SWCStringUtils.isEmpty((String)scaleLimit)) {
            String maxValue = (String)this.getModel().getValue("inputmaxval");
            this.checkInputValue("inputmaxval", maxValue);
            String minValue = (String)this.getModel().getValue("inputminval");
            this.checkInputValue("inputminval", minValue);
        }
    }

    private void initTips() {
        List promptString = (List)SWCMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSService", (String)"queryPromptForString", (Object[])new Object[]{this.getModel().getDataEntityType().getName(), "islistgenerate", this.getModel().getDataEntity()});
        String tipsValue = "";
        Iterator iterator = promptString.iterator();
        while (iterator.hasNext()) {
            String entry;
            tipsValue = entry = (String)iterator.next();
        }
        Tips tips = new Tips();
        tips.setType("text");
        tips.setContent(new LocaleString(tipsValue));
        TipsSupport control = (TipsSupport)this.getControl("islistgenerate");
        control.addTips(tips);
    }

    private void cycleChangeEvent(String cycleNewVal) {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        boolean cycleCanDoChange = (Boolean)pageCache.get("cycleCanDoChange", Boolean.class);
        if (cycleCanDoChange) {
            DynamicObject data = this.getModel().getDataEntity();
            this.setMultipleinputFiled(cycleNewVal, false);
            this.setIslistgenerateFiled(cycleNewVal);
            this.setIsSalaryStdFiled(cycleNewVal);
            long dataTypeId = data.getLong("datatype.id");
            if (dataTypeId != 0L) {
                String multipleInput = data.getString("multipleinput");
                this.setConsumemethodSelectValue(cycleNewVal, dataTypeId, multipleInput, false);
            }
            this.setExtPropAndBizItemEntryStyle();
            if (SWCStringUtils.equals((String)cycleNewVal, (String)"1")) {
                this.getModel().setValue("maxinputtime", (Object)0);
            }
            pageCache.remove("cycleCanDoChange");
        }
    }

    private void openBizPropItemF7() {
        DynamicObject data = this.getModel().getDataEntity(true);
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject createOrgObj = this.getModel().getDataEntity().getDynamicObject("createorg");
        Long createOrgId = createOrgObj.getLong("id");
        QFilter createOrgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_bizitemprop", (Long)createOrgId);
        if (createOrgFilter != null) {
            qFilter.and(createOrgFilter);
        }
        DynamicObjectCollection entry = data.getDynamicObjectCollection("bizitempropentry");
        HashSet idList = new HashSet(16);
        if (entry.size() > 0) {
            idList.addAll(entry.stream().map(obj -> obj.getLong("bizitemprop.id")).collect(Collectors.toSet()));
        }
        if (idList.size() > 0) {
            qFilter.and("id", "not in", idList);
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setBillFormId("hsbs_bizitemprop");
        showParameter.setFormId("bos_listf7");
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("960px");
        styleCss.setHeight("580px");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        showParameter.setLookUp(true);
        showParameter.setMultiSelect(true);
        showParameter.setShowTitle(false);
        showParameter.setHasRight(true);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsbs_bizitemprop"));
        showParameter.getListFilterParameter().setFilter(qFilter);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void delBizPropItem() {
        Long bizItemId = (Long)this.getModel().getValue("id");
        if (bizItemId == null || bizItemId == 0L) {
            this.getView().invokeOperation("deleteentry");
            return;
        }
        DynamicObjectCollection bizItemPropColl = this.getModel().getEntryEntity("bizitempropentry");
        if (bizItemPropColl == null || bizItemPropColl.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"BizItemEdit_13", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("bizitempropentry");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"BizItemEdit_13", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<String> auditList = new ArrayList<String>(10);
        ArrayList<Integer> unAuditList = new ArrayList<Integer>(10);
        for (int selectRow : selectRows) {
            DynamicObject entryObj = (DynamicObject)bizItemPropColl.get(selectRow);
            String isAudit = entryObj.getString("propisaudit");
            if (SWCStringUtils.equals((String)isAudit, (String)"1")) {
                DynamicObject bizItemObj = entryObj.getDynamicObject("bizitemprop");
                String bizItemNumber = bizItemObj.getString("number");
                auditList.add(bizItemNumber);
                continue;
            }
            unAuditList.add(selectRow);
        }
        if (auditList.size() == 0) {
            if (unAuditList.size() != 0) {
                this.getView().invokeOperation("deleteentry");
            }
        } else if (unAuditList.size() == 0) {
            this.showDelFailF7(auditList, auditList.size());
        } else {
            if (unAuditList.size() > 0) {
                int[] delIndex = new int[unAuditList.size()];
                for (int i = 0; i < unAuditList.size(); ++i) {
                    delIndex[i] = (Integer)unAuditList.get(i);
                }
                entryGrid.selectRows(delIndex, 1);
                this.getView().invokeOperation("deleteentry");
            }
            this.getView().updateView("bizitempropentry");
            this.showDelFailF7(auditList, selectRows.length);
        }
    }

    private void showDelFailF7(List<String> delList, int totalCount) {
        int failCount = delList.size();
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("bos_operationresult");
        parameters.setCustomParam("hasMore", (Object)Boolean.FALSE);
        parameters.setShowTitle(false);
        String title = MessageFormat.format(ResManager.loadKDString((String)"\u5171{0}\u6761\u6570\u636e\uff0c\u5220\u9664\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761\u3002", (String)"BizItemEdit_14", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), totalCount, totalCount - failCount, failCount);
        parameters.setCustomParam("title", (Object)title);
        StringBuilder errorMsg = new StringBuilder();
        String errorTpl = ResManager.loadKDString((String)"{0}\uff1a\u8be5\u9879\u76ee\u7684\u5c5e\u6027\u5df2\u5ba1\u6838 \uff0c\u4e0d\u80fd\u5220\u9664\u3002\r\n", (String)"BizItemEdit_15", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
        for (String delNumber : delList) {
            errorMsg.append(MessageFormat.format(errorTpl, delNumber));
        }
        parameters.setCustomParam("errorMsg", (Object)errorMsg.toString());
        this.getView().showForm(parameters);
    }

    private void addBizItemPropDatas(ListSelectedRowCollection selectedRows) {
        if (selectedRows == null || selectedRows.size() == 0) {
            return;
        }
        ArrayList<Long> bizItemPropIdList = new ArrayList<Long>(selectedRows.size());
        for (ListSelectedRow listSelectedRow : selectedRows) {
            long bizItemPropId = (Long)listSelectedRow.getPrimaryKeyValue();
            bizItemPropIdList.add(bizItemPropId);
        }
        BizItemService bizItemService = new BizItemService();
        Map propDataLenMap = bizItemService.batchGetBizItemPropDataLen(bizItemPropIdList);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("bizitemprop", new Object[0]);
        vs.addField("propdatalength", new Object[0]);
        for (ListSelectedRow listSelectedRow : selectedRows) {
            long bizItemPropId = (Long)listSelectedRow.getPrimaryKeyValue();
            vs.addRow(new Object[]{bizItemPropId, propDataLenMap.get(bizItemPropId)});
        }
        model.beginInit();
        model.batchCreateNewEntryRow("bizitempropentry", vs);
        model.endInit();
        this.getView().updateView("bizitempropentry");
    }

    private boolean getUnAuditStatus() {
        boolean isAudit = false;
        String enable = (String)this.getModel().getValue("enable");
        if (SWCStringUtils.equals((String)enable, (String)"1")) {
            isAudit = true;
        }
        return isAudit;
    }

    private void bizItemPropEntryInputValSet() {
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity("bizitempropentry");
        if (entryColl == null || entryColl.size() == 0) {
            return;
        }
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            long dataTypeId;
            DynamicObject dataType;
            DynamicObject entryObj = (DynamicObject)entryColl.get(i);
            DynamicObject bizItemPropObj = entryObj.getDynamicObject("bizitemprop");
            if (SWCObjectUtils.isEmpty((Object)bizItemPropObj) || SWCObjectUtils.isEmpty((Object)(dataType = bizItemPropObj.getDynamicObject("datatype"))) || 1010L != (dataTypeId = dataType.getLong("id"))) continue;
            String scaleLimit = bizItemPropObj.getString("scalelimit");
            BigDecimal maxVal = bizItemPropObj.getBigDecimal("maxvalue");
            BigDecimal minVal = bizItemPropObj.getBigDecimal("minvalue");
            String isMinValNull = bizItemPropObj.getString("isminvalnull");
            String isMaxValNull = bizItemPropObj.getString("ismaxvalnull");
            int scale = 10;
            if (StringUtils.isNotEmpty((String)scaleLimit)) {
                scale = Integer.parseInt(scaleLimit);
            }
            if (SWCStringUtils.equals((String)isMinValNull, (String)"1")) {
                this.getModel().setValue("propinputminval", null, i);
            } else {
                this.getModel().setValue("propinputminval", (Object)minVal.setScale(scale, 4).toPlainString(), i);
            }
            if (SWCStringUtils.equals((String)isMaxValNull, (String)"1")) {
                this.getModel().setValue("propinputmaxval", null, i);
                continue;
            }
            this.getModel().setValue("propinputmaxval", (Object)maxVal.setScale(scale, 4).toPlainString(), i);
        }
    }

    private void bizItemPropEntryDataLengthSet() {
        DynamicObjectCollection propEntryColl = this.getModel().getEntryEntity("bizitempropentry");
        if (propEntryColl == null || propEntryColl.size() == 0) {
            return;
        }
        for (int i = 0; i < propEntryColl.size(); ++i) {
            Integer propDataLen;
            DynamicObject propEntryObj = (DynamicObject)propEntryColl.get(i);
            DynamicObject bizItemPropObj = propEntryObj.getDynamicObject("bizitemprop");
            if (SWCObjectUtils.isEmpty((Object)bizItemPropObj) || (propDataLen = (Integer)bizItemPropObj.get("datalength")) == null) continue;
            this.getModel().setValue("propdatalength", (Object)propDataLen, i);
        }
    }
}

