/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.basedata.bizitem;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbs.common.util.TreeUtils;

public class BizItemTreeListF7Plugin
extends StandardTreeListPlugin
implements SearchEnterListener,
TreeNodeClickListener {
    private static final int CHILDREN_LEVEL = 10;

    public void initializeTree(EventObject eventObject) {
        TreeNode root = this.initRootNode();
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        treeView.addNode(root);
        this.loadChildNode();
        treeView.focusNode(root);
    }

    private TreeNode initRootNode() {
        TreeNode root = new TreeNode();
        root.setId("100000");
        root.setText(ResManager.loadKDString((String)"\u4e1a\u52a1\u9879\u76ee\u7c7b\u522b", (String)"TaxItemTreeListF7Plugin_0", (String)"sit-sitbs-formplugin", (Object[])new Object[0]));
        root.setData((Object)"");
        root.setParentid("");
        root.setIsOpened(true);
        return root;
    }

    private void loadChildNode() {
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        ITreeModel treeModel = this.getTreeModel();
        TreeMap<String, String> allCategoryData = this.getAllTaxCategoryData();
        ArrayList<TreeNode> newNodeList = new ArrayList<TreeNode>(10);
        String parentId = "100000";
        for (Map.Entry<String, String> entry : allCategoryData.entrySet()) {
            TreeNode node = new TreeNode(parentId, entry.getKey(), entry.getValue());
            newNodeList.add(node);
        }
        treeModel.addNodes((Object)parentId, newNodeList);
        treeView.addNodes(newNodeList);
    }

    private TreeMap<String, String> getAllTaxCategoryData() {
        DynamicObject[] dynamicObjects;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_bizitemcategory");
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        String selectFields = "id,number,name";
        QFilter filter = null;
        if (customParams.containsKey("filterLeftTree")) {
            Set<Long> categoryIdList = this.getEffectiveCategoryIdList();
            filter = new QFilter("id", "in", categoryIdList);
        }
        QFilter[] filters = new QFilter[]{filter};
        String orderBys = "number asc";
        for (DynamicObject dynamicObject : dynamicObjects = helper.query(selectFields, filters, orderBys)) {
            String id = dynamicObject.getString("id");
            String name = dynamicObject.getString("name");
            treeMap.put(id, name);
        }
        return treeMap;
    }

    public void refreshNode(RefreshNodeEvent event) {
        super.refreshNode(event);
        TreeNode root = this.getTreeModel().getRoot();
        String nodeId = (String)event.getNodeId();
        TreeNode currNode = root.getTreeNode(nodeId, 10);
        event.setChildNodes(currNode.getChildren());
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        treeView.expand("100000");
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent event) {
        TreeNode root = this.getTreeModel().getRoot();
        String currNodeId = (String)event.getNodeId();
        TreeNode currNode = root.getTreeNode(currNodeId, 10);
        List childIds = TreeUtils.getSubNodes((TreeNode)currNode);
        QFilter filter = new QFilter("bizitemcategory.id", "in", (Object)childIds);
        event.addQFilter(filter);
        event.setCancel(true);
    }

    private Set<Long> getEffectiveCategoryIdList() {
        HashSet<Long> categoryIdList = new HashSet<Long>(16);
        QFilter orgFilter = this.getBizItemOrgFilter();
        List filters = ((ListShowParameter)this.getView().getFormShowParameter()).getListFilterParameter().getQFilters();
        filters.add(orgFilter);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_bizitem");
        Object[] bizItemArr = helper.query("bizitemcategory.id", filters.toArray(new QFilter[0]));
        if (!SWCArrayUtils.isEmpty((Object[])bizItemArr)) {
            for (Object bizItem : bizItemArr) {
                categoryIdList.add(bizItem.getLong("bizitemcategory.id"));
            }
        }
        return categoryIdList;
    }

    private QFilter getBizItemOrgFilter() {
        String entityName = ((IListView)this.getView()).getBillFormId();
        HasPermOrgResult hasPermOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHLXNRR9KPZ", (String)entityName, (String)"47150e89000000ac");
        if (hasPermOrgResult.hasAllOrgPerm()) {
            return new QFilter("1", "=", (Object)1);
        }
        List allOrgList = hasPermOrgResult.getHasPermOrgs();
        QFilter orgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_bizitem", (List)allOrgList, (boolean)true);
        return orgFilter;
    }
}

