/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.basedata.bizitemprop;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FieldTip;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.util.StringUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;
import kd.swc.hsbs.common.enums.DataTypeEnum;

public class BizItemPropEdit
extends SWCDataBaseEdit {
    private static final String REGEX = "^(\\-|\\+)?\\d+(\\.\\d{1,10})?$";

    public void beforeBindData(EventObject eventObject) {
        this.propParamSetByDataType();
        this.initMaxValueAndMinEnable();
        this.setFiledsEnable();
        this.initMaxValueAndMinValue();
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey = args.getProperty().getName();
        ChangeData[] changeData = args.getChangeSet();
        if (SWCStringUtils.equals((String)fieldKey, (String)"datatype")) {
            this.propParamSetByDataType();
            this.clearInputValue("datalength", "scalelimit", "inputminval", "inputmaxval", "earliestdate", "lastdate");
        } else if (SWCStringUtils.equals((String)fieldKey, (String)"scalelimit")) {
            String scaleLimit = (String)changeData[0].getNewValue();
            this.initMaxValueAndMinEnable();
            this.checkMaxValueAndMinValue(scaleLimit);
        } else if (SWCStringUtils.equals((String)fieldKey, (String)"inputminval") || SWCStringUtils.equals((String)fieldKey, (String)"inputmaxval")) {
            String inputValue = (String)changeData[0].getNewValue();
            this.checkInputValue(fieldKey, inputValue);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (SWCStringUtils.equals((String)"save", (String)operateKey) || SWCStringUtils.equals((String)"submit", (String)operateKey)) {
            DynamicObject bizItemObj = this.getModel().getDataEntity();
            String minVal = bizItemObj.getString("inputminval");
            String maxVal = bizItemObj.getString("inputmaxval");
            if (SWCStringUtils.isEmpty((String)minVal)) {
                this.getModel().setValue("isminvalnull", (Object)"1");
            } else {
                BigDecimal minValue = null;
                try {
                    minValue = new BigDecimal(minVal);
                }
                catch (Exception e) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6700\u5c0f\u8f93\u5165\u503c\u201d\u3002", (String)"BizItemPropEdit_3", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                this.getModel().setValue("minvalue", (Object)minValue.toPlainString());
                this.getModel().setValue("isminvalnull", (Object)"0");
            }
            if (SWCStringUtils.isEmpty((String)maxVal)) {
                this.getModel().setValue("ismaxvalnull", (Object)"1");
            } else {
                BigDecimal maxValue = null;
                try {
                    maxValue = new BigDecimal(maxVal);
                }
                catch (Exception e) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6700\u5927\u8f93\u5165\u503c\u201d\u3002", (String)"BizItemPropEdit_4", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                this.getModel().setValue("maxvalue", (Object)maxValue.toPlainString());
                this.getModel().setValue("ismaxvalnull", (Object)"0");
            }
            source.getOption().setVariableValue("save", Boolean.TRUE.toString());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "unaudit": {
                this.setFiledsEnable();
                break;
            }
            case "save": 
            case "submit": {
                OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
                if (!operationResult.isSuccess()) break;
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    private void setFiledsEnable() {
        String enable = (String)this.getModel().getValue("enable");
        if (!"10".equals(enable)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"datatype", "datalength"});
        }
    }

    private void checkMaxValueAndMinValue(String scaleLimit) {
        if (!SWCStringUtils.isEmpty((String)scaleLimit)) {
            String maxValue = (String)this.getModel().getValue("inputmaxval");
            this.checkInputValue("inputmaxval", maxValue);
            String minValue = (String)this.getModel().getValue("inputminval");
            this.checkInputValue("inputminval", minValue);
        }
    }

    private void checkInputValue(String fieldKey, String inputValue) {
        int scale;
        String msg = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6570\u503c\uff0810\u4f4d\u5c0f\u6570\u4ee5\u5185\uff09\u6216\u7a7a\u3002", (String)"BizItemPropEdit_0", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
        FieldTip tip = null;
        String scaleLimit = (String)this.getModel().getValue("scalelimit");
        if (SWCStringUtils.isNotEmpty((String)inputValue) && !inputValue.matches(REGEX)) {
            tip = "inputminval".equals(fieldKey) ? this.showValidateTip(false, msg, "inputminval") : this.showValidateTip(false, msg, "inputmaxval");
            this.getView().showFieldTip(tip);
            return;
        }
        tip = "inputminval".equals(fieldKey) ? this.showValidateTip(true, msg, "inputminval") : this.showValidateTip(true, msg, "inputmaxval");
        this.getView().showFieldTip(tip);
        if (SWCStringUtils.isNotEmpty((String)inputValue) && !SWCStringUtils.isEmpty((String)scaleLimit) && (scale = new BigDecimal(inputValue).scale()) > Integer.parseInt(scaleLimit)) {
            if ("inputminval".equals(fieldKey)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6700\u5c0f\u8f93\u5165\u503c\u4e0d\u7b26\u5408\u5c0f\u6570\u4f4d\u6570\u9650\u5236\u3002", (String)"BizItemPropEdit_1", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6700\u5927\u8f93\u5165\u503c\u4e0d\u7b26\u5408\u5c0f\u6570\u4f4d\u6570\u9650\u5236\u3002", (String)"BizItemPropEdit_2", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private FieldTip showValidateTip(boolean isHide, String msg, String field) {
        FieldTip fieldTip = new FieldTip();
        fieldTip.setSuccess(isHide);
        fieldTip.setFieldKey(field);
        if (!isHide) {
            fieldTip.setTip(msg);
        }
        return fieldTip;
    }

    private void initMaxValueAndMinEnable() {
        String scaleLimit = (String)this.getModel().getValue("scalelimit");
        if (SWCStringUtils.isEmpty((String)scaleLimit)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"inputminval", "inputmaxval"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"inputminval", "inputmaxval"});
        }
    }

    private void propParamSetByDataType() {
        DynamicObject dataTypeObj = this.getModel().getDataEntity().getDynamicObject("datatype");
        if (SWCObjectUtils.isEmpty((Object)dataTypeObj)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"datalength", "scalelimit", "inputminval", "inputmaxval", "earliestdate", "lastdate"});
            return;
        }
        long dataTypeId = dataTypeObj.getLong("id");
        if (dataTypeId == DataTypeEnum.NUMBERIC.getCode()) {
            this.setOrCancelMustInput(false);
            this.getView().setVisible(Boolean.TRUE, new String[]{"scalelimit", "inputminval", "inputmaxval"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"datalength", "earliestdate", "lastdate"});
        } else if (dataTypeId == DataTypeEnum.TEXT.getCode()) {
            this.setOrCancelMustInput(true);
            this.getView().setVisible(Boolean.TRUE, new String[]{"datalength"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"scalelimit", "inputminval", "inputmaxval", "earliestdate", "lastdate"});
        } else if (dataTypeId == DataTypeEnum.DATE.getCode()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"earliestdate", "lastdate"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"datalength", "scalelimit", "inputminval", "inputmaxval"});
        }
    }

    private void clearInputValue(String ... fieldIds) {
        for (String fieldId : fieldIds) {
            this.getModel().setValue(fieldId, null);
        }
    }

    private void setOrCancelMustInput(boolean isText) {
        FieldEdit dataLengthField = (FieldEdit)this.getControl("datalength");
        dataLengthField.setMustInput(true);
        FieldEdit scaleLimitField = (FieldEdit)this.getControl("scalelimit");
        scaleLimitField.setMustInput(true);
        if (isText) {
            scaleLimitField.setMustInput(false);
        } else {
            dataLengthField.setMustInput(false);
        }
        this.getView().updateView("scalelimit");
    }

    private void initMaxValueAndMinValue() {
        DynamicObject dataType = (DynamicObject)this.getModel().getValue("datatype");
        if (SWCObjectUtils.isEmpty((Object)dataType)) {
            return;
        }
        long dataTypeId = dataType.getLong("id");
        if (1010L == dataTypeId) {
            DynamicObject bizItemObj = this.getModel().getDataEntity();
            String scaleLimit = bizItemObj.getString("scalelimit");
            BigDecimal maxVal = bizItemObj.getBigDecimal("maxvalue");
            BigDecimal minVal = bizItemObj.getBigDecimal("minvalue");
            String isMinValNull = bizItemObj.getString("isminvalnull");
            String isMaxValNull = bizItemObj.getString("ismaxvalnull");
            int scale = 10;
            if (StringUtils.isNotEmpty((String)scaleLimit)) {
                scale = Integer.parseInt(scaleLimit);
            }
            if (SWCStringUtils.equals((String)isMinValNull, (String)"1")) {
                this.getModel().setValue("inputminval", null);
            } else {
                this.getModel().setValue("inputminval", (Object)minVal.setScale(scale, 4).toPlainString());
            }
            if (SWCStringUtils.equals((String)isMaxValNull, (String)"1")) {
                this.getModel().setValue("inputmaxval", null);
            } else {
                this.getModel().setValue("inputmaxval", (Object)maxVal.setScale(scale, 4).toPlainString());
            }
        }
    }
}

