/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.basedata.cal;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.common.enums.CalFrequencyEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbs.common.vo.BatchGenerateReturnInfo;

public class CalPeriodGeneratePlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(CalPeriodGeneratePlugin.class);
    private static final String CAL_FREQUENCY = "calfrequency";
    private static final String RATE_RULE = "raterule";
    private static final String RATE_DAY = "rateday";
    private static final String PAY_RULE = "payrule";
    private static final String PAY_DAY = "payday";
    public static final String BATCH_GENERATE_RETURN_INFO = "batchGenerateReturnInfo";

    public void afterCreateNewData(EventObject eventObject) {
        FormShowParameter parameter = this.getFormShowPamarter();
        String frequency = (String)parameter.getCustomParam("calfrequency.type");
        IDataModel model = this.getModel();
        model.setValue(CAL_FREQUENCY, parameter.getCustomParam(CAL_FREQUENCY));
        model.setValue("rowcount", (Object)"");
        IFormView view = this.getView();
        switch (CalFrequencyEnum.valueOf((String)frequency)) {
            case MONTH: {
                this.initMonthFlex((Integer)parameter.getCustomParam("monthday"), view);
                break;
            }
            case WEEK: 
            case BIWEEKLY: {
                this.initWeekFlex((Integer)parameter.getCustomParam("weekday"), view);
                break;
            }
            case HALF_MONTH: {
                this.initHalfMonthFlex((Integer)parameter.getCustomParam("halfmonthfirstday"), (Integer)parameter.getCustomParam("halfmonthsecday"), view);
                break;
            }
            case DAY: {
                view.setVisible(Boolean.FALSE, new String[]{"monthfrequencyrule", "weekfrequencyrule", "salfmonthfrequencyrule"});
                break;
            }
        }
        String batchGenerateReturnInfoJson = this.getView().getParentView().getPageCache().get(BATCH_GENERATE_RETURN_INFO);
        if (SWCStringUtils.isNotEmpty((String)batchGenerateReturnInfoJson)) {
            BatchGenerateReturnInfo batchGenerateReturnInfo = (BatchGenerateReturnInfo)SerializationUtils.fromJsonString((String)batchGenerateReturnInfoJson, BatchGenerateReturnInfo.class);
            Map lastPeriod = batchGenerateReturnInfo.getLastPeriod();
            try {
                model.setValue("startdate", (Object)SWCDateTimeUtils.addDay((Date)SWCDateTimeUtils.parseDate((String)((String)lastPeriod.get("enddate")), (String)"yyyy-MM-dd"), (long)1L));
            }
            catch (ParseException e1) {
                LOGGER.error("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38");
            }
            model.setValue("rowcount", (Object)batchGenerateReturnInfo.getCreateRowCount());
            model.setValue("ratedate", (Object)batchGenerateReturnInfo.getRateDateUseField());
            model.setValue(RATE_RULE, (Object)batchGenerateReturnInfo.getRateDateRule());
            model.setValue(RATE_DAY, (Object)batchGenerateReturnInfo.getRateDateDay());
            model.setValue("paydate", (Object)batchGenerateReturnInfo.getPayDateUseField());
            model.setValue(PAY_RULE, (Object)batchGenerateReturnInfo.getPayDateRule());
            model.setValue(PAY_DAY, (Object)batchGenerateReturnInfo.getPayDateDay());
            model.setValue("perioddate", (Object)batchGenerateReturnInfo.getPeriodDateUseField());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "batchgenerate": {
                if (this.validateRowCount()) {
                    args.setCancel(true);
                    break;
                }
                if (this.validateStartDate()) {
                    args.setCancel(true);
                    break;
                }
                if (this.validateStartDateOverlap()) {
                    this.showErrorNotification(ResManager.loadKDString((String)"\u586b\u5199\u7684\u65e5\u671f\u4e0e\u5206\u5f55\u6240\u5728\u671f\u95f4\u7684\u8d77\u6b62\u65e5\u671f\u91cd\u53e0\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"CalPeriodGeneratePlugin_0", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                this.returnDataToParent();
                break;
            }
        }
    }

    private boolean validateRowCount() {
        int rowCount = this.getModel().getDataEntity().getInt("rowcount");
        boolean flag = false;
        if (rowCount <= 0 || rowCount > 120) {
            this.showErrorNotification(ResManager.loadKDString((String)"\u751f\u6210\u671f\u6570\uff1a\u8bf7\u586b\u5199\uff080,120]\u8303\u56f4\u5185\u7684\u6574\u6570\u3002", (String)"CalPeriodGeneratePlugin_5", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            flag = true;
        }
        return flag;
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String fieldKey = args.getProperty().getName();
        if ("rowcount".equals(fieldKey)) {
            IDataModel model = this.getModel();
            model.beginInit();
            ChangeData changeData = args.getChangeSet()[0];
            if (changeData.getNewValue() instanceof String) {
                model.setValue("rowcount", (Object)"");
                return;
            }
            if (0 == (Integer)changeData.getNewValue()) {
                model.setValue("rowcount", (Object)"");
            }
            model.endInit();
        } else if (RATE_DAY.equals(fieldKey)) {
            this.largeZero(args, RATE_DAY);
        } else if (PAY_DAY.equals(fieldKey)) {
            this.largeZero(args, PAY_DAY);
        }
    }

    private void largeZero(PropertyChangedArgs args, String payday) {
        ChangeData changeData = args.getChangeSet()[0];
        BigDecimal newValue = (BigDecimal)changeData.getNewValue();
        if (newValue != null && BigDecimal.ZERO.compareTo(newValue) > 0) {
            this.getModel().beginInit();
            this.getModel().setValue(payday, (Object)BigDecimal.ZERO);
            this.getModel().endInit();
        }
    }

    private void returnDataToParent() {
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        if (parentView == null) {
            return;
        }
        view.returnDataToParent((Object)this.getDataToParent());
        view.sendFormAction(parentView);
        view.close();
    }

    private BatchGenerateReturnInfo getDataToParent() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        BatchGenerateReturnInfo batchGenerateReturnInfo = new BatchGenerateReturnInfo();
        batchGenerateReturnInfo.setCalFrequencyType(dataEntity.getString("calfrequency.type"));
        batchGenerateReturnInfo.setCreateRowCount(dataEntity.getInt("rowcount"));
        batchGenerateReturnInfo.setMonthDay(dataEntity.getInt("monthday"));
        batchGenerateReturnInfo.setHalfMonthFirstDay(dataEntity.getInt("halfmonthfirstday"));
        batchGenerateReturnInfo.setHalfMonthSecDay(dataEntity.getInt("halfmonthsecday"));
        batchGenerateReturnInfo.setStartDate(dataEntity.getDate("startdate"));
        batchGenerateReturnInfo.setPeriodDateUseField(dataEntity.getString("perioddate"));
        batchGenerateReturnInfo.setRateDateUseField(dataEntity.getString("ratedate"));
        batchGenerateReturnInfo.setRateDateRule(dataEntity.getString(RATE_RULE));
        batchGenerateReturnInfo.setRateDateDay(dataEntity.getInt(RATE_DAY));
        batchGenerateReturnInfo.setPayDateUseField(dataEntity.getString("paydate"));
        batchGenerateReturnInfo.setPayDateRule(dataEntity.getString(PAY_RULE));
        batchGenerateReturnInfo.setPayDateDay(dataEntity.getInt(PAY_DAY));
        return batchGenerateReturnInfo;
    }

    private boolean validateStartDateOverlap() {
        FormShowParameter parameter = this.getFormShowPamarter();
        Date sourceDate = this.getStartDate();
        List result = (List)parameter.getCustomParam("calPeriod");
        if (result == null) {
            return false;
        }
        for (Map period : result) {
            Date startDate = null;
            Date endDate = null;
            try {
                startDate = SWCDateTimeUtils.parseDate((String)((String)period.get("startdate")));
                endDate = SWCDateTimeUtils.parseDate((String)((String)period.get("enddate")));
                if (sourceDate.getTime() < startDate.getTime() || sourceDate.getTime() > endDate.getTime()) continue;
                return true;
            }
            catch (ParseException e) {
                LOGGER.error("\u65e5\u671f\u8f6c\u6362\u51fa\u9519\uff1a{}", (Object)e.getMessage());
            }
        }
        return false;
    }

    private boolean validateStartDate() {
        String frequency = this.getModel().getDataEntity().getString("calfrequency.type");
        switch (CalFrequencyEnum.valueOf((String)frequency)) {
            case MONTH: {
                return this.validateMonthStartDate(this.getModel().getDataEntity().getInt("monthday"));
            }
            case WEEK: 
            case BIWEEKLY: {
                return this.validateWeekStartDate(this.getModel().getDataEntity().getString("weekday"));
            }
            case HALF_MONTH: {
                return this.validateHalfMonthStartDate(this.getModel().getDataEntity().getInt("halfmonthfirstday"), this.getModel().getDataEntity().getInt("halfmonthsecday"));
            }
            case DAY: {
                return false;
            }
        }
        return true;
    }

    private boolean validateHalfMonthStartDate(Integer firstDay, Integer secDay) {
        Date lastDayOfMonth;
        String startDate = SWCDateTimeUtils.format((Date)this.getStartDate(), (String)"dd");
        String halfmonthsecday = String.format(Locale.ROOT, "%02d", secDay);
        String halfmonthfirstday = String.format(Locale.ROOT, "%02d", firstDay);
        if ("31".equals(halfmonthfirstday)) {
            lastDayOfMonth = CalPeriodGeneratePlugin.getLastDayOfMonth(this.getStartDate());
            halfmonthfirstday = SWCDateTimeUtils.format((Date)lastDayOfMonth, (String)"dd");
        }
        if ("31".equals(halfmonthsecday)) {
            lastDayOfMonth = CalPeriodGeneratePlugin.getLastDayOfMonth(this.getStartDate());
            halfmonthsecday = SWCDateTimeUtils.format((Date)lastDayOfMonth, (String)"dd");
        }
        if (SWCStringUtils.equals((String)startDate, (String)halfmonthfirstday) || SWCStringUtils.equals((String)startDate, (String)halfmonthsecday)) {
            return false;
        }
        this.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u786e\u4fdd\u586b\u5199\u7684\u65e5\u671f\u4e0e\u201c\u671f\u95f4\u8d77\u59cb\u89c4\u5219\u201d\u7684\u9996\u8d77\u59cb\u65e5\u6216\u6b21\u8d77\u59cb\u65e5\u4e00\u81f4\u3002", (String)"CalPeriodGeneratePlugin_1", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
        return true;
    }

    private boolean validateWeekStartDate(String weekday) {
        String week = SWCDateTimeUtils.getWeekDay((Date)this.getStartDate()) + "";
        boolean result = !SWCStringUtils.equals((String)week, (String)weekday);
        if (result) {
            this.showErrorNotification(ResManager.loadKDString((String)"\u586b\u5165\u7684\u65e5\u671f\u6240\u5c5e\u661f\u671f\u4e0e\u6240\u5c5e\u671f\u95f4\u8d77\u59cb\u89c4\u5219\u7684\u661f\u671f\u4e0d\u7b26\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"CalPeriodGeneratePlugin_2", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
        }
        return result;
    }

    private boolean validateMonthStartDate(Integer parameter) {
        boolean result;
        String startDate = SWCDateTimeUtils.format((Date)this.getStartDate(), (String)"dd");
        String monthday = String.format(Locale.ROOT, "%02d", parameter);
        if ("31".equals(monthday)) {
            Date lastDayOfMonth = CalPeriodGeneratePlugin.getLastDayOfMonth(this.getStartDate());
            monthday = SWCDateTimeUtils.format((Date)lastDayOfMonth, (String)"dd");
        }
        if (result = !SWCStringUtils.equals((String)startDate, (String)monthday)) {
            this.showErrorNotification(ResManager.loadKDString((String)"\u586b\u5165\u7684\u65e5\u671f\u4e0e\u6240\u5c5e\u671f\u95f4\u8d77\u59cb\u89c4\u5219\u7684\u8d77\u59cb\u65e5\u4e0d\u7b26\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"CalPeriodGeneratePlugin_3", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
        }
        return result;
    }

    private void initHalfMonthFlex(int halfMonthFirstDay, int halfMonthSecDay, IFormView view) {
        this.getModel().setValue("halfmonthfirstday", (Object)halfMonthFirstDay);
        this.getModel().setValue("halfmonthsecday", (Object)halfMonthSecDay);
        view.setVisible(Boolean.TRUE, new String[]{"salfmonthfrequencyrule"});
        view.setVisible(Boolean.FALSE, new String[]{"monthfrequencyrule", "weekfrequencyrule"});
    }

    private void initWeekFlex(int weekday, IFormView view) {
        this.getModel().setValue("weekday", (Object)weekday);
        view.setVisible(Boolean.TRUE, new String[]{"weekfrequencyrule"});
        view.setVisible(Boolean.FALSE, new String[]{"monthfrequencyrule", "salfmonthfrequencyrule"});
    }

    private void initMonthFlex(int monthDay, IFormView view) {
        this.getModel().setValue("monthday", (Object)monthDay);
        view.setVisible(Boolean.TRUE, new String[]{"monthfrequencyrule"});
        view.setVisible(Boolean.FALSE, new String[]{"salfmonthfrequencyrule", "weekfrequencyrule"});
    }

    private FormShowParameter getFormShowPamarter() {
        return this.getView().getFormShowParameter();
    }

    private Date getStartDate() {
        return this.getModel().getDataEntity().getDate("startdate");
    }

    private void showErrorNotification(String message) {
        this.getView().showErrorNotification(message);
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int last = cal.getActualMaximum(5);
        cal.set(5, last);
        return cal.getTime();
    }
}

