/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.basedata.cal;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.business.cal.helper.CalFrequencyFilterHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.common.enums.CalFrequencyEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbs.business.calperiod.CalPeriodFrequencyFactory;
import kd.swc.hsbs.business.calperiod.CalPeriodFrequencyService;
import kd.swc.hsbs.business.calperiod.CalShowFormServiceHelper;
import kd.swc.hsbs.common.vo.BatchGenerateReturnInfo;
import kd.swc.hsbs.formplugin.web.basedata.HisBaseDataSummaryEdit;

public class CalPeriodTypeEdit
extends HisBaseDataSummaryEdit
implements EntryGridBindDataListener,
BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(CalPeriodTypeEdit.class);
    private static final CalFrequencyEnum[] MUST_INPUT_SERIAL_NUMBER = new CalFrequencyEnum[]{CalFrequencyEnum.WEEK, CalFrequencyEnum.HALF_MONTH, CalFrequencyEnum.BIWEEKLY, CalFrequencyEnum.DAY, CalFrequencyEnum.OTHER};
    private static final CalFrequencyEnum[] UNIQUE_PERIOD_DATE = new CalFrequencyEnum[]{CalFrequencyEnum.YEAR, CalFrequencyEnum.HALF_YEAR, CalFrequencyEnum.SEASON, CalFrequencyEnum.MONTH};
    private String regEx = "[\u4e00-\u9fa5]";
    private Pattern pat = Pattern.compile(this.regEx);

    protected List<String> getFixSummarykeyList() {
        ArrayList<String> fixSummaryKeyList = new ArrayList<String>(10);
        fixSummaryKeyList.add("name");
        fixSummaryKeyList.add("number");
        fixSummaryKeyList.add("status");
        fixSummaryKeyList.add("enable");
        fixSummaryKeyList.add("country");
        return fixSummaryKeyList;
    }

    public void createNewData(BizDataEventArgs args) {
        IPageCache pageCache = this.getPageCache();
        pageCache.put("entryway", "addnew");
        this.setFlexCollapse(false);
        this.setFieldMustInput(false, "halfmonthfirstday", "halfmonthsecday", "monthday", "weekday");
        this.getView().setVisible(Boolean.FALSE, new String[]{"monthfrequencyrule", "salfmonthfrequencyrule", "weekfrequencyrule"});
    }

    public void afterCreateNewData(EventObject object) {
        this.generateSampleNumber();
        this.initCountryVisibleAndMustInput();
    }

    public void afterLoadData(EventObject eventObject) {
        this.generateSampleNumber();
        this.initCountryVisibleAndMustInput();
        this.setFrequencyFlexVisible(this.getDynamicObject().getString("calfrequency.type"));
        this.setFlexCollapse(true);
        long startTime = System.currentTimeMillis();
        this.setRefStatus();
        long endTime = System.currentTimeMillis();
        logger.info("\u67e5\u8be2\u671f\u95f4\u4fe1\u606f\u662f\u5426\u88ab\u5f15\u7528\u8017\u65f6\uff1a{}", (Object)(endTime - startTime));
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        BasedataEdit frequency = (BasedataEdit)this.getView().getControl("calfrequency");
        frequency.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void entryGridBindData(EntryGridBindDataEvent event) {
        this.setRefStatus();
        this.setOperationVisible();
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.getView().invokeOperation("setentryenable");
        this.setPeriodNumberEnableByEntryNums();
        this.setFrequencyEnable();
        IPageCache pageCache = this.getPageCache();
        if (SWCStringUtils.equals((String)"addnew", (String)pageCache.get("entryway")) || SWCStringUtils.equals((String)"number", (String)pageCache.get("entryway"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"batchgenerate"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "deleteentry": {
                this.beforeDeleteEntry(args);
                break;
            }
            case "newentry": {
                this.validateFrequencyNotNull(args);
                break;
            }
            case "save": 
            case "entrysave": 
            case "submit": 
            case "audit": {
                if (operate.getOption().tryGetVariableValue("operation", new RefObject())) break;
                int entryRowCount = this.getEntryRowCount();
                if (SWCStringUtils.equals((String)operateKey, (String)"submit") && entryRowCount == 0) {
                    args.setCancel(true);
                    this.submitShowConfirm();
                    break;
                }
                if (entryRowCount <= 0) break;
                HashMap<Integer, DynamicObject> calPeriodMap = new HashMap<Integer, DynamicObject>(entryRowCount);
                if (!this.validateRefStatus(entryRowCount, calPeriodMap)) {
                    args.setCancel(true);
                    this.getView().showMessage(ResManager.loadKDString((String)"\u671f\u95f4\u6570\u636e\u5f15\u7528\u72b6\u6001\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u65b0\u7f16\u8f91\u3002", (String)"CalPeriodEdit_47", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.validateEntryData(args, operateKey, calPeriodMap);
                break;
            }
            case "refresh": {
                this.resetEntryWay();
                break;
            }
            case "batchgenerate": {
                this.showBatchGenerateForm(args);
                break;
            }
            case "setentryenable": {
                this.setOperationVisible();
                break;
            }
            case "disable": {
                if (operate.getOption().tryGetVariableValue("operation", new RefObject())) break;
                args.setCancel(true);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u88ab\u7981\u7528\u7684\u671f\u95f4\u7c7b\u578b\u4e0b\u7684\u6240\u6709\u671f\u95f4\u5c06\u4e0d\u53ef\u518d\u7528\uff0c\u5df2\u88ab\u5f15\u7528\u7684\u671f\u95f4\u4e0d\u53d7\u5f71\u54cd\uff0c\u786e\u8ba4\u7ee7\u7eed\u7981\u7528\uff1f", (String)"CalPeriodEdit_51", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("disable", (IFormPlugin)this));
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = ((FormOperate)afterDoOperationEventArgs.getSource()).getOperateKey()) {
            case "newentry": {
                this.getModel().setValue("periodcalfrequency", (Object)this.getModel().getDataEntity().getDynamicObject("calfrequency"));
                if (this.getModel().getEntryRowCount("entryentity") != 1) break;
                this.setFrequencyEnableByEntryNums(false);
                break;
            }
            case "donothing_editentry": {
                IPageCache pageCache = this.getPageCache();
                pageCache.put("entryway", "operation");
                this.setEntryFieldEnableByStatus(true);
                this.setFrequencyEnable();
                this.setEntryOperateVisible(Boolean.FALSE);
                this.setFrequencyFlexVisible(this.getDynamicObject().getString("calfrequency.type"));
                break;
            }
            case "submit": 
            case "save": 
            case "entrysave": 
            case "audit": {
                OperationResult saveOperationResult = afterDoOperationEventArgs.getOperationResult();
                if (saveOperationResult.isSuccess()) {
                    this.getView().invokeOperation("refresh");
                    break;
                }
                this.getView().updateView("entryentity");
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId;
        switch (callBackId = event.getCallBackId()) {
            case "deleteentry": {
                if (!MessageBoxResult.Yes.equals((Object)event.getResult())) break;
                this.batchDeleteEntry();
                break;
            }
            case "submit": {
                if (!MessageBoxResult.Yes.equals((Object)event.getResult())) break;
                this.getView().invokeOperation(callBackId, this.createOperateOption());
                break;
            }
            case "updateEntryEntityView": {
                this.resetEntryFiledValue();
                this.setOperationVisible();
                break;
            }
            case "batchgenerate": {
                if (!MessageBoxResult.Yes.equals((Object)event.getResult())) break;
                this.getView().invokeOperation("batchgenerate", this.createOperateOption());
                break;
            }
            case "disable": {
                if (!MessageBoxResult.Yes.equals((Object)event.getResult())) break;
                this.getView().invokeOperation("disable", this.createOperateOption());
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "save": 
            case "entrysave": {
                Object entrySaveReturnData = closedCallBackEvent.getReturnData();
                if (!(entrySaveReturnData instanceof Boolean)) break;
                this.getView().invokeOperation(actionId, this.createOperateOption());
                break;
            }
            case "submit": 
            case "audit": {
                this.submitAndAuditCloseCallBack(closedCallBackEvent, actionId);
                break;
            }
            case "batchgenerate": {
                BatchGenerateReturnInfo batchGenerateReturnInfo = (BatchGenerateReturnInfo)closedCallBackEvent.getReturnData();
                if (batchGenerateReturnInfo == null) break;
                batchGenerateReturnInfo.setCalFrequencyPkValue((Long)this.getModel().getDataEntity().getDynamicObject("calfrequency").getPkValue());
                int[] rows = this.batchGenerateCalPeriod(batchGenerateReturnInfo);
                Map<Integer, DynamicObject> repeatIndexs = this.validateRepeatDatesd();
                if (repeatIndexs.size() > 0) {
                    this.getModel().deleteEntryRows("entryentity", rows);
                }
                this.showBatchGenerateResultForm(batchGenerateReturnInfo, repeatIndexs);
                break;
            }
            case "updateEntryEntityView": {
                this.resetEntryFiledValue();
                this.setOperationVisible();
                break;
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs args) {
        if (this.getModel().getEntryRowCount("entryentity") == 0) {
            this.setFrequencyEnableByEntryNums(true);
            this.setPeriodNumberEnableByEntryNums();
        }
        this.getView().updateView("entryentity");
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && SWCStringUtils.equals((String)"bos_list", (String)parentView.getEntityId())) {
            IPageCache parentPageCache = parentView.getPageCache();
            parentPageCache.remove("entryway");
            parentView.invokeOperation("refresh");
            this.getView().sendFormAction(parentView);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey;
        switch (fieldKey = args.getProperty().getName()) {
            case "useorg": {
                this.setFrequencyFlexVisible(this.getDynamicObject().getString("calfrequency.type"));
                this.setFrequencyEnableByEntryNums(true);
                break;
            }
            case "calfrequency": {
                DynamicObject calFrequency = this.getDynamicObject().getDynamicObject("calfrequency");
                if (calFrequency != null) {
                    String type = calFrequency.getString("type");
                    this.setFrequencyFlexVisible(type);
                    break;
                }
                this.setFrequencyFlexVisible(null);
                break;
            }
            case "halfmonthfirstday": 
            case "halfmonthsecday": {
                this.validateHalfMonthRule(this.getDynamicObject(), fieldKey);
                break;
            }
            case "periodnumbersubject": 
            case "periodnumberprefix": 
            case "periodnumbersuffix": 
            case "serialnumber": {
                this.generateSampleNumber();
                break;
            }
            case "startdate": 
            case "enddate": {
                Boolean flag = this.validatorDateOverlap(fieldKey, args);
                flag = this.validatorDateRule(fieldKey, flag, args);
                this.setGangedFieldValue(fieldKey, flag);
                break;
            }
            case "periodyear": 
            case "perioddate": {
                this.checkPeriodDate(fieldKey);
                break;
            }
            case "country": {
                this.getModel().setValue("calfrequency", null);
                break;
            }
            case "areatype": {
                this.setCountryVisibleAndMustInput();
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey;
        switch (fieldKey = evt.getProperty().getName()) {
            case "calfrequency": {
                DynamicObject country = (DynamicObject)this.getModel().getValue("country");
                String areaType = (String)this.getModel().getValue("areatype");
                if (country == null && SWCStringUtils.equals((String)"2", (String)areaType)) {
                    evt.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u56fd\u5bb6/\u5730\u533a\u3002", (String)"CalPeriodEdit_26", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (country != null && SWCStringUtils.equals((String)"2", (String)areaType)) {
                    CalFrequencyFilterHelper.setCalFrequencyFilter((BeforeF7SelectEvent)evt, (Long)((Long)country.getPkValue()));
                    break;
                }
                if (!SWCStringUtils.equals((String)"1", (String)areaType)) break;
                CalFrequencyFilterHelper.setCalFrequencyFilter((BeforeF7SelectEvent)evt, (Long)0L);
                break;
            }
        }
    }

    private void setCountryVisibleAndMustInput() {
        String areaType = (String)this.getModel().getValue("areatype");
        if (SWCStringUtils.equals((String)"1", (String)areaType)) {
            this.getModel().setValue("country", null);
            this.getModel().setValue("calfrequency", null);
            this.setFieldMustInput(false, "country");
        } else if (SWCStringUtils.equals((String)"2", (String)areaType)) {
            this.getModel().setValue("calfrequency", null);
            this.getView().setVisible(Boolean.TRUE, new String[]{"country"});
            this.setFieldMustInput(true, "country");
        }
    }

    private void initCountryVisibleAndMustInput() {
        String areaType = (String)this.getModel().getValue("areatype");
        if (SWCStringUtils.equals((String)"1", (String)areaType)) {
            this.setFieldMustInput(false, "country");
        } else {
            this.setFieldMustInput(true, "country");
        }
    }

    private void setRefStatus() {
        int entryRowCount = this.getEntryRowCount();
        HashMap<Integer, DynamicObject> calPeriodMap = new HashMap<Integer, DynamicObject>(16);
        List<Integer> calPeriodIndexs = this.getRefDynamicObject(entryRowCount, calPeriodMap);
        for (Integer calPeriodIndex : calPeriodIndexs) {
            DynamicObject entryDynamicObject = this.getEntryDynamicObject(calPeriodIndex);
            entryDynamicObject.set("refstatus", (Object)1);
        }
    }

    private boolean validateRefStatus(int entryRowCount, Map<Integer, DynamicObject> calPeriodMap) {
        return this.alteredCalPeriodIndex(entryRowCount, calPeriodMap).isEmpty();
    }

    private List<Integer> alteredCalPeriodIndex(int entryRowCount, Map<Integer, DynamicObject> calPeriodMap) {
        ArrayList<Integer> alteredCalPeriodIndex = new ArrayList<Integer>(entryRowCount);
        List<Integer> calPeriodIndexs = this.getRefDynamicObject(entryRowCount, calPeriodMap);
        for (Integer calPeriodIndex : calPeriodIndexs) {
            DynamicObject calPeriod = calPeriodMap.get(calPeriodIndex);
            if (calPeriod.getBoolean("refstatus")) continue;
            alteredCalPeriodIndex.add(calPeriodIndex);
        }
        return alteredCalPeriodIndex;
    }

    private List<Integer> getRefDynamicObject(int entryRowCount, Map<Integer, DynamicObject> calPeriodMap) {
        HashMap<Long, Integer> PkIndexMapping = new HashMap<Long, Integer>(entryRowCount);
        ArrayList<Long> calPeriodIds = new ArrayList<Long>(entryRowCount);
        for (int index = 0; index < entryRowCount; ++index) {
            DynamicObject entryDynamicObject = this.getEntryDynamicObject(index);
            calPeriodMap.put(index, entryDynamicObject);
            Long pkValue = (Long)entryDynamicObject.getPkValue();
            if (pkValue == 0L) continue;
            PkIndexMapping.put(pkValue, index);
            calPeriodIds.add(pkValue);
        }
        List<Long> calPeriodPKs = this.baseDataCheckRefrence(calPeriodIds);
        ArrayList<Integer> calPeriodIndexs = new ArrayList<Integer>(10);
        for (Long calPeriodPK : calPeriodPKs) {
            Integer calPeriodIndex = (Integer)PkIndexMapping.get(calPeriodPK);
            calPeriodIndexs.add(calPeriodIndex);
        }
        return calPeriodIndexs;
    }

    private List<Long> baseDataCheckRefrence(List<Long> calPeriodIds) {
        ArrayList<Long> calPeriodPKs = new ArrayList<Long>(10);
        if (calPeriodIds.isEmpty()) {
            return calPeriodPKs;
        }
        SWCDataServiceHelper calPeriodTypeHelper = new SWCDataServiceHelper("hsbs_calperiod");
        DynamicObject dynamicObject = calPeriodTypeHelper.generateDynamicObject((Object)calPeriodIds.get(0), "number,name");
        BasedataEntityType basedataEntityType = (BasedataEntityType)dynamicObject.getDataEntityType();
        Map<Object, BaseDataCheckRefrenceResult> checkResult = CalPeriodTypeEdit.baseDataCheckRefrence(basedataEntityType, calPeriodIds.toArray());
        this.cacheReferenceMessage(checkResult);
        for (Object calPeriodPK : checkResult.keySet()) {
            calPeriodPKs.add((Long)calPeriodPK);
        }
        return calPeriodPKs;
    }

    private void cacheReferenceMessage(Map<Object, BaseDataCheckRefrenceResult> checkResult) {
        for (Map.Entry<Object, BaseDataCheckRefrenceResult> entry : checkResult.entrySet()) {
            BaseDataCheckRefrenceResult refrenceResult = entry.getValue();
            MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)refrenceResult.getRefenceKey().getRefEntityKey());
            String billName = refMainType.getDisplayName().toString();
            String fieldName = refrenceResult.getRefenceKey().getRefCol();
            for (IDataEntityProperty property : refMainType.getAllFields().values()) {
                if (property instanceof IFieldHandle && StringUtils.equalsIgnoreCase((CharSequence)property.getAlias(), (CharSequence)refrenceResult.getRefenceKey().getRefCol())) {
                    fieldName = ((IFieldHandle)property).getDisplayName().toString();
                    break;
                }
                if (!(property instanceof MulBasedataProp) || !StringUtils.equalsIgnoreCase((CharSequence)refrenceResult.getRefenceKey().getRefCol(), (CharSequence)"fbasedataid") || !StringUtils.equalsIgnoreCase((CharSequence)refrenceResult.getRefenceKey().getRefTable(), (CharSequence)property.getAlias())) continue;
                fieldName = property.getDisplayName().toString();
                break;
            }
            IPageCache pageCache = this.getPageCache();
            pageCache.put(entry.getKey().toString(), MessageFormat.format(ResManager.loadKDString((String)"\u5b58\u5728\u5f15\u7528\u4e0d\u80fd\u88ab\u5220\u9664\uff0c\u201c{0}\u201d\u7684\u5b57\u6bb5\u201c{1}\u201d\u5f15\u7528\u4e86\u6b64\u8d44\u6599\u6570\u636e\u3002", (String)"CalPeriodEdit_49", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), billName, fieldName));
        }
    }

    private static Map<Object, BaseDataCheckRefrenceResult> baseDataCheckRefrence(BasedataEntityType baseEntityType, Object[] objIds) {
        BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
        checker.setDraftValidReference(false);
        return checker.checkRef(baseEntityType, objIds);
    }

    private void validateHalfMonthRule(DynamicObject dataEntity, String field) {
        int firstSelectDay = dataEntity.getInt("halfmonthfirstday");
        int secSelectDay = dataEntity.getInt("halfmonthsecday");
        if (firstSelectDay != 0 && secSelectDay != 0) {
            if (firstSelectDay == secSelectDay) {
                this.getModel().beginInit();
                dataEntity.set(field, null);
                this.getModel().endInit();
                this.getView().showMessage(ResManager.loadKDString((String)"\u9996\u8d77\u59cb\u65e5\u4e0e\u6b21\u8d77\u59cb\u65e5\u4e0d\u80fd\u76f8\u7b49\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"CalPeriodEdit_48", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                return;
            }
            int interval = Math.abs(secSelectDay - firstSelectDay);
            if (interval < 13 || interval > 16) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u4e24\u4e2a\u8d77\u59cb\u65e5\u7684\u65e5\u671f\u95f4\u9694\u4e0d\u7b26\u5408\u9891\u5ea6\u7c7b\u578b\u4e3a\u534a\u6708\u7684\u65e5\u671f\u89c4\u8303\uff0c\u82e5\u6709\u8bef\u8bf7\u8fdb\u884c\u4fee\u6539\u3002", (String)"CalPeriodEdit_2", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void resetEntryFiledValue() {
        this.getView().updateView("entryentity");
    }

    private OperateOption createOperateOption() {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("operation", "true");
        return operateOption;
    }

    private void submitAndAuditCloseCallBack(ClosedCallBackEvent closedCallBackEvent, String operationKey) {
        Object submitReturnData = closedCallBackEvent.getReturnData();
        if (submitReturnData instanceof Boolean) {
            int entryRowCount = this.getEntryRowCount();
            if (entryRowCount == 0) {
                this.submitShowConfirm();
            } else {
                this.getView().invokeOperation(operationKey, this.createOperateOption());
            }
        }
    }

    private void submitShowConfirm() {
        this.getView().showConfirm(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s: \u671f\u95f4\u5206\u5f55\u5185\u5bb9\u4e3a\u7a7a\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CalPeriodEdit_38", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), this.getModel().getDataEntity().getString("number")), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("submit", (IFormPlugin)this));
    }

    private void validateEntryData(BeforeDoOperationEventArgs args, String operateKey, Map<Integer, DynamicObject> calPeriodMap) {
        int entryRowCount = this.getEntryRowCount();
        boolean repeatDateResult = this.validateRepeatDate(entryRowCount, calPeriodMap);
        if (!repeatDateResult) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7684\u671f\u95f4\u5f00\u59cb\u65e5\u671f\u4e0e\u7ed3\u675f\u65e5\u671f\u3002", (String)"CalPeriodEdit_39", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), MessageTypes.Default, new ConfirmCallBackListener("updateEntryEntityView", (IFormPlugin)this));
            args.setCancel(true);
            return;
        }
        String frequency = this.getDynamicObject().getString("calfrequency.type");
        boolean serialNumberResult = this.validateSerialNumber(frequency);
        if (serialNumberResult) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u9891\u5ea6\u7c7b\u578b\u4e3a \u201c\u5176\u4ed6\u3001\u65e5\u3001\u5468\u3001\u53cc\u5468\u3001\u534a\u6708\u201d \u65f6\uff0c\u4e3a\u907f\u514d\u751f\u6210\u7684\u671f\u95f4\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u7ef4\u62a4\u201c\u6d41\u6c34\u53f7\u4f4d\u6570\u201d\u5b57\u6bb5\u7684\u503c\u3002", (String)"CalPeriodEdit_0", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        boolean uniqueDateResult = this.uniquePeriodDate(frequency, entryRowCount, calPeriodMap);
        if (uniqueDateResult) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7684\u6240\u5c5e\u5e74\u6708\u4f1a\u5bfc\u81f4\u671f\u95f4\u7f16\u7801\u751f\u6210\u9519\u8bef\uff0c\u8bf7\u4fee\u6539\u91cd\u590d\u7684\u201c\u6240\u5c5e\u5e74\u6708\u201d\u5b57\u6bb5\u503c\u3002", (String)"CalPeriodEdit_1", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        List<String> failMessages = this.uniquePeriodName(entryRowCount, calPeriodMap);
        if (!failMessages.isEmpty()) {
            args.setCancel(true);
            String operationName = this.getOperationName(operateKey);
            FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter((String)operationName, (String)String.format(Locale.ROOT, ResManager.loadKDString((String)"\u51711\u5f20\u5355\u636e\uff0c%s\u6210\u529f0\u5f20\uff0c\u5931\u8d251\u5f20\u3002", (String)"CalPeriodEdit_15", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), operationName), failMessages);
            this.getView().showForm(parameters);
            return;
        }
        List<String> dateFailMessages = this.validateDateStandard(frequency, entryRowCount, calPeriodMap);
        if (!dateFailMessages.isEmpty()) {
            args.setCancel(true);
            String title = this.getOperationConfirmTitle(frequency);
            String operationName = this.getOperationName(operateKey);
            FormShowParameter operationResultParameter = SWCShowFormServiceHelper.getOperationConfirmParameter((CloseCallBack)new CloseCallBack((IFormPlugin)this, operateKey), (String)operationName, (String)title, dateFailMessages, (boolean)true);
            this.getView().showForm(operationResultParameter);
        }
    }

    private boolean validateRepeatDate(int entryRowCount, Map<Integer, DynamicObject> calPeriodMap) {
        ArrayList<Integer> repeatIndexs = new ArrayList<Integer>(entryRowCount);
        IDataModel model = this.getModel();
        if (entryRowCount > 1) {
            for (int index = 0; index < entryRowCount; ++index) {
                DynamicObject target = calPeriodMap.get(index);
                Date targetStartDate = target.getDate("startdate");
                Date targetEndDate = target.getDate("enddate");
                for (int j = index + 1; j < entryRowCount; ++j) {
                    DynamicObject source = calPeriodMap.get(j);
                    Date sourceStartDate = source.getDate("startdate");
                    Date sourceEndDate = source.getDate("enddate");
                    if (targetStartDate == null || targetEndDate == null || sourceStartDate == null || sourceEndDate == null || targetStartDate.getTime() > sourceEndDate.getTime() || targetEndDate.getTime() < sourceStartDate.getTime()) continue;
                    repeatIndexs.add(j);
                }
            }
        }
        if (repeatIndexs.size() > 1) {
            Iterator iterator = repeatIndexs.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                DynamicObject dynamicObject = model.getEntryRowEntity("entryentity", index);
                dynamicObject.set("startdate", null);
                dynamicObject.set("enddate", null);
            }
        }
        return repeatIndexs.size() == 0;
    }

    private void resetEntryWay() {
        IPageCache pageCache = this.getPageCache();
        pageCache.put("entryway", "number");
    }

    private void setGangedFieldValue(String field, Boolean flag) {
        if (SWCStringUtils.equals((String)field, (String)"enddate") && flag.booleanValue()) {
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject dynamicObject = this.getEntryDynamicObject(currentRowIndex);
            Date currentEndDate = dynamicObject.getDate("enddate");
            try {
                dynamicObject.set("periodyear", (Object)SWCDateTimeUtils.formatDateToDate((Date)currentEndDate, (String)"yyyy"));
                dynamicObject.set("perioddate", (Object)SWCDateTimeUtils.formatDateToDate((Date)currentEndDate, (String)"yyyy-MM"));
            }
            catch (ParseException e) {
                logger.error("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38");
            }
            if (dynamicObject.getDate("ratedate") == null) {
                dynamicObject.set("ratedate", (Object)currentEndDate);
            }
            if (dynamicObject.getDate("paydate") == null) {
                dynamicObject.set("paydate", (Object)currentEndDate);
            }
            this.getView().updateView("entryentity");
        }
    }

    private boolean uniquePeriodDate(String frequency, int entryRowCount, Map<Integer, DynamicObject> calPeriodMap) {
        String periodNumberSubject = this.getDynamicObject().getString("periodnumbersubject");
        if (SWCStringUtils.equals((String)periodNumberSubject, (String)"perioddate") && Arrays.asList(UNIQUE_PERIOD_DATE).contains(CalFrequencyEnum.valueOf((String)frequency))) {
            HashMap belongYearMonthMap = new HashMap(entryRowCount);
            for (int index = 0; index < entryRowCount; ++index) {
                DynamicObject dynamicObject = calPeriodMap.get(index);
                Date date = dynamicObject.getDate("perioddate");
                if (date == null) continue;
                String belongYearMonth = SWCDateTimeUtils.format((Date)date, (String)"yyyy/MM");
                if (!belongYearMonthMap.containsKey(belongYearMonth)) {
                    belongYearMonthMap.put(belongYearMonth, new ArrayList(10));
                }
                ((List)belongYearMonthMap.get(belongYearMonth)).add(index + 1);
            }
            for (Map.Entry entry : belongYearMonthMap.entrySet()) {
                List value = (List)entry.getValue();
                if (value.size() <= 1) continue;
                return true;
            }
        }
        return false;
    }

    private List<String> validateDateStandard(String frequency, int entryRowCount, Map<Integer, DynamicObject> calPeriodMap) {
        ArrayList<String> failMessages = new ArrayList<String>(entryRowCount);
        for (int index = 0; index < entryRowCount; ++index) {
            DynamicObject dynamicObject = calPeriodMap.get(index);
            StringBuilder stringBuilder = new StringBuilder();
            Date startDate = dynamicObject.getDate("startdate");
            Date endDate = dynamicObject.getDate("enddate");
            if (startDate == null || endDate == null) break;
            long interval = SWCDateTimeUtils.dateDiff((String)"d", (Date)startDate, (Date)endDate);
            boolean flag = this.dateDiff(frequency, interval);
            if (!flag) continue;
            String start = ResManager.loadKDString((String)"\u671f\u95f4\u5f00\u59cb\u65e5\u671f", (String)"CalPeriodEdit_13", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
            String end = ResManager.loadKDString((String)"\u671f\u95f4\u7ed3\u675f\u65e5\u671f", (String)"CalPeriodEdit_14", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
            stringBuilder.append(start);
            stringBuilder.append('-');
            stringBuilder.append(end);
            stringBuilder.append('\uff1a');
            stringBuilder.append(SWCDateTimeUtils.format((Date)startDate, (String)SWCDateTimeUtils.getUserDateFormat()));
            stringBuilder.append('-');
            stringBuilder.append(SWCDateTimeUtils.format((Date)endDate, (String)SWCDateTimeUtils.getUserDateFormat()));
            failMessages.add(stringBuilder.toString());
        }
        return failMessages;
    }

    private boolean dateDiff(String frequency, long interval) {
        CalFrequencyEnum calFrequencyEnum = CalFrequencyEnum.valueOf((String)frequency);
        switch (calFrequencyEnum) {
            case MONTH: {
                if (interval >= 27L && interval <= 30L) break;
                return true;
            }
            case HALF_MONTH: {
                if (interval >= 12L && interval <= 15L) break;
                return true;
            }
            case WEEK: {
                if (interval == 6L) break;
                return true;
            }
            case BIWEEKLY: {
                if (interval == 13L) break;
                return true;
            }
            case SEASON: {
                if (interval >= 88L && interval <= 91L) break;
                return true;
            }
            case HALF_YEAR: {
                if (interval >= 180L && interval <= 183L) break;
                return true;
            }
            case YEAR: {
                if (interval >= 364L && interval <= 365L) break;
                return true;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    private String getOperationConfirmTitle(String frequency) {
        String stanard = "";
        String frequencyName = "";
        CalFrequencyEnum calFrequencyEnum = CalFrequencyEnum.valueOf((String)frequency);
        switch (calFrequencyEnum) {
            case MONTH: {
                stanard = ResManager.loadKDString((String)"\u4ecb\u4e8e28\u81f331", (String)"CalPeriodEdit_6", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
                frequencyName = ResManager.loadKDString((String)"\u6708", (String)"CalPeriodEdit_32", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
                break;
            }
            case HALF_MONTH: {
                stanard = ResManager.loadKDString((String)"\u4ecb\u4e8e13\u81f316", (String)"CalPeriodEdit_7", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
                frequencyName = ResManager.loadKDString((String)"\u534a\u6708", (String)"CalPeriodEdit_31", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
                break;
            }
            case WEEK: {
                stanard = ResManager.loadKDString((String)"\u7b49\u4e8e7", (String)"CalPeriodEdit_8", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
                frequencyName = ResManager.loadKDString((String)"\u5468", (String)"CalPeriodEdit_29", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
                break;
            }
            case BIWEEKLY: {
                stanard = ResManager.loadKDString((String)"\u7b49\u4e8e14", (String)"CalPeriodEdit_9", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
                frequencyName = ResManager.loadKDString((String)"\u53cc\u5468", (String)"CalPeriodEdit_30", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
                break;
            }
            case SEASON: {
                stanard = ResManager.loadKDString((String)"\u4ecb\u4e8e89\u81f392", (String)"CalPeriodEdit_10", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
                frequencyName = ResManager.loadKDString((String)"\u5b63\u5ea6", (String)"CalPeriodEdit_33", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
                break;
            }
            case HALF_YEAR: {
                stanard = ResManager.loadKDString((String)"\u4ecb\u4e8e181\u81f3184", (String)"CalPeriodEdit_11", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
                frequencyName = ResManager.loadKDString((String)"\u534a\u5e74", (String)"CalPeriodEdit_34", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
                break;
            }
            case YEAR: {
                stanard = ResManager.loadKDString((String)"\u4e3a365\u6216366", (String)"CalPeriodEdit_12", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
                frequencyName = ResManager.loadKDString((String)"\u5e74", (String)"CalPeriodEdit_35", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
                break;
            }
        }
        return MessageFormat.format(ResManager.loadKDString((String)"\u9891\u5ea6\u7c7b\u578b\u4e3a{0}\u7684\u671f\u95f4\uff0c\u671f\u95f4\u5f00\u59cb\u65e5\u671f\u4e0e\u671f\u95f4\u7ed3\u675f\u65e5\u671f\u7684\u95f4\u9694\u5e94\u5f53{1}\uff0c\u5b58\u5728\u4e0d\u7b26\u5408\u89c4\u8303\u7684\u6570\u636e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CalPeriodEdit_5", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), frequencyName, stanard);
    }

    private List<String> uniquePeriodName(int entryRowCount, Map<Integer, DynamicObject> calPeriodMap) {
        HashMap<String, List<Integer>> periodNameMap = new HashMap<String, List<Integer>>(entryRowCount);
        for (int index = 0; index < entryRowCount; ++index) {
            DynamicObject dynamicObject = calPeriodMap.get(index);
            if (!SWCStringUtils.isNotEmpty((String)dynamicObject.getString("periodname"))) continue;
            if (!periodNameMap.containsKey(dynamicObject.getString("periodname"))) {
                periodNameMap.put(dynamicObject.getString("periodname"), new ArrayList(10));
            }
            periodNameMap.get(dynamicObject.getString("periodname")).add(index + 1);
        }
        return this.buildFailMessage(periodNameMap);
    }

    private List<String> buildFailMessage(HashMap<String, List<Integer>> periodNameMap) {
        ArrayList<String> failMessages = new ArrayList<String>(10);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        for (Map.Entry<String, List<Integer>> entry : periodNameMap.entrySet()) {
            List<Integer> value = entry.getValue();
            if (value.size() <= 1) continue;
            String periodName = entry.getKey();
            StringBuilder stringBuilder = new StringBuilder();
            value.forEach(row -> stringBuilder.append(row).append(','));
            String failMessage = MessageFormat.format(ResManager.loadKDString((String)"{0} \u671f\u95f4\u4fe1\u606f\u7b2c{1}\u884c\uff0c \u671f\u95f4\u540d\u79f0\u91cd\u590d: {2}\u3002", (String)"CalPeriodEdit_16", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), dataEntity.getString("number"), stringBuilder.substring(0, stringBuilder.length() - 1), periodName);
            failMessages.add(failMessage);
        }
        return failMessages;
    }

    private String getOperationName(String operateKey) {
        if (SWCStringUtils.equals((String)operateKey, (String)"save") || SWCStringUtils.equals((String)operateKey, (String)"entrysave")) {
            return ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"CalPeriodEdit_36", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
        }
        if (SWCStringUtils.equals((String)operateKey, (String)"submit")) {
            return ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"CalPeriodEdit_37", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u5ba1\u6838", (String)"CalPeriodEdit_50", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
    }

    private boolean validateSerialNumber(String frequency) {
        DynamicObject dataEntity = this.getDynamicObject();
        String subjectcoding = dataEntity.getString("periodnumbersubject");
        CalFrequencyEnum calFrequencyEnum = CalFrequencyEnum.valueOf((String)frequency);
        if (SWCStringUtils.equals((String)subjectcoding, (String)"perioddate") && Arrays.asList(MUST_INPUT_SERIAL_NUMBER).contains(calFrequencyEnum)) {
            int serialnumber = dataEntity.getInt("serialnumber");
            return serialnumber == 0;
        }
        return false;
    }

    private void beforeDeleteEntry(BeforeDoOperationEventArgs args) {
        int[] selectRows = this.getEntryIndexArrByEntryName("entryentity");
        if (selectRows.length == 0) {
            return;
        }
        args.setCancel(true);
        this.getView().showConfirm(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4f60\u5df2\u9009\u62e9%s\u6761\u8bb0\u5f55\uff0c\u5220\u9664\u540e\u4e0d\u53ef\u6062\u590d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CalPeriodEdit_18", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), selectRows.length), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deleteentry", (IFormPlugin)this));
    }

    private void setOperationVisible() {
        String enable = (String)this.getModel().getValue("enable");
        if (SWCStringUtils.equals((String)"0", (String)enable)) {
            this.setEntryFieldEnableByStatus(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"maintenance", "batchgenerate", "addrow", "delrow", "saveperiodentity", "cancel"});
            return;
        }
        IPageCache pageCache = this.getPageCache();
        String enterWay = pageCache.get("entryway");
        if (SWCStringUtils.isEmpty((String)enterWay)) {
            IPageCache parentPageCache = this.getView().getParentView().getPageCache();
            enterWay = parentPageCache.get("entryway");
            pageCache.put("entryway", enterWay);
        }
        if (SWCStringUtils.isNotEmpty((String)enterWay)) {
            switch (enterWay) {
                case "operation": 
                case "addnew": {
                    this.setEntryFieldEnableByStatus(true);
                    this.setEntryOperateVisible(Boolean.FALSE);
                    break;
                }
                case "number": {
                    this.setEntryFieldEnableByStatus(false);
                    this.setEntryOperateVisible(Boolean.TRUE);
                    break;
                }
            }
        } else {
            this.setEntryFieldEnableByStatus(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"maintenance", "batchgenerate", "addrow", "delrow", "saveperiodentity", "cancel"});
        }
    }

    private void setEntryFieldEnableByStatus(boolean flag) {
        int entryRowCount = this.getEntryRowCount();
        for (int index = 0; index < entryRowCount; ++index) {
            DynamicObject dynamicObject = this.getEntryDynamicObject(index);
            if (flag && dynamicObject.getBoolean("refstatus")) {
                this.setEntryEntityFieldEnable(Boolean.FALSE, index);
                continue;
            }
            this.setEntryEntityFieldEnable(flag, index);
        }
    }

    private void setEntryEntityFieldEnable(Boolean flag, int index) {
        this.getView().setEnable(flag, index, new String[]{"periodname", "enddate", "startdate", "periodyear", "ratedate", "paydate", "perioddate"});
    }

    private void setFrequencyEnable() {
        int entryRowCount = this.getEntryRowCount();
        if (entryRowCount == 0) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"calfrequency"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"calfrequency", "monthday", "halfmonthfirstday", "halfmonthsecday", "weekday", "country", "areatype"});
        }
    }

    private void setFlexCollapse(boolean flag) {
        Container baseInfoContainer = (Container)this.getView().getControl("fs_baseinfo");
        Container periodContainer = (Container)this.getView().getControl("flexpanelap2");
        baseInfoContainer.setCollapse(flag);
        periodContainer.setCollapse(flag);
    }

    private void batchDeleteEntry() {
        this.setRefStatus();
        int[] selectRows = this.getEntryIndexArrByEntryName("entryentity");
        ArrayList<String> failList = new ArrayList<String>(10);
        int[] deleteRows = this.getDeleteRowsIndex(selectRows, failList);
        IDataModel model = this.getModel();
        model.deleteEntryRows("entryentity", deleteRows);
        if (!failList.isEmpty()) {
            FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter((String)ResManager.loadKDString((String)"\u5220\u884c", (String)"CalPeriodEdit_52", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), (String)MessageFormat.format(ResManager.loadKDString((String)"\u5171{0}\u6761\u8bb0\u5f55\uff0c\u5220\u9664\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761\u3002", (String)"CalPeriodEdit_19", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), selectRows.length, deleteRows.length, selectRows.length - deleteRows.length), failList);
            this.getView().showForm(parameters);
        }
        if (model.getEntryEntity("entryentity").size() == 0) {
            this.setFrequencyEnableByEntryNums(true);
            this.setPeriodNumberEnableByEntryNums();
        }
        this.setOperationVisible();
    }

    private int[] getDeleteRowsIndex(int[] entryGridSelectRows, List<String> failList) {
        ArrayList<Integer> deleteRowList = new ArrayList<Integer>(10);
        IPageCache pageCache = this.getPageCache();
        for (int index : entryGridSelectRows) {
            DynamicObject dynamicObject = this.getEntryDynamicObject(index);
            if (dynamicObject.getBoolean("refstatus")) {
                failList.add(String.format(Locale.ROOT, "%s\uff1a" + pageCache.get(dynamicObject.getPkValue().toString()), dynamicObject.getString("periodnumber")));
                continue;
            }
            deleteRowList.add(index);
        }
        return deleteRowList.stream().mapToInt(Integer::intValue).toArray();
    }

    private void checkPeriodDate(String fieldKey) {
        int rowIndex = this.getCurrentRowIndex();
        if (rowIndex < 0) {
            return;
        }
        DynamicObject dynamicObject = this.getEntryDynamicObject(rowIndex);
        Date fieldValue = dynamicObject.getDate(fieldKey);
        if (fieldValue == null) {
            return;
        }
        Date startDate = dynamicObject.getDate("startdate");
        Date endDate = dynamicObject.getDate("enddate");
        String format = "";
        if (fieldKey.equals("periodyear")) {
            format = "yyyy";
            if (startDate != null && !SWCDateTimeUtils.format((Date)startDate, (String)format).equals(SWCDateTimeUtils.format((Date)fieldValue, (String)format))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u5c5e\u5e74\u4efd\u4e0e\u671f\u95f4\u5f00\u59cb\u65e5\u671f/\u671f\u95f4\u7ed3\u675f\u65e5\u671f\u6240\u5728\u5e74\u4efd\u4e0d\u4e00\u81f4\uff0c\u53ef\u80fd\u5bfc\u81f4\u6570\u636e\u9519\u8bef\u3002", (String)"CalPeriodEdit_22", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                return;
            }
            if (endDate != null && !SWCDateTimeUtils.format((Date)endDate, (String)format).equals(SWCDateTimeUtils.format((Date)fieldValue, (String)format))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u5c5e\u5e74\u4efd\u4e0e\u671f\u95f4\u5f00\u59cb\u65e5\u671f/\u671f\u95f4\u7ed3\u675f\u65e5\u671f\u6240\u5728\u5e74\u4efd\u4e0d\u4e00\u81f4\uff0c\u53ef\u80fd\u5bfc\u81f4\u6570\u636e\u9519\u8bef\u3002", (String)"CalPeriodEdit_22", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            }
        } else {
            format = "yyyy/MM";
            if (startDate != null && !SWCDateTimeUtils.format((Date)startDate, (String)format).equals(SWCDateTimeUtils.format((Date)fieldValue, (String)format))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u5c5e\u5e74\u6708\u4e0e\u671f\u95f4\u5f00\u59cb\u65e5\u671f/\u671f\u95f4\u7ed3\u675f\u65e5\u671f\u6240\u5728\u6708\u4efd\u4e0d\u4e00\u81f4\uff0c\u53ef\u80fd\u5bfc\u81f4\u6570\u636e\u9519\u8bef\u3002", (String)"CalPeriodEdit_23", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                return;
            }
            if (endDate != null && !SWCDateTimeUtils.format((Date)endDate, (String)format).equals(SWCDateTimeUtils.format((Date)fieldValue, (String)format))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u5c5e\u5e74\u6708\u4e0e\u671f\u95f4\u5f00\u59cb\u65e5\u671f/\u671f\u95f4\u7ed3\u675f\u65e5\u671f\u6240\u5728\u6708\u4efd\u4e0d\u4e00\u81f4\uff0c\u53ef\u80fd\u5bfc\u81f4\u6570\u636e\u9519\u8bef\u3002", (String)"CalPeriodEdit_23", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private Boolean validatorDateOverlap(String field, PropertyChangedArgs args) {
        int entryCurrentRowIndex = args.getChangeSet()[0].getRowIndex();
        if (entryCurrentRowIndex == -1) {
            return Boolean.FALSE;
        }
        DynamicObject currentDynamicObject = this.getEntryDynamicObject(entryCurrentRowIndex);
        Date currentDate = currentDynamicObject.getDate(field);
        if (currentDate == null) {
            return Boolean.FALSE;
        }
        int total = this.getEntryRowCount();
        for (int index = 0; index < total; ++index) {
            if (index == entryCurrentRowIndex) continue;
            DynamicObject dynamicObject = this.getEntryDynamicObject(index);
            Date startDate = dynamicObject.getDate("startdate");
            Date endDate = dynamicObject.getDate("enddate");
            if (startDate == null || endDate == null || startDate.after(currentDate) || endDate.before(currentDate)) continue;
            currentDynamicObject.set(field, null);
            String multiLanguageField = this.getMultiLanguageField(field);
            this.getView().showMessage(MessageFormat.format(ResManager.loadKDString((String)"\u586b\u5165\u7684\u671f\u95f4{0}\u65e5\u671f\u4e0e\u5206\u5f55\u4e2d\u5df2\u5b58\u5728\u7684\u7b2c{1}\u884c\u671f\u95f4\u7684\u8d77\u6b62\u65e5\u671f{2}\u81f3{3}\u91cd\u53e0\uff0c\u8bf7\u91cd\u65b0\u586b\u5165\u5176\u4ed6\u503c\u3002", (String)"CalPeriodEdit_24", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), multiLanguageField, index + 1, SWCDateTimeUtils.format((Date)startDate, (String)SWCDateTimeUtils.getUserDateFormat()), SWCDateTimeUtils.format((Date)endDate, (String)SWCDateTimeUtils.getUserDateFormat())), MessageTypes.Default, new ConfirmCallBackListener("updateEntryEntityView", (IFormPlugin)this));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean validatorDateRule(String field, Boolean flag, PropertyChangedArgs args) {
        if (!flag.booleanValue()) {
            return Boolean.FALSE;
        }
        int entryCurrentRowIndex = args.getChangeSet()[0].getRowIndex();
        if (entryCurrentRowIndex == -1) {
            return Boolean.FALSE;
        }
        DynamicObject currentDynamicObject = this.getEntryDynamicObject(entryCurrentRowIndex);
        Date currentStartDate = currentDynamicObject.getDate("startdate");
        Date currentEndDate = currentDynamicObject.getDate("enddate");
        if (currentStartDate != null && currentEndDate != null) {
            if (currentStartDate.after(currentEndDate)) {
                currentDynamicObject.set(field, null);
                String message = this.getErrorMessage(field);
                this.getView().showMessage(message, MessageTypes.Default, new ConfirmCallBackListener("updateEntryEntityView", (IFormPlugin)this));
                return Boolean.FALSE;
            }
            return this.validatorDateRule(currentDynamicObject, entryCurrentRowIndex, currentStartDate, currentEndDate, field);
        }
        return Boolean.TRUE;
    }

    private Boolean validatorDateRule(DynamicObject currentDynamicObject, int entryCurrentRowIndex, Date currentStartDate, Date currentEndDate, String field) {
        int total = this.getEntryRowCount();
        for (int index = 0; index < total; ++index) {
            if (index == entryCurrentRowIndex) continue;
            DynamicObject dynamicObject = this.getEntryDynamicObject(index);
            Date startDate = dynamicObject.getDate("startdate");
            Date endDate = dynamicObject.getDate("enddate");
            if (startDate != null && !currentStartDate.after(startDate) && !currentEndDate.before(startDate)) {
                currentDynamicObject.set(field, null);
                this.getErrorMessage(field, index, startDate, endDate);
                return Boolean.FALSE;
            }
            if (endDate != null && !currentStartDate.after(endDate) && !currentEndDate.before(endDate)) {
                currentDynamicObject.set(field, null);
                this.getErrorMessage(field, index, startDate, endDate);
                return Boolean.FALSE;
            }
            if (startDate == null || endDate == null || currentStartDate.after(startDate) || currentEndDate.before(endDate)) continue;
            currentDynamicObject.set(field, null);
            this.getErrorMessage(field, index, startDate, endDate);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void getErrorMessage(String field, int index, Date startDate, Date endDate) {
        String multiLanguageField = this.getMultiLanguageField(field);
        String message = ResManager.loadKDString((String)"\u586b\u5165\u7684\u671f\u95f4{0}\u65e5\u671f\u4e0e\u5206\u5f55\u4e2d\u5df2\u5b58\u5728\u7684\u7b2c{1}\u884c\u671f\u95f4\u7684\u8d77\u6b62\u65e5\u671f{2}\u81f3{3}\u91cd\u53e0\uff0c\u8bf7\u91cd\u65b0\u586b\u5165\u5176\u4ed6\u503c\u3002", (String)"CalPeriodEdit_24", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
        this.getView().showMessage(MessageFormat.format(message, multiLanguageField, index + 1, startDate == null ? "" : SWCDateTimeUtils.format((Date)startDate, (String)SWCDateTimeUtils.getUserDateFormat()), endDate == null ? "" : SWCDateTimeUtils.format((Date)endDate, (String)SWCDateTimeUtils.getUserDateFormat())), MessageTypes.Default, new ConfirmCallBackListener("updateEntryEntityView", (IFormPlugin)this));
    }

    private String getErrorMessage(String field) {
        switch (field) {
            case "enddate": {
                return ResManager.loadKDString((String)"\u671f\u95f4\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u671f\u95f4\u5f00\u59cb\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u586b\u5165\u5176\u4ed6\u503c\u3002", (String)"CalPeriodEdit_21", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
            }
            case "startdate": {
                return ResManager.loadKDString((String)"\u671f\u95f4\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u671f\u95f4\u7ed3\u675f\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u586b\u5165\u5176\u4ed6\u503c\u3002", (String)"CalPeriodEdit_20", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
            }
        }
        return "";
    }

    private String getMultiLanguageField(String field) {
        switch (field) {
            case "enddate": {
                return ResManager.loadKDString((String)"\u7ed3\u675f", (String)"CalPeriodEdit_4", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
            }
            case "startdate": {
                return ResManager.loadKDString((String)"\u5f00\u59cb", (String)"CalPeriodEdit_3", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
            }
        }
        return "";
    }

    private void validateFrequencyNotNull(BeforeDoOperationEventArgs args) {
        DynamicObject dataEntity = this.getDynamicObject();
        String frequency = dataEntity.getString("calfrequency.type");
        CalPeriodFrequencyService calPeriodFrequencyService = CalPeriodFrequencyFactory.getCalPeriodFrequencyService((String)frequency, (AbstractFormPlugin)this, (IDataModel)this.getModel());
        if (calPeriodFrequencyService.frequencyNotNull(frequency)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u57fa\u672c\u4fe1\u606f\u4e2d\u7684\u201c\u9891\u5ea6\u201d\u548c\u201c\u671f\u95f4\u8d77\u59cb\u89c4\u5219\u201d\u4e24\u5b57\u6bb5\u7684\u503c\u3002", (String)"CalPeriodEdit_25", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (calPeriodFrequencyService.parametersMandatory()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u57fa\u672c\u4fe1\u606f\u4e2d\u7684\u201c\u9891\u5ea6\u201d\u548c\u201c\u671f\u95f4\u8d77\u59cb\u89c4\u5219\u201d\u4e24\u5b57\u6bb5\u7684\u503c\u3002", (String)"CalPeriodEdit_25", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void setPeriodNumberEnableByEntryNums() {
        int entryRowCount = this.getEntryRowCount();
        boolean flag = true;
        if (entryRowCount > 0) {
            flag = false;
        }
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"periodnumberprefix", "periodnumbersubject", "periodnumbersuffix", "serialnumber"});
    }

    private void setFrequencyEnableByEntryNums(boolean flag) {
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"calfrequency", "monthday", "halfmonthfirstday", "halfmonthsecday", "weekday", "country", "areatype"});
    }

    private void generateSampleNumber() {
        DynamicObject calPeriodType = this.getDynamicObject();
        String periodNumberPrefix = calPeriodType.getString("periodnumberprefix");
        if (this.isContainsChinese(periodNumberPrefix)) {
            calPeriodType.set("periodnumberprefix", null);
            this.getView().showMessage(ResManager.loadKDString((String)"\u7f16\u7801\u524d\u7f00\u4e0d\u5141\u8bb8\u8f93\u5165\u4e2d\u6587\u3002", (String)"CalPeriodEdit_27", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            return;
        }
        String periodNumberSuffix = calPeriodType.getString("periodnumbersuffix");
        if (this.isContainsChinese(periodNumberSuffix)) {
            calPeriodType.set("periodnumbersuffix", null);
            this.getView().showMessage(ResManager.loadKDString((String)"\u7f16\u7801\u540e\u7f00\u4e0d\u5141\u8bb8\u8f93\u5165\u4e2d\u6587\u3002", (String)"CalPeriodEdit_28", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            return;
        }
        String periodNumberSubject = calPeriodType.getString("periodnumbersubject");
        String periodNumberSubjectValue = "perioddate".equals(periodNumberSubject) ? SWCDateTimeUtils.format((Date)new Date(), (String)"yyyyMM") : SWCDateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd");
        int serialNumber = calPeriodType.getInt("serialnumber");
        String periodNumberSerialNumber = "";
        if (serialNumber == 1) {
            periodNumberSerialNumber = "1";
        } else if (serialNumber == 2) {
            periodNumberSerialNumber = "01";
        }
        String periodNumberSample = periodNumberPrefix + periodNumberSubjectValue + periodNumberSuffix + periodNumberSerialNumber;
        this.getModel().setValue("periodnumberexample", (Object)periodNumberSample);
    }

    private boolean isContainsChinese(String str) {
        if (SWCStringUtils.isEmpty((String)str)) {
            return false;
        }
        Matcher matcher = this.pat.matcher(str);
        return matcher.find();
    }

    private void setFrequencyFlexVisible(String frequency) {
        CalPeriodFrequencyService calPeriodFrequencyService = CalPeriodFrequencyFactory.getCalPeriodFrequencyService((String)frequency, (AbstractFormPlugin)this, (IDataModel)this.getModel());
        calPeriodFrequencyService.setVisible(this.getModel());
    }

    private void setFieldMustInput(boolean tag, String ... keys) {
        for (String key : keys) {
            FieldEdit fieldEdit = (FieldEdit)this.getControl(key);
            fieldEdit.setMustInput(tag);
            fieldEdit.setVisible(key, tag);
        }
    }

    private void setEntryOperateVisible(Boolean flag) {
        IFormView view = this.getView();
        view.setVisible(flag, new String[]{"maintenance"});
        view.setVisible(Boolean.valueOf(flag == false), new String[]{"addrow", "delrow", "saveperiodentity", "cancel"});
    }

    private int getCurrentRowIndex() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int[] rowIndexs = proxy.getEntryState("entryentity").getSelectedRows();
        if (rowIndexs.length == 0) {
            return -1;
        }
        return rowIndexs[0];
    }

    private int[] getEntryIndexArrByEntryName(String entryName) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entryName);
        return entryGrid.getSelectRows();
    }

    private DynamicObject getDynamicObject() {
        return this.getModel().getDataEntity();
    }

    private int getEntryRowCount() {
        return this.getModel().getEntryRowCount("entryentity");
    }

    private DynamicObject getEntryDynamicObject(int index) {
        return this.getModel().getEntryRowEntity("entryentity", index);
    }

    private void showBatchGenerateForm(BeforeDoOperationEventArgs args) {
        List<Map<String, Date>> result = this.validateEntryDateNotNull();
        if (result == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u5b8c\u6574\u7684\u671f\u95f4\u5f00\u59cb\u7ed3\u675f\u65e5\u671f\u3002", (String)"CalPeriodEdit_53", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String frequency = this.getDynamicObject().getString("calfrequency.type");
        CalPeriodFrequencyService calPeriodFrequencyService = CalPeriodFrequencyFactory.getCalPeriodFrequencyService((String)frequency, (AbstractFormPlugin)this, (IDataModel)this.getModel());
        if (calPeriodFrequencyService.frequencyNotNull(frequency)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u57fa\u672c\u4fe1\u606f\u4e2d\u7684\u201c\u9891\u5ea6\u201d\u548c\u201c\u671f\u95f4\u8d77\u59cb\u89c4\u5219\u201d\u4e24\u5b57\u6bb5\u7684\u503c\u3002", (String)"CalPeriodEdit_25", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        if (calPeriodFrequencyService.checkButtonEnable(args, map)) {
            map.put("calfrequency.type", frequency);
            map.put("calfrequency", this.getDynamicObject().getLong("calfrequency.id"));
            map.put("calPeriod", result);
            this.getView().showForm(CalShowFormServiceHelper.getBatchGenerateForm(map, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "batchgenerate")));
            return;
        }
        Object code = map.get("code");
        if (code != null) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4e24\u4e2a\u8d77\u59cb\u65e5\u7684\u65e5\u671f\u95f4\u9694\u4e0d\u7b26\u5408\u9891\u5ea6\u7c7b\u578b\u4e3a\u201c\u534a\u6708\u201d\u7684\u65e5\u671f\u89c4\u8303\uff0c\u786e\u5b9a\u7ee7\u7eed?", (String)"CalPeriodEdit_46", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("batchgenerate", (IFormPlugin)this));
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u57fa\u672c\u4fe1\u606f\u4e2d\u7684\u201c\u9891\u5ea6\u201d\u548c\u201c\u671f\u95f4\u8d77\u59cb\u89c4\u5219\u201d\u4e24\u5b57\u6bb5\u7684\u503c\u3002", (String)"CalPeriodEdit_25", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
        }
        args.setCancel(true);
    }

    private List<Map<String, Date>> validateEntryDateNotNull() {
        int rowCount = this.getEntryRowCount();
        ArrayList<Map<String, Date>> result = new ArrayList<Map<String, Date>>(rowCount);
        for (int index = 0; index < rowCount; ++index) {
            DynamicObject calPeriod = this.getEntryDynamicObject(index);
            Date startDate = calPeriod.getDate("startdate");
            Date endDate = calPeriod.getDate("enddate");
            if (startDate == null || endDate == null) {
                result.clear();
                return null;
            }
            HashMap<String, Date> map = new HashMap<String, Date>(16);
            map.put("startdate", startDate);
            map.put("enddate", endDate);
            result.add(map);
        }
        return result;
    }

    private int[] batchGenerateCalPeriod(BatchGenerateReturnInfo batchGenerateReturnInfo) {
        String frequency = this.getDynamicObject().getString("calfrequency.type");
        CalPeriodFrequencyService calPeriodFrequencyService = CalPeriodFrequencyFactory.getCalPeriodFrequencyService((String)frequency, (AbstractFormPlugin)this, (IDataModel)this.getModel());
        return calPeriodFrequencyService.batchGenerateCalPeriod(batchGenerateReturnInfo);
    }

    private Map<Integer, DynamicObject> validateRepeatDatesd() {
        int entryRowCount = this.getEntryRowCount();
        HashMap<Integer, DynamicObject> repeatIndexs = new HashMap<Integer, DynamicObject>(16);
        if (entryRowCount > 1) {
            for (int index = 0; index < entryRowCount; ++index) {
                DynamicObject target = this.getEntryDynamicObject(index);
                Date targetStartDate = target.getDate("startdate");
                Date targetEndDate = target.getDate("enddate");
                for (int j = index + 1; j < entryRowCount; ++j) {
                    DynamicObject source = this.getEntryDynamicObject(j);
                    Date sourceStartDate = source.getDate("startdate");
                    Date sourceEndDate = source.getDate("enddate");
                    if (targetStartDate == null || targetEndDate == null || sourceStartDate == null || sourceEndDate == null || targetStartDate.getTime() > sourceEndDate.getTime() || targetEndDate.getTime() < sourceStartDate.getTime()) continue;
                    repeatIndexs.put(index, target);
                }
            }
        }
        return repeatIndexs;
    }

    private void showBatchGenerateResultForm(BatchGenerateReturnInfo batchGenerateReturnInfo, Map<Integer, DynamicObject> repeatIndexs) {
        String title;
        IFormView view = this.getView();
        Date startDate = batchGenerateReturnInfo.getStartDate();
        int createRowCount = batchGenerateReturnInfo.getCreateRowCount();
        boolean operationResult = repeatIndexs.size() == 0;
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("hsbs_generateresult");
        formShowParameter.setShowTitle(false);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "updateEntryEntityView"));
        if (operationResult) {
            this.getPageCache().put("batchGenerateReturnInfo", SerializationUtils.toJsonString((Object)batchGenerateReturnInfo));
            this.setFrequencyEnableByEntryNums(false);
            title = ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"CalPeriodEdit_41", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
            formShowParameter.setCustomParam("firstPeriod", (Object)batchGenerateReturnInfo.getFirstPeriod());
            formShowParameter.setCustomParam("lastPeriod", (Object)batchGenerateReturnInfo.getLastPeriod());
        } else {
            List<String> messages = this.getGenerateFailMessages(repeatIndexs);
            StringBuilder buf = new StringBuilder();
            int len = messages.size();
            for (int index = 0; index < len; ++index) {
                buf.append("<div style='font-size:14px;color:#333333'>").append(messages.get(index)).append("</div>");
            }
            formShowParameter.setCustomParam("failMessages", (Object)buf.toString().trim());
            title = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"CalPeriodEdit_42", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
        }
        formShowParameter.setCustomParam("rowcount", (Object)createRowCount);
        formShowParameter.setCustomParam("title", (Object)title);
        formShowParameter.setCustomParam("startDate", (Object)SWCDateTimeUtils.formatUseUserFormat((Date)startDate));
        formShowParameter.setCustomParam("operationResult", (Object)operationResult);
        view.showForm(formShowParameter);
    }

    private List<String> getGenerateFailMessages(Map<Integer, DynamicObject> repeatIndexs) {
        ArrayList<String> failMessages = new ArrayList<String>(repeatIndexs.size());
        String formatString = SWCDateTimeUtils.getUserDateFormat();
        for (Map.Entry<Integer, DynamicObject> repeat : repeatIndexs.entrySet()) {
            StringBuilder failMessage = new StringBuilder();
            DynamicObject calPeriod = repeat.getValue();
            failMessage.append(SWCDateTimeUtils.format((Date)calPeriod.getDate("startdate"), (String)formatString));
            failMessage.append('-');
            failMessage.append(SWCDateTimeUtils.format((Date)calPeriod.getDate("enddate"), (String)formatString));
            failMessages.add(failMessage.toString());
        }
        return failMessages;
    }
}

