/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.basedata.cloudcolla;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.IBillPlugin;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.swc.hsbs.business.cloudcolla.HSBSCloudCollaHelper;

public class TriggerCollaEdit
extends AbstractFormPlugin
implements IBillPlugin,
BeforeF7SelectListener {
    private static final String PARAM_ENTRYENTITY = "paramentryentity";
    private static final String ENTITY_OBJECT = "entityobject";
    private static final String FIELD_KEY = "fieldkey";
    private static final String FIELD_NAME = "fieldname";
    private static final String FIELD_TYPE = "fieldtype";
    private static final String FIELD_REF = "fieldref";
    private static final String OPERATION_TYPE = "operationtype";
    private static final String OPERATION_CLS = "operationcls";
    private static final String IS_MUST_INPUT = "ismustinput";
    private static final String BIZAPP = "bizapp";
    private static final String DONOTHING_NEWPARAM = "donothing_newparam";
    private static final String PARAMENTRY_ADD = "paramentry_add";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit entityObject = (BasedataEdit)this.getView().getControl(ENTITY_OBJECT);
        entityObject.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bizApp = (BasedataEdit)this.getView().getControl(BIZAPP);
        bizApp.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initParamEntryentityFieldName();
    }

    public void afterLoadData(EventObject e) {
        String parentEntityId;
        this.initParamEntryentityFieldName();
        this.getModel().setDataChanged(false);
        switch (parentEntityId = this.getView().getParentView().getEntityId()) {
            case "hsbs_payrollactgtpl": 
            case "hsbs_payrollact": {
                IFormView view = this.getView();
                view.setVisible(Boolean.FALSE, new String[]{"bar_modify"});
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        switch (fieldKey) {
            case "operationtype": {
                this.setOperationCls(e.getChangeSet()[0].getNewValue());
                break;
            }
            case "bizapp": {
                model.beginInit();
                this.getModel().getDataEntity().set(ENTITY_OBJECT, null);
                this.getModel().deleteEntryData(PARAM_ENTRYENTITY);
                this.getModel().deleteEntryData("pluginentryentity");
                model.endInit();
                this.getView().updateView(ENTITY_OBJECT);
                this.getView().updateView(PARAM_ENTRYENTITY);
                this.getView().updateView("pluginentryentity");
                break;
            }
            case "entityobject": {
                model.beginInit();
                this.getModel().deleteEntryData(PARAM_ENTRYENTITY);
                model.endInit();
                this.getView().updateView(PARAM_ENTRYENTITY);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey;
        switch (fieldKey = event.getProperty().getName()) {
            case "bizapp": {
                List cloudIdList = HSBSCloudCollaHelper.getDefaultCloudIds();
                ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
                listShowParameter.setCustomParam("bizcloudids", (Object)cloudIdList);
                listShowParameter.setCustomParam("focusCloudId", (Object)"/U+QDTL900//");
                QFilter filter1 = new QFilter("bizcloud", "in", (Object)cloudIdList);
                listShowParameter.getListFilterParameter().getQFilters().add(filter1);
                break;
            }
            case "entityobject": {
                DynamicObject bizapp = this.getModel().getDataEntity().getDynamicObject(BIZAPP);
                if (null == bizapp) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u534f\u4f5c\u5e94\u7528\u201d\u3002", (String)"TriggerCollaEdit_1", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                    event.setCancel(true);
                    return;
                }
                ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
                HashSet<String> bizAppIds = new HashSet<String>();
                bizAppIds.add((String)bizapp.get("id"));
                showParameter.setCustomParam("bizappids", (Object)SerializationUtils.toJsonString(bizAppIds));
                QFilter filter = new QFilter("bizappid", "=", bizapp.get("id"));
                showParameter.getListFilterParameter().getQFilters().add(filter);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "donothing_newparam": {
                args.setCancel(true);
                if (!this.validEntityObject()) {
                    return;
                }
                this.showEntityObjectFieldsPage();
                break;
            }
            case "newpluginentry": {
                DynamicObject bizApp = this.getModel().getDataEntity().getDynamicObject(BIZAPP);
                if (bizApp != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u534f\u4f5c\u5e94\u7528\u201d\u3002", (String)"TriggerCollaEdit_1", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "newexeparam": {
                if (this.validEntityObject()) break;
                args.setCancel(true);
                break;
            }
        }
    }

    private boolean validEntityObject() {
        DynamicObject entityObject = this.getModel().getDataEntity().getDynamicObject(ENTITY_OBJECT);
        if (null == entityObject) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5b9e\u4f53\u5bf9\u8c61\u201d\u3002", (String)"TriggerCollaEdit_2", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "newpluginentry": {
                DynamicObjectCollection pluginEntry = this.getModel().getEntryEntity("pluginentryentity");
                ((DynamicObject)pluginEntry.get(pluginEntry.size() - 1)).set("pluginapp", this.getModel().getValue(BIZAPP));
                this.getView().updateView("pluginentryentity");
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        switch (actionId) {
            case "paramentry_add": {
                this.handleSelectedFields(returnData);
                break;
            }
        }
    }

    private void initParamEntryentityFieldName() {
        DataEntityPropertyCollection entityProps = this.getEntityObjectMainEntityType();
        if (null != entityProps) {
            DynamicObjectCollection entryentities = this.getModel().getEntryEntity(PARAM_ENTRYENTITY);
            List<String> fieldKeys = this.getAllFieldKeys(entryentities);
            List<Map<String, String>> fieldPropValues = this.getAllFieldPropValues(entityProps, fieldKeys);
            this.setParamEntryentityValue(fieldPropValues);
        }
    }

    private void setParamEntryentityValue(List<Map<String, String>> fieldPropValues) {
        IDataModel model = this.getModel();
        model.beginInit();
        int size = fieldPropValues.size();
        for (int i = 0; i < size; ++i) {
            Map<String, String> fieldPropValue = fieldPropValues.get(i);
            for (Map.Entry<String, String> entrySet : fieldPropValue.entrySet()) {
                model.setValue(entrySet.getKey(), (Object)entrySet.getValue(), i);
            }
        }
        model.endInit();
        this.getView().updateView(PARAM_ENTRYENTITY);
    }

    private List<String> getAllFieldKeys(DynamicObjectCollection entryentities) {
        ArrayList<String> fieldKeys = new ArrayList<String>();
        for (DynamicObject entryentity : entryentities) {
            fieldKeys.add(entryentity.getString(FIELD_KEY));
        }
        return fieldKeys;
    }

    private DataEntityPropertyCollection getEntityObjectMainEntityType() {
        DynamicObject dyobj = this.getModel().getDataEntity().getDynamicObject(ENTITY_OBJECT);
        if (null != dyobj) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)dyobj.getString("number"));
            return entityType.getProperties();
        }
        return null;
    }

    private List<Map<String, String>> getAllFieldPropValues(DataEntityPropertyCollection entityProps, List<String> fieldKeys) {
        ArrayList<Map<String, String>> propValues = new ArrayList<Map<String, String>>();
        ArrayList<String> noMatchFields = new ArrayList<String>();
        for (String fieldKey : fieldKeys) {
            HashMap<String, String> propValue = new HashMap<String, String>();
            IDataEntityProperty prop = (IDataEntityProperty)entityProps.get((Object)fieldKey);
            if (null != prop) {
                propValue.put(FIELD_NAME, prop.getDisplayName().toString());
                propValue.put(FIELD_TYPE, prop.getPropertyType().getName());
                Boolean isMustInput = prop instanceof FieldProp && ((FieldProp)prop).isMustInput() || prop instanceof BasedataProp && ((BasedataProp)prop).isMustInput();
                propValue.put(IS_MUST_INPUT, isMustInput != false ? "1" : "0");
                if (prop instanceof BasedataProp) {
                    propValue.put(FIELD_REF, ((BasedataProp)prop).getBaseEntityId());
                }
                propValues.add(propValue);
                continue;
            }
            noMatchFields.add(fieldKey);
        }
        if (!noMatchFields.isEmpty()) {
            String join = String.join((CharSequence)",", noMatchFields);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u5bf9\u5e94\u7684\u5b57\u6bb5\u4e3a\uff1a\u201c{}\u201d", (String)"TriggerCollaEdit_0", (String)"swc-hsbs-formplugin", (Object[])new Object[]{join}));
        }
        return propValues;
    }

    private void setOperationCls(Object operationTypeObj) {
        if (operationTypeObj instanceof DynamicObject) {
            DynamicObject operationTypeDyobj = (DynamicObject)operationTypeObj;
            this.getModel().setValue(OPERATION_CLS, operationTypeDyobj.get("operationcls.id"));
        } else {
            this.getModel().setValue(OPERATION_CLS, null);
        }
    }

    private void handleSelectedFields(Object returnData) {
        List selectedFieldKeys = (List)returnData;
        if (CollectionUtils.isEmpty((Collection)selectedFieldKeys)) {
            return;
        }
        this.addEntry(selectedFieldKeys);
        this.initParamEntryentityFieldName();
    }

    private void addEntry(List<String> fieldKeys) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        int startIndex = 0;
        for (String fieldKey : fieldKeys) {
            setter.set(FIELD_KEY, (Object)fieldKey, startIndex);
            ++startIndex;
        }
        model.batchCreateNewEntryRow(PARAM_ENTRYENTITY, setter);
        model.endInit();
        this.getView().updateView(PARAM_ENTRYENTITY);
    }

    private void showEntityObjectFieldsPage() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setStatus(OperationStatus.VIEW);
        formShowParameter.setFormId("hsbs_entobjfieldsmodal");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        DynamicObject entityObject = this.getModel().getDataEntity().getDynamicObject(ENTITY_OBJECT);
        formShowParameter.setCustomParam("entiytObject", (Object)entityObject.getString("number"));
        List<Object> selectedKeys = new ArrayList();
        DynamicObjectCollection paramEntry = this.getModel().getEntryEntity(PARAM_ENTRYENTITY);
        if (CollectionUtils.isNotEmpty((Collection)paramEntry)) {
            selectedKeys = paramEntry.stream().map(entry -> entry.getString(FIELD_KEY)).collect(Collectors.toList());
        }
        formShowParameter.setCustomParam("selectedKeys", selectedKeys);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, PARAMENTRY_ADD));
        this.getView().showForm(formShowParameter);
    }
}

