/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.basedata.datareader;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.swc.hsbp.common.enums.CalDataTypeEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class FixedValueInputPlugin
extends AbstractFormPlugin {
    private static final String BTN_OK = "btnok";

    public void afterCreateNewData(EventObject eventObject) {
        String filterDataType = (String)this.getView().getFormShowParameter().getCustomParam("filterDataType");
        FieldEdit fieldEdit = null;
        if (SWCStringUtils.equals((String)filterDataType, (String)CalDataTypeEnum.STRING.getCode())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"textvalue"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"datevalue", "numeralvalue"});
            fieldEdit = (FieldEdit)this.getView().getControl("textvalue");
        } else if (SWCStringUtils.equals((String)filterDataType, (String)CalDataTypeEnum.DATE.getCode())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"datevalue"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"textvalue", "numeralvalue"});
            fieldEdit = (FieldEdit)this.getView().getControl("datevalue");
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"numeralvalue"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"textvalue", "datevalue"});
            fieldEdit = (FieldEdit)this.getView().getControl("numeralvalue");
        }
        fieldEdit.setMustInput(true);
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String clkKey = control.getKey();
        HashMap<String, String> returnData = new HashMap<String, String>();
        if (BTN_OK.equals(clkKey)) {
            String filterDataType = (String)this.getView().getFormShowParameter().getCustomParam("filterDataType");
            Object value = null;
            String vauleStr = null;
            if (SWCStringUtils.equals((String)filterDataType, (String)CalDataTypeEnum.STRING.getCode())) {
                value = this.getModel().getValue("textvalue");
                if (value == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u56fa\u5b9a\u503c\u3002", (String)"FixedValueInputPlugin_0", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                    return;
                }
                vauleStr = (String)value;
            } else if (SWCStringUtils.equals((String)filterDataType, (String)CalDataTypeEnum.DATE.getCode())) {
                value = this.getModel().getValue("datevalue");
                if (value == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u56fa\u5b9a\u503c\u3002", (String)"FixedValueInputPlugin_0", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                    return;
                }
                vauleStr = SWCDateTimeUtils.format((Date)((Date)value), (String)"yyyy-MM-dd");
            } else {
                value = this.getModel().getValue("numeralvalue");
                if (value == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u56fa\u5b9a\u503c\u3002", (String)"FixedValueInputPlugin_0", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                    return;
                }
                vauleStr = ((BigDecimal)value).toPlainString();
            }
            returnData.put("clickStatus", "ok");
            returnData.put("fixedvalue", vauleStr);
            returnData.put("dataType", filterDataType);
            this.getView().setReturnData(returnData);
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        Object returnData = this.getView().getReturnData();
        if (returnData != null) {
            this.getView().returnDataToParent(returnData);
        }
    }
}

