/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.basedata.fetchconfig;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.enums.CalDataTypeEnum;
import kd.swc.hsbp.common.enums.ResultFetchStrategyEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.FetchItemCheckResultVo;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;
import kd.swc.hsbs.business.basedata.fetchconfig.FetchConfigHelper;

public class CalResultFetchConfigEdit
extends SWCDataBaseEdit
implements BeforeF7SelectListener {
    private static final String FIELD_MATCHCALITEM = "matchcalitem";
    private static final String ITEMTYPE = "itemtype";
    private static final String ITEMDATATYPE = "itemdatatype";
    private static final String FETCHITEMENTRY = "fetchitementry";
    private static final String SALARYITEMENTRY = "salaryitementry";
    private static final String SUPPORTITEMENTRY = "supportitementry";
    private static final String BIZITEMENTRY = "bizitementry";
    private static final String DATA_TYPE_NUM = "num";
    private static final String DATA_TYPE_AMOUNT = "amount";
    private static final String DATA_TYPE_DATE = "date";
    private static final String DATA_TYPE_TEXT = "text";
    private static final String MATCH_FETCH_ITEM = "matchfetchitem";
    private static final String HANDLESTRATEGY = "handlestrategy";
    private static final String TYPE_AREA_CHANGE = "1";
    private static final String TYPE_COUNTRY_CHANGE = "2";
    private static final char LEFT_MID_BRACKET = '\u3010';
    private static final char RIGHT_MID_BRACKET = '\u3011';
    private static final String FIELD_SCENELIMIT = "scenelimit";
    private static final String FIELD_CALSCENE = "calscene";
    private static final String FIELD_DATE_MATCH_METHOD = "datematchmethod";
    private static final String FIELD_PRE_PERIOD_COUNT = "preperiodcount";
    private static final String FIELD_DATE_MATCH = "datematch";
    private static final String FIELD_STRATEGY = "strategy";
    private static final String CHANGE_AREA_TYPE = "changeAreaType";
    private static final String CHANGE_COUNTRY = "changeCountry";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BasedataEdit matchFetchItem = (BasedataEdit)this.getView().getControl(MATCH_FETCH_ITEM);
        matchFetchItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit startDateFetchItem = (BasedataEdit)this.getView().getControl("startitem");
        startDateFetchItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit endDateFetchItem = (BasedataEdit)this.getView().getControl("enditem");
        endDateFetchItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit calScene = (BasedataEdit)this.getView().getControl(FIELD_CALSCENE);
        calScene.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{ITEMTYPE, FIELD_MATCHCALITEM, "startitem", "enditem", "matchfieldname", MATCH_FETCH_ITEM, FIELD_DATE_MATCH_METHOD, FIELD_DATE_MATCH, FIELD_SCENELIMIT, FIELD_PRE_PERIOD_COUNT, FIELD_STRATEGY});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (key = formOperate.getOperateKey()) {
            case "save": {
                boolean check;
                if (formOperate.getOption().tryGetVariableValue("save", new RefObject())) break;
                boolean flag = this.checkPrePeriodCount();
                if (!flag) {
                    args.setCancel(true);
                }
                if (check = this.checkFetchItemConfig()) break;
                args.setCancel(true);
                break;
            }
            case "enable": {
                boolean dataChanged = this.getModel().getDataChanged();
                if (!dataChanged) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"CalResultFetchConfigEdit_13", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "delete": {
                formOperate.getOption().setVariableValue("ignorerefentityids", "hsbs_fetchconfigitem");
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        if (SWCStringUtils.equals((String)"enable", (String)key) || SWCStringUtils.equals((String)"disable", (String)key)) {
            this.checkEnable();
        } else if (SWCStringUtils.equals((String)"addmatchentry", (String)key)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("calitemmatchentry");
            int rowIndex = entryEntity.size() - 1;
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{ITEMDATATYPE, MATCH_FETCH_ITEM, HANDLESTRATEGY});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey = event.getProperty().getName();
        ListShowParameter param = (ListShowParameter)event.getFormShowParameter();
        ListFilterParameter listFilterParameter = param.getListFilterParameter();
        List filterList = listFilterParameter.getQFilters();
        if (SWCStringUtils.equals((String)MATCH_FETCH_ITEM, (String)fieldKey)) {
            this.assembleMatchFetchItemFilter(event, filterList);
        } else if (SWCStringUtils.equals((String)"startitem", (String)fieldKey) || SWCStringUtils.equals((String)"enditem", (String)fieldKey)) {
            this.assembleDateFetchItemRangeFilter(event, filterList);
        } else if (SWCStringUtils.equals((String)FIELD_CALSCENE, (String)fieldKey)) {
            this.assembleCalSceneFilter(event, filterList);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        EntryGrid entryGrid = (EntryGrid)this.getControl("calitemmatchentry");
        int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
        DynamicObjectCollection fieldEntry = this.getModel().getEntryEntity("calitemmatchentry");
        switch (key) {
            case "matchcalitem": {
                if (selectedRows == null || selectedRows.length <= 0) break;
                this.openItemMatchSelectF7(selectedRows[0]);
                break;
            }
            case "strategy": {
                DynamicObject row = (DynamicObject)fieldEntry.get(selectedRows[0]);
                this.openStrategyForm(row.getString(HANDLESTRATEGY));
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey = args.getProperty().getName();
        int rowIndex = args.getChangeSet()[0].getRowIndex();
        switch (fieldKey) {
            case "preperiodcount": {
                this.checkPrePeriodCount();
                break;
            }
            case "datematchmethod": {
                this.checkDateMatchMethod(false);
                break;
            }
            case "scenelimit": {
                this.checkSceneLimit();
                break;
            }
            case "itemtype": {
                this.cleanOtherData(rowIndex, FIELD_MATCHCALITEM, ITEMDATATYPE, MATCH_FETCH_ITEM, HANDLESTRATEGY, FETCHITEMENTRY, SALARYITEMENTRY, SUPPORTITEMENTRY, BIZITEMENTRY, FIELD_STRATEGY);
                break;
            }
            case "areatype": {
                if (this.checkEntryHasData().booleanValue() || this.checkSceneDateRageChanged().booleanValue()) {
                    this.openAreaTypeChangeConfirm((String)args.getChangeSet()[0].getOldValue());
                    break;
                }
                this.checkAreaType();
                break;
            }
            case "country": {
                DynamicObject oldCountry = (DynamicObject)args.getChangeSet()[0].getOldValue();
                if (oldCountry == null) {
                    return;
                }
                if (!this.checkEntryHasData().booleanValue() && !this.checkSceneDateRageChanged().booleanValue()) break;
                this.openCountryChangeConfirm(oldCountry.getString("id"));
                break;
            }
            case "matchcalitem": {
                String newValue = (String)args.getChangeSet()[0].getNewValue();
                if (SWCStringUtils.isEmpty((String)newValue)) {
                    this.cleanOtherData(rowIndex, ITEMDATATYPE, MATCH_FETCH_ITEM, HANDLESTRATEGY, FETCHITEMENTRY, SALARYITEMENTRY, SUPPORTITEMENTRY, BIZITEMENTRY, FIELD_STRATEGY);
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{ITEMDATATYPE, MATCH_FETCH_ITEM, HANDLESTRATEGY});
                    break;
                }
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{ITEMDATATYPE, MATCH_FETCH_ITEM, HANDLESTRATEGY});
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (SWCStringUtils.isEmpty((String)actionId)) {
            return;
        }
        if (SWCStringUtils.equals((String)FIELD_STRATEGY, (String)actionId)) {
            Object backData = closedCallBackEvent.getReturnData();
            Map data = (Map)backData;
            if (data == null) {
                return;
            }
            String value = (String)data.get("value");
            EntryGrid entryGrid = (EntryGrid)this.getControl("calitemmatchentry");
            int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
            int index = 0;
            if (selectedRows.length > 0) {
                index = selectedRows[0];
            }
            this.getModel().setValue(FIELD_STRATEGY, (Object)ResultFetchStrategyEnum.getDesc((String)value), index);
            this.getModel().setValue(HANDLESTRATEGY, (Object)value, index);
            return;
        }
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (CollectionUtils.isEmpty((Collection)returnData)) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("calitemmatchentry");
        int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
        switch (actionId) {
            case "hsbs_supportitem": {
                this.setObjItemSelect(selectedRows[0], returnData.get(0).getPrimaryKeyValue(), SUPPORTITEMENTRY, "hsbs_supportitem");
                break;
            }
            case "hsbs_salaryitem": {
                this.setObjItemSelect(selectedRows[0], returnData.get(0).getPrimaryKeyValue(), SALARYITEMENTRY, "hsbs_salaryitem");
                break;
            }
            case "hsbs_bizitem": {
                this.setObjItemSelect(selectedRows[0], returnData.get(0).getPrimaryKeyValue(), BIZITEMENTRY, "hsbs_bizitem");
                break;
            }
            case "hsbs_fetchitem": {
                this.setObjItemSelect(selectedRows[0], returnData.get(0).getPrimaryKeyValue(), FETCHITEMENTRY, "hsbs_fetchitem");
                break;
            }
            case "matchfetchitem": {
                this.setObjItemSelect(selectedRows[0], returnData.get(0).getPrimaryKeyValue(), MATCH_FETCH_ITEM, "hsbs_fetchitem");
                break;
            }
            case "startitem": {
                this.setStartEndItem("startitem", returnData.get(0));
                break;
            }
            case "enditem": {
                this.setStartEndItem("enditem", returnData.get(0));
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        String customVaule = messageBoxClosedEvent.getCustomVaule();
        switch (callBackId) {
            case "changeAreaType": {
                if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                    this.cleanConfigData(result, customVaule, TYPE_AREA_CHANGE);
                    this.checkAreaType();
                    break;
                }
                String oldSAreaTypeValue = messageBoxClosedEvent.getCustomVaule();
                this.getModel().beginInit();
                this.getModel().setValue("areatype", (Object)oldSAreaTypeValue);
                this.getModel().endInit();
                this.getView().updateView();
                break;
            }
            case "changeCountry": {
                if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                    this.cleanConfigData(result, customVaule, TYPE_COUNTRY_CHANGE);
                    break;
                }
                String oldCountryValue = messageBoxClosedEvent.getCustomVaule();
                this.getModel().beginInit();
                this.getModel().setValue("country", (Object)Long.valueOf(oldCountryValue));
                this.getModel().endInit();
                this.getView().updateView();
                break;
            }
            case "fetch_too_many_notify": {
                if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("save", "true");
                this.getView().invokeOperation("save", operateOption);
                break;
            }
        }
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.setFieldEntryData();
    }

    public void afterBindData(EventObject eventObject) {
        this.checkEnable();
        this.checkAreaType();
        this.getModel().setDataChanged(false);
        this.checkEntryDataType();
        this.checkSceneLimit();
        this.checkDateMatchMethod(true);
    }

    private void openStrategyForm(String handlestrategy) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("calitemmatchentry");
        int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
        DynamicObjectCollection filterEntry = this.getModel().getEntryEntity("calitemmatchentry");
        DynamicObject row = (DynamicObject)filterEntry.get(selectedRows[0]);
        String dataType = row.getString(ITEMDATATYPE);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCaption(ResManager.loadKDString((String)"\u6570\u636e\u5904\u7406\u7b56\u7565", (String)"CalResultFetchConfigEdit_15", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
        showParameter.setFormId("hsbs_combovalueinput");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("dataType", (Object)dataType);
        showParameter.setCustomParam("from", (Object)"resultFetchConfig");
        showParameter.setCustomParam("value", (Object)handlestrategy);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, FIELD_STRATEGY);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void assembleCalSceneFilter(BeforeF7SelectEvent event, List<QFilter> filterList) {
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsbs_resultfetchconfig", (String)"47150e89000000ac");
        if (permOrgs != null && !permOrgs.hasAllOrgPerm()) {
            filterList.add(new QFilter("org.id", "in", (Object)permOrgs.getHasPermOrgs()));
        }
        if (!this.setOnlyCountryFilter(filterList)) {
            event.setCancel(true);
            return;
        }
    }

    private boolean setOnlyCountryFilter(List<QFilter> filterList) {
        String areaType = (String)this.getModel().getValue("areatype");
        if (SWCStringUtils.equals((String)areaType, (String)TYPE_AREA_CHANGE)) {
            return true;
        }
        DynamicObject country = (DynamicObject)this.getModel().getValue("country");
        if (country == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u56fd\u5bb6/\u5730\u533a\u3002", (String)"CalResultFetchConfigEdit_1", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            return false;
        }
        QFilter filter = new QFilter("country", "=", (Object)country.getLong("id"));
        filterList.add(filter);
        return true;
    }

    private void assembleDateFetchItemRangeFilter(BeforeF7SelectEvent event, List<QFilter> filterList) {
        if (!this.setCountryFilter(filterList)) {
            event.setCancel(true);
            return;
        }
        HashSet dateTypeIds = CalDataTypeEnum.DATE.getMatchTypeIdSet();
        filterList.add(new QFilter("datatype", "in", (Object)dateTypeIds));
        List relatedCode = FetchConfigHelper.selectRelatedFetchItem((String)TYPE_AREA_CHANGE);
        if (CollectionUtils.isEmpty((Collection)relatedCode)) {
            filterList.add(new QFilter("enable", "=", (Object)"-1"));
        } else {
            filterList.add(new QFilter("enable", "=", (Object)TYPE_AREA_CHANGE));
            filterList.add(new QFilter("uniquecode", "in", (Object)relatedCode));
        }
    }

    private boolean checkFetchItemConfig() {
        IFormView view = this.getView();
        DynamicObjectCollection calItemMatchEntry = this.getModel().getEntryEntity("calitemmatchentry");
        if (CollectionUtils.isEmpty((Collection)calItemMatchEntry)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8ba1\u7b97\u9879\u76ee\u6620\u5c04\u53d6\u6570\u9879\u76ee\u201d\u3002", (String)"CalResultFetchConfigEdit_4", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            return false;
        }
        for (DynamicObject singleEntry : calItemMatchEntry) {
            if (!SWCStringUtils.equals((String)"4", (String)singleEntry.getString(ITEMTYPE))) continue;
            ArrayList<Long> fetchItemIdList = new ArrayList<Long>(10);
            fetchItemIdList.add(singleEntry.getLong("fetchitementry.id"));
            FetchItemCheckResultVo result = FetchConfigHelper.checkFetchItemCycle((long)singleEntry.getLong("fetchitementry.id"), fetchItemIdList);
            if (!SWCStringUtils.equals((String)TYPE_COUNTRY_CHANGE, (String)result.getResult())) continue;
            view.showConfirm(ResManager.loadKDString((String)"\u53d6\u6570\u9879\u76ee\u4f9d\u8d56\u5c42\u6b21\u5c06\u8d85\u8fc75\u5c42\uff0c\u53ef\u80fd\u589e\u5927\u8ba1\u7b97\u6846\u67b6\u590d\u6742\u5ea6\u4ee5\u53ca\u8ba1\u7b97\u6027\u80fd\u635f\u8017\uff0c\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"CalResultFetchConfigEdit_9", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("fetch_too_many_notify", (IFormPlugin)this));
        }
        return true;
    }

    private String assembleFetchItemStr(List<String> fetchItemList) {
        StringBuilder sb = new StringBuilder();
        if (!CollectionUtils.isEmpty(fetchItemList)) {
            fetchItemList.stream().forEach(item -> sb.append('\u3010').append((String)item).append('\u3011'));
        }
        return sb.toString();
    }

    private void assembleMatchFetchItemFilter(BeforeF7SelectEvent event, List<QFilter> filterList) {
        List<Long> selectedItemId;
        if (!this.setCountryFilter(filterList)) {
            event.setCancel(true);
            return;
        }
        String dataType = this.assembleFetchItemDataType();
        HashSet dateTypeIds = Sets.newHashSetWithExpectedSize((int)2);
        dateTypeIds.add(1030L);
        if (StringUtils.equals((CharSequence)CalDataTypeEnum.DATE.getCode(), (CharSequence)dataType)) {
            dateTypeIds.add(1050L);
        } else if (StringUtils.equals((CharSequence)CalDataTypeEnum.BIGDECIMAL.getCode(), (CharSequence)dataType)) {
            dateTypeIds.add(1010L);
        }
        filterList.add(new QFilter("datatype", "in", (Object)dateTypeIds));
        List itemIdList = FetchConfigHelper.getRelatedFetchItemId();
        if (!CollectionUtils.isEmpty((Collection)itemIdList)) {
            filterList.add(new QFilter("id", "not in", (Object)itemIdList));
        }
        if (!CollectionUtils.isEmpty(selectedItemId = this.assembleSelectedFetchItemId())) {
            filterList.add(new QFilter("id", "not in", selectedItemId));
        }
    }

    private List<Long> assembleSelectedFetchItemId() {
        ArrayList<Long> itemIdList = new ArrayList<Long>(10);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("calitemmatchentry");
        if (entryEntity == null || entryEntity.size() == 0) {
            return itemIdList;
        }
        for (DynamicObject obj : entryEntity) {
            itemIdList.add(obj.getLong("matchfetchitem.id"));
        }
        return itemIdList;
    }

    private Boolean checkSceneDateRageChanged() {
        IDataModel model = this.getModel();
        DynamicObjectCollection value = (DynamicObjectCollection)model.getValue(FIELD_CALSCENE);
        if (value != null && value.size() > 0 || model.getValue("startitem") != null || model.getValue("enditem") != null) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private boolean checkPrePeriodCount() {
        int prePeriodCount;
        String dateMatchMethod = (String)this.getModel().getValue(FIELD_DATE_MATCH_METHOD);
        if (TYPE_AREA_CHANGE.equals(dateMatchMethod) && ((prePeriodCount = this.getModel().getDataEntity().getInt(FIELD_PRE_PERIOD_COUNT)) < 1 || prePeriodCount > 12)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u524d\u5e8f\u671f\u95f4\u4e2a\u6570\u53ea\u80fd\u662f1-12\u3002", (String)"CalResultFetchConfigEdit_14", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void checkDateMatchMethod(boolean flag) {
        String dateMatchMethod = (String)this.getModel().getValue(FIELD_DATE_MATCH_METHOD);
        FieldEdit prePeriodCount = (FieldEdit)this.getControl(FIELD_PRE_PERIOD_COUNT);
        FieldEdit dateMatch = (FieldEdit)this.getControl(FIELD_DATE_MATCH);
        FieldEdit startItem = (FieldEdit)this.getControl("startitem");
        FieldEdit endItem = (FieldEdit)this.getControl("enditem");
        if (TYPE_AREA_CHANGE.equals(dateMatchMethod)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FIELD_PRE_PERIOD_COUNT});
            this.getView().setVisible(Boolean.FALSE, new String[]{FIELD_DATE_MATCH, "startitem", "enditem"});
            prePeriodCount.setMustInput(true);
            this.batchSetFieldMustInput(false, dateMatch, startItem, endItem);
            this.cleanFieldData(FIELD_DATE_MATCH, "startitem", "startitemcode", "enditem", "enditemcode");
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{FIELD_PRE_PERIOD_COUNT});
            this.getView().setVisible(Boolean.TRUE, new String[]{FIELD_DATE_MATCH, "startitem", "enditem"});
            prePeriodCount.setMustInput(false);
            this.batchSetFieldMustInput(true, dateMatch, startItem, endItem);
            this.cleanFieldData(FIELD_PRE_PERIOD_COUNT);
        }
        if (flag) {
            this.getModel().setDataChanged(false);
        }
    }

    private void checkSceneLimit() {
        String sceneLimit = (String)this.getModel().getValue(FIELD_SCENELIMIT);
        FieldEdit calSceneField = (FieldEdit)this.getControl(FIELD_CALSCENE);
        if (TYPE_COUNTRY_CHANGE.equals(sceneLimit)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FIELD_CALSCENE});
            calSceneField.setMustInput(true);
        } else {
            DynamicObjectCollection calScene = (DynamicObjectCollection)this.getModel().getValue(FIELD_CALSCENE);
            if (calScene != null) {
                this.getModel().beginInit();
                this.getModel().setValue(FIELD_CALSCENE, null);
                this.getModel().endInit();
                this.getView().updateView(FIELD_CALSCENE);
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{FIELD_CALSCENE});
            calSceneField.setMustInput(false);
        }
    }

    private Boolean checkEntryHasData() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("calitemmatchentry");
        if (entryEntity == null || entryEntity.size() == 0) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void cleanOtherData(int rowIndex, String ... field) {
        for (String single : field) {
            this.getModel().beginInit();
            this.getModel().setValue(single, null, rowIndex);
            this.getModel().endInit();
            this.getView().updateView(single, rowIndex);
        }
    }

    private void cleanFieldData(String ... field) {
        for (String single : field) {
            this.getModel().beginInit();
            this.getModel().setValue(single, null);
            this.getModel().endInit();
            this.getView().updateView(single);
        }
    }

    private void batchSetFieldMustInput(boolean visible, FieldEdit ... fieldEdits) {
        for (FieldEdit field : fieldEdits) {
            field.setMustInput(visible);
        }
    }

    private String assembleFetchItemDataType() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("calitemmatchentry");
        int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
        DynamicObjectCollection filterEntry = this.getModel().getEntryEntity("calitemmatchentry");
        DynamicObject row = (DynamicObject)filterEntry.get(selectedRows[0]);
        return row.getString(ITEMDATATYPE);
    }

    private void openItemMatchSelectF7(int rowIndex) {
        DynamicObjectCollection fieldEntry = this.getModel().getEntryEntity("calitemmatchentry");
        DynamicObject row = (DynamicObject)fieldEntry.get(rowIndex);
        String itemType = row.getString(ITEMTYPE);
        if (SWCStringUtils.isEmpty((String)itemType)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u7c7b\u578b\uff0c\u518d\u9009\u62e9\u8ba1\u7b97\u5143\u7d20\u3002", (String)"CalResultFetchConfigEdit_0", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, Set<String>> existItemCodeMap = this.assembleExistFieldItemMap(fieldEntry, rowIndex);
        Set<String> existItemCodeSet = existItemCodeMap.get(itemType);
        if (existItemCodeSet == null) {
            existItemCodeSet = new HashSet<String>(0);
        }
        switch (itemType) {
            case "1": {
                this.openSourceFieldF7("hsbs_salaryitem", existItemCodeSet);
                break;
            }
            case "2": {
                this.openSourceFieldF7("hsbs_supportitem", existItemCodeSet);
                break;
            }
            case "3": {
                this.openSourceFieldF7("hsbs_bizitem", existItemCodeSet);
                break;
            }
            case "4": {
                this.openSourceFieldF7("hsbs_fetchitem", existItemCodeSet);
                break;
            }
        }
    }

    private Map<String, Set<String>> assembleExistFieldItemMap(DynamicObjectCollection fieldEntry, int rowIndex) {
        HashMap<String, Set<String>> itemMap = new HashMap<String, Set<String>>(16);
        HashMap<String, String> itemTypeFieldMap = new HashMap<String, String>(4);
        itemTypeFieldMap.put(TYPE_AREA_CHANGE, SALARYITEMENTRY);
        itemTypeFieldMap.put(TYPE_COUNTRY_CHANGE, SUPPORTITEMENTRY);
        itemTypeFieldMap.put("3", BIZITEMENTRY);
        itemTypeFieldMap.put("4", FETCHITEMENTRY);
        for (int i = 0; i < fieldEntry.size(); ++i) {
            DynamicObject itemObj;
            String itemType;
            if (i == rowIndex || SWCStringUtils.isEmpty((String)(itemType = (itemObj = (DynamicObject)fieldEntry.get(i)).getString(ITEMTYPE)))) continue;
            Set itemList = itemMap.computeIfAbsent(itemType, single -> new HashSet(16));
            DynamicObject targetObj = itemObj.getDynamicObject((String)itemTypeFieldMap.get(itemType));
            if (targetObj == null) continue;
            itemList.add(targetObj.getString("uniquecode"));
        }
        return itemMap;
    }

    private void openSourceFieldF7(String entity, Set<String> existCodes) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(1);
        if (!this.setCountryFilter(filterList)) {
            return;
        }
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)entity, (boolean)false);
        showParameter.setFormId("bos_listf7");
        showParameter.setBillFormId(entity);
        ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
        List qFilters = listFilterParameter.getQFilters();
        if (SWCStringUtils.equals((String)entity, (String)"hsbs_fetchitem")) {
            List itemCodeList = FetchConfigHelper.selectRelatedFetchItem(null);
            if (CollectionUtils.isEmpty((Collection)itemCodeList)) {
                qFilters.add(new QFilter("enable", "=", (Object)"-1"));
            } else {
                itemCodeList.removeAll(existCodes);
                qFilters.add(new QFilter("uniquecode", "in", (Object)itemCodeList));
            }
            qFilters.addAll(filterList);
        } else {
            qFilters.add(new QFilter("uniquecode", "not in", existCodes));
        }
        qFilters.add(new QFilter("enable", "=", (Object)TYPE_AREA_CHANGE));
        qFilters.add(new QFilter("status", "=", (Object)"C"));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, entity);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private boolean setCountryFilter(List<QFilter> filterList) {
        String areaType = (String)this.getModel().getValue("areatype");
        if (SWCStringUtils.equals((String)areaType, (String)TYPE_AREA_CHANGE)) {
            filterList.add(new QFilter("areatype", "=", (Object)areaType));
            return true;
        }
        DynamicObject country = (DynamicObject)this.getModel().getValue("country");
        if (country == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u56fd\u5bb6/\u5730\u533a\u3002", (String)"CalResultFetchConfigEdit_1", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            return false;
        }
        QFilter filter = new QFilter("country", "=", (Object)country.getLong("id"));
        filter.or(new QFilter("areatype", "=", (Object)TYPE_AREA_CHANGE));
        filterList.add(filter);
        return true;
    }

    private void setStartEndItem(String itemKey, ListSelectedRow selectedRow) {
        this.getModel().beginInit();
        String name = selectedRow.getName();
        Long pkid = (Long)selectedRow.getPrimaryKeyValue();
        DynamicObject dyObject = FetchConfigHelper.selectDyObjByType((Long)pkid, (String)"hsbs_fetchitem");
        String code = dyObject.getString("uniquecode");
        if (SWCStringUtils.equals((String)"startitem", (String)itemKey)) {
            this.getModel().setValue("startitem", (Object)name);
            this.getModel().setValue("startitemcode", (Object)code);
            this.getModel().endInit();
            this.updateView("startitem", "startitemcode");
        }
        if (SWCStringUtils.equals((String)"enditem", (String)itemKey)) {
            this.getModel().setValue("enditem", (Object)name);
            this.getModel().setValue("enditemcode", (Object)code);
            this.getModel().endInit();
            this.updateView("enditem", "enditemcode");
        }
    }

    private void setObjItemSelect(int selectIndex, Object primaryKeyValue, String entry, String entity) {
        DynamicObject fetchItem;
        String matchDataType;
        this.getModel().beginInit();
        this.getModel().setValue(entry, primaryKeyValue, selectIndex);
        this.getModel().setValue(FIELD_MATCHCALITEM, (Object)((DynamicObject)this.getModel().getValue(entry)).getString("name"), selectIndex);
        DynamicObject obj = FetchConfigHelper.selectDyObjByType((Long)((Long)primaryKeyValue), (String)entity);
        String dataType = obj.getString("datatype.storagetype");
        String dateTypeShow = this.assembleDataTypeShow(dataType);
        this.getModel().setValue(ITEMDATATYPE, (Object)dateTypeShow, selectIndex);
        if (!SWCStringUtils.equals((String)DATA_TYPE_NUM, (String)dataType) && !SWCStringUtils.equals((String)DATA_TYPE_AMOUNT, (String)dataType)) {
            this.getView().setEnable(Boolean.FALSE, selectIndex, new String[]{HANDLESTRATEGY});
            this.getModel().setValue(HANDLESTRATEGY, null, selectIndex);
            this.getModel().setValue(FIELD_STRATEGY, null, selectIndex);
        } else {
            this.getView().setEnable(Boolean.TRUE, selectIndex, new String[]{HANDLESTRATEGY});
        }
        DynamicObject matchFetchItem = (DynamicObject)this.getModel().getValue(MATCH_FETCH_ITEM, selectIndex);
        if (null != matchFetchItem && !SWCStringUtils.equals((String)dataType, (String)(matchDataType = (fetchItem = FetchConfigHelper.selectDyObjByType((Long)matchFetchItem.getLong("id"), (String)"hsbs_fetchitem")).getString("datatype.storagetype")))) {
            this.cleanOtherData(selectIndex, MATCH_FETCH_ITEM);
        }
        this.getModel().endInit();
        this.checkEmptyEntry();
        this.getView().updateView();
    }

    private void checkEmptyEntry() {
        DynamicObjectCollection fieldEntry = this.getModel().getEntryEntity("calitemmatchentry");
        for (int i = 0; i < fieldEntry.size(); ++i) {
            DynamicObject obj = (DynamicObject)fieldEntry.get(i);
            String itemName = obj.getString(FIELD_MATCHCALITEM);
            if (!SWCStringUtils.isEmpty((String)itemName)) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{MATCH_FETCH_ITEM, HANDLESTRATEGY});
        }
    }

    private String assembleDataTypeShow(String dataType) {
        String type;
        switch (dataType) {
            case "amount": 
            case "num": {
                type = CalDataTypeEnum.BIGDECIMAL.getCode();
                break;
            }
            case "date": {
                type = CalDataTypeEnum.DATE.getCode();
                break;
            }
            case "text": {
                type = CalDataTypeEnum.STRING.getCode();
                break;
            }
            default: {
                type = CalDataTypeEnum.STRING.getCode();
            }
        }
        return type;
    }

    private void updateView(String ... fields) {
        for (String field : fields) {
            this.getView().updateView(field);
        }
    }

    private void openAreaTypeChangeConfirm(String oldValue) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CHANGE_AREA_TYPE, (IFormPlugin)this);
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u66f4\u6539\u56fd\u5bb6/\u5730\u533a\u7c7b\u578b\uff0c\u5173\u8054\u4fe1\u606f\u5185\u5bb9\u5c06\u88ab\u6e05\u7a7a\uff0c\u786e\u8ba4\u66f4\u6539\uff1f", (String)"CalResultFetchConfigEdit_2", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, null, options, ConfirmTypes.Default, confirmCallBacks, null, oldValue);
    }

    private void checkEntryDataType() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("calitemmatchentry");
        DynamicObject[] dataEntitys = entryGrid.getEntryData().getDataEntitys();
        this.getModel().beginInit();
        for (int i = 0; i < dataEntitys.length; ++i) {
            if (!SWCStringUtils.equals((String)CalDataTypeEnum.DATE.getCode(), (String)dataEntitys[i].getString(ITEMDATATYPE)) && !SWCStringUtils.equals((String)CalDataTypeEnum.STRING.getCode(), (String)dataEntitys[i].getString(ITEMDATATYPE))) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{HANDLESTRATEGY});
        }
        this.getModel().endInit();
        this.getView().updateView("calitemmatchentry");
    }

    private void checkEnable() {
        String enable = (String)this.getModel().getValue("enable");
        if (SWCStringUtils.equals((String)TYPE_AREA_CHANGE, (String)enable) || SWCStringUtils.equals((String)"0", (String)enable)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
        }
        if (SWCStringUtils.equals((String)TYPE_AREA_CHANGE, (String)enable) || SWCStringUtils.equals((String)"0", (String)enable)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"areatype", "country"});
        }
    }

    private void setFieldEntryData() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("calitemmatchentry");
        this.getModel().beginInit();
        for (int index = 0; index < entryEntity.size(); ++index) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(index);
            String dataType = dynamicObject.getString(HANDLESTRATEGY);
            String dataTypeName = ResultFetchStrategyEnum.getDesc((String)dataType);
            this.getModel().setValue(FIELD_STRATEGY, (Object)dataTypeName, index);
        }
        this.getModel().endInit();
    }

    private void cleanConfigData(MessageBoxResult result, String customVaule, String type) {
        if (MessageBoxResult.Yes.equals((Object)result)) {
            this.getModel().deleteEntryData("calitemmatchentry");
            this.cleanFieldData(FIELD_CALSCENE, "startitem", "startitemcode", "enditem", "enditemcode");
            this.checkAreaType();
        } else {
            this.getModel().beginInit();
            if (SWCStringUtils.equals((String)TYPE_AREA_CHANGE, (String)type)) {
                this.getModel().setValue("areatype", (Object)customVaule);
            }
            if (SWCStringUtils.equals((String)TYPE_COUNTRY_CHANGE, (String)type)) {
                this.getModel().setValue("country", (Object)Long.valueOf(customVaule));
            }
            this.getModel().endInit();
            this.getView().updateView();
        }
    }

    private void checkAreaType() {
        String areaType = (String)this.getModel().getValue("areatype");
        FieldEdit contryField = (FieldEdit)this.getControl("country");
        if (TYPE_COUNTRY_CHANGE.equals(areaType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"country"});
            contryField.setMustInput(true);
        } else {
            DynamicObject country = (DynamicObject)this.getModel().getValue("country");
            if (country != null) {
                this.getModel().beginInit();
                this.getModel().setValue("country", null);
                this.getModel().endInit();
                this.getView().updateView();
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"country"});
            contryField.setMustInput(false);
        }
    }

    private void openCountryChangeConfirm(String oldValue) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CHANGE_COUNTRY, (IFormPlugin)this);
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u66f4\u6539\u56fd\u5bb6/\u5730\u533a,\u5173\u8054\u4fe1\u606f\u5185\u5bb9\u5c06\u88ab\u6e05\u7a7a,\u786e\u8ba4\u66f4\u6539\uff1f", (String)"CalResultFetchConfigEdit_3", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, null, options, ConfirmTypes.Default, confirmCallBacks, null, oldValue);
    }
}

