/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.basedata.fetchconfig;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.enums.ConditionFieldTypeEnum;
import kd.swc.hsbp.common.enums.ConditionValueTypeEnum;
import kd.swc.hsbp.common.enums.PersonParamsEnum;
import kd.swc.hsbp.common.enums.ResultFetchStrategyEnum;
import kd.swc.hsbp.common.enums.RuleOperatorEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class ComboValueInputEdit
extends AbstractFormPlugin {
    private static final String BTN_OK = "btnok";
    private Map<String, String> comboItemMap = new HashMap<String, String>(0);
    private static final String CACHE_KEY_COMBOITEMMAP = "cache_key_comboitemmap";

    public void afterCreateNewData(EventObject eventObject) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String from = (String)formShowParameter.getCustomParam("from");
        if (SWCStringUtils.equals((String)from, (String)"resultFetchConfig")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"textfield", "datefield", "bigintfield", "mulcombofield"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"combofield"});
            String dataType = (String)formShowParameter.getCustomParam("dataType");
            String handlestrategy = (String)formShowParameter.getCustomParam("value");
            ComboEdit comboEdit = (ComboEdit)this.getControl("combofield");
            List<ComboItem> comboData = this.getDataStrategyComboData(dataType);
            comboEdit.setComboItems(comboData);
            String value = SWCStringUtils.isNotEmpty((String)handlestrategy) ? handlestrategy : (SWCStringUtils.equals((String)ConditionFieldTypeEnum.TYPE_NUM.getCode(), (String)dataType) ? "0" : "1");
            this.getModel().setValue("combofield", (Object)value);
            this.getView().updateView("combofield");
            return;
        }
        String fieldType = (String)formShowParameter.getCustomParam("fieldType");
        String field = (String)formShowParameter.getCustomParam("field");
        String compareType = (String)formShowParameter.getCustomParam("compareType");
        String fetchSource = (String)formShowParameter.getCustomParam("fetchSource");
        String fieldCode = (String)formShowParameter.getCustomParam("fieldCode");
        String calingFetch = (String)formShowParameter.getCustomParam("calingFetch");
        String dimensionality = (String)formShowParameter.getCustomParam("dimensionality");
        String compareValue = (String)formShowParameter.getCustomParam("compareValue");
        String compareValueType = (String)formShowParameter.getCustomParam("compareValueType");
        ComboEdit comboEdit = (ComboEdit)this.getControl("combofield");
        MulComboEdit mulComboEdit = (MulComboEdit)this.getControl("mulcombofield");
        List<Object> comboData = new ArrayList(10);
        this.showFieldByFieldType(field, fieldType, compareValue, compareType);
        String value = "";
        if (SWCStringUtils.equals((String)field, (String)"comparetype")) {
            comboData = this.getCompareTypeComboData(fieldType);
            value = compareType;
        } else if (SWCStringUtils.equals((String)field, (String)"comparevaluetype")) {
            comboData = this.getCompareValueTypeComboData(fieldType, compareType, calingFetch, dimensionality);
            value = compareValueType;
        } else if (SWCStringUtils.equals((String)field, (String)"person")) {
            comboData = this.getPersonTaskParamsComboData(ConditionValueTypeEnum.TYPE_PERSON.getCode());
            value = compareValue;
        } else if (SWCStringUtils.equals((String)field, (String)"task")) {
            comboData = this.getPersonTaskParamsComboData(ConditionValueTypeEnum.TYPE_TASK.getCode());
            value = compareValue;
        } else if (SWCStringUtils.equals((String)field, (String)"comparevaluetext") && SWCStringUtils.equals((String)fieldType, (String)ConditionFieldTypeEnum.TYPE_ENUM.getCode())) {
            comboData = this.getEnumComboData(fetchSource, fieldCode);
            value = compareValue;
        }
        List<String> multiCompareTypeList = Arrays.asList("in", "not_in");
        if (multiCompareTypeList.contains(compareType) && SWCStringUtils.equals((String)field, (String)"comparevaluetext")) {
            mulComboEdit.setComboItems(comboData);
            value = compareValue.replaceAll(";", ",");
            this.getModel().setValue("mulcombofield", (Object)value);
            this.getView().updateView("mulcombofield");
        } else {
            comboEdit.setComboItems(comboData);
            this.getModel().setValue("combofield", (Object)value);
            this.getView().updateView("combofield");
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String clkKey = control.getKey();
        HashMap<String, String> returnData = new HashMap<String, String>(16);
        if (!BTN_OK.equals(clkKey)) {
            return;
        }
        List<String> multiCompareTypeList = Arrays.asList("in", "not_in");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String from = (String)formShowParameter.getCustomParam("from");
        if (SWCStringUtils.equals((String)from, (String)"resultFetchConfig")) {
            String strategy = (String)this.getModel().getValue("combofield");
            returnData.put("value", strategy);
            returnData.put("name", strategy);
            this.getView().setReturnData(returnData);
            this.getView().close();
            return;
        }
        String fieldType = (String)formShowParameter.getCustomParam("fieldType");
        String field = (String)formShowParameter.getCustomParam("field");
        String compareType = (String)formShowParameter.getCustomParam("compareType");
        Map<String, String> dataMap = this.getCacheComboItemMap();
        String value = this.getValue(field, fieldType, compareType, multiCompareTypeList);
        value = value.replaceAll(",", ";");
        returnData.put("clickStatus", "ok");
        returnData.put("value", value);
        returnData.put("dataType", fieldType);
        if (dataMap != null && !SWCStringUtils.isEmpty((String)value)) {
            String displayName;
            if (multiCompareTypeList.contains(compareType)) {
                String[] split = value.split(";");
                StringBuilder sb = new StringBuilder();
                for (String single : split) {
                    if (sb.length() > 0) {
                        sb.append(';');
                    }
                    sb.append(dataMap.get(single));
                }
                displayName = sb.toString();
            } else {
                displayName = dataMap.get(value);
            }
            returnData.put("name", displayName);
        } else {
            returnData.put("name", "");
        }
        this.getView().setReturnData(returnData);
        this.getView().close();
    }

    public void beforeClosed(BeforeClosedEvent event) {
        Object returnData = this.getView().getReturnData();
        if (returnData != null) {
            this.getView().returnDataToParent(returnData);
        }
    }

    private List<ComboItem> getEnumComboData(String fetchSource, String fieldCode) {
        this.comboItemMap = new HashMap<String, String>(16);
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(10);
        EntityType entityType = this.getDataEntityType(fetchSource, fieldCode);
        if (entityType == null) {
            return list;
        }
        DynamicProperty property = entityType.getProperty(fieldCode.substring(fieldCode.lastIndexOf(46) + 1));
        if (property instanceof BooleanProp) {
            String falseStr = ResManager.loadKDString((String)"\u5426", (String)"ComboValueInputEdit_0", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
            String trueStr = ResManager.loadKDString((String)"\u662f", (String)"ComboValueInputEdit_1", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
            list.add(new ComboItem(new LocaleString(falseStr), "0"));
            list.add(new ComboItem(new LocaleString(trueStr), "1"));
            this.comboItemMap.put("0", falseStr);
            this.comboItemMap.put("1", trueStr);
        } else if (property instanceof ComboProp) {
            ComboProp fieldValueCombo = (ComboProp)property;
            List comboItems = fieldValueCombo.getComboItems();
            if (SWCListUtils.isEmpty((List)comboItems)) {
                return list;
            }
            for (ValueMapItem item : comboItems) {
                String value = item.getValue();
                LocaleString name = item.getName();
                list.add(new ComboItem(name, value));
                this.comboItemMap.put(value, name.getLocaleValue());
            }
        }
        this.cacheComboItemMap();
        return list;
    }

    private EntityType getDataEntityType(String fetchSource, String fieldCode) {
        String[] split = fieldCode.split("\\.");
        if (split.length == 0) {
            return null;
        }
        if (split.length == 1) {
            return EntityMetadataCache.getDataEntityType((String)fetchSource);
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)fetchSource);
        fieldCode = fieldCode.substring(fieldCode.indexOf(46) + 1);
        DynamicProperty prop = dataEntityType.getProperty(split[0]);
        if (prop instanceof EntryProp) {
            EntryType entryType = (EntryType)dataEntityType.getAllEntities().get(split[0]);
            if (split.length == 2) {
                return entryType;
            }
            prop = entryType.getProperty(split[1]);
            if (prop instanceof BasedataProp) {
                return this.getDataEntityType(((BasedataProp)prop).getBaseEntityId(), fieldCode.substring(fieldCode.indexOf(46) + 1));
            }
            return null;
        }
        if (prop instanceof BasedataProp) {
            return this.getDataEntityType(((BasedataProp)prop).getBaseEntityId(), fieldCode.substring(fieldCode.indexOf(46) + 1));
        }
        return null;
    }

    private void cacheComboItemMap() {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        pageCache.put(CACHE_KEY_COMBOITEMMAP, this.comboItemMap);
    }

    private Map<String, String> getCacheComboItemMap() {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        Map dataMap = (Map)pageCache.get(CACHE_KEY_COMBOITEMMAP, Map.class);
        return dataMap;
    }

    private List<ComboItem> getCompareValueTypeComboData(String fieldType, String compareType, String calingFetch, String dimensionality) {
        List tempList;
        this.comboItemMap = new HashMap<String, String>(16);
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(10);
        List valueTypeList1 = ConditionFieldTypeEnum.getValueTypeByCondition((String)compareType, (String)calingFetch, (String)dimensionality);
        List valueTypeList2 = ConditionFieldTypeEnum.getValueTypeByFieldType((String)fieldType, (String)calingFetch, (String)dimensionality);
        if (!(SWCListUtils.isEmpty((List)valueTypeList1) || SWCListUtils.isEmpty((List)valueTypeList2) || SWCListUtils.isEmpty(tempList = valueTypeList1.stream().filter(single -> valueTypeList2.contains(single)).collect(Collectors.toList())))) {
            for (ConditionValueTypeEnum operatorEnum : tempList) {
                String code = operatorEnum.getCode();
                String desc = operatorEnum.getDesc();
                list.add(new ComboItem(new LocaleString(desc), code));
                this.comboItemMap.put(code, desc);
            }
        }
        this.cacheComboItemMap();
        return list;
    }

    private List<ComboItem> getPersonTaskParamsComboData(String type) {
        this.comboItemMap = new HashMap<String, String>(16);
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(10);
        if (SWCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_PERSON.getCode(), (String)type)) {
            List personParams = PersonParamsEnum.getPersonParams();
            for (PersonParamsEnum personParamsEnum : personParams) {
                String desc = personParamsEnum.getDesc();
                String code = personParamsEnum.getCode();
                list.add(new ComboItem(new LocaleString(desc), code));
                this.comboItemMap.put(code, desc);
            }
        } else {
            String code = PersonParamsEnum.PARAM_TASK.getCode();
            String desc = PersonParamsEnum.PARAM_TASK.getDesc();
            list.add(new ComboItem(new LocaleString(desc), code));
            this.comboItemMap.put(code, desc);
        }
        this.cacheComboItemMap();
        return list;
    }

    private void showFieldByFieldType(String field, String fieldType, String compareValue, String compareType) {
        if (SWCStringUtils.equals((String)field, (String)"comparetype") || SWCStringUtils.equals((String)field, (String)"comparevaluetype")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"textfield", "datefield", "bigintfield", "mulcombofield"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"combofield"});
        } else {
            List<String> multiCompareTypeList = Arrays.asList("in", "not_in");
            String value = SWCStringUtils.isEmpty((String)compareValue) ? "" : compareValue;
            switch (fieldType) {
                case "BigDecimal": {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"combofield", "textfield", "datefield", "mulcombofield"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"bigintfield"});
                    this.getModel().setValue("bigintfield", (Object)value);
                    break;
                }
                case "Date": {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"combofield", "textfield", "bigintfield", "mulcombofield"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"datefield"});
                    this.getModel().setValue("datefield", (Object)value);
                    break;
                }
                case "String": {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"combofield", "datefield", "bigintfield", "mulcombofield"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"textfield"});
                    this.getModel().setValue("textfield", (Object)value);
                    break;
                }
                default: {
                    if (multiCompareTypeList.contains(compareType)) {
                        this.getView().setVisible(Boolean.FALSE, new String[]{"textfield", "datefield", "bigintfield", "combofield"});
                        this.getView().setVisible(Boolean.TRUE, new String[]{"mulcombofield"});
                        break;
                    }
                    this.getView().setVisible(Boolean.FALSE, new String[]{"textfield", "datefield", "bigintfield", "mulcombofield"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"combofield"});
                }
            }
        }
    }

    private String getValue(String field, String fieldType, String compareType, List<String> multiCompareTypeList) {
        String value = "";
        Object combofield = this.getModel().getValue("combofield");
        BigDecimal bigintfield = this.getModel().getDataEntity().getBigDecimal("bigintfield");
        if (SWCStringUtils.equals((String)field, (String)"comparetype") || SWCStringUtils.equals((String)field, (String)"comparevaluetype")) {
            if (combofield != null) {
                value = (String)combofield;
            }
        } else {
            switch (fieldType) {
                case "BigDecimal": {
                    if (bigintfield == null) break;
                    value = bigintfield.stripTrailingZeros().toPlainString();
                    break;
                }
                case "Date": {
                    Date dateValue = this.getModel().getDataEntity().getDate("datefield");
                    if (dateValue == null) break;
                    value = SWCDateTimeUtils.format((Date)dateValue, (String)"yyyy-MM-dd");
                    break;
                }
                case "String": {
                    Object textfield = this.getModel().getValue("textfield");
                    if (textfield == null) break;
                    value = (String)textfield;
                    break;
                }
                default: {
                    if (multiCompareTypeList.contains(compareType)) {
                        Object mulcombofield = this.getModel().getValue("mulcombofield");
                        if (mulcombofield == null) break;
                        String mulValue = (String)mulcombofield;
                        value = mulValue.substring(1, mulValue.length() - 1);
                        break;
                    }
                    if (combofield == null) break;
                    value = (String)combofield;
                }
            }
        }
        return value;
    }

    private List<ComboItem> getCompareTypeComboData(String fieldType) {
        this.comboItemMap = new HashMap<String, String>(16);
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(10);
        List judgeConditionByType = ConditionFieldTypeEnum.getJudgeConditionByType((String)fieldType);
        if (!SWCListUtils.isEmpty((List)judgeConditionByType)) {
            for (RuleOperatorEnum operatorEnum : judgeConditionByType) {
                String name = operatorEnum.getName();
                String value = operatorEnum.getValue();
                list.add(new ComboItem(new LocaleString(name), value));
                this.comboItemMap.put(value, name);
            }
        }
        this.cacheComboItemMap();
        return list;
    }

    private List<ComboItem> getDataStrategyComboData(String dataType) {
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(3);
        List strategyLilst = ResultFetchStrategyEnum.getByDataType((String)dataType);
        if (!SWCListUtils.isEmpty((List)strategyLilst)) {
            for (ResultFetchStrategyEnum strategyEnum : strategyLilst) {
                String name = strategyEnum.getDesc();
                String value = strategyEnum.getCode();
                list.add(new ComboItem(new LocaleString(name), value));
            }
        }
        return list;
    }
}

