/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.basedata.fetchconfig;

import com.alibaba.fastjson.JSON;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.business.area.AreaHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.CalDataTypeEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCInteDateTimeUtil;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.FetchItemCheckResultVo;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;
import kd.swc.hsbs.business.basedata.fetchconfig.FetchConfigHelper;

public class CustFetchConfigEdit
extends SWCDataBaseEdit
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(CustFetchConfigEdit.class);
    private static final char LEFT_MID_BRACKET = '\u3010';
    private static final char RIGHT_MID_BRACKET = '\u3011';
    private static final String VALUETYPE_FIXED = "1";
    private static final String ADD_OUT_ENTRY = "addoutentry";
    private static final String DELETE_OUT_ENTRY = "deleteoutentry";
    private static final String ADD_INPUT_ENTRY = "addinputentry";
    private static final String DELETE_INPUT_ENTRY = "deleteinputentry";
    private static final String CHANGE_AREA_TYPE = "changeAreaType";
    private static final String CHANGE_COUNTRY = "changeCountry";
    private static final String CHANGE_DIMENSIONALITY = "dimensionality";
    private static final String CHANGE_FETCH_TYPE = "changeFetchType";
    private static final String CHECKFETCHITEMQUOTE = "checkFetchItemQuote";
    private static final String FETCHITEMQUOTEDISABLE = "checkFetchItemQuoteDisable";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject args) {
        super.registerListener(args);
        this.addClickListeners(new String[]{"inputparamitem", "srcfieldnum", "inputparamitemtype"});
        BasedataEdit fetchItem = (BasedataEdit)this.getView().getControl("fetchitem");
        fetchItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterLoadData(EventObject args) {
        super.afterLoadData(args);
        IDataModel dataModel = this.getModel();
        long id = this.getModel().getDataEntity().getLong("id");
        SWCDataServiceHelper fetchConfigItemHelper = new SWCDataServiceHelper("hsbs_fetchconfigitem");
        DynamicObject[] DynamicObjects = fetchConfigItemHelper.query("id,fetchfieldentry,custfetchconfig,fetchitem,enable", new QFilter[]{new QFilter("custfetchconfig", "in", (Object)id)});
        HashMap<Long, DynamicObject> calRuleItemEntryMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject dynamicObject : DynamicObjects) {
            long fetchfieldentry = dynamicObject.getLong("fetchfieldentry");
            if (fetchfieldentry == 0L) continue;
            calRuleItemEntryMap.put(fetchfieldentry, dynamicObject);
        }
        DynamicObjectCollection calRuleItemEntryColl = dataModel.getEntryEntity("fetchfieldentry");
        for (DynamicObject dynamicObject : calRuleItemEntryColl) {
            long entryId = dynamicObject.getLong("id");
            DynamicObject dynamicObj = (DynamicObject)calRuleItemEntryMap.get(entryId);
            if (null == dynamicObj) continue;
            dynamicObject.set("fetchitem", (Object)dynamicObj.getDynamicObject("fetchitem"));
        }
        DynamicObjectCollection dynamicObjectCollection = dataModel.getEntryEntity("inputfieldentry");
        try {
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                String fieldType = dynamicObject.getString("inputparamitemtype");
                if (SWCStringUtils.equals((String)fieldType, (String)VALUETYPE_FIXED)) {
                    String dataType = dynamicObject.getString("inputparamdatatype");
                    String inputValue = dynamicObject.getString("inputparamfixedvalue");
                    if (SWCStringUtils.equals((String)CalDataTypeEnum.DATE.getCode(), (String)dataType) && SWCStringUtils.isNotEmpty((String)inputValue)) {
                        inputValue = SWCInteDateTimeUtil.formateDate((Date)SWCDateTimeUtils.parseDate((String)inputValue, (String)"yyyy-MM-dd"));
                        dynamicObject.set("inputparamitem", (Object)inputValue);
                        continue;
                    }
                    dynamicObject.set("inputparamitem", (Object)inputValue);
                    continue;
                }
                dynamicObject.set("inputparamitem", (Object)dynamicObject.getString("inputparamfetchitem.name"));
            }
        }
        catch (ParseException exception) {
            logger.error("date parse error", (Throwable)exception);
        }
        this.getModel().setDataChanged(false);
        this.getModel().updateEntryCache(calRuleItemEntryColl);
        this.getView().updateView("fetchfieldentry");
    }

    public void afterBindData(EventObject args) {
        this.showInitPage();
        String enable = (String)this.getModel().getValue("enable");
        boolean areaTypeStatus = SWCStringUtils.equals((String)enable, (String)"10");
        if (areaTypeStatus) {
            this.getView().setEnable(Boolean.valueOf(areaTypeStatus), new String[]{"number", "areatype"});
        } else {
            this.getView().setEnable(Boolean.valueOf(areaTypeStatus), new String[]{"number", "areatype", "country"});
        }
        this.getModel().setDataChanged(false);
    }

    public void beforeBindData(EventObject args) {
        super.beforeBindData(args);
        boolean isSysPreSet = this.getModel().getDataEntity().getBoolean("issyspreset");
        FormShowParameter form = this.getView().getFormShowParameter();
        if (isSysPreSet) {
            form.setStatus(OperationStatus.VIEW);
        }
        this.setFetchFieldAuth();
    }

    private void showInitPage() {
        this.showInputParamHide();
        this.checkAreaType();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String opKey = operate.getOperateKey();
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (opKey) {
            case "addoutentry": {
                this.setQueryFields("fetchfieldentry");
                this.setFetchFieldAuth();
                break;
            }
            case "addinputentry": {
                this.setQueryFields("inputfieldentry");
                this.flushInputEntity();
                break;
            }
            case "deleteoutentry": {
                this.validateDeleteEntry("fetchfieldentry", opKey);
                args.setCancel(false);
                break;
            }
            case "deleteinputentry": {
                this.validateDeleteEntry("inputfieldentry", opKey);
                args.setCancel(false);
                break;
            }
            case "save": {
                if (operate.getOption().tryGetVariableValue("save", new RefObject())) break;
                args.setCancel(this.checkFetchItemConfig("save"));
                break;
            }
            case "delete": {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("hsbs_fetchconfigitem").append(',').append("hsbs_custfetchinentry");
                operate.getOption().setVariableValue("ignorerefentityids", stringBuilder.toString());
                break;
            }
            case "enable": {
                boolean checkFlag;
                boolean dataChanged = this.getModel().getDataChanged();
                if (dataChanged) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"CalResultFetchConfigEdit_13", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
                if (!(checkFlag = this.checkFetchItemConfig("enable"))) break;
                args.setCancel(true);
                break;
            }
            case "disable": {
                if (operate.getOption().tryGetVariableValue("disable", new RefObject())) break;
                args.setCancel(this.checkFetchItemConfigList());
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String enable = this.getModel().getDataEntity().getString("enable");
        boolean enableStatus = SWCStringUtils.equals((String)enable, (String)VALUETYPE_FIXED) || SWCStringUtils.equals((String)enable, (String)"0");
        this.getView().setEnable(Boolean.valueOf(!enableStatus), new String[]{"number", "areatype", "country"});
        this.checkAreaType();
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        if (SWCStringUtils.equals((String)key, (String)"inputparamitem")) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("inputfieldentry");
            int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
            this.openFilterValueSelectF7(selectedRows[0]);
        } else if (SWCStringUtils.equals((String)key, (String)"srcfieldnum")) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("fetchfieldentry");
            int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
            PageCache pageCache = new PageCache(this.getView().getPageId());
            pageCache.put("opRowNum", String.valueOf(selectedRows[0]));
            this.showFieldsList(selectedRows[0]);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey = args.getProperty().getName();
        ChangeData data = args.getChangeSet()[0];
        int index = data.getRowIndex();
        DynamicObjectCollection collection = this.getModel().getEntryEntity("fetchfieldentry");
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("inputfieldentry");
        String msg = "";
        switch (fieldKey) {
            case "areatype": {
                String oldAreaType = (String)args.getChangeSet()[0].getOldValue();
                if (oldAreaType == null || this.checkEntityData()) {
                    this.changeAreaTypeData();
                    return;
                }
                msg = ResManager.loadKDString((String)"\u66f4\u6539\u56fd\u5bb6/\u5730\u533a\u7c7b\u578b\uff0c\u5173\u8054\u4fe1\u606f\u5185\u5bb9\u5c06\u88ab\u6e05\u7a7a\uff0c\u786e\u8ba4\u66f4\u6539\uff1f", (String)"CustFetchConfigEdit_0", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
                this.openChangeConfirm(oldAreaType, CHANGE_AREA_TYPE, msg);
                break;
            }
            case "country": {
                DynamicObject oldCountry = (DynamicObject)args.getChangeSet()[0].getOldValue();
                DynamicObject newValue = (DynamicObject)args.getChangeSet()[0].getNewValue();
                if (ObjectUtils.isEmpty((Object)oldCountry) || ObjectUtils.nullSafeEquals((Object)newValue, (Object)oldCountry) || this.checkEntityData()) {
                    return;
                }
                msg = ResManager.loadKDString((String)"\u66f4\u6539\u56fd\u5bb6/\u5730\u533a,\u5173\u8054\u4fe1\u606f\u5185\u5bb9\u5c06\u88ab\u6e05\u7a7a,\u786e\u8ba4\u66f4\u6539\uff1f", (String)"CustFetchConfigEdit_6", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
                this.openChangeConfirm(oldCountry.getString("id"), CHANGE_COUNTRY, msg);
                break;
            }
            case "dimensionality": {
                Object oldDimensionality = args.getChangeSet()[0].getOldValue();
                if (ObjectUtils.isEmpty((Object)oldDimensionality) || this.isEntityEmpty()) {
                    return;
                }
                msg = ResManager.loadKDString((String)"\u66f4\u6539\u53d6\u6570\u7ef4\u5ea6\uff0c\u5173\u8054\u4fe1\u606f\u5185\u5bb9\u5c06\u88ab\u6e05\u7a7a\uff0c\u786e\u8ba4\u66f4\u6539\uff1f", (String)"CustFetchConfigEdit_7", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
                this.openChangeConfirm((String)args.getChangeSet()[0].getOldValue(), CHANGE_DIMENSIONALITY, msg);
                break;
            }
            case "inputparamdatatype": 
            case "inputparamitemtype": {
                this.getModel().beginInit();
                this.getModel().setValue("inputparamitem", null, entryCurrentRowIndex);
                this.getModel().setValue("inputparamfetchitem", null, entryCurrentRowIndex);
                this.getModel().setValue("inputparamfixedvalue", null, entryCurrentRowIndex);
                this.getModel().endInit();
                this.getView().updateView("inputparamitem", entryCurrentRowIndex);
                this.flushInputEntity();
                break;
            }
            case "fetchitem": {
                this.setFetchItemDataStatus(args, "fetchitem");
                break;
            }
            case "srctype": 
            case "srcentity": 
            case "srcenum": {
                this.initSrcInfo(collection, index);
                this.setSrcEditAuth(collection, index);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        switch (callBackId) {
            case "changeAreaType": {
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    this.changeAreaTypeData();
                    break;
                }
                this.getModel().beginInit();
                String oldSelectTypeValue = messageBoxClosedEvent.getCustomVaule();
                this.getModel().setValue("areatype", (Object)oldSelectTypeValue);
                this.getModel().endInit();
                this.getView().updateView("areatype");
                break;
            }
            case "changeCountry": {
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    this.clearFetchField();
                    break;
                }
                this.getModel().beginInit();
                String oldSelectTypeValue = messageBoxClosedEvent.getCustomVaule();
                this.getModel().setValue("country", (Object)oldSelectTypeValue);
                this.getModel().endInit();
                this.getView().updateView("country");
                break;
            }
            case "dimensionality": {
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    this.setChangeDimensionality();
                    break;
                }
                this.getModel().beginInit();
                String oldSelectTypeValue = messageBoxClosedEvent.getCustomVaule();
                this.getModel().setValue(CHANGE_DIMENSIONALITY, (Object)oldSelectTypeValue);
                this.getModel().endInit();
                this.getView().updateView(CHANGE_DIMENSIONALITY);
                break;
            }
            case "deleteoutentry": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                this.deleteEntry("fetchfieldentry");
                this.setFetchFieldAuth();
                break;
            }
            case "deleteinputentry": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                this.deleteEntry("inputfieldentry");
                break;
            }
            case "fetch_too_many_notify": 
            case "checkFetchItemQuote": {
                if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("save", "false");
                this.getView().invokeOperation("save", operateOption);
                break;
            }
            case "checkFetchItemQuoteDisable": {
                if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("disable", "false");
                this.getView().invokeOperation("disable", operateOption);
                break;
            }
        }
    }

    private void showInputParamHide() {
        ArrayList<ComboItem> data = new ArrayList<ComboItem>();
        data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u56fa\u5b9a\u503c", (String)"FetchConfigEdit_17", (String)"swc-hsbs-formplugin", (Object[])new Object[0])), VALUETYPE_FIXED));
        data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u53d6\u6570\u9879\u76ee", (String)"FetchConfigEdit_18", (String)"swc-hsbs-formplugin", (Object[])new Object[0])), "2"));
        ComboEdit comboEdit = (ComboEdit)this.getControl("inputparamitemtype");
        comboEdit.setComboItems(data);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (ObjectUtils.isEmpty((Object)returnData)) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("inputfieldentry");
        int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
        switch (actionId) {
            case "fetchitem": {
                ListSelectedRowCollection selected = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                int entryIndex = this.getModel().getEntryCurrentRowIndex("fetchfieldentry");
                Long fetchitem = (Long)selected.get(0).getPrimaryKeyValue();
                List cacheList = (List)JSON.parseObject((String)this.getPageCache().get(this.getView().getPageId()), List.class);
                if (!CollectionUtils.isEmpty((Collection)cacheList)) {
                    cacheList.remove(fetchitem);
                }
                this.getModel().beginInit();
                this.getModel().setValue("fetchitem", (Object)fetchitem, entryIndex);
                this.getModel().endInit();
                this.getView().updateView("fetchfieldentry", entryIndex);
                this.setFetchFieldAuth();
                break;
            }
            case "hsbs_fetchitem": {
                ListSelectedRowCollection fetchItem = (ListSelectedRowCollection)returnData;
                if (CollectionUtils.isEmpty((Collection)fetchItem)) {
                    return;
                }
                this.getModel().beginInit();
                this.getModel().setValue("inputparamfetchitem", fetchItem.get(0).getPrimaryKeyValue(), selectedRows[0]);
                this.getModel().setValue("inputparamitem", (Object)((DynamicObject)this.getModel().getValue("inputparamfetchitem")).getString("name"), selectedRows[0]);
                this.getModel().endInit();
                this.getView().updateView("inputparamitem", selectedRows[0]);
                break;
            }
            case "hsbs_fixedvalueinput": {
                Map paramMap = (Map)returnData;
                if (returnData == null || !SWCStringUtils.equals((String)((String)paramMap.get("clickStatus")), (String)"ok")) {
                    return;
                }
                String value = (String)paramMap.get("fixedvalue");
                String dataType = (String)paramMap.get("dataType");
                String valueView = "";
                if (SWCStringUtils.equals((String)CalDataTypeEnum.DATE.getCode(), (String)dataType)) {
                    try {
                        valueView = SWCInteDateTimeUtil.formateDate((Date)SWCDateTimeUtils.parseDate((String)value, (String)"yyyy-MM-dd"));
                    }
                    catch (ParseException exception) {
                        logger.error("date parse error", (Throwable)exception);
                    }
                } else {
                    valueView = value;
                }
                this.getModel().beginInit();
                this.getModel().setValue("inputparamfixedvalue", (Object)value, selectedRows[0]);
                this.getModel().setValue("inputparamitem", (Object)valueView, selectedRows[0]);
                this.getModel().endInit();
                this.getView().updateView("inputparamitem", selectedRows[0]);
                break;
            }
            case "hsbs_itemsrcfield": {
                Map fieldMap = (Map)returnData;
                if (ObjectUtils.isEmpty((Object)fieldMap)) {
                    return;
                }
                String clickStatus = (String)fieldMap.get("clickStatus");
                if (!SWCStringUtils.equals((String)clickStatus, (String)"ok")) break;
                DynamicObject obj = (DynamicObject)fieldMap.get("fieldInfo");
                PageCache pageCache = new PageCache(this.getView().getPageId());
                int rowNum = Integer.parseInt(pageCache.get("opRowNum"));
                String srcFieldStr = obj.get("srcfieldname") + "(" + obj.get("srcfieldnum") + ")";
                this.getModel().setValue("srcfieldnum", (Object)srcFieldStr, rowNum);
                this.getModel().setValue("srcfield", obj.get("srcfieldnum"), rowNum);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key;
        switch (key = event.getProperty().getName()) {
            case "fetchitem": {
                this.setFetchItemsubjectVF7Filter(event);
                break;
            }
        }
    }

    private void setFetchItemsubjectVF7Filter(BeforeF7SelectEvent event) {
        if (StringUtils.equals((CharSequence)((String)this.getModel().getValue("areatype")), (CharSequence)"2") && ObjectUtils.isEmpty((Object)this.getModel().getValue("country"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u56fd\u5bb6/\u5730\u533a\u3002", (String)"CustFetchConfigEdit_8", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("fetchfieldentry");
        ArrayList<String> list = new ArrayList<String>(10);
        entryEntity.stream().forEach(param -> {
            String fetchItem = param.getString("fetchitem.number");
            if (StringUtils.isNotBlank((CharSequence)fetchItem)) {
                list.add(fetchItem);
            }
        });
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int focusRow = proxy.getEntryState("fetchfieldentry").getFocusRow();
        FormShowParameter parameter = event.getFormShowParameter();
        ListShowParameter listParameter = (ListShowParameter)parameter;
        ListFilterParameter listFilterParameter = listParameter.getListFilterParameter();
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        if (!this.setCountryFilter(filterList)) {
            return;
        }
        QFilter qFilter = this.getFilter(focusRow, list);
        List qFilters = listFilterParameter.getQFilters();
        qFilters.add(qFilter);
        qFilters.addAll(filterList);
        listParameter.setListFilterParameter(listFilterParameter);
        listParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "fetchitem"));
    }

    private QFilter getFilter(int focusRow, List<String> list) {
        QFilter filter = new QFilter("enable", "in", (Object)VALUETYPE_FIXED);
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity("fetchfieldentry", focusRow);
        if (dynamicObject == null) {
            return filter;
        }
        long id = dynamicObject.getLong("fetchitem.id");
        if (id != 0L) {
            String number = dynamicObject.getString("fetchitem.number");
            list.remove(number);
        }
        Object enable = this.getView().getModel().getValue("enable");
        long fetchConfigId = 0L;
        if (SWCObjectUtils.equals((Object)enable, (Object)VALUETYPE_FIXED)) {
            fetchConfigId = (Long)this.getView().getModel().getValue("id");
        }
        filter.and("number", "not in", list);
        List FetchItemIdList = FetchConfigHelper.getRelatedFetchItemIdByFetchConfigId((Long)fetchConfigId);
        filter.and("id", "not in", (Object)FetchItemIdList);
        return filter;
    }

    private boolean setCountryFilter(List<QFilter> filterList) {
        String areaType = (String)this.getModel().getValue("areatype");
        if (SWCStringUtils.equals((String)areaType, (String)VALUETYPE_FIXED)) {
            filterList.add(new QFilter("areatype", "=", (Object)areaType));
            return true;
        }
        DynamicObject country = (DynamicObject)this.getModel().getValue("country");
        if (country == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u56fd\u5bb6/\u5730\u533a\u3002", (String)"CustFetchConfigEdit_8", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            return false;
        }
        QFilter qFilter = AreaHelper.addAreaFilter((long)country.getLong("id"), (String)areaType);
        filterList.add(qFilter);
        return true;
    }

    private void openChangeConfirm(String oldValue, String type, String msg) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(type, (IFormPlugin)this);
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        this.getView().showConfirm(msg, null, options, ConfirmTypes.Default, confirmCallBacks, null, oldValue);
    }

    private void clearFetchField() {
        this.getModel().deleteEntryData("fetchfieldentry");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("inputfieldentry");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            String inputParamItemType = dynamicObject.getString("inputparamitemtype");
            if (!SWCStringUtils.equals((String)"2", (String)inputParamItemType)) continue;
            this.getModel().setValue("inputparamitem", null, i);
            this.getModel().setValue("inputparamfetchitem", null, i);
            this.getModel().setValue("inputparamfixedvalue", null, i);
        }
        this.getView().updateView("inputfieldentry");
    }

    private void setQueryFields(String actionId) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        int entryRowCount = this.getView().getModel().getEntryRowCount(actionId);
        model.beginInit();
        model.batchCreateNewEntryRow(actionId, 1);
        model.endInit();
        this.getView().updateView(actionId, entryRowCount);
    }

    private void openFetchItemF7Parameter(String filterDataType) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(1);
        if (!this.setCountryFilter(filterList)) {
            return;
        }
        ListShowParameter showParameter = new ListShowParameter();
        ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
        this.setF7OpenStyle(showParameter.getOpenStyle());
        showParameter.setShowTitle(false);
        showParameter.setLookUp(true);
        showParameter.setMultiSelect(false);
        showParameter.setFormId("bos_listf7");
        showParameter.setBillFormId("hsbs_fetchitem");
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setHasRight(true);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsbs_fetchitem"));
        HashSet matchTypeIdSet = SWCStringUtils.equals((String)filterDataType, (String)CalDataTypeEnum.DATE.getCode()) ? CalDataTypeEnum.DATE.getMatchTypeIdSet() : (SWCStringUtils.equals((String)filterDataType, (String)CalDataTypeEnum.BIGDECIMAL.getCode()) ? CalDataTypeEnum.BIGDECIMAL.getMatchTypeIdSet() : CalDataTypeEnum.STRING.getMatchTypeIdSet());
        List qFilters = listFilterParameter.getQFilters();
        String dimensionality = (String)this.getView().getModel().getValue(CHANGE_DIMENSIONALITY);
        List relatedFetchItemId = FetchConfigHelper.getRelatedFetchItemIdByDimensionality((String)dimensionality);
        qFilters.add(new QFilter("datatype", "in", (Object)matchTypeIdSet));
        qFilters.add(new QFilter("id", "in", (Object)relatedFetchItemId));
        qFilters.addAll(filterList);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void setF7OpenStyle(OpenStyle openStyle) {
        openStyle.setShowType(ShowType.Modal);
        StyleCss cssValue = new StyleCss();
        cssValue.setWidth("880px");
        cssValue.setHeight("600px");
        openStyle.setInlineStyleCss(cssValue);
    }

    private void checkAreaType() {
        String areaType = (String)this.getModel().getValue("areatype");
        FieldEdit contryField = (FieldEdit)this.getControl("country");
        if ("2".equals(areaType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"country"});
            contryField.setMustInput(true);
        } else {
            DynamicObject country = (DynamicObject)this.getModel().getValue("country");
            if (country != null) {
                this.getModel().beginInit();
                this.getModel().setValue("country", null);
                this.getModel().endInit();
                this.getView().updateView("country");
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"country"});
            contryField.setMustInput(false);
        }
    }

    private void validateDeleteEntry(String entityId, String calBackId) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int[] selectRows = proxy.getEntryState(entityId).getSelectedRows();
        if (selectRows.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"CustFetchConfigEdit_9", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            return;
        }
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(calBackId, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"EnumConfigEdit_1", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u7ee7\u7eed", (String)"EnumConfigEdit_2", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = MessageFormat.format(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684{0}\u6761\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\r\n\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"EnumConfigEdit_3", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), selectRows.length);
        String changeDescStr = this.getModel().getChangeDesc();
        this.getView().showConfirm(msg, changeDescStr, options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
    }

    private void deleteEntry(String entityId) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(entityId);
        int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
        this.getModel().deleteEntryRows(entityId, selectedRows);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"CustFetchConfigEdit_3", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
    }

    private void openFilterValueSelectF7(int rowIndex) {
        DynamicObjectCollection filterEntry = this.getModel().getEntryEntity("inputfieldentry");
        DynamicObject row = (DynamicObject)filterEntry.get(rowIndex);
        String fieldType = row.getString("inputparamitemtype");
        if (SWCStringUtils.isEmpty((String)fieldType)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u503c\u7c7b\u578b\uff0c\u518d\u9009\u62e9\u8fc7\u6ee4\u6761\u4ef6\u7684\u503c\u3002", (String)"CustFetchConfigEdit_10", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            return;
        }
        String filterDataType = row.getString("inputparamdatatype");
        if (SWCStringUtils.isEmpty((String)filterDataType)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6570\u636e\u7c7b\u578b\u201d\u5b57\u6bb5\uff0c\u5426\u5219\u65e0\u6cd5\u586b\u5199\u201c\u53c2\u6570\u503c\u201d\u3002", (String)"CustFetchConfigEdit_1", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            return;
        }
        if (SWCStringUtils.equals((String)fieldType, (String)VALUETYPE_FIXED)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("hsbs_fixedvalueinput");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam("filterDataType", (Object)filterDataType);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "hsbs_fixedvalueinput");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(showParameter);
        } else {
            this.openFetchItemF7Parameter(filterDataType);
        }
    }

    private List<QFilter> openFetchFieldItemF7() {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(3);
        qFilters.add(new QFilter("enable", "=", (Object)VALUETYPE_FIXED));
        String areaType = (String)this.getModel().getValue("areatype");
        DynamicObject countryObj = (DynamicObject)this.getModel().getValue("country");
        if (StringUtils.equals((CharSequence)areaType, (CharSequence)VALUETYPE_FIXED)) {
            qFilters.add(new QFilter("areatype", "=", (Object)VALUETYPE_FIXED));
        }
        if (StringUtils.equals((CharSequence)areaType, (CharSequence)"2")) {
            if (StringUtils.isNotBlank((Object)countryObj)) {
                qFilters.add(new QFilter("country", "=", countryObj.get("id")));
            }
            qFilters.add(new QFilter("areatype", "=", (Object)"2"));
        }
        return qFilters;
    }

    private void showFieldsList(int index) {
        DynamicObjectCollection collection = this.getModel().getEntryEntity("fetchfieldentry");
        DynamicObject dyObj = (DynamicObject)collection.get(index);
        List<Map<String, String>> srcFieldsList = this.getSrcFields(dyObj, true);
        if (ObjectUtils.isEmpty(srcFieldsList)) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("srcfieldslist", srcFieldsList);
        showParameter.setFormId("hsbs_itemsrcfield");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsbs_itemsrcfield"));
        this.getView().showForm(showParameter);
    }

    private List<Map<String, String>> getSrcFields(DynamicObject dynamicObject, boolean isInit) {
        ArrayList<Map<String, String>> srcFieldsList = new ArrayList<Map<String, String>>(10);
        String src = "";
        String srcType = dynamicObject.getString("srctype");
        String srcentity = dynamicObject.getString("srcentity");
        String srcenum = dynamicObject.getString("srcenum");
        if (!SWCStringUtils.isEmpty((String)srcentity) && SWCStringUtils.equals((String)srcType, (String)VALUETYPE_FIXED)) {
            src = dynamicObject.getString("srcentity.number");
        } else if (!SWCStringUtils.isEmpty((String)srcenum) && SWCStringUtils.equals((String)srcType, (String)"2")) {
            src = "hsbs_enumconfig";
        } else {
            if (isInit && SWCStringUtils.isEmpty((String)src)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u503c\u6765\u6e90\u5b9e\u4f53\u6216\u679a\u4e3e\u3002", (String)"CustFetchConfigEdit_11", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), new Object[0]));
            }
            return srcFieldsList;
        }
        Map allFieldsMap = null;
        try {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)src);
            allFieldsMap = mainEntityType.getAllFields();
        }
        catch (KDException kdException) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8be5\u5b9e\u4f53\u7684\u503c\u6765\u6e90\u5b57\u6bb5\u4e0d\u53ef\u7528\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u5b9e\u4f53\u3002", (String)"CustFetchConfigEdit_12", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), new Object[0]));
            return srcFieldsList;
        }
        for (Map.Entry entry : allFieldsMap.entrySet()) {
            HashMap map = new HashMap(3);
            LocaleString srcfieldname = ((IDataEntityProperty)entry.getValue()).getDisplayName();
            String srcfieldnum = (String)entry.getKey();
            if (srcfieldname == null || srcfieldnum == null) continue;
            map.put("srcfieldnum", entry.getKey());
            map.put("srcfieldname", ((IDataEntityProperty)entry.getValue()).getDisplayName().toString());
            srcFieldsList.add(map);
        }
        if (isInit && ObjectUtils.isEmpty(srcFieldsList)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u503c\u6765\u6e90\u5b9e\u4f53\u6216\u679a\u4e3e\u65e0\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165\u3002", (String)"CustFetchConfigEdit_13", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), new Object[0]));
        }
        return srcFieldsList;
    }

    private void initSrcField(DynamicObjectCollection dyObjs) {
        for (int index = 0; index < dyObjs.size(); ++index) {
            DynamicObject dyObj = (DynamicObject)dyObjs.get(index);
            List<Map<String, String>> srcFields = this.getSrcFields(dyObj, false);
            String srcField = (String)dyObj.get("srcfield");
            String srcFieldStr = "";
            for (Map<String, String> map : srcFields) {
                if (!SWCStringUtils.equals((String)map.get("srcfieldnum"), (String)srcField)) continue;
                srcFieldStr = map.get("srcfieldname") + "(" + srcField + ")";
            }
            IDataModel model = this.getModel();
            model.setValue("srcfieldnum", (Object)srcFieldStr, index);
        }
    }

    private void initSrcInfo(DynamicObjectCollection collection, int index) {
        DynamicObject dynamicObject = (DynamicObject)collection.get(index);
        String srcType = dynamicObject.getString("srctype");
        IDataModel model = this.getModel();
        model.beginInit();
        if (VALUETYPE_FIXED.equals(srcType)) {
            model.setValue("srcenum", (Object)"", index);
        } else if ("2".equals(srcType)) {
            model.setValue("srcentity", (Object)"", index);
        } else {
            model.setValue("srcentity", (Object)"", index);
            model.setValue("srcenum", (Object)"", index);
        }
        model.setValue("srcfieldnum", (Object)"", index);
        model.setValue("srcfield", (Object)"", index);
        model.endInit();
        this.getView().updateView("srcenum", index);
        this.getView().updateView("srcentity", index);
        this.getView().updateView("srcfieldnum", index);
        this.getView().updateView("srcenum", index);
    }

    private void setSrcEditAuth(DynamicObjectCollection collection, int index) {
        DynamicObject dynamicObject = (DynamicObject)collection.get(index);
        String srcType = dynamicObject.getString("srctype");
        IFormView view = this.getView();
        if (VALUETYPE_FIXED.equals(srcType)) {
            view.setEnable(Boolean.FALSE, index, new String[]{"srcenum"});
            view.setEnable(Boolean.TRUE, index, new String[]{"srcentity", "srcfieldnum"});
        } else if ("2".equals(srcType)) {
            view.setEnable(Boolean.FALSE, index, new String[]{"srcentity", "srcfieldnum"});
            view.setEnable(Boolean.TRUE, index, new String[]{"srcenum"});
        } else {
            view.setEnable(Boolean.FALSE, index, new String[]{"srcentity", "srcenum", "srcfieldnum"});
        }
    }

    private void setFetchFieldAuth() {
        DynamicObjectCollection fetchCollection = this.getModel().getEntryEntity("fetchfieldentry");
        this.initSrcField(fetchCollection);
        for (int index = 0; index < fetchCollection.size(); ++index) {
            this.setSrcEditAuth(fetchCollection, index);
        }
    }

    private boolean checkEntityData() {
        DynamicObjectCollection fetchEntry = this.getView().getModel().getEntryEntity("fetchfieldentry");
        DynamicObjectCollection relationEntity = this.getView().getModel().getEntryEntity("inputfieldentry");
        boolean flag = true;
        for (DynamicObject dynamicObject : relationEntity) {
            String inputType = dynamicObject.getString("inputparamitemtype");
            String inputValue = dynamicObject.getString("inputparamfixedvalue");
            if (!SWCStringUtils.equals((String)"2", (String)inputType) || !SWCStringUtils.isNotEmpty((String)inputValue)) continue;
            flag = false;
            break;
        }
        return CollectionUtils.isEmpty((Collection)fetchEntry) && flag;
    }

    private void changeAreaTypeData() {
        this.clearFetchField();
        String selectType = (String)this.getModel().getValue("areatype");
        FieldEdit control = (FieldEdit)this.getControl("country");
        boolean flag = SWCStringUtils.equals((String)selectType, (String)VALUETYPE_FIXED);
        this.getView().setVisible(Boolean.valueOf(!flag), new String[]{"country"});
        control.setMustInput(!flag);
        this.getView().getModel().setValue("country", null);
    }

    private boolean isContainsChinese(String str) {
        String regEx = "[\u4e00-\u9fa5]";
        Pattern pat = Pattern.compile(regEx);
        if (SWCStringUtils.isEmpty((String)str)) {
            return false;
        }
        Matcher matcher = pat.matcher(str);
        return matcher.find();
    }

    private boolean checkFetchItemConfig(String opName) {
        boolean quoteStatus;
        IFormView view = this.getView();
        String fetchPath = this.getModel().getDataEntity().getString("fetchpath");
        boolean containsChinese = this.isContainsChinese(fetchPath);
        if (containsChinese) {
            String msg = ResManager.loadKDString((String)"\u63d2\u4ef6\u8def\u5f84\u4e0d\u5141\u8bb8\u8f93\u5165\u4e2d\u6587\u3002", (String)"CustFetchConfigEdit_5", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
            view.showTipNotification(msg);
            return true;
        }
        DynamicObjectCollection calItemMatchEntry = this.getModel().getEntryEntity("fetchfieldentry");
        if (CollectionUtils.isEmpty((Collection)calItemMatchEntry)) {
            String msg = ResManager.loadKDString((String)"\u51fa\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u81f3\u5c11\u9700\u8981\u4e00\u6761\u6570\u636e\u3002", (String)"CustFetchConfigEdit_14", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
            view.showTipNotification(msg);
            return true;
        }
        DynamicObjectCollection relationEntry = this.getModel().getEntryEntity("inputfieldentry");
        if (!SWCListUtils.isEmpty((List)relationEntry)) {
            StringBuilder msgSb = new StringBuilder();
            for (int i = 0; i < relationEntry.size(); ++i) {
                String inputParam = ((DynamicObject)relationEntry.get(i)).getString("inputparam");
                String inputParamName = ((DynamicObject)relationEntry.get(i)).getString("inputparamname");
                String dataType = ((DynamicObject)relationEntry.get(i)).getString("inputparamdatatype");
                String itemType = ((DynamicObject)relationEntry.get(i)).getString("inputparamitemtype");
                String itemValue = ((DynamicObject)relationEntry.get(i)).getString("inputparamitem");
                ArrayList<String> msgList = new ArrayList<String>(10);
                if (SWCStringUtils.isEmpty((String)inputParam)) {
                    msgList.add(ResManager.loadKDString((String)"\u201c\u5165\u53c2\u201d", (String)"CustFetchConfigEdit_23", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                }
                if (SWCStringUtils.isEmpty((String)inputParamName)) {
                    msgList.add(ResManager.loadKDString((String)"\u201c\u5165\u53c2\u540d\u79f0\u201d", (String)"CustFetchConfigEdit_24", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                }
                if (SWCStringUtils.isEmpty((String)dataType)) {
                    msgList.add(ResManager.loadKDString((String)"\u201c\u6570\u636e\u7c7b\u578b\u201d", (String)"CustFetchConfigEdit_25", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                }
                if (SWCStringUtils.isEmpty((String)itemType)) {
                    msgList.add(ResManager.loadKDString((String)"\u201c\u53c2\u6570\u7c7b\u578b\u201d", (String)"CustFetchConfigEdit_26", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                }
                if (SWCStringUtils.isEmpty((String)itemValue)) {
                    msgList.add(ResManager.loadKDString((String)"\u201c\u53c2\u6570\u503c\u201d", (String)"CustFetchConfigEdit_27", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                }
                String errMsg = String.join((CharSequence)"\u3001", msgList);
                if (SWCListUtils.isEmpty(msgList)) continue;
                msgSb.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5165\u53c2\u201d\u7b2c{0}\u884c\uff1a", (String)"CustFetchConfigEdit_28", (String)"swc-hsbs-formplugin", (Object[])new Object[]{i + 1})).append(errMsg).append("\u3002\r\n");
            }
            if (msgSb.length() > 0) {
                view.showTipNotification(msgSb.toString());
                return true;
            }
        }
        boolean flag = false;
        String message = "";
        ArrayList<Long> fetchItemIds = new ArrayList<Long>(10);
        for (DynamicObject dynamicObject : calItemMatchEntry) {
            String srcenum;
            Long fetchItem = dynamicObject.getLong("fetchitem.id");
            fetchItemIds.add(fetchItem);
            for (DynamicObject relationObject : relationEntry) {
                long inputParamFetchItem = relationObject.getLong("inputparamfetchitem.id");
                if (fetchItem != inputParamFetchItem || !StringUtils.equals((CharSequence)relationObject.getString("inputparamitemtype"), (CharSequence)"2")) continue;
                message = dynamicObject.getString("fetchitem.name");
                flag = true;
                break;
            }
            if (flag) {
                String msg = MessageFormat.format(ResManager.loadKDString((String)"\u53d6\u6570\u9879\u76ee:{0}\uff0c\u5faa\u73af\u4f9d\u8d56\u7684\u6570\u636e\u4e0d\u80fd\u8fdb\u884c\u4fdd\u5b58\u3002", (String)"CustFetchConfigEdit_15", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), message);
                view.showErrorNotification(msg);
                return true;
            }
            String srcType = dynamicObject.getString("srctype");
            if (StringUtils.equals((CharSequence)srcType, (CharSequence)VALUETYPE_FIXED)) {
                String srcEntity = dynamicObject.getString("srcentity");
                String srcFieldNum = dynamicObject.getString("srcfieldnum");
                if (StringUtils.isBlank((CharSequence)srcEntity) || StringUtils.isBlank((CharSequence)srcFieldNum)) {
                    message = dynamicObject.getString("fetchitem.name");
                    String msg = MessageFormat.format(ResManager.loadKDString((String)"\u53d6\u6570\u9879\u76ee:{0}\uff0c\u8bf7\u586b\u5199\u503c\u6765\u6e90\u5b9e\u4f53\u548c\u503c\u6765\u6e90\u5b57\u6bb5\u3002", (String)"CustFetchConfigEdit_16", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), message);
                    view.showErrorNotification(msg);
                    return true;
                }
            }
            if (!StringUtils.equals((CharSequence)srcType, (CharSequence)"2") || !StringUtils.isBlank((CharSequence)(srcenum = dynamicObject.getString("srcenum")))) continue;
            message = dynamicObject.getString("fetchitem.name");
            String msg = MessageFormat.format(ResManager.loadKDString((String)"\u53d6\u6570\u9879\u76ee:{0}\uff0c\u8bf7\u586b\u5199\u201c\u503c\u6765\u6e90\u679a\u4e3e\u201d\u3002", (String)"CustFetchConfigEdit_17", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), message);
            view.showErrorNotification(msg);
            return true;
        }
        ArrayList relationCodeList = new ArrayList(10);
        relationEntry.forEach(param -> {
            if (StringUtils.equals((CharSequence)param.getString("inputparamitemtype"), (CharSequence)"2")) {
                relationCodeList.add(param.getString("inputparamfetchitem.uniquecode"));
            }
        });
        long configId = this.getModel().getDataEntity().getLong("id");
        if (!CollectionUtils.isEmpty(relationCodeList)) {
            FetchItemCheckResultVo result = FetchConfigHelper.checkFetchConfigItemCycle((long)configId, relationCodeList);
            if (SWCStringUtils.equals((String)VALUETYPE_FIXED, (String)result.getResult())) {
                String fetchItemStr = this.assembleFetchItemStr(result.getFetchItemList());
                String msg = MessageFormat.format(ResManager.loadKDString((String)"\u53d6\u6570\u914d\u7f6e{0}\u5b58\u5728\u5faa\u73af\u4f9d\u8d56\uff0c\u8bf7\u68c0\u67e5\u53d6\u6570\u914d\u7f6e\uff0c\u5e76\u4fee\u6539\u3002", (String)"CustFetchConfigEdit_18", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), fetchItemStr);
                view.showErrorNotification(msg);
                return true;
            }
            if (SWCStringUtils.equals((String)"2", (String)result.getResult())) {
                view.showConfirm(ResManager.loadKDString((String)"\u53d6\u6570\u9879\u76ee\u4f9d\u8d56\u5c42\u6b21\u5c06\u8d85\u8fc75\u5c42\uff0c\u53ef\u80fd\u589e\u5927\u8ba1\u7b97\u6846\u67b6\u590d\u6742\u5ea6\u4ee5\u53ca\u8ba1\u7b97\u6027\u80fd\u635f\u8017\uff0c\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"CustFetchConfigEdit_19", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("fetch_too_many_notify", (IFormPlugin)this));
                return true;
            }
        }
        if (quoteStatus = this.checkChangeCalOrDimensionality()) {
            return quoteStatus;
        }
        return this.checkFetchItemUsed(view, fetchItemIds, configId);
    }

    private boolean checkFetchItemUsed(IFormView view, List<Long> fetchItemIds, long configId) {
        FetchItemCheckResultVo fetchItemCheckResultVo = FetchConfigHelper.checkBatchFetchItemEnableByIds(fetchItemIds, (long)configId);
        if (SWCStringUtils.equals((String)"3", (String)fetchItemCheckResultVo.getResult())) {
            view.showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u5b58\u5728\u4ee5\u4e0b\u53d6\u6570\u9879\u76ee\u5df2\u7ecf\u88ab\u4f7f\u7528\uff1a{0}\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u8bd5\u3002", (String)"CustFetchConfigEdit_22", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), fetchItemCheckResultVo.getFetchItemList()));
            return true;
        }
        return false;
    }

    private boolean checkFetchItemConfigList() {
        ArrayList<Long> fetchConfigIds = new ArrayList<Long>();
        long id = this.getModel().getDataEntity().getLong("id");
        fetchConfigIds.add(id);
        FetchConfigHelper fetchConfigHelper = new FetchConfigHelper();
        DynamicObject[] fetchItems = fetchConfigHelper.selectFetchItemListByCustId(fetchConfigIds);
        List fetchItemList = Arrays.stream(fetchItems).map(param -> param.getLong("fetchitem.id")).collect(Collectors.toList());
        String message = fetchConfigHelper.checkFetchConfigQuote(fetchItemList);
        message = message + fetchConfigHelper.checkCustFetchConfigQuote(fetchItemList);
        message = message + fetchConfigHelper.checkResultFetchConfigQuote(fetchItemList);
        if (SWCStringUtils.isNotEmpty((String)message)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u53d6\u6570\u9879\u76ee\u88ab\u5176\u4ed6\u914d\u7f6e\u5173\u8054\uff0c\u5982\u679c\u7981\u7528\u4f1a\u5f71\u54cd\u8ba1\u7b97\u53d6\u6570\uff0c\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"CustFetchConfigEdit_20", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), message, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(FETCHITEMQUOTEDISABLE, (IFormPlugin)this));
            return true;
        }
        return false;
    }

    private boolean checkChangeCalOrDimensionality() {
        String enable = this.getModel().getDataEntity().getString("enable");
        if (!SWCStringUtils.equals((String)VALUETYPE_FIXED, (String)enable)) {
            return false;
        }
        String dimensionality = this.getModel().getDataEntity().getString(CHANGE_DIMENSIONALITY);
        ArrayList<Long> ids = new ArrayList<Long>();
        long id = this.getModel().getDataEntity().getLong("id");
        ids.add(id);
        FetchConfigHelper fetchConfigHelper = new FetchConfigHelper();
        DynamicObject[] fetchConfigObjs = fetchConfigHelper.selectCustFetchConfigList(ids);
        if (fetchConfigObjs == null) {
            return false;
        }
        DynamicObject[] fetchItems = fetchConfigHelper.selectFetchItemListByCustId(ids);
        List fetchItemList = Arrays.stream(fetchItems).map(param -> param.getLong("fetchitem.id")).collect(Collectors.toList());
        String message = "";
        String oldDimensionality = fetchConfigObjs[0].getString(CHANGE_DIMENSIONALITY);
        if (!SWCStringUtils.equals((String)dimensionality, (String)fetchConfigObjs[0].getString(CHANGE_DIMENSIONALITY)) && SWCStringUtils.equals((String)VALUETYPE_FIXED, (String)oldDimensionality)) {
            message = message + fetchConfigHelper.checkFetchConfigQuote(fetchItemList);
            message = message + fetchConfigHelper.checkCustFetchConfigQuote(fetchItemList);
            message = message + fetchConfigHelper.checkResultFetchConfigQuote(fetchItemList);
        }
        if (SWCStringUtils.isNotEmpty((String)message)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5bf9\u53d6\u6570\u7ef4\u5ea6\u3001\u8ba1\u7b97\u4e2d\u53d6\u6570\u3001\u53d6\u6570\u5b57\u6bb5\u7684\u8c03\u6574\uff0c\u4f1a\u5f71\u54cd\u5b58\u5728\u5173\u8054\u5173\u7cfb\u7684\u5176\u4ed6\u914d\u7f6e\uff0c\u8bf7\u8c03\u6574\u540e\u91cd\u8bd5\u3002", (String)"CustFetchConfigEdit_21", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), message, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(CHECKFETCHITEMQUOTE, (IFormPlugin)this));
            return true;
        }
        return false;
    }

    private String assembleFetchItemStr(List<String> fetchItemList) {
        StringBuilder sb = new StringBuilder();
        if (!CollectionUtils.isEmpty(fetchItemList)) {
            fetchItemList.stream().forEach(item -> sb.append('\u3010').append((String)item).append('\u3011'));
        }
        return sb.toString();
    }

    private void setFetchItemDataStatus(PropertyChangedArgs args, String fieldMark) {
        int seq = Integer.parseInt(args.getChangeSet()[0].getDataEntity().getString("seq")) - 1;
        String filterCheck = this.getView().getPageCache().get(fieldMark + "_filterCheck_" + seq);
        if (!SWCStringUtils.equals((String)filterCheck, (String)VALUETYPE_FIXED)) {
            this.getView().getPageCache().put(fieldMark + "_filterCheck_" + seq, VALUETYPE_FIXED);
            this.getModel().beginInit();
            if (StringUtils.equals((CharSequence)fieldMark, (CharSequence)"fetchitem")) {
                this.getModel().setValue(fieldMark, args.getChangeSet()[0].getNewValue(), seq);
            } else {
                this.getModel().setValue(fieldMark, args.getChangeSet()[0].getOldValue(), seq);
            }
            this.getModel().endInit();
        } else {
            this.getView().getPageCache().put(fieldMark + "_filterCheck_" + seq, null);
        }
    }

    private void setChangeDimensionality() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("inputfieldentry");
        DynamicObject[] dataEntitys = entryGrid.getEntryData().getDataEntitys();
        for (int i = 0; i < dataEntitys.length; ++i) {
            String fieldType = dataEntitys[i].getString("inputparamitemtype");
            if (!StringUtils.equals((CharSequence)fieldType, (CharSequence)"2")) continue;
            this.getModel().beginInit();
            this.getView().getModel().setValue("inputparamitem", null, i);
            this.getModel().endInit();
        }
        this.getView().updateView("inputfieldentry");
    }

    private void flushInputEntity() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("inputfieldentry");
        for (int i = 0; i < entryEntity.size(); ++i) {
            String dataType = ((DynamicObject)entryEntity.get(i)).getString("inputparamdatatype");
            String itemType = ((DynamicObject)entryEntity.get(i)).getString("inputparamitemtype");
            boolean flag = SWCStringUtils.isNotEmpty((String)dataType) && SWCStringUtils.isNotEmpty((String)itemType);
            this.getView().setEnable(Boolean.valueOf(flag), i, new String[]{"inputparamitem"});
            this.getView().updateView("inputfieldentry", i);
        }
    }

    private boolean isEntityEmpty() {
        DynamicObjectCollection fetchFieldEntry = this.getModel().getEntryEntity("fetchfieldentry");
        DynamicObjectCollection inputFieldEntry = this.getModel().getEntryEntity("inputfieldentry");
        return SWCListUtils.isEmpty((List)fetchFieldEntry) && SWCListUtils.isEmpty((List)inputFieldEntry);
    }
}

