/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.basedata.fetchconfig;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.FormulaEditHelper;
import kd.bos.designer.query.QueryEntityParseHelper;
import kd.bos.designer.query.QueryEntityTreeBuildParameter;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDException;
import kd.bos.ext.hr.metadata.form.control.Hint;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.JSONUtils;
import kd.swc.hsbp.business.area.AreaHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.CalDataTypeEnum;
import kd.swc.hsbp.common.enums.ConditionFieldTypeEnum;
import kd.swc.hsbp.common.enums.ConditionLogicTypeEnum;
import kd.swc.hsbp.common.enums.ConditionValueTypeEnum;
import kd.swc.hsbp.common.enums.FetchConditionEntryFieldEnum;
import kd.swc.hsbp.common.enums.RuleOperatorEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCInteDateTimeUtil;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.FetchItemCheckResultVo;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;
import kd.swc.hsbs.business.basedata.fetchconfig.FetchConfigHelper;
import kd.swc.hsbs.business.datareader.DataReaderHelper;

public class FetchConfigEdit
extends SWCDataBaseEdit
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(FetchConfigEdit.class);
    public static final String SHOW_FILED_SPLIT = "\\.";
    private static final char LEFT_MID_BRACKET = '\u3010';
    private static final char RIGHT_MID_BRACKET = '\u3011';
    private static final String ADD_FETCH_FIELD_ENTRY = "addfetchfieldentry";
    private static final String DELETE_FETCH_FIELD_ENTRY = "deletefetchfieldentry";
    private static final String ADD_RELATION_FIELD_ENTRY = "addrelationentry";
    private static final String DELETE_RELATION_FIELD_ENTRY = "deleterelationentry";
    private static final String ADD_DATASORT_FIELD_ENTRY = "adddatasortentry";
    private static final String DELETE_DATASORT_FIELD_ENTRY = "deletedatasortentry";
    private static final String CHANGE_AREA_TYPE = "changeAreaType";
    private static final String CHANGE_COUNTRY = "changeCountry";
    private static final String CHANGE_DIMENSIONALITY = "dimensionality";
    private static final String CHANGE_FETCH_TYPE = "changeFetchType";
    private static final String CHANGE_FETCH_SOURCE = "fetchsource";
    private static final String CHANGE_FETCH_CAL = "calculationfetch";
    private static final String CHECKFETCHITEMQUOTE = "checkFetchItemQuote";
    private static final String FETCHITEMQUOTEDISABLE = "checkFetchItemQuoteDisable";
    private static final String RELATION_ENTITY = "relationentity";
    private static final String KEY_FIELDNAME = "filterfieldname";
    private static final String KEY_COMPARETYPE = "comparetype";
    private static final String KEY_COMPARETYPEVALUE = "condition";
    private static final String KEY_FIELDTYPE = "filterdatatype";
    private static final String KEY_COMPAREVALUETEXT = "comparevaluetext";
    private static final String KEY_COMPAREVALUE = "comparevalue";
    private static final String KEY_COMPAREVALUETYPE = "comparevaluetype";
    private static final String KEY_VALUETYPE = "valuetype";
    private static final String KEY_FILTERFIELD = "filterfield";
    private static final String KEY_RADIOGROUPFIELD = "conditionlogictype";
    private static final String BTN_AND = "btnand";
    private static final String BTN_OR = "btnor";
    private static final String BTN_LEFT = "left";
    private static final String BTN_RIGHT = "right";
    private static final String KEY_CONDITIONLOGICTEXT = "conditionlogictext";
    private static final String SYSTEM_TYPE = "swc-hsbs-formplugin";
    private static final String CACHE_KEY_CONDITION_ENTRY_ROWINDEX = "conditionentryindex";
    private static final String KEY_CHECK_ENTRY = "checkEntryFlag";
    private static final String KEY_CHECK_ENTRY_SIZE = "checkEntrySizeFlag";
    private static final String KEY_F7SOURCE = "f7source";
    private static final String FETCHCONFIG_CONDITIONLOGIC_TYPE_AND = "1";
    private static final String KEY_PRORATION_SWITCH = "proration";
    private static final String KEY_PRORATIONSTARTFIELD = "prorationstartfield";
    private static final String KEY_PRORATIONENDFIELD = "prorationendfield";
    private static final String KEY_PRORATIONSTARTNAME = "prorationstartdatename";
    private static final String KEY_PRORATIONENDNAME = "prorationenddatename";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject args) {
        super.registerListener(args);
        this.addClickListeners(new String[]{"startdate", "enddate", "filter", "srcfieldnum", CHANGE_FETCH_CAL, KEY_COMPAREVALUETYPE, KEY_FIELDNAME, KEY_COMPARETYPE, KEY_COMPAREVALUETEXT, BTN_AND, BTN_OR, BTN_LEFT, BTN_RIGHT, KEY_PRORATIONSTARTNAME, KEY_PRORATIONENDNAME});
        BasedataEdit objectType = (BasedataEdit)this.getView().getControl(CHANGE_FETCH_SOURCE);
        objectType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit fetchItem = (BasedataEdit)this.getView().getControl("fetchitem");
        fetchItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterLoadData(EventObject args) {
        super.afterLoadData(args);
        IDataModel dataModel = this.getModel();
        long id = this.getModel().getDataEntity().getLong("id");
        SWCDataServiceHelper fetchConfigItemHelper = new SWCDataServiceHelper("hsbs_fetchconfigitem");
        DynamicObject[] DynamicObjects = fetchConfigItemHelper.query("id,fetchfieldentry,fetchconfig,fetchitem,enable", new QFilter[]{new QFilter("fetchconfig", "in", (Object)id)});
        HashMap<Long, DynamicObject> calRuleItemEntryMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject dynamicObject : DynamicObjects) {
            long fetchfieldentry = dynamicObject.getLong("fetchfieldentry");
            if (fetchfieldentry == 0L) continue;
            calRuleItemEntryMap.put(fetchfieldentry, dynamicObject);
        }
        DynamicObjectCollection calRuleItemEntryColl = dataModel.getEntryEntity("fetchfieldentry");
        for (DynamicObject dynamicObject : calRuleItemEntryColl) {
            long entryId = dynamicObject.getLong("id");
            DynamicObject dynamicObj = (DynamicObject)calRuleItemEntryMap.get(entryId);
            if (null == dynamicObj) continue;
            dynamicObject.set("fetchitem", (Object)dynamicObj.getDynamicObject("fetchitem"));
        }
        DynamicObjectCollection filterEntry = dataModel.getEntryEntity(RELATION_ENTITY);
        try {
            for (DynamicObject entryObj : filterEntry) {
                String fieldType = entryObj.getString(KEY_FIELDTYPE);
                if (!SWCStringUtils.equals((String)"Date", (String)fieldType)) continue;
                String comparevalue = entryObj.getString(KEY_COMPAREVALUE);
                entryObj.set(KEY_COMPAREVALUETEXT, (Object)SWCInteDateTimeUtil.formateDate((Date)SWCDateTimeUtils.parseDate((String)comparevalue, (String)"yyyy-MM-dd")));
            }
        }
        catch (ParseException exception) {
            logger.error("date parse error", (Throwable)exception);
        }
        this.getModel().setDataChanged(false);
        this.getModel().updateEntryCache(calRuleItemEntryColl);
        this.getView().updateView("fetchfieldentry");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        this.showInitPage();
        switch (operateKey = args.getOperateKey()) {
            case "deleterelationentry": {
                this.getPageCache().remove(CACHE_KEY_CONDITION_ENTRY_ROWINDEX);
                break;
            }
        }
    }

    public void afterBindData(EventObject args) {
        this.showInitPage();
        this.initConditionLogicData();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(RELATION_ENTITY);
        this.updateConditionEntryEnable(entryEntity);
        this.changeCalculationFetch();
        this.initProrationSwitch();
        this.initSumFetch();
        this.setFetchFieldAuth();
        this.getModel().setDataChanged(false);
    }

    private void initSumFetch() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        boolean sumFetchSwitch = dataEntity.getBoolean("sumfetch");
        if (sumFetchSwitch) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"datasort"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"sumtype"});
            ComboEdit sumType = (ComboEdit)this.getControl("sumtype");
            sumType.setMustInput(true);
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"datasort"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"sumtype"});
        }
    }

    public void beforeBindData(EventObject args) {
        super.beforeBindData(args);
        boolean isSysPreSet = this.getModel().getDataEntity().getBoolean("issyspreset");
        FormShowParameter form = this.getView().getFormShowParameter();
        if (isSysPreSet) {
            form.setStatus(OperationStatus.VIEW);
        }
        this.setConditionEntryData();
        this.initTips();
        this.initConditionLogicBtnName();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String opKey = operate.getOperateKey();
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (opKey) {
            case "addfetchfieldentry": {
                this.openFieldTreeAddForm("fetchfieldentry");
                break;
            }
            case "deletefetchfieldentry": {
                this.validateDeleteEntry("fetchfieldentry", opKey);
                args.setCancel(false);
                break;
            }
            case "addrelationentry": {
                this.openFieldTreeAddForm(RELATION_ENTITY);
                break;
            }
            case "deleterelationentry": {
                this.validateDeleteEntry(RELATION_ENTITY, opKey);
                args.setCancel(false);
                break;
            }
            case "adddatasortentry": {
                this.openFieldTreeAddForm("fetchsortentry");
                break;
            }
            case "deletedatasortentry": {
                this.validateDeleteEntry("fetchsortentry", opKey);
                args.setCancel(false);
                break;
            }
            case "save": {
                boolean checkFlag;
                ArrayList<DynamicObject> allConditionList = new ArrayList<DynamicObject>(10);
                if (!operate.getOption().tryGetVariableValue("save", new RefObject()) && (checkFlag = this.checkFetchItemConfig("save"))) {
                    args.setCancel(true);
                    break;
                }
                String conditionLogicType = this.getModel().getDataEntity().getString(KEY_RADIOGROUPFIELD);
                if (SWCStringUtils.equals((String)ConditionLogicTypeEnum.CUST.getCode(), (String)conditionLogicType)) {
                    this.formatConditionLogicCode();
                }
                ArrayList<DynamicObject> personConditionList = new ArrayList<DynamicObject>(10);
                ArrayList<DynamicObject> personFTConditionList = new ArrayList<DynamicObject>(10);
                ArrayList<DynamicObject> taskFTConditionList = new ArrayList<DynamicObject>(10);
                ArrayList<DynamicObject> taskConditionList = new ArrayList<DynamicObject>(10);
                DynamicObjectCollection relationEntry = this.getModel().getEntryEntity(RELATION_ENTITY);
                this.assembleConditionTypeList(relationEntry, personConditionList, personFTConditionList, taskConditionList, taskFTConditionList, allConditionList);
                String dimensionality = this.getModel().getDataEntity().getString(CHANGE_DIMENSIONALITY);
                IFormView view = this.getView();
                if (!operate.getOption().tryGetVariableValue(KEY_CHECK_ENTRY, new RefObject())) {
                    boolean checkFlag1 = this.checkConditionEntry(relationEntry, view, dimensionality);
                    if (checkFlag1) {
                        args.setCancel(true);
                        break;
                    }
                    if (SWCStringUtils.equals((String)"0", (String)dimensionality)) {
                        if (SWCListUtils.isEmpty(personConditionList) && SWCListUtils.isEmpty(personFTConditionList)) {
                            view.showTipNotification(ResManager.loadKDString((String)"\u5173\u8054\u4fe1\u606f\u4e2d\u81f3\u5c11\u9700\u8981\u4e00\u4e2a\u4eba\u5458\u53c2\u6570\u6216\u8005\u4eba\u5458\u7ef4\u5ea6\u7684\u53d6\u6570\u9879\u76ee\uff0c\u4e14\u5224\u65ad\u6761\u4ef6\u5fc5\u987b\u4e3a\u201c\u7b49\u4e8e\u201d\u3002", (String)"FetchConfigEdit_46", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                            args.setCancel(true);
                            break;
                        }
                        if (SWCListUtils.isEmpty(personConditionList)) {
                            String msg = ResManager.loadKDString((String)"\u5173\u8054\u4fe1\u606f\u4e2d\u672a\u5305\u542b\u4eba\u5458\u53c2\u6570\uff0c\u53ef\u80fd\u5f71\u54cd\u53d6\u6570\u51c6\u786e\u6027\uff0c\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"FetchConfigEdit_62", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                            this.openChangeConfirm("", KEY_CHECK_ENTRY, msg);
                            args.setCancel(true);
                            break;
                        }
                    }
                }
                if (operate.getOption().tryGetVariableValue(KEY_CHECK_ENTRY_SIZE, new RefObject()) || allConditionList.size() <= 5) break;
                String msg = ResManager.loadKDString((String)"\u5305\u542b\u53d6\u6570\u9879\u76ee\u6216\u53c2\u6570\u7684\u52a8\u6001\u5173\u8054\u4fe1\u606f\u8fc7\u591a\u53ef\u80fd\u5f71\u54cd\u53d6\u6570\u6027\u80fd\uff08\u5efa\u8bae\u63a7\u5236\u57285\u6761\u4ee5\u5185\uff09\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"FetchConfigEdit_61", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                this.openChangeConfirm("", KEY_CHECK_ENTRY_SIZE, msg);
                args.setCancel(true);
                break;
            }
            case "disable": {
                if (operate.getOption().tryGetVariableValue("disable", new RefObject())) break;
                args.setCancel(this.checkFetchItemConfigList());
                break;
            }
            case "delete": {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("hsbs_fetchconfigitem").append(',').append("hsbs_fetchfilterentry");
                formOperate.getOption().setVariableValue("ignorerefentityids", stringBuilder.toString());
                break;
            }
            case "enable": {
                boolean checkFlag;
                boolean dataChanged = this.getModel().getDataChanged();
                if (dataChanged && SWCStringUtils.isNotEmpty((String)this.getModel().getChangeDesc())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"FetchConfigEdit_45", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    args.setCancel(true);
                }
                if (!(checkFlag = this.checkFetchItemConfig("enable"))) break;
                args.setCancel(true);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        EntryGrid entryGrid = (EntryGrid)this.getControl(RELATION_ENTITY);
        int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
        DynamicObjectCollection filterEntry = this.getModel().getEntryEntity(RELATION_ENTITY);
        String caption = "";
        if (SWCStringUtils.equals((String)key, (String)KEY_COMPARETYPE)) {
            caption = ResManager.loadKDString((String)"\u5224\u65ad\u6761\u4ef6", (String)"FetchConfigEdit_65", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        } else if (SWCStringUtils.equals((String)key, (String)KEY_COMPAREVALUETYPE)) {
            caption = ResManager.loadKDString((String)"\u6bd4\u8f83\u503c\u7c7b\u578b", (String)"FetchConfigEdit_66", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        } else if (SWCStringUtils.equals((String)key, (String)KEY_COMPAREVALUETEXT)) {
            caption = ResManager.loadKDString((String)"\u6bd4\u8f83\u503c", (String)"FetchConfigEdit_67", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        }
        switch (key) {
            case "filterfieldname": {
                this.getPageCache().put(CACHE_KEY_CONDITION_ENTRY_ROWINDEX, String.valueOf(selectedRows[0]));
                this.openFieldTreeAddForm(RELATION_ENTITY);
                break;
            }
            case "comparetype": 
            case "comparevaluetype": {
                DynamicObject row = (DynamicObject)filterEntry.get(selectedRows[0]);
                if (this.checkConditionField(row, key)) break;
                String dimensionality = this.getModel().getDataEntity().getString(CHANGE_DIMENSIONALITY);
                this.openCompareTypeComboForm(caption, row, key, "", "", dimensionality);
                break;
            }
            case "comparevaluetext": {
                DynamicObject row1 = (DynamicObject)filterEntry.get(selectedRows[0]);
                if (this.checkConditionField(row1, key)) break;
                this.openCompareValueForm(caption, row1, key);
                break;
            }
            case "srcfieldnum": {
                entryGrid = (EntryGrid)this.getControl("fetchfieldentry");
                selectedRows = entryGrid.getEntryState().getSelectedRows();
                PageCache pageCache = new PageCache(this.getView().getPageId());
                pageCache.put("opRowNum", String.valueOf(selectedRows[0]));
                this.showFieldsList(selectedRows[0]);
                break;
            }
            case "btnand": 
            case "btnor": 
            case "left": 
            case "right": {
                this.fillConditionLogic(key);
                break;
            }
            case "prorationstartdatename": 
            case "prorationenddatename": {
                this.openProrationDateFieldTree(key);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey = args.getProperty().getName();
        ChangeData data = args.getChangeSet()[0];
        int index = data.getRowIndex();
        DynamicObjectCollection collection = this.getModel().getEntryEntity("fetchfieldentry");
        switch (fieldKey) {
            case "areatype": {
                String oldAreaType = (String)args.getChangeSet()[0].getOldValue();
                DynamicObject country = this.getModel().getDataEntity().getDynamicObject("country");
                if (oldAreaType == null || this.checkEntityData(country)) {
                    this.changeAreaTypeData();
                    return;
                }
                String msg = ResManager.loadKDString((String)"\u66f4\u6539\u56fd\u5bb6/\u5730\u533a\u7c7b\u578b\uff0c\u53d6\u6570\u5b57\u6bb5\u548c\u5173\u8054\u4fe1\u606f\u5185\u90e8\u5206\u5185\u5bb9\u5c06\u88ab\u6e05\u7a7a\uff0c\u786e\u8ba4\u66f4\u6539\uff1f", (String)"FetchConfigEdit_0", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                this.openChangeConfirm(oldAreaType, CHANGE_AREA_TYPE, msg);
                break;
            }
            case "country": {
                DynamicObject oldCountry = (DynamicObject)args.getChangeSet()[0].getOldValue();
                DynamicObject newValue = (DynamicObject)args.getChangeSet()[0].getNewValue();
                if (ObjectUtils.isEmpty((Object)oldCountry) || ObjectUtils.nullSafeEquals((Object)newValue, (Object)oldCountry) || this.checkEntityData(newValue)) {
                    return;
                }
                String msg = ResManager.loadKDString((String)"\u66f4\u6539\u56fd\u5bb6/\u5730\u533a\uff0c\u53d6\u6570\u5b57\u6bb5\u548c\u5173\u8054\u4fe1\u606f\u5185\u90e8\u5206\u5185\u5bb9\u5c06\u88ab\u6e05\u7a7a\uff0c\u786e\u8ba4\u66f4\u6539\uff1f", (String)"FetchConfigEdit_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                this.openChangeConfirm(oldCountry.getString("id"), CHANGE_COUNTRY, msg);
                break;
            }
            case "dimensionality": {
                String msg = ResManager.loadKDString((String)"\u66f4\u6539\u53d6\u6570\u7ef4\u5ea6\uff0c\u5173\u8054\u4fe1\u606f\u5185\u5bb9\u5c06\u88ab\u6e05\u7a7a\uff0c\u786e\u8ba4\u66f4\u6539\uff1f", (String)"FetchConfigEdit_3", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                this.openChangeConfirm((String)args.getChangeSet()[0].getOldValue(), CHANGE_DIMENSIONALITY, msg);
                break;
            }
            case "fetchsource": {
                DynamicObject oldObjectType = (DynamicObject)args.getChangeSet()[0].getOldValue();
                if (oldObjectType == null) {
                    return;
                }
                String msg = ResManager.loadKDString((String)"\u66f4\u6539\u53d6\u6570\u6765\u6e90\uff0c\u5173\u8054\u4fe1\u606f\u5185\u5bb9\u5c06\u88ab\u6e05\u7a7a\uff0c\u786e\u8ba4\u66f4\u6539\uff1f", (String)"FetchConfigEdit_5", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                this.openChangeConfirm(oldObjectType.getString("id"), CHANGE_FETCH_SOURCE, msg);
                break;
            }
            case "calculationfetch": {
                Object calValue = args.getChangeSet()[0].getOldValue();
                if (ObjectUtils.isEmpty((Object)calValue)) {
                    this.openFetchCalculationChangeConfirm();
                    break;
                }
                this.changeCalculationFetch();
                this.getView().getModel().setValue(CHANGE_FETCH_CAL, (Object)Boolean.FALSE);
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(RELATION_ENTITY);
                this.updateConditionEntryEnable(entryEntity);
                break;
            }
            case "sumfetch": {
                Object sumFetchValue = args.getChangeSet()[0].getOldValue();
                ComboEdit sumType = (ComboEdit)this.getControl("sumtype");
                if (ObjectUtils.isEmpty((Object)sumFetchValue)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"datasort"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"sumtype"});
                    sumType.setMustInput(true);
                    this.cleanFieldEntryFetchItem("fetchitem");
                    this.initFieldEntrySumType();
                    this.getModel().deleteEntryData("fetchsortentry");
                } else {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"datasort"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"sumtype"});
                    sumType.setMustInput(false);
                    this.cleanFieldEntryFetchItem("fetchitem", "sumtype");
                }
                this.setFetchFieldAuth();
                break;
            }
            case "comparevaluetype": {
                this.cleanEntryRowData(index, KEY_COMPAREVALUETEXT, KEY_COMPAREVALUE);
                String compareValueType = (String)data.getNewValue();
                if (!SWCStringUtils.isEmpty((String)compareValueType)) break;
                this.getModel().setValue(KEY_VALUETYPE, null, index);
                break;
            }
            case "comparetype": {
                String compareType = (String)data.getNewValue();
                if (SWCStringUtils.equals((String)RuleOperatorEnum.IS_NULL.getName(), (String)compareType) || SWCStringUtils.equals((String)RuleOperatorEnum.IS_NOT_NULL.getName(), (String)compareType)) {
                    this.getView().setEnable(Boolean.FALSE, index, new String[]{KEY_COMPAREVALUETYPE, KEY_VALUETYPE, KEY_COMPAREVALUETEXT, KEY_COMPAREVALUE});
                    this.cleanEntryRowData(index, KEY_COMPAREVALUETYPE, KEY_VALUETYPE, KEY_COMPAREVALUETEXT, KEY_COMPAREVALUE);
                } else {
                    this.getView().setEnable(Boolean.TRUE, index, new String[]{KEY_COMPAREVALUETYPE, KEY_VALUETYPE, KEY_COMPAREVALUETEXT, KEY_COMPAREVALUE});
                }
                if (SWCStringUtils.isEmpty((String)compareType)) {
                    this.getModel().setValue(KEY_COMPARETYPEVALUE, null, index);
                }
                this.updateField(index, KEY_COMPARETYPEVALUE, KEY_COMPAREVALUETYPE, KEY_VALUETYPE, KEY_COMPAREVALUETEXT, KEY_COMPAREVALUE);
                break;
            }
            case "fetchitem": {
                this.setFetchItemDataStatus(args, "fetchitem");
                break;
            }
            case "srctype": 
            case "srcentity": 
            case "srcenum": {
                this.initSrcInfo(collection, index);
                this.setSrcEditAuth(collection, index);
                break;
            }
            case "filterfieldname": {
                this.cleanEntryRowData(index, KEY_FILTERFIELD, KEY_FIELDTYPE, KEY_COMPARETYPE, KEY_COMPARETYPEVALUE, KEY_COMPAREVALUETYPE, KEY_VALUETYPE, KEY_COMPAREVALUETEXT, KEY_COMPAREVALUE);
                break;
            }
            case "conditionlogictype": {
                this.setConditionLogicTextVisible();
                this.setConditionLogic();
                break;
            }
            case "conditionlogictext": {
                String conditionLogicText = this.getModel().getDataEntity().getString(KEY_CONDITIONLOGICTEXT);
                String conditionLogicCode = this.assembleConditionLogicCode(conditionLogicText);
                this.getModel().setValue("conditionlogiccode", (Object)conditionLogicCode);
                break;
            }
            case "comparevaluetext": {
                Object newValue1 = data.getNewValue();
                if (!SWCStringUtils.isEmpty((String)(newValue1 + ""))) break;
                this.getModel().setValue(KEY_COMPAREVALUE, null, index);
                break;
            }
            case "proration": {
                this.cleanProrationFieldValue();
                this.initProrationSwitch();
                break;
            }
            case "prorationstartdatename": 
            case "prorationenddatename": {
                Object fieldValue = data.getNewValue();
                if (!SWCStringUtils.isEmpty((String)(fieldValue + ""))) break;
                if (SWCStringUtils.equals((String)KEY_PRORATIONSTARTNAME, (String)fieldKey)) {
                    this.getModel().setValue(KEY_PRORATIONSTARTFIELD, null);
                    break;
                }
                this.getModel().setValue(KEY_PRORATIONENDFIELD, null);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        String oldValue = messageBoxClosedEvent.getCustomVaule();
        switch (callBackId) {
            case "changeAreaType": {
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    this.changeAreaTypeData();
                    break;
                }
                this.getModel().beginInit();
                this.getModel().setValue("areatype", (Object)oldValue);
                this.getModel().endInit();
                this.getView().updateView("areatype");
                break;
            }
            case "changeCountry": {
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    this.clearFetchField();
                    break;
                }
                this.getModel().beginInit();
                this.getModel().setValue("country", (Object)oldValue);
                this.getModel().endInit();
                this.getView().updateView("country");
                break;
            }
            case "dimensionality": {
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    this.showInitPage();
                    this.clearFilterEntryByDimensionality();
                    break;
                }
                this.getModel().beginInit();
                this.getModel().setValue(CHANGE_DIMENSIONALITY, (Object)oldValue);
                this.getModel().endInit();
                this.getView().updateView(CHANGE_DIMENSIONALITY);
                break;
            }
            case "fetchsource": {
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    this.getModel().deleteEntryData("fetchfieldentry");
                    this.getModel().deleteEntryData(RELATION_ENTITY);
                    this.getModel().deleteEntryData("fetchsortentry");
                    this.cleanProrationFieldValue();
                    break;
                }
                this.getModel().beginInit();
                this.getModel().setValue(CHANGE_FETCH_SOURCE, (Object)oldValue);
                this.getModel().endInit();
                this.getView().updateView(CHANGE_FETCH_SOURCE);
                break;
            }
            case "calculationfetch": {
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap2"});
                    break;
                }
                this.getModel().beginInit();
                this.getModel().setValue(CHANGE_FETCH_CAL, (Object)Boolean.FALSE);
                this.getModel().endInit();
                this.getView().updateView(CHANGE_FETCH_CAL);
                break;
            }
            case "deletefetchfieldentry": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                this.deleteEntry("fetchfieldentry");
                this.setFetchFieldAuth();
                break;
            }
            case "deleterelationentry": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                this.deleteEntry(RELATION_ENTITY);
                break;
            }
            case "deletedatasortentry": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                this.deleteEntry("fetchsortentry");
                break;
            }
            case "fetch_too_many_notify": 
            case "checkFetchItemQuote": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("save", "false");
                this.getView().invokeOperation("save", operateOption);
                break;
            }
            case "checkFetchItemQuoteDisable": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("disable", "false");
                this.getView().invokeOperation("disable", operateOption);
                break;
            }
            case "checkEntryFlag": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("save", "false");
                operateOption.setVariableValue(KEY_CHECK_ENTRY, "false");
                this.getView().invokeOperation("save", operateOption);
                break;
            }
            case "checkEntrySizeFlag": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("save", "false");
                operateOption.setVariableValue(KEY_CHECK_ENTRY, "false");
                operateOption.setVariableValue(callBackId, "false");
                this.getView().invokeOperation("save", operateOption);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (ObjectUtils.isEmpty((Object)returnData)) {
            this.getPageCache().remove(CACHE_KEY_CONDITION_ENTRY_ROWINDEX);
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(RELATION_ENTITY);
        int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
        int index = 0;
        if (selectedRows.length > 0) {
            index = selectedRows[0];
        }
        DynamicObjectCollection conditionEntry = this.getModel().getEntryEntity(RELATION_ENTITY);
        String f7Source = this.getPageCache().get(KEY_F7SOURCE);
        if (SWCStringUtils.equals((String)actionId, (String)f7Source)) {
            ListSelectedRowCollection selected = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (SWCListUtils.isEmpty((List)selected)) {
                return;
            }
            StringBuilder valueSb = new StringBuilder();
            for (ListSelectedRow rowData : selected) {
                if (valueSb.length() > 0) {
                    valueSb.append(';');
                }
                valueSb.append(rowData.getPrimaryKeyValue());
            }
            this.getModel().setValue(KEY_COMPAREVALUETEXT, (Object)valueSb.toString(), index);
            this.getModel().setValue(KEY_COMPAREVALUE, (Object)valueSb.toString(), index);
        }
        switch (actionId) {
            case "fetchitem": {
                ListSelectedRowCollection selected = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                int entryIndex = this.getModel().getEntryCurrentRowIndex("fetchfieldentry");
                long fetchItem = (Long)ObjectConverter.convert((Object)selected.get(0).getPrimaryKeyValue(), Long.class, (boolean)true);
                this.getModel().beginInit();
                this.getModel().setValue("fetchitem", (Object)fetchItem, entryIndex);
                this.getModel().endInit();
                this.getView().updateView("fetchitem", entryIndex);
                break;
            }
            case "fetchfieldentry": {
                this.setQueryFields((String)returnData, "fetchfieldentry", true);
                this.setFetchFieldAuth();
                break;
            }
            case "relationentity": {
                String rowIndex = this.getPageCache().get(CACHE_KEY_CONDITION_ENTRY_ROWINDEX);
                if (SWCStringUtils.isEmpty((String)rowIndex)) {
                    this.setQueryFields((String)returnData, RELATION_ENTITY, false);
                } else {
                    int dataIndex = Integer.parseInt(rowIndex);
                    this.setConditionEntryField(dataIndex, (String)returnData, false);
                }
                this.setConditionLogic();
                this.getPageCache().remove(CACHE_KEY_CONDITION_ENTRY_ROWINDEX);
                break;
            }
            case "fetchsortentry": {
                this.setQueryFields((String)returnData, "fetchsortentry", true);
                break;
            }
            case "hsbs_fetchitem": 
            case "hsbs_supportitem": {
                ListSelectedRowCollection fetchItemFilter = (ListSelectedRowCollection)returnData;
                if (CollectionUtils.isEmpty((Collection)fetchItemFilter)) {
                    return;
                }
                Long itemId = (Long)fetchItemFilter.get(0).getPrimaryKeyValue();
                this.getModel().setValue(KEY_COMPAREVALUETEXT, (Object)fetchItemFilter.get(0).getName(), index);
                this.getModel().setValue(KEY_COMPAREVALUE, (Object)FetchConfigHelper.getItemUniqueCodeByEntityAndId((String)actionId, (Long)itemId), index);
                this.getView().updateView(KEY_COMPAREVALUETEXT, index);
                this.getView().updateView(KEY_COMPAREVALUE, index);
                break;
            }
            case "hsbs_itemsrcfield": {
                Map fieldMap = (Map)ObjectConverter.convert((Object)returnData, Map.class, (boolean)true);
                if (ObjectUtils.isEmpty((Object)fieldMap)) {
                    return;
                }
                String clickStatus = (String)fieldMap.get("clickStatus");
                if (!SWCStringUtils.equals((String)clickStatus, (String)"ok")) break;
                DynamicObject obj = (DynamicObject)fieldMap.get("fieldInfo");
                PageCache pageCache = new PageCache(this.getView().getPageId());
                int rowNum = Integer.parseInt(pageCache.get("opRowNum"));
                String srcFieldStr = obj.get("srcfieldname") + "(" + obj.get("srcfieldnum") + ")";
                this.getModel().setValue("srcfieldnum", (Object)srcFieldStr, rowNum);
                this.getModel().setValue("srcfield", obj.get("srcfieldnum"), rowNum);
                break;
            }
            case "comparetype": 
            case "comparevaluetype": {
                Map data = (Map)returnData;
                String value = (String)data.get("value");
                if (SWCStringUtils.equals((String)actionId, (String)KEY_COMPARETYPE)) {
                    if (SWCStringUtils.isEmpty((String)value)) {
                        this.getModel().setValue(KEY_COMPARETYPE, null, index);
                        this.getModel().setValue(KEY_COMPARETYPEVALUE, null, index);
                        this.getModel().setValue(KEY_COMPAREVALUETYPE, null, index);
                        this.getModel().setValue(KEY_VALUETYPE, null, index);
                        break;
                    }
                    RuleOperatorEnum opEnum = RuleOperatorEnum.getEnum((String)value);
                    if (opEnum != null) {
                        this.getModel().setValue(KEY_COMPARETYPE, (Object)opEnum.getName(), index);
                        this.getModel().setValue(KEY_COMPARETYPEVALUE, (Object)opEnum.getValue(), index);
                    }
                } else if (SWCStringUtils.equals((String)actionId, (String)KEY_COMPAREVALUETYPE)) {
                    if (SWCStringUtils.isEmpty((String)value)) {
                        this.getModel().setValue(KEY_COMPAREVALUETYPE, null, index);
                        this.getModel().setValue(KEY_VALUETYPE, null, index);
                        break;
                    }
                    ConditionValueTypeEnum valueTypeEnum = ConditionValueTypeEnum.getEnumByCode((String)value);
                    if (valueTypeEnum != null) {
                        this.getModel().setValue(KEY_COMPAREVALUETYPE, (Object)valueTypeEnum.getDesc(), index);
                        this.getModel().setValue(KEY_VALUETYPE, (Object)valueTypeEnum.getCode(), index);
                    }
                }
                this.checkEntryCompareValueType(index, conditionEntry);
                break;
            }
            case "person": 
            case "task": 
            case "enum": 
            case "comparevaluetext": {
                Map map = (Map)returnData;
                if (map == null || map.size() <= 0) break;
                String name = (String)map.get("name");
                String comparevalue = (String)map.get("value");
                String comparevalueStr = "";
                String dataType = (String)map.get("dataType");
                if (SWCStringUtils.isEmpty((String)name) && SWCStringUtils.equals((String)"Date", (String)dataType)) {
                    try {
                        comparevalueStr = SWCInteDateTimeUtil.formateDate((Date)SWCDateTimeUtils.parseDate((String)comparevalue, (String)"yyyy-MM-dd"));
                    }
                    catch (ParseException exception) {
                        logger.error("date parse error", (Throwable)exception);
                    }
                } else {
                    comparevalueStr = comparevalue;
                }
                this.getModel().setValue(KEY_COMPAREVALUETEXT, (Object)(SWCStringUtils.isEmpty((String)name) ? comparevalueStr : name), index);
                this.getModel().setValue(KEY_COMPAREVALUE, (Object)comparevalue, index);
                break;
            }
            case "prorationstartdatename": 
            case "prorationenddatename": {
                this.setProrationField((String)returnData, actionId);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key;
        switch (key = event.getProperty().getName()) {
            case "fetchitem": {
                this.setFetchItemsubjectVF7Filter(event);
                break;
            }
            case "fetchsource": {
                this.setFetchSourcesF7Filter(event);
                break;
            }
        }
    }

    private void initFieldEntrySumType() {
        DynamicObjectCollection fieldEntity = this.getModel().getEntryEntity("fetchfieldentry");
        for (int i = 0; i < fieldEntity.size(); ++i) {
            DynamicObject entryObj = (DynamicObject)fieldEntity.get(i);
            String dataType = entryObj.getString("datatype");
            if (SWCStringUtils.equals((String)ConditionFieldTypeEnum.TYPE_DATE.getCode(), (String)dataType) || SWCStringUtils.equals((String)ConditionFieldTypeEnum.TYPE_TEXT.getCode(), (String)dataType)) {
                this.getModel().setValue("sumtype", (Object)"2", i);
                continue;
            }
            this.getModel().setValue("sumtype", (Object)FETCHCONFIG_CONDITIONLOGIC_TYPE_AND, i);
        }
    }

    private void cleanFieldEntryFetchItem(String ... fields) {
        DynamicObjectCollection fieldEntity = this.getModel().getEntryEntity("fetchfieldentry");
        this.getModel().beginInit();
        for (int i = 0; i < fieldEntity.size(); ++i) {
            this.clearFilterEntryField(i, fields);
        }
        this.getModel().endInit();
        this.getView().updateView("fetchfieldentry");
    }

    private void setProrationField(String fields, String actionId) {
        Map<String, Map<String, String>> propertyMap = this.assemblePropertyMap();
        Map<String, String> propertyCodeMap = propertyMap.get("codeMap");
        Map<String, String> propertyNameMap = propertyMap.get("nameMap");
        String fullField = fields.replace('{', ' ').replace('}', ' ').trim();
        String field = fullField.substring(fullField.indexOf(46) + 1);
        String fieldType = propertyCodeMap.get(field);
        if (SWCStringUtils.isNotEmpty((String)fieldType) && !SWCStringUtils.equals((String)"id", (String)field) && SWCStringUtils.equals((String)ConditionFieldTypeEnum.TYPE_ID.getCode(), (String)fieldType)) {
            fullField = fullField + ".id";
        }
        String fieldName = propertyNameMap.get(fullField.substring(fullField.indexOf(46) + 1));
        if (SWCStringUtils.equals((String)KEY_PRORATIONSTARTNAME, (String)actionId)) {
            this.getModel().setValue(actionId, (Object)fieldName);
            this.getModel().setValue(KEY_PRORATIONSTARTFIELD, (Object)field);
        } else {
            this.getModel().setValue(actionId, (Object)fieldName);
            this.getModel().setValue(KEY_PRORATIONENDFIELD, (Object)field);
        }
    }

    private void initProrationSwitch() {
        TextEdit end;
        TextEdit start;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        boolean prorationSwitch = dataEntity.getBoolean(KEY_PRORATION_SWITCH);
        if (!prorationSwitch) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_PRORATIONSTARTNAME, KEY_PRORATIONENDNAME});
            start = (TextEdit)this.getControl(KEY_PRORATIONSTARTNAME);
            end = (TextEdit)this.getControl(KEY_PRORATIONENDNAME);
            start.setMustInput(false);
            end.setMustInput(false);
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_PRORATIONSTARTNAME, KEY_PRORATIONENDNAME});
            start = (TextEdit)this.getControl(KEY_PRORATIONSTARTNAME);
            end = (TextEdit)this.getControl(KEY_PRORATIONENDNAME);
            start.setMustInput(true);
            end.setMustInput(true);
        }
        String fetchSource = dataEntity.getString(CHANGE_FETCH_SOURCE);
        if (SWCStringUtils.isEmpty((String)fetchSource)) {
            return;
        }
        Map<String, Map<String, String>> propertyMap = this.assemblePropertyMap();
        Map<String, String> propertyNameMap = propertyMap.get("nameMap");
        String startField = dataEntity.getString(KEY_PRORATIONSTARTFIELD);
        String endField = dataEntity.getString(KEY_PRORATIONENDFIELD);
        this.getModel().setValue(KEY_PRORATIONSTARTNAME, (Object)propertyNameMap.get(startField));
        this.getModel().setValue(KEY_PRORATIONENDNAME, (Object)propertyNameMap.get(endField));
    }

    private void initTips() {
        Map promptMap = (Map)SWCMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSService", (String)"queryPromptIdAndContent", (Object[])new Object[]{this.getModel().getDataEntityType().getName(), "hintap", this.getModel().getDataEntity()});
        logger.info("\u4e2d\u53f0\u63d0\u793a\u8bed\u8fd4\u56de\u5185\u5bb9\uff1a{}", JSONObject.toJSON((Object)promptMap));
        Boolean isShow = Boolean.FALSE;
        Hint hintAp = (Hint)this.getControl("hintap");
        if (hintAp != null) {
            for (Map.Entry entry : promptMap.entrySet()) {
                Long key = (Long)entry.getKey();
                String value = (String)entry.getValue();
                if (!SWCStringUtils.isNotEmpty((String)value)) continue;
                hintAp.setContent(key, value);
                isShow = Boolean.TRUE;
            }
        }
        this.getView().setVisible(isShow, new String[]{"flexpanelap"});
    }

    private void cleanProrationFieldValue() {
        this.getModel().setValue(KEY_PRORATIONSTARTFIELD, null);
        this.getModel().setValue(KEY_PRORATIONENDFIELD, null);
        this.getModel().setValue(KEY_PRORATIONSTARTNAME, null);
        this.getModel().setValue(KEY_PRORATIONENDNAME, null);
    }

    private void initConditionLogicBtnName() {
        HashMap andArgMap = new HashMap(1);
        HashMap<String, String> andNameMap = new HashMap<String, String>(1);
        HashMap orArgMap = new HashMap(1);
        HashMap<String, String> orNameMap = new HashMap<String, String>(1);
        String langKey = RequestContext.get().getLang().name();
        andNameMap.put(langKey, ConditionLogicTypeEnum.AND.getName().getLocaleString().getLocaleValue());
        andArgMap.put("text", andNameMap);
        this.getView().updateControlMetadata(BTN_AND, andArgMap);
        orNameMap.put(langKey, ConditionLogicTypeEnum.OR.getName().getLocaleString().getLocaleValue());
        orArgMap.put("text", orNameMap);
        this.getView().updateControlMetadata(BTN_OR, orArgMap);
    }

    private void clearFilterEntryByDimensionality() {
        String dimensionality = this.getModel().getDataEntity().getString(CHANGE_DIMENSIONALITY);
        DynamicObjectCollection conditionEntry = this.getModel().getEntryEntity(RELATION_ENTITY);
        if (SWCListUtils.isEmpty((List)conditionEntry)) {
            return;
        }
        ArrayList<String> fetchItemCodeList = new ArrayList<String>(10);
        for (DynamicObject dyObj : conditionEntry) {
            String valueType = dyObj.getString(KEY_VALUETYPE);
            String filtervalue = dyObj.getString(KEY_COMPAREVALUE);
            if (!SWCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_FTITEM.getCode(), (String)valueType) || !SWCStringUtils.isNotEmpty((String)filtervalue)) continue;
            fetchItemCodeList.add(filtervalue);
        }
        Map<String, String> fetchItemDimenMap = this.assembleFetchItemDimenMap(fetchItemCodeList);
        for (int i = 0; i < conditionEntry.size(); ++i) {
            boolean noMatchFlag;
            DynamicObject dyObj = (DynamicObject)conditionEntry.get(i);
            String valueType = dyObj.getString(KEY_VALUETYPE);
            String filtervalue = dyObj.getString(KEY_COMPAREVALUE);
            if (SWCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_FTITEM.getCode(), (String)valueType) && SWCStringUtils.isNotEmpty((String)filtervalue)) {
                String itemDimen = fetchItemDimenMap.get(filtervalue);
                if (SWCStringUtils.equals((String)FETCHCONFIG_CONDITIONLOGIC_TYPE_AND, (String)dimensionality) && !SWCStringUtils.equals((String)dimensionality, (String)itemDimen)) {
                    this.clearFilterEntryField(i, KEY_COMPAREVALUETEXT, KEY_COMPAREVALUE);
                }
            }
            boolean bl = noMatchFlag = SWCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_PERSON.getCode(), (String)valueType) && SWCStringUtils.equals((String)dimensionality, (String)FETCHCONFIG_CONDITIONLOGIC_TYPE_AND) || SWCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_TASK.getCode(), (String)valueType) && SWCStringUtils.equals((String)dimensionality, (String)"0");
            if (!noMatchFlag) continue;
            this.clearFilterEntryField(i, KEY_COMPAREVALUETEXT, KEY_COMPAREVALUE, KEY_COMPAREVALUETYPE, KEY_VALUETYPE);
        }
    }

    private Map<String, String> assembleFetchItemDimenMap(List<String> fetchItemCodeList) {
        HashMap<String, String> fetchItemMap = new HashMap<String, String>(16);
        FetchConfigHelper fetchConfigHelper = new FetchConfigHelper();
        DynamicObject[] dynamicObjects = fetchConfigHelper.selectFetchItemListByCode(fetchItemCodeList);
        if (dynamicObjects.length == 0) {
            return fetchItemMap;
        }
        for (DynamicObject dyObj : dynamicObjects) {
            String uniquecode = dyObj.getString("fetchitem.uniquecode");
            String dimensionality = dyObj.getString("fetchconfig.dimensionality");
            fetchItemMap.put(uniquecode, dimensionality);
        }
        return fetchItemMap;
    }

    private void checkEntryCompareValueType(int index, DynamicObjectCollection conditionEntry) {
        boolean checkMultiData;
        String calingFetch;
        DynamicObject entryObj = (DynamicObject)conditionEntry.get(index);
        String valueType = entryObj.getString(KEY_VALUETYPE);
        String fieldType = entryObj.getString(KEY_FIELDTYPE);
        String compareTypeValue = entryObj.getString(KEY_COMPARETYPEVALUE);
        String compareValue = entryObj.getString(KEY_COMPAREVALUE);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String dimensionality = dataEntity.getString(CHANGE_DIMENSIONALITY);
        boolean checkFlag = this.checkHasSameCompareValueType(compareTypeValue, valueType, fieldType, dimensionality, calingFetch = dataEntity.getString(CHANGE_FETCH_CAL));
        if (!checkFlag) {
            this.cleanEntryRowData(index, KEY_COMPAREVALUETYPE, KEY_VALUETYPE, KEY_COMPAREVALUETEXT, KEY_COMPAREVALUE);
        }
        boolean bl = checkMultiData = (SWCStringUtils.equals((String)RuleOperatorEnum.EQUAL.getValue(), (String)compareTypeValue) || SWCStringUtils.equals((String)RuleOperatorEnum.NOT_EQUAL.getValue(), (String)compareTypeValue)) && compareValue.contains(";");
        if (checkMultiData) {
            this.cleanEntryRowData(index, KEY_COMPAREVALUETEXT, KEY_COMPAREVALUE);
        }
    }

    private boolean checkHasSameCompareValueType(String compareType, String valueType, String fieldType, String dimensionality, String calingFetch) {
        List valueTypeList1 = ConditionFieldTypeEnum.getValueTypeByCondition((String)compareType, (String)calingFetch, (String)dimensionality);
        List valueTypeList2 = ConditionFieldTypeEnum.getValueTypeByFieldType((String)fieldType, (String)calingFetch, (String)dimensionality);
        if (!SWCListUtils.isEmpty((List)valueTypeList1) && !SWCListUtils.isEmpty((List)valueTypeList2)) {
            List tempList = valueTypeList1.stream().filter(single -> valueTypeList2.contains(single)).collect(Collectors.toList());
            if (SWCListUtils.isEmpty(tempList)) {
                return false;
            }
            for (ConditionValueTypeEnum single2 : tempList) {
                if (!SWCStringUtils.equals((String)single2.getCode(), (String)valueType)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkConditionField(DynamicObject row, String key) {
        String field = row.getString(KEY_FIELDNAME);
        String compareType = row.getString(KEY_COMPARETYPE);
        String compareValueType = row.getString(KEY_COMPAREVALUETYPE);
        if (SWCStringUtils.equals((String)key, (String)KEY_COMPARETYPE) && SWCStringUtils.isEmpty((String)field)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6761\u4ef6\u5b57\u6bb5\u3002", (String)"FetchConfigEdit_59", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return true;
        }
        if (SWCStringUtils.equals((String)key, (String)KEY_COMPAREVALUETYPE) && SWCStringUtils.isEmpty((String)compareType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5224\u65ad\u6761\u4ef6\u3002", (String)"FetchConfigEdit_68", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return true;
        }
        if (SWCStringUtils.equals((String)key, (String)KEY_COMPAREVALUETEXT) && SWCStringUtils.isEmpty((String)compareValueType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6bd4\u8f83\u503c\u7c7b\u578b\u3002", (String)"FetchConfigEdit_69", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void setConditionEntryField(int entryIndex, String returnData, boolean isFilterBaseData) {
        Map<String, String> rowMap;
        Map<String, Map<String, String>> propertyMap = this.assemblePropertyMap();
        Map<String, String> propertyClassMap = propertyMap.get("codeMap");
        String queryId = this.getModel().getDataEntity().getString("fetchsource.id");
        String fullFieldName = returnData.replace('{', ' ').replace('}', ' ').trim();
        String fieldName = fullFieldName.substring(fullFieldName.indexOf(46) + 1);
        String fieldType = propertyClassMap.get(fieldName);
        if (SWCStringUtils.isNotEmpty((String)fieldType) && !SWCStringUtils.equals((String)"id", (String)fieldName) && SWCStringUtils.equals((String)ConditionFieldTypeEnum.TYPE_ID.getCode(), (String)fieldType) && !SWCStringUtils.equals((String)"boid", (String)fieldName)) {
            fullFieldName = fullFieldName + ".id";
        }
        if ((rowMap = this.getRowInfo(fullFieldName, queryId, new ArrayList<String>(0), isFilterBaseData)) == null) {
            return;
        }
        String fieldAlias = rowMap.get("fieldAlias");
        String displayName = rowMap.get("displayName");
        this.getModel().setValue(KEY_FIELDNAME, (Object)displayName, entryIndex);
        this.getModel().setValue(KEY_FILTERFIELD, (Object)fieldAlias, entryIndex);
        this.getModel().setValue(KEY_FIELDTYPE, (Object)fieldType, entryIndex);
    }

    private String assembleConditionLogicCode(String conditionLogicText) {
        String conditionLogicCode = conditionLogicText.replaceAll(ResManager.loadKDString((String)"\u5e76\u4e14", (String)"FetchConfigEdit_39", (String)SYSTEM_TYPE, (Object[])new Object[0]), ConditionLogicTypeEnum.AND.getWord()).replaceAll(ResManager.loadKDString((String)"\u6216\u8005", (String)"FetchConfigEdit_40", (String)SYSTEM_TYPE, (Object[])new Object[0]), ConditionLogicTypeEnum.OR.getWord());
        return conditionLogicCode;
    }

    private void updateField(int index, String ... fields) {
        this.getModel().beginInit();
        for (String field : fields) {
            this.getView().updateView(field, index);
        }
        this.getModel().endInit();
    }

    private void fillConditionLogic(String key) {
        String name = "";
        switch (key) {
            case "btnand": {
                name = ResManager.loadKDString((String)"\u5e76\u4e14", (String)"FetchConfigEdit_39", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                break;
            }
            case "btnor": {
                name = ResManager.loadKDString((String)"\u6216\u8005", (String)"FetchConfigEdit_40", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                break;
            }
            case "left": {
                name = "(";
                break;
            }
            case "right": {
                name = ")";
                break;
            }
        }
        FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)key, (String)KEY_CONDITIONLOGICTEXT, (String)name);
    }

    private void setConditionLogic() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String conditionLogicType = dataEntity.getString(KEY_RADIOGROUPFIELD);
        DynamicObjectCollection relationCollection = this.getModel().getEntryEntity(RELATION_ENTITY);
        StringBuilder conditionLogicSb = new StringBuilder();
        StringBuilder conditionLogicTextSb = new StringBuilder();
        if (!SWCListUtils.isEmpty((List)relationCollection)) {
            for (int index = 0; index < relationCollection.size(); ++index) {
                DynamicObject dynamicObject = (DynamicObject)relationCollection.get(index);
                String conditionNumber = dynamicObject.getString("conditionnumber");
                if (index == 0) {
                    conditionLogicSb.append(conditionNumber).append(' ');
                    conditionLogicTextSb.append(conditionNumber).append(' ');
                    continue;
                }
                conditionLogicSb.append(ConditionLogicTypeEnum.getByCode((String)conditionLogicType).getWord()).append(' ').append(conditionNumber).append(' ');
                conditionLogicTextSb.append(ConditionLogicTypeEnum.getByCode((String)conditionLogicType).getDesc()).append(' ').append(conditionNumber).append(' ');
            }
        }
        if (!SWCStringUtils.equals((String)ConditionLogicTypeEnum.CUST.getCode(), (String)conditionLogicType)) {
            this.getModel().setValue("conditionlogiccode", (Object)conditionLogicSb.toString());
            this.getView().updateView("conditionlogiccode");
            this.getModel().setValue(KEY_CONDITIONLOGICTEXT, (Object)conditionLogicTextSb.toString());
            this.getView().updateView(KEY_CONDITIONLOGICTEXT);
        }
    }

    private void showInitPage() {
        String dimensionality = (String)this.getModel().getValue(CHANGE_DIMENSIONALITY);
        boolean calPerson = StringUtils.equals((CharSequence)dimensionality, (CharSequence)"0");
        boolean taskDimensionality = StringUtils.equals((CharSequence)dimensionality, (CharSequence)FETCHCONFIG_CONDITIONLOGIC_TYPE_AND);
        this.getView().setVisible(Boolean.valueOf(calPerson), new String[]{CHANGE_FETCH_CAL});
        String enable = this.getModel().getDataEntity().getString("enable");
        boolean proration = this.getModel().getDataEntity().getBoolean(KEY_PRORATION_SWITCH);
        boolean enableStatus = SWCStringUtils.equals((String)enable, (String)FETCHCONFIG_CONDITIONLOGIC_TYPE_AND) || SWCStringUtils.equals((String)enable, (String)"0");
        this.getView().setEnable(Boolean.valueOf(!enableStatus), new String[]{"number", "areatype", "country"});
        if (taskDimensionality) {
            this.getModel().setValue(CHANGE_FETCH_CAL, (Object)0);
            this.getModel().setValue(KEY_PRORATION_SWITCH, (Object)0);
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_PRORATION_SWITCH, KEY_PRORATIONSTARTNAME, KEY_PRORATIONENDNAME});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_PRORATION_SWITCH});
            if (proration) {
                this.getView().setVisible(Boolean.TRUE, new String[]{KEY_PRORATIONSTARTNAME, KEY_PRORATIONENDNAME});
            }
        }
        this.checkAreaType();
    }

    private void initConditionLogicData() {
        this.setConditionLogicTextVisible();
        String conditionLogicCode = this.getModel().getDataEntity().getString("conditionlogiccode");
        if (SWCStringUtils.isNotEmpty((String)conditionLogicCode)) {
            String conditionLogicText = conditionLogicCode.replaceAll(ConditionLogicTypeEnum.AND.getWord(), ConditionLogicTypeEnum.AND.getDesc()).replaceAll(ConditionLogicTypeEnum.OR.getWord(), ConditionLogicTypeEnum.OR.getDesc());
            this.getModel().setValue(KEY_CONDITIONLOGICTEXT, (Object)conditionLogicText);
        }
    }

    private void setConditionLogicTextVisible() {
        String conditionLogic = (String)this.getModel().getValue(KEY_RADIOGROUPFIELD);
        if (SWCStringUtils.equals((String)"3", (String)conditionLogic)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_CONDITIONLOGICTEXT, BTN_AND, BTN_OR, BTN_LEFT, BTN_RIGHT});
            this.initConditionLogicBtnName();
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_CONDITIONLOGICTEXT, BTN_AND, BTN_OR, BTN_LEFT, BTN_RIGHT});
        }
    }

    private void cleanEntryRowData(int index, String ... fields) {
        this.getModel().beginInit();
        for (String field : fields) {
            this.getModel().setValue(field, null, index);
            this.getView().updateView(field, index);
        }
        this.getModel().endInit();
    }

    private void openCompareValueForm(String caption, DynamicObject row, String key) {
        String fieldType = row.getString(KEY_FIELDTYPE);
        String compareValueType = row.getString(KEY_VALUETYPE);
        String fetchSource = this.getModel().getDataEntity().getDynamicObject(CHANGE_FETCH_SOURCE).getString("id");
        String fieldCode = row.getString(KEY_FILTERFIELD);
        String selectedData = row.getString(KEY_COMPAREVALUE);
        String compareType = row.getString(KEY_COMPARETYPEVALUE);
        Map<String, Map<String, String>> propertyMap = this.assemblePropertyMap();
        Map<String, String> sourceMap = propertyMap.get("sourceMap");
        boolean isMultiSelect = ConditionFieldTypeEnum.getMultiSelectByCompareType((String)compareType);
        switch (fieldType) {
            case "Id": {
                if (SWCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_PERSON.getCode(), (String)compareValueType)) {
                    this.openCompareTypeComboForm(caption, row, "person", fetchSource, fieldCode, "");
                    break;
                }
                if (SWCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_TASK.getCode(), (String)compareValueType)) {
                    this.openCompareTypeComboForm(caption, row, "task", fetchSource, fieldCode, "");
                    break;
                }
                if (!SWCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_FIXED.getCode(), (String)compareValueType)) break;
                String f7Source = SWCStringUtils.equals((String)"id", (String)fieldCode) || SWCStringUtils.equals((String)"boid", (String)fieldCode) ? fetchSource : sourceMap.get(fieldCode);
                MainEntityType mainEntity = EntityMetadataCache.getDataEntityType((String)f7Source);
                if (mainEntity instanceof QueryEntityType) {
                    f7Source = ((QueryEntityType)mainEntity).getEntityName();
                }
                if (!SWCStringUtils.isNotEmpty((String)f7Source)) break;
                this.getPageCache().put(KEY_F7SOURCE, f7Source);
                this.openSourceFieldF7(f7Source, fieldType, isMultiSelect, selectedData);
                break;
            }
            case "Enum": {
                if (!SWCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_FIXED.getCode(), (String)compareValueType)) break;
                this.openCompareTypeComboForm(caption, row, key, fetchSource, fieldCode, "");
                break;
            }
            case "BigDecimal": 
            case "Date": 
            case "String": {
                if (SWCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_FIXED.getCode(), (String)compareValueType)) {
                    this.openCompareTypeComboForm(caption, row, key, fetchSource, fieldCode, "");
                    break;
                }
                if (SWCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_FTITEM.getCode(), (String)compareValueType)) {
                    this.openSourceFieldF7("hsbs_fetchitem", fieldType, isMultiSelect, selectedData);
                    break;
                }
                if (!SWCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_SPITEM.getCode(), (String)compareValueType)) break;
                this.openSourceFieldF7("hsbs_supportitem", fieldType, isMultiSelect, selectedData);
                break;
            }
        }
    }

    private void openSourceFieldF7(String entity, String fieldType, boolean isMultiSelect, String selectedData) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(1);
        if (!this.setCountryFilter(filterList)) {
            return;
        }
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)entity, (boolean)isMultiSelect);
        if (SWCStringUtils.equals((String)entity, (String)"hsbs_fetchitem") || SWCStringUtils.equals((String)entity, (String)"hsbs_supportitem")) {
            ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
            HashSet matchTypeIdSet = SWCStringUtils.equals((String)fieldType, (String)CalDataTypeEnum.DATE.getCode()) ? CalDataTypeEnum.DATE.getMatchTypeIdSet() : (SWCStringUtils.equals((String)fieldType, (String)CalDataTypeEnum.BIGDECIMAL.getCode()) ? CalDataTypeEnum.BIGDECIMAL.getMatchTypeIdSet() : CalDataTypeEnum.STRING.getMatchTypeIdSet());
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(new QFilter("datatype", "in", (Object)matchTypeIdSet));
            qFilters.add(new QFilter("status", "=", (Object)"C"));
            qFilters.add(new QFilter("enable", "=", (Object)FETCHCONFIG_CONDITIONLOGIC_TYPE_AND));
            if (SWCStringUtils.equals((String)entity, (String)"hsbs_fetchitem")) {
                List fetchItemIdList;
                String dimensionality = (String)this.getView().getModel().getValue(CHANGE_DIMENSIONALITY);
                List relatedFetchItemId = FetchConfigHelper.getRelatedFetchItemIdByDimensionality((String)dimensionality);
                qFilters.add(new QFilter("datatype", "in", (Object)matchTypeIdSet));
                qFilters.add(new QFilter("id", "in", (Object)relatedFetchItemId));
                DynamicObjectCollection filterEntry = this.getModel().getEntryEntity("fetchfieldentry");
                if (!SWCListUtils.isEmpty((List)filterEntry) && !SWCListUtils.isEmpty(fetchItemIdList = filterEntry.stream().map(single -> single.getLong("fetchitem.id")).collect(Collectors.toList()))) {
                    qFilters.add(new QFilter("id", "not in", fetchItemIdList));
                }
            }
            qFilters.addAll(filterList);
            selectedData = FetchConfigHelper.getItemIdByEntityAndUniquecode((String)entity, (String)selectedData);
        }
        if (SWCStringUtils.isNotEmpty((String)selectedData)) {
            Object[] ids = selectedData.split(";");
            showParameter.setSelectedRows(ids);
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, entity);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void openCompareTypeComboForm(String caption, DynamicObject row, String key, String fetchSource, String fieldCode, String dimensionality) {
        String fieldType = row.getString(KEY_FIELDTYPE);
        String compareType = row.getString(KEY_COMPARETYPEVALUE);
        String compareValue = row.getString(KEY_COMPAREVALUE);
        String compareValueType = row.getString(KEY_VALUETYPE);
        String calingFetch = this.getModel().getDataEntity().getString(CHANGE_FETCH_CAL);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCaption(caption);
        showParameter.setFormId("hsbs_combovalueinput");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("fieldType", (Object)fieldType);
        showParameter.setCustomParam("field", (Object)key);
        showParameter.setCustomParam("compareType", (Object)compareType);
        showParameter.setCustomParam("fetchSource", (Object)fetchSource);
        showParameter.setCustomParam("fieldCode", (Object)fieldCode);
        showParameter.setCustomParam(CHANGE_DIMENSIONALITY, (Object)dimensionality);
        showParameter.setCustomParam("calingFetch", (Object)calingFetch);
        showParameter.setCustomParam("compareValue", (Object)compareValue);
        showParameter.setCustomParam("compareValueType", (Object)compareValueType);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void setFetchItemsubjectVF7Filter(BeforeF7SelectEvent event) {
        if (StringUtils.equals((CharSequence)((String)this.getModel().getValue("areatype")), (CharSequence)"2") && ObjectUtils.isEmpty((Object)this.getModel().getValue("country"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u56fd\u5bb6/\u5730\u533a\u3002", (String)"FetchConfigEdit_14", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("fetchfieldentry");
        ArrayList<String> list = new ArrayList<String>(10);
        entryEntity.stream().forEach(param -> {
            String fetchItem = param.getString("fetchitem.number");
            if (StringUtils.isNotBlank((CharSequence)fetchItem)) {
                list.add(fetchItem);
            }
        });
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int focusRow = proxy.getEntryState("fetchfieldentry").getFocusRow();
        FormShowParameter parameter = event.getFormShowParameter();
        ListShowParameter listParameter = (ListShowParameter)parameter;
        ListFilterParameter listFilterParameter = listParameter.getListFilterParameter();
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        if (!this.setCountryFilter(filterList)) {
            return;
        }
        QFilter qFilter = this.getFilter(focusRow, list);
        List qFilters = listFilterParameter.getQFilters();
        qFilters.add(qFilter);
        qFilters.addAll(filterList);
        listParameter.setListFilterParameter(listFilterParameter);
        listParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "fetchitem"));
    }

    private void setFetchSourcesF7Filter(BeforeF7SelectEvent event) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        QFilter qFilter = new QFilter("modeltype", "in", (Object)new String[]{"QueryListModel", "BaseFormModel", "BillFormModel"});
        filterList.add(qFilter);
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        showParameter.getListFilterParameter().setQFilters(filterList);
    }

    private QFilter getFilter(int focusRow, List<String> list) {
        QFilter filter = new QFilter("enable", "in", (Object)FETCHCONFIG_CONDITIONLOGIC_TYPE_AND);
        DynamicObject dy = this.getModel().getEntryRowEntity("fetchfieldentry", focusRow);
        if (dy == null) {
            return filter;
        }
        String datatype = dy.getString("datatype");
        HashSet dateTypeIds = Sets.newHashSetWithExpectedSize((int)2);
        dateTypeIds.add(1030L);
        if (StringUtils.equals((CharSequence)CalDataTypeEnum.DATE.getCode(), (CharSequence)datatype)) {
            dateTypeIds.add(1050L);
        } else if (StringUtils.equals((CharSequence)CalDataTypeEnum.BIGDECIMAL.getCode(), (CharSequence)datatype)) {
            dateTypeIds.add(1010L);
        }
        boolean sumfetch = this.getView().getModel().getDataEntity().getBoolean("sumfetch");
        if (sumfetch) {
            dateTypeIds.add(1010L);
            dateTypeIds.remove(1050L);
        }
        filter.and("datatype", "in", (Object)dateTypeIds);
        long id = dy.getLong("fetchitem.id");
        if (id != 0L) {
            String number = dy.getString("fetchitem.number");
            list.remove(number);
        }
        Object enable = this.getView().getModel().getValue("enable");
        long fetchConfigId = 0L;
        if (SWCObjectUtils.equals((Object)enable, (Object)FETCHCONFIG_CONDITIONLOGIC_TYPE_AND)) {
            fetchConfigId = (Long)this.getView().getModel().getValue("id");
        }
        filter.and("number", "not in", list);
        List FetchItemIdList = FetchConfigHelper.getRelatedFetchItemIdByFetchConfigId((Long)fetchConfigId);
        filter.and("id", "not in", (Object)FetchItemIdList);
        return filter;
    }

    private boolean setCountryFilter(List<QFilter> filterList) {
        String areaType = (String)this.getModel().getValue("areatype");
        if (SWCStringUtils.equals((String)areaType, (String)FETCHCONFIG_CONDITIONLOGIC_TYPE_AND)) {
            filterList.add(new QFilter("areatype", "=", (Object)areaType));
            return true;
        }
        DynamicObject country = (DynamicObject)this.getModel().getValue("country");
        if (country == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u56fd\u5bb6/\u5730\u533a\u3002", (String)"FetchConfigEdit_14", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        QFilter qFilter = AreaHelper.addAreaFilter((long)country.getLong("id"), (String)areaType);
        filterList.add(qFilter);
        return true;
    }

    private void openChangeConfirm(String oldValue, String type, String msg) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(type, (IFormPlugin)this);
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks, null, oldValue);
    }

    private void openFetchCalculationChangeConfirm() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CHANGE_FETCH_CAL, (IFormPlugin)this);
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u8ba1\u7b97\u65f6\u53d6\u6570\u4f1a\u5f71\u54cd\u8ba1\u7b97\u6027\u80fd\uff0c\u8bf7\u8c28\u614e\u5f00\u542f\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"FetchConfigEdit_19", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        this.getView().showConfirm(msg, null, options, ConfirmTypes.Default, confirmCallBacks, null, "");
    }

    private void clearFetchField() {
        List spItemDyObjList;
        List fetchItemDyObjList;
        DynamicObjectCollection filterEntity = this.getModel().getEntryEntity(RELATION_ENTITY);
        DynamicObjectCollection fieldEntity = this.getModel().getEntryEntity("fetchfieldentry");
        long countryId = this.getModel().getDataEntity().getLong("country.id");
        String configAreaType = this.getModel().getDataEntity().getString("areatype");
        this.clearFieldEntryNotMatch(fieldEntity, countryId, configAreaType);
        ArrayList<String> fetchItemIdList = new ArrayList<String>(10);
        ArrayList<String> spItemIdList = new ArrayList<String>(10);
        this.assembleFetchAndSpItemIdList(null, filterEntity, fetchItemIdList, spItemIdList);
        Map<String, Object> fetchItemDyObjMap = new HashMap<String, DynamicObject>(16);
        Map<String, Object> spItemDyObjMap = new HashMap<String, DynamicObject>(16);
        if (!SWCListUtils.isEmpty(fetchItemIdList) && !SWCListUtils.isEmpty((List)(fetchItemDyObjList = FetchConfigHelper.getFetchSpItemDyObjList(fetchItemIdList, (String)"hsbs_fetchitem")))) {
            fetchItemDyObjMap = fetchItemDyObjList.stream().collect(Collectors.toMap(mapKey -> mapKey.getString("uniquecode"), Function.identity(), (v1, v2) -> v1));
        }
        if (!SWCListUtils.isEmpty(spItemIdList) && !SWCListUtils.isEmpty((List)(spItemDyObjList = FetchConfigHelper.getFetchSpItemDyObjList(spItemIdList, (String)"hsbs_supportitem")))) {
            spItemDyObjMap = spItemDyObjList.stream().collect(Collectors.toMap(mapKey -> mapKey.getString("uniquecode"), Function.identity(), (v1, v2) -> v1));
        }
        this.clearFilterEntryNotMatch(filterEntity, countryId, configAreaType, fetchItemDyObjMap, spItemDyObjMap);
        this.getView().updateView(RELATION_ENTITY);
        this.updateConditionEntryEnable(filterEntity);
    }

    private void clearFilterEntryNotMatch(DynamicObjectCollection filterEntity, long countryId, String configAreaType, Map<String, DynamicObject> fetchItemDyObjMap, Map<String, DynamicObject> spItemDyObjMap) {
        for (int i = 0; i < filterEntity.size(); ++i) {
            DynamicObject spObj;
            DynamicObject dynamicObject = (DynamicObject)filterEntity.get(i);
            String valueType = dynamicObject.getString(KEY_VALUETYPE);
            String compareValue = dynamicObject.getString(KEY_COMPAREVALUE);
            if (SWCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_FTITEM.getCode(), (String)valueType)) {
                DynamicObject fetchObj = fetchItemDyObjMap.get(compareValue);
                if (fetchObj == null) continue;
                String fetchAreaType = fetchObj.getString("areatype");
                long filterItemCountryId = fetchObj.getLong("country.id");
                if (SWCStringUtils.equals((String)configAreaType, (String)FETCHCONFIG_CONDITIONLOGIC_TYPE_AND)) {
                    if (SWCStringUtils.equals((String)fetchAreaType, (String)"2")) {
                        this.clearFilterEntryField(i, KEY_COMPAREVALUETEXT, KEY_COMPAREVALUE);
                    }
                } else if (SWCStringUtils.equals((String)fetchAreaType, (String)"2") && filterItemCountryId != countryId) {
                    this.clearFilterEntryField(i, KEY_COMPAREVALUETEXT, KEY_COMPAREVALUE);
                }
            }
            if (!SWCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_SPITEM.getCode(), (String)valueType) || (spObj = spItemDyObjMap.get(compareValue)) == null) continue;
            String spAreaType = spObj.getString("areatype");
            long spCountryId = spObj.getLong("country.id");
            if (SWCStringUtils.equals((String)configAreaType, (String)FETCHCONFIG_CONDITIONLOGIC_TYPE_AND)) {
                if (!SWCStringUtils.equals((String)spAreaType, (String)"2")) continue;
                this.clearFilterEntryField(i, KEY_COMPAREVALUETEXT, KEY_COMPAREVALUE);
                continue;
            }
            if (!SWCStringUtils.equals((String)spAreaType, (String)"2") || spCountryId == countryId) continue;
            this.clearFilterEntryField(i, KEY_COMPAREVALUETEXT, KEY_COMPAREVALUE);
        }
    }

    private void clearFieldEntryNotMatch(DynamicObjectCollection fieldEntity, long countryId, String configAreaType) {
        if (SWCListUtils.isEmpty((List)fieldEntity)) {
            return;
        }
        for (int i = 0; i < fieldEntity.size(); ++i) {
            DynamicObject fetchItem = ((DynamicObject)fieldEntity.get(i)).getDynamicObject("fetchitem");
            if (fetchItem == null) continue;
            String areaType = fetchItem.getString("areatype");
            long itemCountryId = fetchItem.getLong("country.id");
            if (SWCStringUtils.equals((String)configAreaType, (String)FETCHCONFIG_CONDITIONLOGIC_TYPE_AND)) {
                if (!SWCStringUtils.equals((String)areaType, (String)"2")) continue;
                this.getModel().setValue("fetchitem", null, i);
                continue;
            }
            if (!SWCStringUtils.equals((String)areaType, (String)"2") || itemCountryId == countryId) continue;
            this.getModel().setValue("fetchitem", null, i);
        }
    }

    private void clearFilterEntryField(int index, String ... fields) {
        for (String field : fields) {
            this.getModel().setValue(field, null, index);
        }
    }

    private void changeCalculationFetch() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(RELATION_ENTITY);
        DynamicObject[] dataEntitys = entryGrid.getEntryData().getDataEntitys();
        boolean calingFlag = this.getModel().getDataEntity().getBoolean(CHANGE_FETCH_CAL);
        if (!calingFlag) {
            for (int i = 0; i < dataEntitys.length; ++i) {
                String valueType = dataEntitys[i].getString(KEY_VALUETYPE);
                this.getModel().beginInit();
                if (StringUtils.equals((CharSequence)valueType, (CharSequence)ConditionValueTypeEnum.TYPE_SPITEM.getCode())) {
                    this.getView().getModel().setValue(KEY_COMPAREVALUETYPE, null, i);
                    this.getView().getModel().setValue(KEY_VALUETYPE, null, i);
                    this.getView().getModel().setValue(KEY_COMPAREVALUETEXT, null, i);
                    this.getView().getModel().setValue(KEY_COMPAREVALUE, null, i);
                }
                this.getModel().endInit();
            }
            this.getView().getModel().setValue(KEY_RADIOGROUPFIELD, (Object)FETCHCONFIG_CONDITIONLOGIC_TYPE_AND);
        }
        this.getView().setVisible(Boolean.valueOf(calingFlag), new String[]{"flexpanelap2"});
        this.getView().updateView(RELATION_ENTITY);
    }

    private void openFieldTreeAddForm(String entityId) {
        DynamicObject baseObject = this.getModel().getDataEntity();
        DynamicObject queryObj = (DynamicObject)baseObject.get(CHANGE_FETCH_SOURCE);
        if (ObjectUtils.isEmpty((Object)queryObj)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d6\u6570\u6765\u6e90\u3002", (String)"FetchConfigEdit_13", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection collection = this.getModel().getEntryEntity(entityId);
        String fieldName = "field";
        boolean showId = false;
        if (SWCStringUtils.equals((String)entityId, (String)"fetchsortentry")) {
            fieldName = "sortfield";
        } else if (SWCStringUtils.equals((String)entityId, (String)RELATION_ENTITY)) {
            fieldName = KEY_FILTERFIELD;
            showId = true;
        }
        TreeNode fieldTreeNode = this.getTreeNodes(collection, queryObj, fieldName, showId);
        if (ObjectUtils.isEmpty((Object)fieldTreeNode)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u6dfb\u52a0\u5b57\u6bb5\u3002", (String)"FetchConfigEdit_12", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        String isMultiSelect = SWCStringUtils.equals((String)"fetchfieldentry", (String)entityId) ? "true" : "false";
        this.showQueryForm(fieldTreeNode, isMultiSelect, entityId);
    }

    private void openProrationDateFieldTree(String field) {
        DynamicObject baseObject = this.getModel().getDataEntity();
        DynamicObject queryObj = (DynamicObject)baseObject.get(CHANGE_FETCH_SOURCE);
        if (ObjectUtils.isEmpty((Object)queryObj)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d6\u6570\u6765\u6e90\u3002", (String)"FetchConfigEdit_13", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        TreeNode fieldTreeNode = this.getTreeNodes(null, queryObj, "", false);
        if (ObjectUtils.isEmpty((Object)fieldTreeNode)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u6dfb\u52a0\u5b57\u6bb5\u3002", (String)"FetchConfigEdit_12", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        this.showQueryForm(fieldTreeNode, "false", field);
    }

    private TreeNode getTreeNodes(DynamicObjectCollection collection, DynamicObject queryObj, String fieldName, boolean showId) {
        HashSet<String> fieldIdSet;
        String queryPK = queryObj.getString("id");
        MainEntityType mainEntity = EntityMetadataCache.getDataEntityType((String)queryPK);
        if (mainEntity instanceof QueryEntityType) {
            mainEntity = EntityMetadataCache.getDataEntityType((String)((QueryEntityType)mainEntity).getEntityName());
        }
        Map propertyMap = DataReaderHelper.getPropertyClassMap((Map)mainEntity.getAllEntities());
        try {
            this.getPageCache().put("propertyMapStr", JSONUtils.toString((Object)propertyMap));
        }
        catch (Exception exception) {
            logger.error((Throwable)exception);
        }
        TreeNode parentEntityFieldTreeNode = FetchConfigEdit.buildTreeNodesByEntityType(mainEntity, showId);
        String rootTablePrefix = parentEntityFieldTreeNode.getId().split(SHOW_FILED_SPLIT)[0];
        if (!SWCStringUtils.equals((String)fieldName, (String)KEY_FILTERFIELD) && !CollectionUtils.isEmpty((Collection)collection)) {
            fieldIdSet = new HashSet(collection.size());
            for (DynamicObject dynamicObject : collection) {
                fieldIdSet.add(rootTablePrefix + "." + dynamicObject.getString(fieldName));
            }
        } else {
            fieldIdSet = new HashSet<String>(0);
        }
        this.filterFields(parentEntityFieldTreeNode, fieldIdSet, (Map)propertyMap.get("codeMap"));
        return parentEntityFieldTreeNode;
    }

    private static TreeNode buildTreeNodesByEntityType(MainEntityType mainEntityType, boolean showId) {
        QueryEntityTreeBuildParameter parameter = new QueryEntityTreeBuildParameter(mainEntityType);
        parameter.setIncludePKField(showId);
        parameter.setOnlyPhysicsField(false);
        parameter.setDynamicText(true);
        return QueryEntityParseHelper.buildBillTreeNodes((QueryEntityTreeBuildParameter)parameter, (boolean)showId, (String)".id");
    }

    private void filterFields(TreeNode treeNode, Set<String> fieldIdSet, Map<String, String> propertyClassMap) {
        treeNode.setChildren(FetchConfigEdit.buildCopyOnWriteTreeNode(treeNode.getChildren()));
        List parentNodeList = treeNode.getChildren();
        String rootTablePrefix = treeNode.getId().split(SHOW_FILED_SPLIT)[0];
        for (TreeNode childNode : parentNodeList) {
            childNode.setChildren(FetchConfigEdit.buildCopyOnWriteTreeNode(childNode.getChildren()));
            for (TreeNode gradeChildNode : childNode.getChildren()) {
                FetchConfigEdit.doFilterFields(treeNode, childNode, gradeChildNode, fieldIdSet, rootTablePrefix, propertyClassMap);
            }
            if (CollectionUtils.isEmpty((Collection)childNode.getChildren())) {
                treeNode.deleteChildNode(childNode.getId());
            }
            this.delBranchWithoutLeaf(treeNode, childNode);
        }
    }

    private static List<TreeNode> buildCopyOnWriteTreeNode(List<TreeNode> nodes) {
        return Lists.newCopyOnWriteArrayList(nodes);
    }

    private static void doFilterFields(TreeNode grandParentNode, TreeNode parentNode, TreeNode childNode, Set<String> fieldIdSet, String prefix, Map<String, String> propertyClassMap) {
        if (CollectionUtils.isEmpty((Collection)childNode.getChildren())) {
            String nodeId = childNode.getId().replace('{', ' ').replace('}', ' ').trim();
            if (fieldIdSet.contains(nodeId)) {
                parentNode.deleteChildNode(childNode.getId());
            } else if (propertyClassMap.get(nodeId.substring(nodeId.indexOf(46) + 1)) == null) {
                parentNode.deleteChildNode(childNode.getId());
            }
            if (CollectionUtils.isEmpty((Collection)parentNode.getChildren())) {
                grandParentNode.deleteChildNode(parentNode.getId());
            }
            return;
        }
        childNode.setChildren(FetchConfigEdit.buildCopyOnWriteTreeNode(childNode.getChildren()));
        for (TreeNode branchNode : childNode.getChildren()) {
            FetchConfigEdit.doFilterFields(parentNode, childNode, branchNode, fieldIdSet, prefix, propertyClassMap);
        }
    }

    private void delBranchWithoutLeaf(TreeNode parentNode, TreeNode node) {
        if (Objects.isNull(node)) {
            return;
        }
        List childNodes = node.getChildren();
        if (Objects.isNull(childNodes)) {
            return;
        }
        for (TreeNode childNoe : childNodes) {
            this.delBranchWithoutLeaf(node, childNoe);
        }
        if (Objects.nonNull(node.getChildren()) && node.getChildren().isEmpty()) {
            parentNode.deleteChildNode(node.getId());
        }
    }

    private void showQueryForm(TreeNode entityFieldTreeNode, String isMultiSelect, String actionId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsbs_field");
        String nodesJson = SerializationUtils.toJsonString((Object)entityFieldTreeNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.getCustomParams().put("ismulti", isMultiSelect);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void setQueryFields(String fields, String actionId, boolean isFilterBaseData) {
        ArrayList<String> fieldList;
        if (SWCStringUtils.isEmpty((String)fields)) {
            return;
        }
        int entryType = this.assembleEntryType(actionId);
        Map<String, Map<String, String>> propertyMap = this.assemblePropertyMap();
        Map<String, String> propertyClassMap = propertyMap.get("codeMap");
        DynamicObjectCollection dyObjs = this.getModel().getEntryEntity(actionId);
        int numberIndex = 1;
        if (entryType == 1) {
            numberIndex = this.assembleConditionNumberIndex(dyObjs);
        }
        String fieldId = this.assembleFieldId(entryType);
        if (entryType != 1) {
            fieldList = new ArrayList<String>(10);
            for (DynamicObject dyObj : dyObjs) {
                String field = dyObj.getString(fieldId);
                fieldList.add(field);
            }
        } else {
            fieldList = new ArrayList(0);
        }
        DynamicObject object = this.getModel().getDataEntity();
        String queryId = object.getString("fetchsource.id");
        boolean sumFetch = object.getBoolean("sumfetch");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        this.initSetterField(entryType, setter, sumFetch);
        int index = 0;
        if (SWCStringUtils.equals((String)"fetchfieldentry", (String)actionId)) {
            this.assembleMultiEntryRowData(sumFetch, fields, queryId, fieldList, isFilterBaseData, entryType, propertyClassMap, numberIndex, setter, index);
        } else {
            boolean flag;
            String fullFieldName = fields.replace('{', ' ').replace('}', ' ').trim();
            String fieldName = fullFieldName.substring(fullFieldName.indexOf(46) + 1);
            String fieldType = propertyClassMap.get(fieldName);
            if (SWCStringUtils.isNotEmpty((String)fieldType) && !SWCStringUtils.equals((String)"id", (String)fieldName) && SWCStringUtils.equals((String)ConditionFieldTypeEnum.TYPE_ID.getCode(), (String)fieldType) && !SWCStringUtils.equals((String)"boid", (String)fieldName)) {
                fullFieldName = fullFieldName + ".id";
            }
            if (flag = this.assembleSingleEntryRowData(sumFetch, fullFieldName, queryId, fieldList, isFilterBaseData, entryType, propertyClassMap, numberIndex, setter, index)) {
                return;
            }
        }
        model.batchCreateNewEntryRow(actionId, setter);
        model.endInit();
        this.getView().updateView(actionId);
        if (entryType == 1) {
            dyObjs = this.getModel().getEntryEntity(actionId);
            this.updateConditionEntryEnable(dyObjs);
        }
    }

    private void updateConditionEntryEnable(DynamicObjectCollection dyObjs) {
        for (int i = 0; i < dyObjs.size(); ++i) {
            String compareType = ((DynamicObject)dyObjs.get(i)).getString(KEY_COMPARETYPE);
            if (!SWCStringUtils.equals((String)RuleOperatorEnum.IS_NULL.getName(), (String)compareType) && !SWCStringUtils.equals((String)RuleOperatorEnum.IS_NOT_NULL.getName(), (String)compareType)) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{KEY_COMPAREVALUETYPE, KEY_VALUETYPE, KEY_COMPAREVALUETEXT, KEY_COMPAREVALUE});
        }
    }

    private void assembleMultiEntryRowData(boolean sumFetch, String fields, String queryId, List<String> fieldList, boolean isFilterBaseData, int entryType, Map<String, String> propertyClassMap, int numberIndex, TableValueSetter setter, int index) {
        JSONArray jsonArr = JSONArray.parseArray((String)fields);
        for (Object obj : jsonArr) {
            JSONObject jsonObj = (JSONObject)obj;
            String fullFieldName = jsonObj.getString("id").replace('{', ' ').replace('}', ' ').trim();
            if (((Boolean)jsonObj.get((Object)"isParent")).booleanValue()) continue;
            this.assembleSingleEntryRowData(sumFetch, fullFieldName, queryId, fieldList, isFilterBaseData, entryType, propertyClassMap, numberIndex, setter, index);
        }
    }

    private boolean assembleSingleEntryRowData(boolean sumFetch, String fullFieldName, String queryId, List<String> fieldList, boolean isFilterBaseData, int entryType, Map<String, String> propertyClassMap, int numberIndex, TableValueSetter setter, int index) {
        Map<String, String> rowMap = this.getRowInfo(fullFieldName, queryId, fieldList, isFilterBaseData);
        if (rowMap == null) {
            return true;
        }
        String fieldAlias = rowMap.get("fieldAlias");
        String displayName = rowMap.get("displayName");
        if (entryType != 2) {
            String dataType = fieldAlias.endsWith(".id") ? propertyClassMap.get(fieldAlias.substring(0, fieldAlias.length() - 3)) : propertyClassMap.get(fieldAlias);
            if (SWCStringUtils.isEmpty((String)dataType)) {
                return true;
            }
            if (entryType == 1) {
                String conditionNumber = this.assembleConditionNumber(numberIndex++);
                setter.addRow(new Object[]{conditionNumber, fieldAlias, displayName, dataType});
            } else {
                if (SWCStringUtils.equals((String)dataType, (String)ConditionFieldTypeEnum.TYPE_ENUM.getCode())) {
                    dataType = ConditionFieldTypeEnum.TYPE_TEXT.getCode();
                }
                if (sumFetch) {
                    if (!SWCStringUtils.equals((String)dataType, (String)ConditionFieldTypeEnum.TYPE_NUM.getCode())) {
                        setter.addRow(new Object[]{fieldAlias, displayName, dataType, "2"});
                    } else {
                        setter.addRow(new Object[]{fieldAlias, displayName, dataType, FETCHCONFIG_CONDITIONLOGIC_TYPE_AND});
                    }
                } else {
                    setter.addRow(new Object[]{fieldAlias, displayName, dataType});
                }
            }
        } else {
            setter.addRow(new Object[]{fieldAlias, displayName});
        }
        if (entryType == 0) {
            this.getView().setEnable(Boolean.FALSE, index, new String[]{"srcentity", "srcenum", "srcfield"});
        }
        return false;
    }

    private String assembleConditionNumber(int numberIndex) {
        String indexStr = numberIndex < 10 ? "0" + numberIndex : numberIndex + "";
        return "T" + indexStr;
    }

    private int assembleConditionNumberIndex(DynamicObjectCollection dyObjs) {
        int index = 1;
        if (SWCListUtils.isEmpty((List)dyObjs)) {
            return index;
        }
        for (DynamicObject dyObj : dyObjs) {
            int objIndex;
            String conditionNumber = dyObj.getString("conditionNumber");
            if (SWCStringUtils.isEmpty((String)conditionNumber) || (objIndex = Integer.parseInt(conditionNumber.substring(1))) <= index) continue;
            index = objIndex;
        }
        return index + 1;
    }

    private void initSetterField(int entryType, TableValueSetter setter, boolean sumFetch) {
        if (entryType == 0) {
            setter.addField("field", new Object[0]);
            setter.addField("fieldname", new Object[0]);
            setter.addField("datatype", new Object[0]);
            if (sumFetch) {
                setter.addField("sumtype", new Object[0]);
            }
        } else if (entryType == 1) {
            setter.addField("conditionnumber", new Object[0]);
            setter.addField(KEY_FILTERFIELD, new Object[0]);
            setter.addField(KEY_FIELDNAME, new Object[0]);
            setter.addField(KEY_FIELDTYPE, new Object[0]);
        } else {
            setter.addField("sortfield", new Object[0]);
            setter.addField("sortfieldname", new Object[0]);
        }
    }

    private String assembleFieldId(int entryType) {
        String fieldId = entryType == 0 ? "field" : (entryType == 1 ? KEY_FILTERFIELD : "sortfield");
        return fieldId;
    }

    private Map<String, Map<String, String>> assemblePropertyMap() {
        Map propertyMap = new HashMap(16);
        try {
            propertyMap = (Map)JSONUtils.cast((String)this.getPageCache().get("propertyMapStr"), Map.class);
        }
        catch (Exception exception) {
            logger.error((Throwable)exception);
        }
        if (propertyMap.size() == 0) {
            DynamicObject baseObject = this.getModel().getDataEntity();
            DynamicObject queryObj = (DynamicObject)baseObject.get(CHANGE_FETCH_SOURCE);
            String queryPK = queryObj.getString("id");
            MainEntityType mainEntity = EntityMetadataCache.getDataEntityType((String)queryPK);
            propertyMap = DataReaderHelper.getPropertyClassMap((Map)mainEntity.getAllEntities());
        }
        return propertyMap;
    }

    private int assembleEntryType(String actionId) {
        if (SWCStringUtils.equals((String)actionId, (String)RELATION_ENTITY)) {
            return 1;
        }
        if (SWCStringUtils.equals((String)actionId, (String)"fetchsortentry")) {
            return 2;
        }
        return 0;
    }

    private Map<String, String> getRowInfo(String fullFieldName, String queryId, List<String> fieldList, boolean isFilterBaseData) {
        String fieldAlias;
        String fieldValue;
        String[] fieldName = fullFieldName.split(SHOW_FILED_SPLIT);
        String entityAlias = null;
        String entityNumber = null;
        String displayName = "";
        if (fieldName.length > 1) {
            entityAlias = fieldName[0];
            entityNumber = fieldName[0];
        }
        String fieldBaseData = "";
        if (fieldName.length == 0) {
            fieldValue = fullFieldName;
        } else if (fieldName.length == 3) {
            fieldBaseData = fieldName[fieldName.length - 2];
            fieldValue = fieldName[fieldName.length - 1];
        } else if (fieldName.length == 4) {
            fieldBaseData = fieldName[fieldName.length - 3];
            fieldValue = fieldName[fieldName.length - 2] + "." + fieldName[fieldName.length - 1];
        } else {
            fieldValue = fieldName[fieldName.length - 1];
            if (SWCStringUtils.equals((String)fieldValue, (String)"id") && isFilterBaseData) {
                return null;
            }
        }
        if (fieldValue.toLowerCase().contains("billhead")) {
            return null;
        }
        boolean isMainEntityField = false;
        MainEntityType mainEntity = EntityMetadataCache.getDataEntityType((String)queryId);
        if (mainEntity instanceof QueryEntityType) {
            mainEntity = EntityMetadataCache.getDataEntityType((String)((QueryEntityType)mainEntity).getEntityName());
        }
        String mainEntityName = mainEntity.getName();
        if (null != entityAlias && entityAlias.equals(mainEntityName)) {
            StringBuilder fieldValues = new StringBuilder(fieldName[1]);
            for (int cunt = 2; cunt < fieldName.length; ++cunt) {
                fieldValues.append('.');
                fieldValues.append(fieldName[cunt]);
            }
            fieldAlias = String.valueOf(fieldValues);
            isMainEntityField = true;
        } else {
            fieldAlias = fullFieldName;
        }
        if (!SWCStringUtils.isEmpty((String)entityNumber)) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            DataEntityPropertyCollection properties = dataEntityType.getProperties();
            String entityName = dataEntityType.getDisplayName().toString();
            String baseName = "";
            boolean isBaseData = false;
            for (IDataEntityProperty dtProp : properties) {
                if (dtProp.getName().equals(fieldBaseData)) {
                    baseName = dtProp.getDisplayName() != null ? dtProp.getDisplayName().toString() : dtProp.getAlias();
                    displayName = this.findPropertity(fieldValue, dtProp);
                    break;
                }
                if (!dtProp.getName().equals(fieldValue)) continue;
                if (dtProp instanceof BasedataProp) {
                    isBaseData = true;
                }
                if (dtProp.getDisplayName() != null) {
                    displayName = dtProp.getDisplayName().toString();
                    continue;
                }
                displayName = dtProp.getAlias();
            }
            if (isBaseData && isFilterBaseData) {
                return null;
            }
            if (!SWCStringUtils.isEmpty((String)baseName)) {
                displayName = baseName + "." + displayName;
            }
            if (!isMainEntityField) {
                displayName = entityName + "." + displayName;
            }
        }
        if (fieldList.contains(fieldAlias)) {
            return null;
        }
        HashMap<String, String> rowMap = new HashMap<String, String>(2);
        rowMap.put("fieldAlias", fieldAlias);
        rowMap.put("displayName", displayName);
        return rowMap;
    }

    private String findPropertity(String fieldValue, IDataEntityProperty dtProp) {
        MainEntityType bdType2;
        String displayName = "";
        DataEntityPropertyCollection properties = null;
        if (dtProp instanceof BasedataProp) {
            BasedataProp bdProp2 = (BasedataProp)dtProp;
            bdType2 = (MainEntityType)bdProp2.getComplexType();
            properties = bdType2.getProperties();
        } else if (dtProp instanceof EntryProp) {
            EntryProp entryProp = (EntryProp)dtProp;
            IDataEntityType entryEntitytype = entryProp.getItemType();
            properties = entryEntitytype.getProperties();
        }
        if (properties != null) {
            String[] fieldValueArray = fieldValue.split(SHOW_FILED_SPLIT);
            String baseDataProp = fieldValueArray[0];
            for (IDataEntityProperty baseProp : properties) {
                if (fieldValueArray.length > 1 && baseProp instanceof BasedataProp && baseProp.getName().equals(baseDataProp)) {
                    String baseDataPropVal = fieldValueArray[1];
                    BasedataProp bdProp2 = (BasedataProp)baseProp;
                    bdType2 = (MainEntityType)bdProp2.getComplexType();
                    properties = bdType2.getProperties();
                    for (IDataEntityProperty endBaseProp : properties) {
                        if (!endBaseProp.getName().equals(baseDataPropVal)) continue;
                        displayName = bdProp2.getDisplayName() == null ? bdProp2.getAlias() : bdProp2.getDisplayName().toString();
                        String propDisplayName = endBaseProp.getDisplayName() == null ? endBaseProp.getAlias() : endBaseProp.getDisplayName().toString();
                        displayName = displayName + "." + propDisplayName;
                        return displayName;
                    }
                    continue;
                }
                if (!baseProp.getName().equals(fieldValue)) continue;
                if (baseProp.getDisplayName() != null) {
                    displayName = baseProp.getDisplayName().toString();
                    break;
                }
                displayName = baseProp.getAlias();
                break;
            }
        }
        return displayName;
    }

    private void checkAreaType() {
        String areaType = this.getModel().getDataEntity().getString("areatype");
        FieldEdit countryField = (FieldEdit)this.getControl("country");
        if ("2".equals(areaType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"country"});
            countryField.setMustInput(true);
        } else {
            DynamicObject country = (DynamicObject)this.getModel().getValue("country");
            if (country != null) {
                this.getModel().beginInit();
                this.getModel().setValue("country", null);
                this.getModel().endInit();
                this.getView().updateView("country");
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"country"});
            countryField.setMustInput(false);
        }
    }

    private void validateDeleteEntry(String entityId, String calBackId) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int[] selectRows = proxy.getEntryState(entityId).getSelectedRows();
        if (selectRows.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\uff0c\u7136\u540e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"FetchConfigEdit_11", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(calBackId, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"EnumConfigEdit_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u7ee7\u7eed", (String)"EnumConfigEdit_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684{0}\u6761\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\r\n\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"EnumConfigEdit_3", (String)SYSTEM_TYPE, (Object[])new Object[]{selectRows.length});
        String changeDescStr = this.getModel().getChangeDesc();
        this.getView().showConfirm(msg, changeDescStr, options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
    }

    private void deleteEntry(String entityId) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(entityId);
        int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
        this.getModel().deleteEntryRows(entityId, selectedRows);
        if (SWCStringUtils.equals((String)RELATION_ENTITY, (String)entityId)) {
            this.setConditionLogic();
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"FetchConfigEdit_10", (String)SYSTEM_TYPE, (Object[])new Object[0]));
    }

    private void showFieldsList(int index) {
        DynamicObjectCollection collection = this.getModel().getEntryEntity("fetchfieldentry");
        DynamicObject dyObj = (DynamicObject)collection.get(index);
        List<Map<String, String>> srcFieldsList = this.getSrcFields(dyObj, true);
        if (ObjectUtils.isEmpty(srcFieldsList)) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("srcfieldslist", srcFieldsList);
        showParameter.setFormId("hsbs_itemsrcfield");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsbs_itemsrcfield"));
        this.getView().showForm(showParameter);
    }

    private List<Map<String, String>> getSrcFields(DynamicObject dynamicObject, boolean isInit) {
        ArrayList<Map<String, String>> srcFieldsList = new ArrayList<Map<String, String>>(10);
        String src = "";
        String srcType = dynamicObject.getString("srctype");
        String srcentity = dynamicObject.getString("srcentity");
        String srcenum = dynamicObject.getString("srcenum");
        if (!SWCStringUtils.isEmpty((String)srcentity) && SWCStringUtils.equals((String)srcType, (String)FETCHCONFIG_CONDITIONLOGIC_TYPE_AND)) {
            src = dynamicObject.getString("srcentity.number");
        } else if (!SWCStringUtils.isEmpty((String)srcenum) && SWCStringUtils.equals((String)srcType, (String)"2")) {
            src = "hsbs_enumconfig";
        } else {
            if (isInit && SWCStringUtils.isEmpty((String)src)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u503c\u6765\u6e90\u5b9e\u4f53\u6216\u679a\u4e3e\u3002", (String)"FetchConfigEdit_72", (String)SYSTEM_TYPE, (Object[])new Object[0]), new Object[0]));
            }
            return srcFieldsList;
        }
        Map allFieldsMap = null;
        try {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)src);
            allFieldsMap = mainEntityType.getAllFields();
        }
        catch (KDException kdException) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8be5\u5b9e\u4f53\u7684\u503c\u6765\u6e90\u5b57\u6bb5\u4e0d\u53ef\u7528\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u5b9e\u4f53\u3002", (String)"FetchConfigEdit_35", (String)SYSTEM_TYPE, (Object[])new Object[0]), new Object[0]));
            return srcFieldsList;
        }
        for (Map.Entry entry : allFieldsMap.entrySet()) {
            HashMap map = new HashMap(3);
            LocaleString srcfieldname = ((IDataEntityProperty)entry.getValue()).getDisplayName();
            String srcfieldnum = (String)entry.getKey();
            if (srcfieldname == null || srcfieldnum == null) continue;
            map.put("srcfieldnum", entry.getKey());
            map.put("srcfieldname", ((IDataEntityProperty)entry.getValue()).getDisplayName().toString());
            srcFieldsList.add(map);
        }
        if (isInit && ObjectUtils.isEmpty(srcFieldsList)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u503c\u6765\u6e90\u5b9e\u4f53\u6216\u679a\u4e3e\u65e0\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165\u3002", (String)"FetchConfigEdit_73", (String)SYSTEM_TYPE, (Object[])new Object[0]), new Object[0]));
        }
        return srcFieldsList;
    }

    private void initSrcField(DynamicObjectCollection dyObjs) {
        for (int index = 0; index < dyObjs.size(); ++index) {
            DynamicObject dyObj = (DynamicObject)dyObjs.get(index);
            List<Map<String, String>> srcFields = this.getSrcFields(dyObj, false);
            String srcField = (String)dyObj.get("srcfield");
            String srcFieldStr = "";
            for (Map<String, String> map : srcFields) {
                if (!SWCStringUtils.equals((String)map.get("srcfieldnum"), (String)srcField)) continue;
                srcFieldStr = map.get("srcfieldname") + "(" + srcField + ")";
            }
            IDataModel model = this.getModel();
            model.setValue("srcfieldnum", (Object)srcFieldStr, index);
        }
    }

    private void initSrcInfo(DynamicObjectCollection collection, int index) {
        DynamicObject dynamicObject = (DynamicObject)collection.get(index);
        String srcType = dynamicObject.getString("srctype");
        IDataModel model = this.getModel();
        model.beginInit();
        if (FETCHCONFIG_CONDITIONLOGIC_TYPE_AND.equals(srcType)) {
            model.setValue("srcenum", (Object)"", index);
        } else if ("2".equals(srcType)) {
            model.setValue("srcentity", (Object)"", index);
        } else {
            model.setValue("srcentity", (Object)"", index);
            model.setValue("srcenum", (Object)"", index);
        }
        model.setValue("srcfieldnum", (Object)"", index);
        model.setValue("srcfield", (Object)"", index);
        model.endInit();
        this.getView().updateView("srcenum", index);
        this.getView().updateView("srcentity", index);
        this.getView().updateView("srcfieldnum", index);
        this.getView().updateView("srcenum", index);
    }

    private void setSrcEditAuth(DynamicObjectCollection collection, int index) {
        DynamicObject dynamicObject = (DynamicObject)collection.get(index);
        String srcType = dynamicObject.getString("srctype");
        IFormView view = this.getView();
        if (FETCHCONFIG_CONDITIONLOGIC_TYPE_AND.equals(srcType)) {
            view.setEnable(Boolean.FALSE, index, new String[]{"srcenum"});
            view.setEnable(Boolean.TRUE, index, new String[]{"srcentity", "srcfieldnum"});
        } else if ("2".equals(srcType)) {
            view.setEnable(Boolean.FALSE, index, new String[]{"srcentity", "srcfieldnum"});
            view.setEnable(Boolean.TRUE, index, new String[]{"srcenum"});
        } else {
            view.setEnable(Boolean.FALSE, index, new String[]{"srcentity", "srcenum", "srcfieldnum"});
        }
    }

    private void setConditionEntryData() {
        DynamicObjectCollection relationCollection = this.getModel().getEntryEntity(RELATION_ENTITY);
        this.getModel().beginInit();
        for (int index = 0; index < relationCollection.size(); ++index) {
            DynamicObject dynamicObject = (DynamicObject)relationCollection.get(index);
            String compareType = dynamicObject.getString(KEY_COMPARETYPEVALUE);
            String compareTypeName = ConditionFieldTypeEnum.getCompareTypeByValue((String)compareType);
            this.getModel().setValue(KEY_COMPARETYPE, (Object)compareTypeName, index);
            String valueType = dynamicObject.getString(KEY_VALUETYPE);
            String valueTypeName = ConditionValueTypeEnum.getDesc((String)valueType);
            this.getModel().setValue(KEY_COMPAREVALUETYPE, (Object)valueTypeName, index);
        }
        this.getModel().endInit();
    }

    private void setFetchFieldAuth() {
        DynamicObjectCollection fetchCollection = this.getModel().getEntryEntity("fetchfieldentry");
        this.initSrcField(fetchCollection);
        for (int index = 0; index < fetchCollection.size(); ++index) {
            this.setSrcEditAuth(fetchCollection, index);
        }
    }

    private boolean checkEntityData(DynamicObject newValue) {
        List spItemDyObjList;
        boolean checkFetchItem;
        List fetchItemDyObjList;
        DynamicObjectCollection fetchEntry = this.getView().getModel().getEntryEntity("fetchfieldentry");
        DynamicObjectCollection relationEntity = this.getView().getModel().getEntryEntity(RELATION_ENTITY);
        ArrayList<String> fetchItemCodeList = new ArrayList<String>(10);
        ArrayList<String> spItemCodeList = new ArrayList<String>(10);
        this.assembleFetchAndSpItemIdList(fetchEntry, relationEntity, fetchItemCodeList, spItemCodeList);
        if (!(SWCListUtils.isEmpty(fetchItemCodeList) || SWCListUtils.isEmpty((List)(fetchItemDyObjList = FetchConfigHelper.getFetchSpItemDyObjList(fetchItemCodeList, (String)"hsbs_fetchitem"))) || (checkFetchItem = this.checkAreaTypeAndCountryMatch(newValue, fetchItemDyObjList)))) {
            return false;
        }
        if (!SWCListUtils.isEmpty(spItemCodeList) && !SWCListUtils.isEmpty((List)(spItemDyObjList = FetchConfigHelper.getFetchSpItemDyObjList(spItemCodeList, (String)"hsbs_supportitem")))) {
            return this.checkAreaTypeAndCountryMatch(newValue, spItemDyObjList);
        }
        return true;
    }

    private void assembleFetchAndSpItemIdList(DynamicObjectCollection fetchEntry, DynamicObjectCollection relationEntity, List<String> fetchItemIdList, List<String> spItemIdList) {
        List collect;
        if (!SWCListUtils.isEmpty((List)fetchEntry) && !SWCListUtils.isEmpty(collect = fetchEntry.stream().filter(value -> value.getDynamicObject("fetchitem") != null).map(field -> field.getDynamicObject("fetchitem").getString("uniquecode")).collect(Collectors.toList()))) {
            fetchItemIdList.addAll(collect);
        }
        for (DynamicObject dynamicObject : relationEntity) {
            String valueType = dynamicObject.getString(KEY_VALUETYPE);
            String filtervalue = dynamicObject.getString(KEY_COMPAREVALUE);
            if (SWCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_FTITEM.getCode(), (String)valueType) && SWCStringUtils.isNotEmpty((String)filtervalue)) {
                fetchItemIdList.add(filtervalue);
            }
            if (!SWCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_SPITEM.getCode(), (String)valueType) || !SWCStringUtils.isNotEmpty((String)filtervalue)) continue;
            spItemIdList.add(filtervalue);
        }
    }

    private boolean checkAreaTypeAndCountryMatch(DynamicObject newValue, List<DynamicObject> fetchItemDyObjList) {
        String newAreaType = this.getModel().getDataEntity().getString("areatype");
        for (DynamicObject dyObj : fetchItemDyObjList) {
            String itemAreaType = dyObj.getString("areatype");
            long itemCountryId = dyObj.getLong("country.id");
            if (SWCStringUtils.equals((String)FETCHCONFIG_CONDITIONLOGIC_TYPE_AND, (String)newAreaType)) {
                if (!SWCStringUtils.equals((String)"2", (String)itemAreaType)) continue;
                return false;
            }
            if (!SWCStringUtils.equals((String)"2", (String)itemAreaType)) continue;
            if (newValue == null) {
                return false;
            }
            long newItemCountryId = newValue.getLong("id");
            if (itemCountryId == newItemCountryId) continue;
            return false;
        }
        return true;
    }

    private void changeAreaTypeData() {
        String selectType = (String)this.getModel().getValue("areatype");
        FieldEdit control = (FieldEdit)this.getControl("country");
        boolean flag = SWCStringUtils.equals((String)selectType, (String)FETCHCONFIG_CONDITIONLOGIC_TYPE_AND);
        if (flag) {
            this.clearFetchField();
        }
        this.getView().setVisible(Boolean.valueOf(!flag), new String[]{"country"});
        control.setMustInput(!flag);
        this.getModel().beginInit();
        this.getView().getModel().setValue("country", null);
        this.getModel().endInit();
        this.getView().updateView("country");
    }

    private boolean checkFetchItemConfig(String opType) {
        boolean itemCycle;
        boolean enableFlag;
        IFormView view = this.getView();
        DynamicObjectCollection calItemMatchEntry = this.getModel().getEntryEntity("fetchfieldentry");
        if (CollectionUtils.isEmpty((Collection)calItemMatchEntry)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u53d6\u6570\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u81f3\u5c11\u9700\u8981\u4e00\u6761\u6570\u636e\u3002", (String)"FetchConfigEdit_31", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return true;
        }
        DynamicObjectCollection relationEntry = this.getModel().getEntryEntity(RELATION_ENTITY);
        if (CollectionUtils.isEmpty((Collection)relationEntry)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5173\u8054\u4fe1\u606f\u201d\u3002", (String)"FetchConfigEdit_74", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return true;
        }
        ArrayList<Long> fetchItemIds = new ArrayList<Long>(10);
        if (this.checkFetchFieldEntry(view, calItemMatchEntry, relationEntry, fetchItemIds)) {
            return true;
        }
        long configId = this.getModel().getDataEntity().getLong("id");
        if (this.checkFetchItemUsed(view, fetchItemIds, configId)) {
            return true;
        }
        ArrayList<String> relationItemCodeList = new ArrayList<String>(10);
        for (DynamicObject param : relationEntry) {
            String fetchItemCode;
            if (!StringUtils.equals((CharSequence)param.getString(KEY_VALUETYPE), (CharSequence)ConditionValueTypeEnum.TYPE_FTITEM.getCode()) || SWCStringUtils.isEmpty((String)(fetchItemCode = param.getString(KEY_COMPAREVALUE)))) continue;
            if (fetchItemCode.contains(";")) {
                String[] itemsArr = fetchItemCode.split(";");
                Collections.addAll(relationItemCodeList, itemsArr);
                continue;
            }
            relationItemCodeList.add(fetchItemCode);
        }
        String enable = this.getModel().getDataEntity().getString("enable");
        boolean bl = enableFlag = SWCStringUtils.equals((String)opType, (String)"enable") || SWCStringUtils.equals((String)opType, (String)"save") && SWCStringUtils.equals((String)FETCHCONFIG_CONDITIONLOGIC_TYPE_AND, (String)enable);
        if (enableFlag && !CollectionUtils.isEmpty(relationItemCodeList) && (itemCycle = this.checkFetchItemCycle(view, relationItemCodeList, configId))) {
            return true;
        }
        boolean quoteStatus = this.checkChangeCalOrDimensionality();
        if (quoteStatus) {
            return quoteStatus;
        }
        return false;
    }

    private void formatConditionLogicCode() {
        String conditionLogicText = this.getModel().getDataEntity().getString(KEY_CONDITIONLOGICTEXT).trim();
        StringBuilder sb = new StringBuilder();
        char[] chars = conditionLogicText.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            boolean check;
            boolean bl = check = chars[i] == '(' || chars[i] == ')' || chars[i] == 'T';
            if (i == 0) {
                sb.append(chars[i]);
                continue;
            }
            if (check && chars[i - 1] != ' ') {
                sb.append(' ').append(chars[i]);
            } else {
                sb.append(chars[i]);
            }
            if (i == chars.length - 1 || chars[i] != ')' || chars[i + 1] == ' ') continue;
            sb.append(' ');
        }
        conditionLogicText = sb.toString();
        this.getModel().setValue(KEY_CONDITIONLOGICTEXT, (Object)conditionLogicText);
    }

    private boolean checkConditionEntry(DynamicObjectCollection relationEntry, IFormView view, String dimensionality) {
        if (SWCListUtils.isEmpty((List)relationEntry) && SWCStringUtils.equals((String)"0", (String)dimensionality)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5173\u8054\u4fe1\u606f\u4e2d\u81f3\u5c11\u9700\u8981\u4e00\u4e2a\u4eba\u5458\u53c2\u6570\u6216\u8005\u4eba\u5458\u7ef4\u5ea6\u7684\u53d6\u6570\u9879\u76ee\uff0c\u4e14\u5224\u65ad\u6761\u4ef6\u5fc5\u987b\u4e3a\u201c\u7b49\u4e8e\u201d\u3002", (String)"FetchConfigEdit_46", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return true;
        }
        if (this.checkConditionEntryMustImput(view, relationEntry)) {
            return true;
        }
        String conditionLogicType = this.getModel().getDataEntity().getString(KEY_RADIOGROUPFIELD);
        return SWCStringUtils.equals((String)"3", (String)conditionLogicType) && this.checkConditionLogic(view, relationEntry);
    }

    private boolean checkConditionLogic(IFormView view, DynamicObjectCollection relationEntry) {
        List<String> conditionNumberList = relationEntry.stream().map(single -> single.getString("conditionnumber")).collect(Collectors.toList());
        String conditionLogicText = this.getModel().getDataEntity().getString(KEY_CONDITIONLOGICTEXT);
        if (SWCStringUtils.isEmpty((String)conditionLogicText)) {
            String errMsg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6761\u4ef6\u8868\u8fbe\u5f0f\u3002", (String)"FetchConfigEdit_51", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            view.showTipNotification(errMsg);
            return true;
        }
        if (!this.checkHasNoExistNumber(view, conditionLogicText, conditionNumberList)) {
            return true;
        }
        if (!this.checkBacketValid(view, conditionLogicText, conditionNumberList)) {
            return true;
        }
        if (!this.checkKeyWordStartOrEnd(view, conditionLogicText)) {
            return true;
        }
        return !this.checkMultiKeyWordNeighbor(view, conditionLogicText, conditionNumberList);
    }

    private boolean checkMultiKeyWordNeighbor(IFormView view, String conditionLogicText, List<String> conditionNumberList) {
        boolean bracketFlag;
        List<String> splitStrList = Arrays.asList("\\(", "\\)", " ");
        List<String> keyWordList = this.splitKeyWordList(splitStrList, conditionLogicText);
        List<String> wordList = Arrays.asList(ConditionLogicTypeEnum.AND.getDesc(), ConditionLogicTypeEnum.OR.getDesc());
        for (int i = 0; i < keyWordList.size() - 1; ++i) {
            boolean wordFlag;
            boolean bl = wordFlag = wordList.contains(keyWordList.get(i)) && wordList.contains(keyWordList.get(i + 1));
            if (wordFlag) {
                view.showTipNotification(ResManager.loadKDString((String)"\u6761\u4ef6\u903b\u8f91\u8868\u8fbe\u5f0f\u6709\u8bef\uff0c\u8fde\u63a5\u5173\u952e\u8bcd\u4e4b\u95f4\u6ca1\u6709\u6761\u4ef6\u7f16\u7801\u3002", (String)"FetchConfigEdit_54", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return false;
            }
            if (!conditionNumberList.contains(keyWordList.get(i)) || !conditionNumberList.contains(keyWordList.get(i + 1))) continue;
            view.showTipNotification(ResManager.loadKDString((String)"\u6761\u4ef6\u903b\u8f91\u8868\u8fbe\u5f0f\u6709\u8bef\uff0c\u6761\u4ef6\u7f16\u7801\u4e4b\u95f4\u6ca1\u6709\u8fde\u63a5\u5173\u952e\u8bcd\u3002", (String)"FetchConfigEdit_55", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        keyWordList = this.splitKeyWordList(Collections.singletonList(" "), conditionLogicText);
        boolean bl = bracketFlag = SWCStringUtils.equals((String)keyWordList.get(0), (String)")") || SWCStringUtils.equals((String)keyWordList.get(keyWordList.size() - 1), (String)"(");
        if (bracketFlag) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6761\u4ef6\u903b\u8f91\u8868\u8fbe\u5f0f\u6709\u8bef\uff0c\u62ec\u53f7\u4f4d\u7f6e\u6709\u8bef\u3002", (String)"FetchConfigEdit_56", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        for (int j = 0; j < keyWordList.size() - 1; ++j) {
            boolean bracketFlag3;
            boolean bracketFlag1 = SWCStringUtils.equals((String)keyWordList.get(j), (String)"(") && SWCStringUtils.equals((String)keyWordList.get(j + 1), (String)")");
            boolean bracketFlag2 = SWCStringUtils.equals((String)keyWordList.get(j), (String)")") && SWCStringUtils.equals((String)keyWordList.get(j + 1), (String)"(");
            boolean flag1 = wordList.contains(keyWordList.get(j)) && SWCStringUtils.equals((String)keyWordList.get(j + 1), (String)")");
            boolean bl2 = bracketFlag3 = j < keyWordList.size() - 2 && SWCStringUtils.equals((String)keyWordList.get(j), (String)"(") && SWCStringUtils.equals((String)keyWordList.get(j + 2), (String)")");
            if (bracketFlag1 || bracketFlag2 || bracketFlag3) {
                view.showTipNotification(ResManager.loadKDString((String)"\u6761\u4ef6\u903b\u8f91\u8868\u8fbe\u5f0f\u6709\u8bef\uff0c\u62ec\u53f7\u4f4d\u7f6e\u6709\u8bef\u3002", (String)"FetchConfigEdit_56", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return false;
            }
            if (!flag1) continue;
            view.showTipNotification(ResManager.loadKDString((String)"\u6761\u4ef6\u903b\u8f91\u8868\u8fbe\u5f0f\u6709\u8bef\uff0c\u62ec\u53f7\u4e0d\u80fd\u548c\u8fde\u63a5\u5173\u952e\u8bcd\u76f8\u90bb\u3002", (String)"FetchConfigEdit_60", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkKeyWordStartOrEnd(IFormView view, String conditionLogicText) {
        List<String> splitStrList = Arrays.asList("\\(", "\\)", " ");
        List<String> keyWordList = this.splitKeyWordList(splitStrList, conditionLogicText);
        List<String> wordList = Arrays.asList(ConditionLogicTypeEnum.AND.getDesc(), ConditionLogicTypeEnum.OR.getDesc());
        if (wordList.contains(keyWordList.get(0)) || wordList.contains(keyWordList.get(keyWordList.size() - 1))) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6761\u4ef6\u8868\u8fbe\u5f0f\u4e0d\u5f97\u4ee5\u5173\u952e\u8bcd\u5f00\u5934\u6216\u7ed3\u5c3e\u3002", (String)"FetchConfigEdit_52", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkBacketValid(IFormView view, String conditionLogicText, List<String> conditionNumberList) {
        Map<String, Long> collect;
        ArrayList<String> splitStrList = new ArrayList<String>(Arrays.asList(ConditionLogicTypeEnum.AND.getDesc(), ConditionLogicTypeEnum.OR.getDesc(), " "));
        splitStrList.addAll(conditionNumberList);
        List<String> keyWordList = this.splitKeyWordList(splitStrList, conditionLogicText);
        List bracketList = Stream.of(keyWordList.stream().map(String::valueOf).collect(Collectors.joining()).split("")).collect(Collectors.toList());
        int leftBrackCount = 0;
        int rightBrackCount = 0;
        for (String brack : bracketList) {
            if (SWCStringUtils.equals((String)"(", (String)brack)) {
                ++leftBrackCount;
                continue;
            }
            if (!SWCStringUtils.equals((String)")", (String)brack) || leftBrackCount >= ++rightBrackCount) continue;
            view.showTipNotification(ResManager.loadKDString((String)"\u6761\u4ef6\u903b\u8f91\u8868\u8fbe\u5f0f\u6709\u8bef\uff0c\u62ec\u53f7\u4f4d\u7f6e\u6709\u8bef\u3002", (String)"FetchConfigEdit_56", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        if ((bracketList.contains("(") || bracketList.contains(")")) && !(collect = bracketList.stream().collect(Collectors.groupingBy(key -> key, Collectors.counting()))).get("(").equals(collect.get(")"))) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6761\u4ef6\u8868\u8fbe\u5f0f\u4e2d\u7684\u62ec\u53f7\u6570\u91cf\u4e0d\u5339\u914d\u3002", (String)"FetchConfigEdit_53", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private List<String> splitKeyWordList(List<String> splitStrList, String conditionLogicText) {
        String splitStr = splitStrList.stream().map(String::valueOf).collect(Collectors.joining("|"));
        List<String> keyWordList = Stream.of(conditionLogicText.split(splitStr)).collect(Collectors.toList());
        keyWordList.removeIf(word -> SWCStringUtils.isEmpty((String)word));
        return keyWordList;
    }

    private boolean checkHasNoExistNumber(IFormView view, String conditionLogicText, List<String> conditionNumberList) {
        List<String> splitStrList = Arrays.asList("\\(", "\\)", " ");
        List<String> keyWordList = this.splitKeyWordList(splitStrList, conditionLogicText);
        List wordList = ConditionLogicTypeEnum.getKeyWordList();
        StringBuilder errMsgSb = new StringBuilder();
        if (conditionLogicText.contains("\uff08") || conditionLogicText.contains("\uff09")) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4f7f\u7528\u82f1\u6587\u62ec\u53f7\uff0c\u6761\u4ef6\u8868\u8fbe\u5f0f\u6709\u8bef\u3002", (String)"FetchConfigEdit_58", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        if (SWCListUtils.isEmpty(keyWordList)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6761\u4ef6\u8868\u8fbe\u5f0f\u6709\u8bef\uff0c\u4e0d\u5305\u542b\u6761\u4ef6\u7f16\u7801\u3002", (String)"FetchConfigEdit_57", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        for (String word : keyWordList) {
            if (wordList.contains(word) || conditionNumberList.contains(word)) continue;
            if (errMsgSb.length() == 0) {
                errMsgSb.append(word);
                continue;
            }
            errMsgSb.append(',').append(word);
        }
        if (errMsgSb.length() > 0) {
            view.showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u5173\u952e\u8bcd\u6216\u6761\u4ef6\u5206\u5f55\u7f16\u7801\u4e0d\u5b58\u5728\uff1a{0}\u3002", (String)"FetchConfigEdit_50", (String)SYSTEM_TYPE, (Object[])new Object[0]), errMsgSb.toString()));
            return false;
        }
        List notContainNumberList = conditionNumberList.stream().filter(single -> !conditionLogicText.contains((CharSequence)single)).collect(Collectors.toList());
        if (!SWCListUtils.isEmpty(notContainNumberList)) {
            StringBuilder numberSb = new StringBuilder();
            for (String number : notContainNumberList) {
                if (numberSb.length() > 0) {
                    numberSb.append(ResManager.loadKDString((String)"\u3001", (String)"FetchConfigEdit_70", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
                numberSb.append(number);
            }
            view.showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u6761\u4ef6\u903b\u8f91\u8868\u8fbe\u5f0f\u6709\u8bef\uff0c\u672a\u5305\u542b\u4ee5\u4e0b\u5206\u5f55\u7f16\u7801\uff1a{0}\u3002", (String)"FetchConfigEdit_64", (String)SYSTEM_TYPE, (Object[])new Object[0]), numberSb.toString()));
            return false;
        }
        return true;
    }

    private boolean checkConditionEntryMustImput(IFormView view, DynamicObjectCollection relationEntry) {
        int index = 1;
        ArrayList<String> errMsgList = new ArrayList<String>(10);
        for (DynamicObject entryObj : relationEntry) {
            String compareType = entryObj.getString(KEY_COMPARETYPE);
            if (SWCStringUtils.equals((String)RuleOperatorEnum.IS_NULL.getName(), (String)compareType) || SWCStringUtils.equals((String)RuleOperatorEnum.IS_NOT_NULL.getName(), (String)compareType)) {
                ++index;
                continue;
            }
            Map<String, String> entryFieldMap = this.assembleEntryFieldMap(entryObj);
            String errMsg = this.checkIsNull(entryFieldMap, index++);
            if (!SWCStringUtils.isNotEmpty((String)errMsg)) continue;
            errMsgList.add(errMsg);
        }
        if (!SWCListUtils.isEmpty(errMsgList)) {
            StringBuilder msgSb = new StringBuilder();
            for (String msg : errMsgList) {
                if (msgSb.length() == 0) {
                    msgSb.append(msg);
                    continue;
                }
                msgSb.append("\r\n").append(msg);
            }
            view.showTipNotification(msgSb.toString());
            return true;
        }
        return false;
    }

    private Map<String, String> assembleEntryFieldMap(DynamicObject entryObj) {
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>(16);
        dataMap.put(KEY_COMPARETYPEVALUE, entryObj.getString(KEY_COMPARETYPEVALUE));
        dataMap.put(KEY_VALUETYPE, entryObj.getString(KEY_VALUETYPE));
        dataMap.put(KEY_COMPAREVALUE, entryObj.getString(KEY_COMPAREVALUE));
        return dataMap;
    }

    private String checkIsNull(Map<String, String> entryFieldMap, int index) {
        StringBuilder errMsgSb = new StringBuilder();
        for (Map.Entry<String, String> entry : entryFieldMap.entrySet()) {
            if (!SWCStringUtils.isEmpty((String)entry.getValue())) continue;
            if (errMsgSb.length() == 0) {
                errMsgSb.append(FetchConditionEntryFieldEnum.getDesc((String)entry.getKey()));
                continue;
            }
            errMsgSb.append('\uff0c').append(FetchConditionEntryFieldEnum.getDesc((String)entry.getKey()));
        }
        if (errMsgSb.length() > 0) {
            return MessageFormat.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5173\u8054\u4fe1\u606f\u7b2c{0}\u884c\u4ee5\u4e0b\u5b57\u6bb5\uff1a{1}\u3002", (String)"FetchConfigEdit_49", (String)SYSTEM_TYPE, (Object[])new Object[0]), index, errMsgSb.toString());
        }
        return errMsgSb.toString();
    }

    private void assembleConditionTypeList(DynamicObjectCollection relationEntry, List<DynamicObject> personConditionList, List<DynamicObject> personFTConditionList, List<DynamicObject> taskConditionList, List<DynamicObject> taskFTConditionList, List<DynamicObject> allConditionList) {
        List fetchItemList = relationEntry.stream().filter(single -> SWCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_FTITEM.getCode(), (String)single.getString(KEY_VALUETYPE))).map(obj -> obj.getString(KEY_COMPAREVALUE)).collect(Collectors.toList());
        FetchConfigHelper fetchConfigHelper = new FetchConfigHelper();
        DynamicObject[] fetchItemObjs = fetchConfigHelper.selectFetchItemListByCode(fetchItemList);
        Map<Object, Object> fetchItemDimensionMap = new HashMap(16);
        if (fetchItemObjs != null && fetchItemObjs.length > 0) {
            fetchItemDimensionMap = Arrays.stream(fetchItemObjs).collect(Collectors.toMap(key -> key.getString("fetchitem.uniquecode"), value -> SWCStringUtils.isEmpty((String)value.getString("fetchconfig.dimensionality")) ? "0" : value.getString("fetchconfig.dimensionality"), (v1, v2) -> v1));
        }
        for (DynamicObject single2 : relationEntry) {
            String valueType = single2.getString(KEY_VALUETYPE);
            String condition = single2.getString(KEY_COMPARETYPEVALUE);
            if (!SWCStringUtils.equals((String)condition, (String)RuleOperatorEnum.EQUAL.getValue())) continue;
            if (SWCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_PERSON.getCode(), (String)valueType)) {
                personConditionList.add(single2);
                continue;
            }
            if (SWCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_FTITEM.getCode(), (String)valueType)) {
                String itemCode = single2.getString(KEY_COMPAREVALUE);
                if (SWCStringUtils.equals((String)"0", (String)((String)fetchItemDimensionMap.get(itemCode)))) {
                    personFTConditionList.add(single2);
                    continue;
                }
                if (!SWCStringUtils.equals((String)FETCHCONFIG_CONDITIONLOGIC_TYPE_AND, (String)((String)fetchItemDimensionMap.get(itemCode)))) continue;
                taskFTConditionList.add(single2);
                continue;
            }
            if (!SWCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_TASK.getCode(), (String)valueType)) continue;
            taskConditionList.add(single2);
        }
        allConditionList.addAll(personConditionList);
        allConditionList.addAll(personFTConditionList);
        allConditionList.addAll(taskConditionList);
        allConditionList.addAll(taskFTConditionList);
    }

    private boolean checkFetchItemUsed(IFormView view, List<Long> fetchItemIds, long configId) {
        FetchItemCheckResultVo fetchItemCheckResultVo = FetchConfigHelper.checkBatchFetchItemEnableByIds(fetchItemIds, (long)configId);
        if (SWCStringUtils.equals((String)"3", (String)fetchItemCheckResultVo.getResult())) {
            view.showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u5b58\u5728\u4ee5\u4e0b\u53d6\u6570\u9879\u76ee\u5df2\u7ecf\u88ab\u4f7f\u7528\uff1a{0}\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u8bd5\u3002", (String)"FetchConfigEdit_75", (String)SYSTEM_TYPE, (Object[])new Object[0]), fetchItemCheckResultVo.getFetchItemList()));
            return true;
        }
        return false;
    }

    private boolean checkFetchItemCycle(IFormView view, List<String> relationItemCodeList, long configId) {
        FetchItemCheckResultVo result = FetchConfigHelper.checkFetchConfigItemCycle((long)configId, relationItemCodeList);
        if (SWCStringUtils.equals((String)FETCHCONFIG_CONDITIONLOGIC_TYPE_AND, (String)result.getResult())) {
            String fetchItemStr = this.assembleFetchItemStr(result.getFetchItemList());
            view.showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u53d6\u6570\u914d\u7f6e{0}\u5b58\u5728\u5faa\u73af\u4f9d\u8d56\uff0c\u8bf7\u68c0\u67e5\u53d6\u6570\u914d\u7f6e\uff0c\u5e76\u4fee\u6539\u3002", (String)"FetchConfigEdit_42", (String)SYSTEM_TYPE, (Object[])new Object[0]), fetchItemStr));
            return true;
        }
        if (SWCStringUtils.equals((String)"2", (String)result.getResult())) {
            view.showConfirm(ResManager.loadKDString((String)"\u53d6\u6570\u9879\u76ee\u4f9d\u8d56\u5c42\u6b21\u5c06\u8d85\u8fc75\u5c42\uff0c\u53ef\u80fd\u589e\u5927\u8ba1\u7b97\u6846\u67b6\u590d\u6742\u5ea6\u4ee5\u53ca\u8ba1\u7b97\u6027\u80fd\u635f\u8017\uff0c\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"FetchConfigEdit_43", (String)SYSTEM_TYPE, (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("fetch_too_many_notify", (IFormPlugin)this));
            return true;
        }
        return false;
    }

    private boolean checkFetchFieldEntry(IFormView view, DynamicObjectCollection calItemMatchEntry, DynamicObjectCollection relationEntry, List<Long> fetchItemIds) {
        boolean flag = false;
        String message = "";
        for (DynamicObject dynamicObject : calItemMatchEntry) {
            String srcenum;
            for (DynamicObject relationObject : relationEntry) {
                long fetchItem = dynamicObject.getLong("fetchitem.id");
                String filterFetchItem = relationObject.getString(KEY_COMPAREVALUE);
                if (!StringUtils.equals((CharSequence)relationObject.getString(KEY_COMPAREVALUETYPE), (CharSequence)ConditionValueTypeEnum.TYPE_FTITEM.getCode()) || !SWCStringUtils.isNotEmpty((String)filterFetchItem) || fetchItem != Long.parseLong(filterFetchItem)) continue;
                message = dynamicObject.getString(KEY_COMPAREVALUETEXT);
                flag = true;
                break;
            }
            if (flag) {
                view.showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u53d6\u6570\u9879\u76ee:{0}\uff0c\u5faa\u73af\u4f9d\u8d56\u7684\u6570\u636e\u4e0d\u80fd\u8fdb\u884c\u4fdd\u5b58\u3002", (String)"FetchConfigEdit_33", (String)SYSTEM_TYPE, (Object[])new Object[0]), message));
                return true;
            }
            fetchItemIds.add(dynamicObject.getLong("fetchitem.id"));
            String srcType = dynamicObject.getString("srctype");
            if (StringUtils.equals((CharSequence)srcType, (CharSequence)FETCHCONFIG_CONDITIONLOGIC_TYPE_AND)) {
                String srcEntity = dynamicObject.getString("srcentity");
                String srcFieldNum = dynamicObject.getString("srcfieldnum");
                if (StringUtils.isBlank((CharSequence)srcEntity) || StringUtils.isBlank((CharSequence)srcFieldNum)) {
                    message = dynamicObject.getString("fetchitem.name");
                    view.showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u53d6\u6570\u9879\u76ee:{0}\uff0c\u8bf7\u586b\u5199\u503c\u6765\u6e90\u5b9e\u4f53\u548c\u503c\u6765\u6e90\u5b57\u6bb5\u3002", (String)"FetchConfigEdit_30", (String)SYSTEM_TYPE, (Object[])new Object[0]), message));
                    return true;
                }
            }
            if (!StringUtils.equals((CharSequence)srcType, (CharSequence)"2") || !StringUtils.isBlank((CharSequence)(srcenum = dynamicObject.getString("srcenum")))) continue;
            message = dynamicObject.getString("fetchitem.name");
            view.showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u53d6\u6570\u9879\u76ee:{0}\uff0c\u8bf7\u586b\u5199\u201c\u503c\u6765\u6e90\u679a\u4e3e\u201d\u3002", (String)"FetchConfigEdit_29", (String)SYSTEM_TYPE, (Object[])new Object[0]), message));
            return true;
        }
        return false;
    }

    private boolean checkFetchItemConfigList() {
        ArrayList<Long> fetchConfigIds = new ArrayList<Long>();
        long id = this.getModel().getDataEntity().getLong("id");
        fetchConfigIds.add(id);
        FetchConfigHelper fetchConfigHelper = new FetchConfigHelper();
        DynamicObject[] fetchItems = fetchConfigHelper.selectFetchItemList(fetchConfigIds);
        List fetchItemList = Arrays.stream(fetchItems).map(param -> param.getLong("fetchitem.id")).collect(Collectors.toList());
        String message = fetchConfigHelper.checkFetchConfigQuote(fetchItemList);
        message = message + fetchConfigHelper.checkCustFetchConfigQuote(fetchItemList);
        message = message + fetchConfigHelper.checkResultFetchConfigQuote(fetchItemList);
        if (SWCStringUtils.isNotEmpty((String)message)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u53d6\u6570\u9879\u76ee\u88ab\u5176\u4ed6\u914d\u7f6e\u5173\u8054\uff0c\u5982\u679c\u7981\u7528\u4f1a\u5f71\u54cd\u8ba1\u7b97\u53d6\u6570\uff0c\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"FetchConfigEdit_37", (String)SYSTEM_TYPE, (Object[])new Object[0]), message, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(FETCHITEMQUOTEDISABLE, (IFormPlugin)this));
            return true;
        }
        return false;
    }

    private boolean checkChangeCalOrDimensionality() {
        String enable = this.getModel().getDataEntity().getString("enable");
        if (!SWCStringUtils.equals((String)FETCHCONFIG_CONDITIONLOGIC_TYPE_AND, (String)enable)) {
            return false;
        }
        String calculationFetch = this.getModel().getDataEntity().getString(CHANGE_FETCH_CAL);
        String dimensionality = this.getModel().getDataEntity().getString(CHANGE_DIMENSIONALITY);
        ArrayList<Long> ids = new ArrayList<Long>();
        long id = this.getModel().getDataEntity().getLong("id");
        ids.add(id);
        FetchConfigHelper fetchConfigHelper = new FetchConfigHelper();
        DynamicObject[] fetchConfigObjs = fetchConfigHelper.selectFetchConfigList(ids);
        if (fetchConfigObjs == null) {
            return false;
        }
        DynamicObject[] fetchItems = fetchConfigHelper.selectFetchItemList(ids);
        List<Long> fetchItemList = Arrays.stream(fetchItems).map(param -> param.getLong("fetchitem.id")).collect(Collectors.toList());
        String oldCalculationfetch = fetchConfigObjs[0].getString(CHANGE_FETCH_CAL);
        String message = "";
        boolean flag = true;
        if (!SWCStringUtils.equals((String)calculationFetch, (String)oldCalculationfetch)) {
            if (SWCStringUtils.equals((String)"true", (String)oldCalculationfetch)) {
                message = fetchConfigHelper.checkFetchConfigQuote(fetchItemList);
            } else {
                message = this.selectFetchCOnfigQuote(message, fetchConfigHelper, fetchItemList, flag);
                flag = false;
            }
        }
        String oldDimensionality = fetchConfigObjs[0].getString(CHANGE_DIMENSIONALITY);
        if (!SWCStringUtils.equals((String)dimensionality, (String)fetchConfigObjs[0].getString(CHANGE_DIMENSIONALITY)) && SWCStringUtils.equals((String)FETCHCONFIG_CONDITIONLOGIC_TYPE_AND, (String)oldDimensionality)) {
            message = this.selectFetchCOnfigQuote(message, fetchConfigHelper, fetchItemList, flag);
        }
        if (SWCStringUtils.isNotEmpty((String)message)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5bf9\u53d6\u6570\u7ef4\u5ea6\u3001\u8ba1\u7b97\u4e2d\u53d6\u6570\u3001\u53d6\u6570\u5b57\u6bb5\u7684\u8c03\u6574\uff0c\u4f1a\u5f71\u54cd\u5b58\u5728\u5173\u8054\u5173\u7cfb\u7684\u5176\u4ed6\u914d\u7f6e\uff0c\u8bf7\u8c03\u6574\u540e\u91cd\u8bd5\u3002", (String)"FetchConfigEdit_36", (String)SYSTEM_TYPE, (Object[])new Object[0]), message, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(CHECKFETCHITEMQUOTE, (IFormPlugin)this));
            return true;
        }
        return false;
    }

    private String selectFetchCOnfigQuote(String message, FetchConfigHelper fetchConfigHelper, List<Long> fetchItemList, boolean flag) {
        if (flag) {
            message = fetchConfigHelper.checkFetchConfigQuote(fetchItemList);
            message = message + fetchConfigHelper.checkCustFetchConfigQuote(fetchItemList);
            message = message + fetchConfigHelper.checkResultFetchConfigQuote(fetchItemList);
        }
        return message;
    }

    private String assembleFetchItemStr(List<String> fetchItemList) {
        StringBuilder sb = new StringBuilder();
        if (!CollectionUtils.isEmpty(fetchItemList)) {
            fetchItemList.stream().forEach(item -> sb.append('\u3010').append((String)item).append('\u3011'));
        }
        return sb.toString();
    }

    private void setFetchItemDataStatus(PropertyChangedArgs args, String fieldMark) {
        int seq = Integer.parseInt(args.getChangeSet()[0].getDataEntity().getString("seq")) - 1;
        String filterCheck = this.getView().getPageCache().get(fieldMark + "_filterCheck_" + seq);
        if (!SWCStringUtils.equals((String)filterCheck, (String)FETCHCONFIG_CONDITIONLOGIC_TYPE_AND)) {
            this.getView().getPageCache().put(fieldMark + "_filterCheck_" + seq, FETCHCONFIG_CONDITIONLOGIC_TYPE_AND);
            this.getModel().beginInit();
            if (StringUtils.equals((CharSequence)fieldMark, (CharSequence)"fetchitem")) {
                this.getModel().setValue(fieldMark, args.getChangeSet()[0].getNewValue(), seq);
            } else {
                this.getModel().setValue(fieldMark, args.getChangeSet()[0].getOldValue(), seq);
            }
            this.getModel().endInit();
        } else {
            this.getView().getPageCache().put(fieldMark + "_filterCheck_" + seq, null);
        }
    }
}

