/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.basedata.fetchconfig;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.FetchItemCheckResultVo;
import kd.swc.hsbs.business.basedata.fetchconfig.FetchConfigHelper;

public class FetchConfigList
extends AbstractListPlugin {
    private static final String CHECKFETCHITEMQUOTE = "checkFetchItemQuote";
    private static final char LEFT_MID_BRACKET = '\u3010';
    private static final char RIGHT_MID_BRACKET = '\u3011';

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection coll;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (SWCStringUtils.equals((String)operateKey, (String)"enable")) {
            coll = args.getListSelectedData();
            Object[] ids = coll.getPrimaryKeyValues();
            if (ids.length > 1) {
                String errorTips = ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u6279\u91cf\u542f\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"FetchConfigList_1", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(errorTips);
                return;
            }
            FetchItemCheckResultVo result = FetchConfigHelper.checkFetchConfigCycle((long)((Long)ids[0]));
            if (SWCStringUtils.equals((String)"1", (String)result.getResult())) {
                String fetchItemStr = this.assembleFetchItemStr(result.getFetchItemList());
                this.getView().showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u53d6\u6570\u914d\u7f6e{0}\u5b58\u5728\u5faa\u73af\u4f9d\u8d56\uff0c\u8bf7\u68c0\u67e5\u53d6\u6570\u914d\u7f6e\uff0c\u5e76\u4fee\u6539\u3002", (String)"FetchConfigList_2", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), fetchItemStr));
                return;
            }
            if (SWCStringUtils.equals((String)"2", (String)result.getResult())) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u53d6\u6570\u9879\u76ee\u4f9d\u8d56\u5c42\u6b21\u5c06\u8d85\u8fc75\u5c42\uff0c\u53ef\u80fd\u589e\u5927\u8ba1\u7b97\u6846\u67b6\u590d\u6742\u5ea6\u4ee5\u53ca\u8ba1\u7b97\u6027\u80fd\u635f\u8017\uff0c\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"FetchConfigList_3", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("fetch_too_many_notify", (IFormPlugin)this));
                return;
            }
        }
        if (SWCStringUtils.equals((String)"delete", (String)operateKey)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("hsbs_fetchconfigitem").append(',').append("hsbs_fetchfilterentry");
            operate.getOption().setVariableValue("ignorerefentityids", stringBuilder.toString());
        }
        if (SWCStringUtils.equals((String)"disable", (String)operateKey) && !operate.getOption().tryGetVariableValue("disable", new RefObject())) {
            coll = args.getListSelectedData();
            Object[] primaryKeyValues = coll.getPrimaryKeyValues();
            List<Long> fetchConfigIds = Arrays.stream(primaryKeyValues).map(param -> (Long)param).collect(Collectors.toList());
            args.setCancel(this.checkFetchItemConfigList(fetchConfigIds));
        }
    }

    private String assembleFetchItemStr(List<String> fetchItemList) {
        StringBuilder sb = new StringBuilder();
        if (!CollectionUtils.isEmpty(fetchItemList)) {
            fetchItemList.stream().forEach(item -> sb.append('\u3010').append((String)item).append('\u3011'));
        }
        return sb.toString();
    }

    private boolean checkFetchItemConfigList(List<Long> fetchConfigIds) {
        FetchConfigHelper fetchConfigHelper = new FetchConfigHelper();
        DynamicObject[] fetchItems = fetchConfigHelper.selectFetchItemList(fetchConfigIds);
        List fetchItemList = Arrays.stream(fetchItems).map(param -> param.getLong("fetchitem.id")).collect(Collectors.toList());
        String message = fetchConfigHelper.checkFetchConfigQuote(fetchItemList);
        message = message + fetchConfigHelper.checkCustFetchConfigQuote(fetchItemList);
        if (SWCStringUtils.isNotEmpty((String)(message = message + fetchConfigHelper.checkResultFetchConfigQuote(fetchItemList)))) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u53d6\u6570\u9879\u76ee\u88ab\u5176\u4ed6\u914d\u7f6e\u5173\u8054\uff0c\u5982\u679c\u7981\u7528\u4f1a\u5f71\u54cd\u8ba1\u7b97\u53d6\u6570\uff0c\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"FetchConfigList_0", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), message, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(CHECKFETCHITEMQUOTE, (IFormPlugin)this));
            return true;
        }
        return false;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
            case "checkFetchItemQuote": {
                if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("disable", "false");
                this.getView().invokeOperation("disable", operateOption);
                break;
            }
        }
    }
}

