/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.basedata.fetchconfig;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbs.business.basedata.fetchconfig.FetchConfigHelper;

public class FetchItemList
extends AbstractListPlugin {
    public void setFilter(SetFilterEvent args) {
        super.setFilter(args);
        List qFilters = args.getQFilters();
        ArrayList<QFilter> addQFilterList = new ArrayList<QFilter>(10);
        ArrayList<QFilter> removeQFilterList = new ArrayList<QFilter>(10);
        for (QFilter qFilter : qFilters) {
            String property;
            if (null == qFilter || !SWCStringUtils.equals((String)(property = qFilter.getProperty()), (String)"fetchconfig")) continue;
            List fetchItemIds = FetchConfigHelper.selectRelatedFetchItemIdList((QFilter)qFilter);
            if (CollectionUtils.isEmpty((Collection)fetchItemIds)) break;
            Object value = qFilter.getValue();
            String cp = qFilter.getCP();
            if (SWCStringUtils.equals((String)cp, (String)"=") && SWCStringUtils.equals((String)value.toString(), (String)"EMPTY")) {
                addQFilterList.add(new QFilter("id", "not in", (Object)fetchItemIds));
            } else {
                addQFilterList.add(new QFilter("id", "in", (Object)fetchItemIds));
            }
            removeQFilterList.add(qFilter);
            break;
        }
        qFilters.addAll(addQFilterList);
        qFilters.removeAll(removeQFilterList);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                DynamicObjectCollection collection = super.getData(arg0, arg1);
                ArrayList pkIds = new ArrayList(collection.size());
                collection.forEach(param -> pkIds.add((Long)param.getPkValue()));
                Map relatedFetchItemMap = FetchConfigHelper.getRelatedFetchItemList(pkIds);
                if (null == relatedFetchItemMap) {
                    return collection;
                }
                for (DynamicObject dynamicObject : collection) {
                    FetchItemList.this.setFetchConfigData(relatedFetchItemMap, dynamicObject);
                }
                return collection;
            }
        });
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if (SWCStringUtils.equals((String)"fetchconfig", (String)fieldName)) {
            this.clickFetchConfigHyperLink(args);
        }
    }

    private void setFetchConfigData(Map<Long, DynamicObject> relatedFetchItemMap, DynamicObject dynamicObject) {
        String fetchConfigType;
        long fetchItem = dynamicObject.getLong("id");
        DynamicObject fetchItemObj = relatedFetchItemMap.get(fetchItem);
        if (null == fetchItemObj) {
            return;
        }
        String dimensionality = "";
        String calTaskName = ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1", (String)"FetchConfigEdit_9", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
        String calObjectName = ResManager.loadKDString((String)"\u6838\u7b97\u5bf9\u8c61", (String)"FetchConfigEdit_6", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)fetchItemObj.getString("fetchconfig.dimensionality"))) {
            dimensionality = StringUtils.equals((CharSequence)fetchItemObj.getString("fetchconfig.dimensionality"), (CharSequence)"1") ? calTaskName : calObjectName;
        }
        String calculationfetch = "";
        if (StringUtils.isNotBlank((CharSequence)fetchItemObj.getString("fetchconfig.calculationfetch"))) {
            String openName = ResManager.loadKDString((String)"\u662f", (String)"FetchConfigEdit_24", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
            String closeName = ResManager.loadKDString((String)"\u5426", (String)"FetchConfigEdit_25", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
            calculationfetch = StringUtils.equals((CharSequence)fetchItemObj.getString("fetchconfig.calculationfetch"), (CharSequence)"true") ? openName : closeName;
        }
        String configType = "";
        switch (fetchConfigType = fetchItemObj.getString("configtype")) {
            case "0": {
                configType = ResManager.loadKDString((String)"\u53d6\u6570\u914d\u7f6e", (String)"FetchConfigEdit_27", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
                dynamicObject.set("fetchconfig", fetchItemObj.get("fetchconfig.name"));
                break;
            }
            case "1": {
                configType = ResManager.loadKDString((String)"\u85aa\u916c\u7ed3\u679c\u53d6\u6570\u914d\u7f6e", (String)"FetchConfigEdit_28", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
                dimensionality = ResManager.loadKDString((String)"\u6838\u7b97\u5bf9\u8c61", (String)"FetchConfigEdit_6", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
                calculationfetch = ResManager.loadKDString((String)"\u5426", (String)"FetchConfigEdit_25", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
                dynamicObject.set("fetchconfig", fetchItemObj.get("resultfetchconfig.name"));
                break;
            }
            case "2": {
                configType = ResManager.loadKDString((String)"\u63d2\u4ef6\u53d6\u6570\u914d\u7f6e", (String)"CustFetchConfigEdit_2", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
                dimensionality = StringUtils.equals((CharSequence)fetchItemObj.getString("custfetchconfig.dimensionality"), (CharSequence)"1") ? calTaskName : calObjectName;
                calculationfetch = ResManager.loadKDString((String)"\u5426", (String)"FetchConfigEdit_25", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
                dynamicObject.set("fetchconfig", fetchItemObj.get("custfetchconfig.name"));
                break;
            }
        }
        dynamicObject.set("dimensionality", (Object)dimensionality);
        dynamicObject.set("calculationfetch", (Object)calculationfetch);
        dynamicObject.set("configtype", (Object)configType);
    }

    private void clickFetchConfigHyperLink(HyperLinkClickArgs args) {
        args.setCancel(true);
        IListView listView = (IListView)this.getView();
        long pkId = (Long)ObjectConverter.convert((Object)listView.getFocusRowPkId(), Long.class, (boolean)true);
        QFilter qFilter = new QFilter("fetchitem", "=", (Object)pkId);
        DynamicObject dynamicObject = FetchConfigHelper.getRelatedFetchItemInfo((QFilter)qFilter, (String)"fetchconfig,resultfetchconfig,custfetchconfig,configtype");
        if (null == dynamicObject) {
            String errorTips = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u3002", (String)"FetchConfigEdit_26", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errorTips);
            return;
        }
        IListView listview = (IListView)this.getView();
        long enrollId = (Long)listview.getFocusRowPkId();
        String formId = listview.getBillFormId();
        boolean cheackIsDeleted = SWCShowFormServiceHelper.isExists((Object)enrollId, (String)formId);
        if (!cheackIsDeleted) {
            String errorTips = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u3002", (String)"FetchConfigEdit_26", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errorTips);
            return;
        }
        String configtype = dynamicObject.getString("configtype");
        long fetchConfig = dynamicObject.getLong("fetchconfig.id");
        long currUserId = RequestContext.get().getCurrUserId();
        boolean addFlag = false;
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        if (StringUtils.equals((CharSequence)configtype, (CharSequence)"0")) {
            baseShowParameter.setFormId("hsbs_fetchconfig");
            addFlag = SWCPermissionServiceHelper.hasPerm((long)currUserId, (String)"/UHLXNRR9KPZ", (String)"hsbs_fetchconfig", (String)"4715a0df000000ac");
        }
        if (StringUtils.equals((CharSequence)configtype, (CharSequence)"1")) {
            baseShowParameter.setFormId("hsbs_resultfetchconfig");
            addFlag = SWCPermissionServiceHelper.hasPerm((long)currUserId, (String)"/UHLXNRR9KPZ", (String)"hsbs_resultfetchconfig", (String)"4715a0df000000ac");
            fetchConfig = dynamicObject.getLong("resultfetchconfig.id");
        }
        if (StringUtils.equals((CharSequence)configtype, (CharSequence)"2")) {
            baseShowParameter.setFormId("hsbs_custfetchconfig");
            addFlag = SWCPermissionServiceHelper.hasPerm((long)currUserId, (String)"/UHLXNRR9KPZ", (String)"hsbs_resultfetchconfig", (String)"4715a0df000000ac");
            fetchConfig = dynamicObject.getLong("custfetchconfig.id");
        }
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if (addFlag) {
            baseShowParameter.setStatus(OperationStatus.EDIT);
        } else {
            baseShowParameter.setStatus(OperationStatus.VIEW);
        }
        baseShowParameter.setPkId((Object)fetchConfig);
        baseShowParameter.setPageId(this.getView().getPageId() + "form" + fetchConfig);
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }
}

