/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.basedata.onholdmsgcfg;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class OnHoldMsgConfigEidt
extends SWCDataBaseEdit
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private static final String KEY_RECEIVER = "receiver";
    private static final String RECEIVER_PAGE = "hrcs_rolelist";
    private static final String KEY_MSGTEMPLATE = "msgtemplate";
    private static final String KEY_MSGTEMPLATECONTENT = "msgtemplatecontent";
    private static final String KEY_MSGSCENE = "msgscene";

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.setMsgScene();
        this.initEditData();
    }

    private void setMsgScene() {
        SWCDataServiceHelper msgTemplateHelper = new SWCDataServiceHelper("msg_template");
        String selectProperties = "msgscene,msgscenename";
        DynamicObject[] templates = msgTemplateHelper.query(selectProperties, new QFilter[]{new QFilter("msgentity", "=", (Object)"hsas_onholdbill")});
        HashMap<String, String> sceneMap = new HashMap<String, String>(16);
        for (DynamicObject template : templates) {
            String msgscene = template.getString(KEY_MSGSCENE);
            String msgscenename = template.getString("msgscenename");
            if (sceneMap.containsKey(msgscene)) continue;
            sceneMap.put(msgscene, msgscenename);
        }
        ComboEdit sceneCtl = (ComboEdit)this.getView().getControl(KEY_MSGSCENE);
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(10);
        for (Map.Entry scene : sceneMap.entrySet()) {
            data.add(new ComboItem(new LocaleString((String)scene.getValue()), (String)scene.getKey()));
        }
        sceneCtl.setComboItems(data);
    }

    private void initEditData() {
        DynamicObject templateObj = this.getModel().getDataEntity().getDynamicObject(KEY_MSGTEMPLATE);
        if (templateObj == null) {
            return;
        }
        String msgtemplate = templateObj.getString(KEY_MSGTEMPLATE);
        String msgscene = templateObj.getString(KEY_MSGSCENE);
        if (SWCStringUtils.isNotEmpty((String)msgtemplate)) {
            this.getModel().setValue(KEY_MSGTEMPLATECONTENT, (Object)msgtemplate);
        }
        if (SWCStringUtils.isNotEmpty((String)msgscene)) {
            this.getModel().setValue(KEY_MSGSCENE, (Object)msgscene);
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{KEY_MSGTEMPLATECONTENT});
        this.addBeforeF7SelectListener(KEY_MSGTEMPLATE);
        BasedataEdit msgTemplateCtl = (BasedataEdit)this.getView().getControl(KEY_MSGTEMPLATE);
        msgTemplateCtl.addAfterF7SelectListener((AfterF7SelectListener)this);
    }

    private void addBeforeF7SelectListener(String ... fields) {
        for (String filed : fields) {
            BasedataEdit control = (BasedataEdit)this.getView().getControl(filed);
            control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent args) {
        String key;
        switch (key = args.getProperty().getName()) {
            case "msgtemplate": {
                String msgscene = this.getModel().getDataEntity().getString(KEY_MSGSCENE);
                ListShowParameter showParameter = (ListShowParameter)args.getFormShowParameter();
                List qFilters = showParameter.getListFilterParameter().getQFilters();
                if (SWCStringUtils.isNotEmpty((String)msgscene)) {
                    qFilters.add(new QFilter(KEY_MSGSCENE, "=", (Object)msgscene));
                }
                qFilters.add(new QFilter("msgentity", "=", (Object)"hsas_onholdbill"));
                break;
            }
        }
    }

    public void afterF7Select(AfterF7SelectEvent evt) {
        Control control = (Control)evt.getSource();
        switch (control.getKey()) {
            case "msgtemplate": {
                DynamicObject msgConfig = this.getModel().getDataEntity(true);
                String msgTemplateContent = msgConfig.getString("msgtemplate.msgtemplate");
                this.getModel().setValue(KEY_MSGTEMPLATECONTENT, (Object)msgTemplateContent);
                if (!SWCStringUtils.isEmpty((String)msgConfig.getString(KEY_MSGSCENE))) break;
                this.getModel().setValue(KEY_MSGSCENE, (Object)msgConfig.getString("msgtemplate.msgscene"));
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (source.getKey()) {
            case "msgtemplatecontent": {
                BasedataEdit msgTemplateCtl = (BasedataEdit)this.getView().getControl(KEY_MSGTEMPLATE);
                msgTemplateCtl.click();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey = args.getProperty().getName();
        if (SWCStringUtils.equals((String)KEY_MSGSCENE, (String)fieldKey)) {
            this.setMsgTemplateNull();
        }
    }

    private void setMsgTemplateNull() {
        DynamicObject msgConfig = this.getModel().getDataEntity();
        String displayScene = msgConfig.getString(KEY_MSGSCENE);
        String templateScene = msgConfig.getString("msgtemplate.msgscene");
        if (!SWCStringUtils.equals((String)templateScene, (String)displayScene)) {
            this.getModel().setValue(KEY_MSGTEMPLATE, null);
            this.getModel().setValue(KEY_MSGTEMPLATECONTENT, null);
        }
    }
}

