/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.basedata.paysubject;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.TipsSupport;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.paysubject.PaySubjectLawHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCSalaryParameterServiceHelper;
import kd.swc.hsbp.common.history.model.SWCHisBaseConstants;
import kd.swc.hsbp.common.util.SWCBaseUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbs.business.basedata.paysubject.PaySubjectHelper;
import kd.swc.hsbs.common.enums.CashIntergrationEnum;
import kd.swc.hsbs.formplugin.web.basedata.HisBaseDataSummaryEdit;

public class PaySubjectEdit
extends HisBaseDataSummaryEdit
implements BeforeF7SelectListener {
    private static final String AP_AGENTPAY = "agentpayap";
    private static final String CASHINTERGRATION = "cashintergration";
    private static final String PAYENTITY = "payorgent";
    private static final String AGENTPAYORG = "agentpayorg";
    private static final String ISDEFAULT = "isdefault";
    private static final String SCOPEOPERATION = "scopeoperation";
    private static final String CHECKSCOPE = "donothing_checkscope";
    private static final String SETSCOPE = "donothing_setscope";
    private static final String ADDAGENTPAYORG = "donothing_addagentpayorg";
    private static final String CONFIRMCHANGE = "confirmchange";
    private static final String CALL_BACK_SCOPE = "call_back_scope";
    private static final String CALL_BACK_CASH = "call_back_cash";

    public void setView(IFormView formView) {
        BasedataEdit countryEdit;
        super.setView(formView);
        if (BaseDataHisHelper.isHisPage((IFormView)this.getView()) && (countryEdit = (BasedataEdit)this.getView().getControl("country")) != null) {
            countryEdit.setEnable(null, false, 0);
        }
    }

    public void initialize() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(PAYENTITY);
        entryGrid.addPackageDataListener(pkEvent -> {
            if (pkEvent.getSource() instanceof OperationColumn && SCOPEOPERATION.equalsIgnoreCase(((OperationColumn)pkEvent.getSource()).getKey())) {
                List operationColItems = (List)pkEvent.getFormatValue();
                BillOperationStatus billStatus = ((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus();
                boolean isDefault = pkEvent.getRowData().getBoolean(ISDEFAULT);
                for (OperationColItem operationColItem : operationColItems) {
                    boolean isModify;
                    if (isDefault) {
                        operationColItem.setVisible(false);
                        continue;
                    }
                    String operationKey = operationColItem.getOperationKey();
                    boolean isHisPage = BaseDataHisHelper.isHisPage((IFormView)this.getView());
                    boolean bl = isModify = BillOperationStatus.ADDNEW.equals((Object)billStatus) || BillOperationStatus.EDIT.equals((Object)billStatus);
                    if (!isModify && SETSCOPE.equals(operationKey)) {
                        operationColItem.setVisible(false);
                    }
                    if (isModify && CHECKSCOPE.equals(operationKey)) {
                        operationColItem.setVisible(false);
                    }
                    String pageStatus = this.getPageCache().get("pageStatus");
                    String mutexOperKey = this.getPageCache().get("MUTEX_OPER_KEY");
                    String hisPageEnable = this.getPageCache().get("hisPageEnable");
                    if (!isHisPage || !"edit".equals(pageStatus) && !"modify".equals(mutexOperKey)) continue;
                    if (CHECKSCOPE.equals(operationKey)) {
                        operationColItem.setVisible(false);
                        continue;
                    }
                    if (!SETSCOPE.equals(operationKey)) continue;
                    operationColItem.setVisible(true);
                }
            }
        });
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        OrgEdit payOrg = (OrgEdit)this.getControl(AGENTPAYORG);
        payOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit lawEntity = (BasedataEdit)this.getControl("lawentity");
        lawEntity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object needlaw = SWCSalaryParameterServiceHelper.getSalaryParam((String)"paysubject", (String)"needlaw");
        if (needlaw != null && Boolean.parseBoolean(String.valueOf(needlaw))) {
            BasedataEdit lawentityEdit = (BasedataEdit)this.getView().getControl("lawentity");
            lawentityEdit.setMustInput(true);
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        String cashintergration = this.getModel().getDataEntity().getString(CASHINTERGRATION);
        boolean isKingdee = cashintergration != null && SWCStringUtils.indexOfIgnoreCase((String)cashintergration, (String)CashIntergrationEnum.KINGDEE.getCode()) >= 0;
        this.setAgentpayVisible(isKingdee);
        this.initTips();
        BillOperationStatus billStatus = ((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus();
        if (BaseDataHisHelper.isHisPage((IFormView)this.getView()) && BillOperationStatus.ADDNEW.equals((Object)billStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"summaryap"});
        }
        if (PaySubjectLawHelper.getLawIsMust().booleanValue()) {
            BasedataEdit lawEntity = (BasedataEdit)this.getControl("lawentity");
            lawEntity.setMustInput(true);
        }
    }

    public void afterLoadData(EventObject eventObject) {
        this.updateEntrySeq();
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propName = args.getProperty().getName();
        ChangeData[] changeSet = args.getChangeSet();
        ChangeData changeDate = changeSet[0];
        switch (propName) {
            case "cashintergration": {
                String cashintergration = (String)changeDate.getNewValue();
                Boolean isKingdee = cashintergration != null && SWCStringUtils.indexOfIgnoreCase((String)cashintergration, (String)CashIntergrationEnum.KINGDEE.getCode()) >= 0;
                if (this.getModel().getDataEntity(true).getDynamicObjectCollection(PAYENTITY).isEmpty()) {
                    this.setAgentpayVisible(isKingdee);
                    return;
                }
                this.changeCashInterGartion();
                break;
            }
            case "isdefault": {
                Boolean isdefault = (Boolean)changeDate.getNewValue();
                if (isdefault != null && isdefault.booleanValue()) {
                    this.isDefaultEvent();
                    break;
                }
                this.getView().updateView(PAYENTITY, this.getCurrentRowIndex());
                break;
            }
        }
    }

    private void initTips() {
        Object entry2;
        List promptString = (List)SWCMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSService", (String)"queryPromptForString", (Object[])new Object[]{this.getModel().getDataEntityType().getName(), "payorgentlab", this.getModel().getDataEntity()});
        String tipsValue = "";
        for (Object entry2 : promptString) {
            tipsValue = entry2;
        }
        Label label = (Label)this.getControl("payorgentlab");
        label.setText(tipsValue);
        promptString = (List)SWCMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSService", (String)"queryPromptForString", (Object[])new Object[]{this.getModel().getDataEntityType().getName(), CASHINTERGRATION, this.getModel().getDataEntity()});
        entry2 = promptString.iterator();
        while (entry2.hasNext()) {
            String entry3;
            tipsValue = entry3 = (String)entry2.next();
        }
        Tips tips = new Tips();
        tips.setType("text");
        tips.setContent(new LocaleString(tipsValue));
        TipsSupport control = (TipsSupport)this.getControl(CASHINTERGRATION);
        control.addTips(tips);
    }

    private void isDefaultEvent() {
        EntryGrid grid = (EntryGrid)this.getControl(PAYENTITY);
        int[] rows = grid.getSelectRows();
        int selectRow = rows[0];
        Integer defaultOrgInex = this.getDefaultOrgIndex(selectRow);
        Boolean selectedIsdefault = (Boolean)this.getModel().getValue(ISDEFAULT, selectRow);
        String cashInterGration = this.getModel().getDataEntity().getString(CASHINTERGRATION);
        if (defaultOrgInex != null && selectedIsdefault != null && selectedIsdefault.booleanValue()) {
            String msg = SWCStringUtils.equals((String)CashIntergrationEnum.KINGDEE.getCode(), (String)cashInterGration) ? ResManager.loadKDString((String)"\u6bcf\u4e2a\u652f\u4ed8\u4e3b\u4f53\u53ea\u80fd\u8bbe\u7f6e\u4e00\u4e2a\u9ed8\u8ba4\u4ed8\u6b3e\u8d44\u91d1\u7ec4\u7ec7\uff0c\u786e\u8ba4\u66ff\u6362\u73b0\u6709\u7684\u9ed8\u8ba4\u4ed8\u6b3e\u8d44\u91d1\u7ec4\u7ec7\uff1f", (String)"PaySubjectEdit_BLUE_1", (String)"swc-hsbs-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6bcf\u4e2a\u652f\u4ed8\u4e3b\u4f53\u53ea\u80fd\u8bbe\u7f6e\u4e00\u4e2a\u9ed8\u8ba4\u4ed8\u6b3e\u8d26\u53f7\uff0c\u786e\u8ba4\u66ff\u6362\u73b0\u6709\u7684\u9ed8\u8ba4\u4ed8\u6b3e\u8d26\u53f7\uff1f", (String)"PaySubjectEdit_BLUE_2", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
            MessageBoxOptions options = MessageBoxOptions.YesNo;
            ConfirmCallBackListener listener = new ConfirmCallBackListener("setDefaultOrg");
            this.getView().showConfirm(msg, options, listener);
        } else {
            this.getView().updateView(PAYENTITY, this.getCurrentRowIndex());
        }
    }

    private void changeCashInterGartion() {
        String msg = ResManager.loadKDString((String)"\u53d8\u66f4\u5bf9\u63a5\u51fa\u7eb3\u7cfb\u7edf\uff0c\u5c06\u6e05\u7a7a\u4ed8\u6b3e\u4fe1\u606f\uff0c\u786e\u8ba4\u7ee7\u7eed\u53d8\u66f4\uff1f", (String)"PaySubjectEdit_BLUE_3", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"PaySubjectEdit_BLUE_4", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u5b9a", (String)"PaySubjectEdit_BLUE_5", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        ConfirmCallBackListener listener = new ConfirmCallBackListener(CALL_BACK_CASH);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, listener, btnNameMaps);
    }

    private Integer getDefaultOrgIndex(int selectCol) {
        DynamicObjectCollection cols = this.getModel().getEntryEntity(PAYENTITY);
        DynamicObject col = null;
        int size = cols.size();
        for (int i = 0; i < size; ++i) {
            boolean isdefault;
            if (i == selectCol || !(isdefault = (col = (DynamicObject)cols.get(i)).getBoolean(ISDEFAULT))) continue;
            return i;
        }
        return null;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        if (null == returnData) {
            return;
        }
        switch (closedCallBackEvent.getActionId()) {
            case "call_back_scope": {
                Map paySubjectScopeMap = (Map)returnData.get("paySubjectScopeMap");
                this.setPayEntityData(paySubjectScopeMap);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String key;
        super.confirmCallBack(event);
        switch (key = event.getCallBackId()) {
            case "setDefaultOrg": {
                if (event.getResult().equals((Object)MessageBoxResult.Yes)) {
                    this.swapDefaultPayOrg();
                    break;
                }
                this.rollBackChangeDefaulet();
                break;
            }
            case "call_back_cash": {
                String cashintergration = this.getModel().getDataEntity().getString(CASHINTERGRATION);
                Boolean isKingdee = cashintergration != null && SWCStringUtils.indexOfIgnoreCase((String)cashintergration, (String)CashIntergrationEnum.KINGDEE.getCode()) >= 0;
                if (event.getResult().equals((Object)MessageBoxResult.Yes)) {
                    this.setAgentpayVisible(isKingdee);
                    this.clearAgentPayOrg();
                    break;
                }
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                model.beginInit();
                cashintergration = isKingdee != false ? null : CashIntergrationEnum.KINGDEE.getCode();
                this.getModel().setValue(CASHINTERGRATION, (Object)cashintergration);
                model.endInit();
                this.getView().updateView(CASHINTERGRATION);
                break;
            }
        }
    }

    private void rollBackChangeDefaulet() {
        EntryGrid grid = (EntryGrid)this.getControl(PAYENTITY);
        int[] rows = grid.getSelectRows();
        int selectRow = rows[0];
        this.getModel().setValue(ISDEFAULT, (Object)Boolean.FALSE, selectRow);
    }

    private void swapDefaultPayOrg() {
        EntryGrid grid = (EntryGrid)this.getControl(PAYENTITY);
        int[] rows = grid.getSelectRows();
        int selectRow = rows[0];
        int oldRow = this.getDefaultOrgIndex(selectRow);
        this.getModel().setValue(ISDEFAULT, (Object)Boolean.TRUE, selectRow);
        this.getModel().setValue(ISDEFAULT, (Object)Boolean.FALSE, oldRow);
    }

    private void setAgentpayVisible(boolean visible) {
        EntryGrid payentity = (EntryGrid)this.getControl(PAYENTITY);
        payentity.setMustInput(AGENTPAYORG, visible);
        payentity.setMustInput("agentpayaccount", !visible);
        payentity.setMustInput("agentpaybank", !visible);
        payentity.setMustInput(PAYENTITY, visible);
        this.getView().setVisible(Boolean.valueOf(!visible), new String[]{"agentpayaccount", "agentpaybank"});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{AGENTPAYORG});
    }

    private FormShowParameter getScopeForm() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALL_BACK_SCOPE));
        parameter.setFormId("hsbs_paysubjectscope");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        return parameter;
    }

    private Map<String, Object> getScopeData() {
        HashMap<String, Object> paySubjectScopeMap = new HashMap<String, Object>(16);
        DynamicObject dataEntity = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection(PAYENTITY).get(this.getCurrentRowIndex());
        DynamicObjectCollection salaryItem = dataEntity.getDynamicObjectCollection("salaryitemmul");
        DynamicObjectCollection payMethod = dataEntity.getDynamicObjectCollection("paymethodmul");
        DynamicObjectCollection currency = dataEntity.getDynamicObjectCollection("currencymul");
        DynamicObjectCollection bankPurpose = dataEntity.getDynamicObjectCollection("bankpurposemul");
        String filterGridData = dataEntity.getString("applicationscope");
        paySubjectScopeMap.put("filterGridData", filterGridData);
        paySubjectScopeMap.put("salaryItem", salaryItem.stream().map(object -> object.getLong("fbasedataid_id")).collect(Collectors.toList()));
        paySubjectScopeMap.put("payMethod", payMethod.stream().map(object -> object.getLong("fbasedataid_id")).collect(Collectors.toList()));
        paySubjectScopeMap.put("currency", currency.stream().map(object -> object.getLong("fbasedataid_id")).collect(Collectors.toList()));
        paySubjectScopeMap.put("bankPurpose", bankPurpose.stream().map(object -> object.getLong("fbasedataid_id")).collect(Collectors.toList()));
        return paySubjectScopeMap;
    }

    private int getCurrentRowIndex() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int rowIndex = proxy.getEntryState(PAYENTITY).getFocusRow();
        return rowIndex;
    }

    private void setPayEntityData(Map<String, Object> paySubjectScopeMap) {
        String filterGridData = (String)paySubjectScopeMap.get("filterGridData");
        List salaryItem = (List)paySubjectScopeMap.get("salaryItem");
        List payMethod = (List)paySubjectScopeMap.get("payMethod");
        List currency = (List)paySubjectScopeMap.get("currency");
        List bankPurpose = (List)paySubjectScopeMap.get("bankPurpose");
        int currentRowIndex = this.getCurrentRowIndex();
        this.getModel().setValue("applicationscope", (Object)filterGridData, currentRowIndex);
        this.getModel().setValue("salaryitemmul", (Object)salaryItem.toArray(), currentRowIndex);
        this.getModel().setValue("paymethodmul", (Object)payMethod.toArray(), currentRowIndex);
        this.getModel().setValue("currencymul", (Object)currency.toArray(), currentRowIndex);
        this.getModel().setValue("bankpurposemul", (Object)bankPurpose.toArray(), currentRowIndex);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        FormOperate forOperate = (FormOperate)args.getSource();
        switch (key = forOperate.getOperateKey()) {
            case "confirmchange": {
                ((BillShowParameter)this.getView().getFormShowParameter()).setBillStatus(BillOperationStatus.VIEW);
                this.getView().updateView(PAYENTITY);
                break;
            }
            case "donothing_addagentpayorg": {
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                model.beginInit();
                model.batchCreateNewEntryRow(PAYENTITY, this.createEntryTableSetter());
                model.endInit();
                this.getView().updateView(PAYENTITY);
                break;
            }
            case "save": 
            case "submit": 
            case "audit": {
                forOperate.getOption().setVariableValue("isSave", "true");
                break;
            }
            case "donothing_checkscope": {
                FormShowParameter scopeForm = this.getScopeForm();
                scopeForm.setStatus(OperationStatus.VIEW);
                scopeForm.setCustomParam("paySubjectScopeMap", this.getScopeData());
                this.getView().showForm(scopeForm);
                break;
            }
            case "donothing_setscope": {
                FormShowParameter scopeForm = this.getScopeForm();
                scopeForm.setCustomParam("paySubjectScopeMap", this.getScopeData());
                this.getView().showForm(scopeForm);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        switch (args.getOperateKey()) {
            case "donothing_addagentpayorg": {
                this.updateEntrySeq();
                break;
            }
            case "deleteentry": {
                this.updateEntrySeq();
                break;
            }
            case "unsubmit": {
                ((BillShowParameter)this.getView().getFormShowParameter()).setBillStatus(BillOperationStatus.EDIT);
                this.getView().updateView(PAYENTITY);
                break;
            }
            case "save": 
            case "submit": 
            case "donothing_confirmchange": 
            case "confirmchange": {
                this.getView().updateView(PAYENTITY);
                break;
            }
        }
    }

    private void updateEntrySeq() {
        IDataModel dataModel = this.getModel();
        DynamicObjectCollection payentityColl = dataModel.getDataEntity(true).getDynamicObjectCollection(PAYENTITY);
        int seq = 1;
        for (DynamicObject dynamicObject : payentityColl) {
            dynamicObject.set("seq", (Object)seq);
            ++seq;
        }
    }

    private TableValueSetter createEntryTableSetter() {
        TableValueSetter entry = new TableValueSetter(new String[0]);
        entry.addField(ISDEFAULT, new Object[0]);
        boolean isDefault = false;
        DynamicObjectCollection coll = this.getModel().getDataEntity(true).getDynamicObjectCollection(PAYENTITY);
        if (coll != null && coll.stream().filter(data -> data.getBoolean(ISDEFAULT)).collect(Collectors.toList()).isEmpty()) {
            isDefault = true;
        }
        entry.addRow(new Object[]{isDefault});
        return entry;
    }

    private void clearAgentPayOrg() {
        IDataModel dataModel = this.getModel();
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        model.deleteEntryData(PAYENTITY);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key;
        switch (key = event.getProperty().getName()) {
            case "agentpayorg": {
                List fiOrgList = PaySubjectHelper.getFiReceiveOrgList();
                if (fiOrgList == null) break;
                FormShowParameter parameter = event.getFormShowParameter();
                List<Long> billList = this.getBillAgentPayOrgList();
                fiOrgList.removeAll(billList);
                parameter.setCustomParam("range", (Object)fiOrgList);
                parameter.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
                break;
            }
            case "lawentity": {
                this.setFilterBeforeSelectLawEntity(event);
                break;
            }
        }
    }

    private void setFilterBeforeSelectLawEntity(BeforeF7SelectEvent event) {
        SWCDataServiceHelper paySubjectHelper = new SWCDataServiceHelper("hsbs_paysubject");
        QFilter statusTempFilter = new QFilter("status", "in", Arrays.asList("A", "B"));
        QFilter statusAuditFilter = new QFilter("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
        statusTempFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        statusAuditFilter.and(new QFilter("iscurrentversion", "=", (Object)"0"));
        statusAuditFilter.or(statusTempFilter);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        QFilter lawEntityFilter = new QFilter("boid", "!=", (Object)dataEntity.getLong("boid"));
        Date bsled = dataEntity.getDate("bsled");
        lawEntityFilter.and(new QFilter("bsed", "<=", (Object)(bsled == null ? SWCBaseUtils.getMaxLoseEffectDate() : bsled)));
        lawEntityFilter.and(new QFilter("bsled", ">=", (Object)dataEntity.getDate("bsed")));
        DynamicObject[] paySubjectObjs = paySubjectHelper.query("lawentity", new QFilter[]{lawEntityFilter, statusAuditFilter});
        ArrayList<Long> idList = new ArrayList<Long>(10);
        for (DynamicObject paySubjectObj : paySubjectObjs) {
            Long lawId = paySubjectObj.getLong("lawentity.id");
            if (lawId == 0L) continue;
            idList.add(lawId);
        }
        QFilter idFilter = new QFilter("id", "not in", idList);
        event.addCustomQFilter(idFilter);
    }

    private List<Long> getBillAgentPayOrgList() {
        DynamicObjectCollection cols = this.getModel().getEntryEntity(PAYENTITY);
        ArrayList<Long> billIds = new ArrayList<Long>();
        for (DynamicObject col : cols) {
            long agentpayOrgId = col.getLong("agentpayorg.id");
            billIds.add(agentpayOrgId);
        }
        return billIds;
    }

    protected List<String> getFixSummarykeyList() {
        ArrayList<String> fixSummarykeyList = new ArrayList<String>();
        fixSummarykeyList.add("name");
        fixSummarykeyList.add("number");
        fixSummarykeyList.add("bsed");
        fixSummarykeyList.add("status");
        fixSummarykeyList.add("enable");
        fixSummarykeyList.add("country");
        fixSummarykeyList.add("countryimg");
        fixSummarykeyList.add("ismodify");
        return fixSummarykeyList;
    }
}

