/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.basedata.paysubject;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.ComboProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.common.enu.ValidatorOrderEnum;
import kd.hr.impt.core.validate.AbstractValidateHandler;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbs.common.enums.CashIntergrationEnum;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class PaySubjectImportHrValidatorHandler
extends AbstractValidateHandler {
    private static final Log logger = LogFactory.getLog(PaySubjectImportHrValidatorHandler.class);

    public ValidatorOrderEnum setValidatorRole() {
        return ValidatorOrderEnum.AFTER;
    }

    public void validate(List<ImportBillData> billDataList, ImportLog importLog) {
        logger.info("PaySubjectImportHrValidatorHandler validate");
        if (billDataList != null) {
            logger.info("PaySubjectImportHrValidatorHandler billDataList :{}", (Object)billDataList.size());
        }
        if (CollectionUtils.isEmpty(billDataList)) {
            return;
        }
        List pkIds = billDataList.stream().filter(billData -> !Objects.isNull(billData.getPkId())).map(billData -> Long.parseLong(String.valueOf(billData.getPkId()))).collect(Collectors.toList());
        Map<Object, Object> paySubjectMap = Maps.newHashMapWithExpectedSize((int)16);
        if (!CollectionUtils.isEmpty(pkIds)) {
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_paysubject");
            DynamicObject[] dynamicObjects = helper.query(pkIds.toArray());
            paySubjectMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(object -> object.getLong("id"), Function.identity(), (o1, o2) -> o2));
        }
        for (ImportBillData billData2 : billDataList) {
            DynamicObject dynamicObject = (DynamicObject)paySubjectMap.get(billData2.getPkId());
            try {
                JSONArray payOrgEnt;
                String cashintergration;
                JSONObject data = (JSONObject)billData2.getData().get((Object)"hsbs_paysubject");
                int excelIndex = data.getInteger("$excelIndex");
                if (!SWCObjectUtils.isEmpty((Object)dynamicObject)) {
                    String errorMsg;
                    if (SWCStringUtils.equals((String)"B", (String)dynamicObject.getString("status"))) {
                        errorMsg = ResManager.loadKDString((String)"\u65e0\u6cd5\u66f4\u65b0\u5df2\u63d0\u4ea4\u7684\u6570\u636e\u3002", (String)"PaySubjectImportHrValidatorHandler_5", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
                        importLog.writeRowLog(billData2.getSheetName(), billData2.getStartIndex(), billData2.getEndIndex(), excelIndex, errorMsg);
                        continue;
                    }
                    long createOrgId = dynamicObject.getLong("createorg.id");
                    JSONObject createorg = data.getJSONObject("createorg");
                    long billCreateOrgId = createorg.getLong("id");
                    String number = dynamicObject.getString("number");
                    String billNumber = data.getString("number");
                    long countryId = dynamicObject.getLong("country.id");
                    JSONObject country = data.getJSONObject("country");
                    long billcountryId = country.getLong("id");
                    ComboProp strategy = (ComboProp)EntityMetadataCache.getDataEntityType((String)"hsbs_paysubject").getProperty("ctrlstrategy");
                    String ctrlStrategy = strategy.getItemByName(dynamicObject.getString("ctrlstrategy"));
                    String billCtrlStrategy = data.getString("ctrlstrategy");
                    String billCashintergration = data.getString("cashintergration");
                    String cashintergration2 = dynamicObject.getString("cashintergration");
                    if (!(createOrgId == billCreateOrgId && SWCStringUtils.equals((String)number, (String)billNumber) && countryId == billcountryId && SWCStringUtils.equals((String)ctrlStrategy, (String)billCtrlStrategy) && SWCStringUtils.equals((String)CashIntergrationEnum.getDesc((String)cashintergration2), (String)billCashintergration))) {
                        logger.info("PaySubjectImportHrValidatorHandler billDataList errorMsg:{}=={};{}=={},{}=={},{}=={},{}=={}", new Object[]{createOrgId, billCreateOrgId, number, billNumber, countryId, billcountryId, ctrlStrategy, billCtrlStrategy, cashintergration2, billCashintergration});
                        errorMsg = ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u3001\u7f16\u7801\u3001\u56fd\u5bb6/\u5730\u533a\u3001\u5bf9\u63a5\u51fa\u7eb3\u7cfb\u7edf\u3001\u63a7\u5236\u7b56\u7565\u4e0d\u5141\u8bb8\u53d8\u66f4\uff0c\u9700\u4e0e\u88ab\u66f4\u65b0\u6570\u636e\u4fdd\u6301\u4e00\u81f4\uff0c\u8bf7\u8c03\u6574\u786e\u8ba4\u3002", (String)"PaySubjectImportHrValidatorHandler_0", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
                        importLog.writeRowLog(billData2.getSheetName(), billData2.getStartIndex(), billData2.getEndIndex(), excelIndex, errorMsg);
                        continue;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)(cashintergration = data.getString("cashintergration")))) {
                    data.put("cashintergration", null);
                }
                if (null == (payOrgEnt = (JSONArray)data.get((Object)"payorgent")) || payOrgEnt.isEmpty()) continue;
                for (int i = 0; i < payOrgEnt.size(); ++i) {
                    JSONObject entJsonObject = payOrgEnt.getJSONObject(i);
                    Object agentpayorg = entJsonObject.get((Object)"agentpayorg");
                    int excelEntIndex = entJsonObject.getInteger("$excelIndex");
                    Object agentpayaccount = entJsonObject.get((Object)"agentpayaccount");
                    Object agentpaybank = entJsonObject.get((Object)"agentpaybank");
                    if (StringUtils.isEmpty((CharSequence)cashintergration)) {
                        if (Objects.isNull(agentpayaccount) && !Objects.isNull(agentpaybank) || !Objects.isNull(agentpayaccount) && Objects.isNull(agentpaybank)) {
                            String errorMsg = ResManager.loadKDString((String)"\u5f53\u5bf9\u63a5\u51fa\u7eb3\u7cfb\u7edf\u4e3a\u7a7a\u65f6\uff0c\u4ed8\u6b3e\u8d26\u53f7\u53ca\u4ed8\u6b3e\u94f6\u884c\u9700\u540c\u65f6\u7ef4\u62a4\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"PaySubjectImportHrValidatorHandler_1", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
                            importLog.writeRowLog(billData2.getSheetName(), billData2.getStartIndex(), billData2.getEndIndex(), excelEntIndex, errorMsg);
                        }
                        if (!Objects.isNull(agentpayorg)) {
                            String errorMsg = ResManager.loadKDString((String)"\u5f53\u5bf9\u63a5\u51fa\u7eb3\u7cfb\u7edf\u4e3a\u7a7a\u65f6\uff0c\u53ef\u9009\u7ef4\u62a4\u4ed8\u6b3e\u8d26\u53f7\u3001\u4ed8\u6b3e\u94f6\u884c\uff0c\u65e0\u9700\u7ef4\u62a4\u4ed8\u6b3e\u8d44\u91d1\u7ec4\u7ec7\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"PaySubjectImportHrValidatorHandler_2", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
                            importLog.writeRowLog(billData2.getSheetName(), billData2.getStartIndex(), billData2.getEndIndex(), excelEntIndex, errorMsg);
                        }
                        entJsonObject.put("agentpayorg", null);
                    }
                    if (!SWCStringUtils.equals((String)cashintergration, (String)CashIntergrationEnum.KINGDEE.getDesc())) continue;
                    if (Objects.isNull(agentpayorg)) {
                        String errorMsg = ResManager.loadKDString((String)"\u5f53\u5bf9\u63a5\u51fa\u7eb3\u7cfb\u7edf\u4e3a\u91d1\u8776\u4e91\u661f\u701a\u65f6\uff0c\u9700\u586b\u5199\u201c\u4ed8\u6b3e\u8d44\u91d1\u7ec4\u7ec7\u201d\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"PaySubjectImportHrValidatorHandler_3", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
                        importLog.writeRowLog(billData2.getSheetName(), billData2.getStartIndex(), billData2.getEndIndex(), excelEntIndex, errorMsg);
                    }
                    if (!Objects.isNull(agentpayaccount) || !Objects.isNull(agentpaybank)) {
                        String errorMsg = ResManager.loadKDString((String)"\u5f53\u5bf9\u63a5\u51fa\u7eb3\u7cfb\u7edf\u4e3a\u91d1\u8776\u4e91\u661f\u701a\u65f6\uff0c\u9700\u586b\u5199\u201c\u4ed8\u6b3e\u8d44\u91d1\u7ec4\u7ec7\u201d\uff0c\u65e0\u9700\u7ef4\u62a4\u4ed8\u6b3e\u8d26\u53f7\u3001\u4ed8\u6b3e\u94f6\u884c\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"PaySubjectImportHrValidatorHandler_4", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
                        importLog.writeRowLog(billData2.getSheetName(), billData2.getStartIndex(), billData2.getEndIndex(), excelEntIndex, errorMsg);
                    }
                    entJsonObject.put("agentpayaccount", null);
                    entJsonObject.put("agentpaybank", null);
                }
            }
            catch (Throwable e) {
                logger.error(e);
            }
        }
    }
}

