/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.basedata.paysubject;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class PaySubjectScopeEdit
extends SWCDataBaseEdit {
    private static final String CONFIG = "checkcfg";
    private static final String OPENCONFIG = "donothing_opencfg";
    private static final String CLOSECONFIG = "donothing_closecfg";
    private static final String SAVE = "donothing_save";
    private static final String CONFIRM_SAVE = "confirm_save";
    private static List<String> fileds = Arrays.asList("payrollgroup.name", "adminorg.name", "hsas_empposorgrelhr.company.name", "hsas_empposorgrelhr.adminorg.name", "hsas_empentrel.laborreltype.name", "hsas_empentrel.laborrelstatus.name");
    private static LinkedHashSet<String> compareTypes = new LinkedHashSet<String>(Arrays.asList(CompareTypeEnum.IN.getId(), CompareTypeEnum.NOTIN.getId()));

    public void beforeBindData(EventObject eventObject) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        filterGrid.setEntityNumber("hsas_payaccountpersonquery");
        filterGrid.setFilterFieldKeys(fileds);
        Map paySubjectScopeMap = (Map)this.getView().getFormShowParameter().getCustomParam("paySubjectScopeMap");
        this.setScopeData(paySubjectScopeMap);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (!OperationStatus.VIEW.equals((Object)status)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnback"});
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        List filterColumns = filterGrid.getFilterColumns();
        int size = filterColumns.size();
        Map[] sortFilterColumns = new Map[size];
        Map<String, String> filedNameLangMap = this.getMap();
        for (Map column : filterColumns) {
            String fieldName = (String)column.get("fieldName");
            String name = filedNameLangMap.get(fieldName);
            if (name == null) continue;
            column.put("fieldCaption", name);
            int index = fileds.indexOf(fieldName);
            sortFilterColumns[index] = column;
            List compareTypeDtos = (List)column.get("compareTypes");
            column.put("compareTypes", compareTypeDtos.stream().filter(compareTypeDto -> compareTypes.contains(compareTypeDto.getId())).collect(Collectors.toList()));
        }
        filterGrid.setFilterColumns(Arrays.asList(sortFilterColumns));
        Map paySubjectScopeMap = (Map)this.getView().getFormShowParameter().getCustomParam("paySubjectScopeMap");
        String filterGridData = (String)paySubjectScopeMap.get("filterGridData");
        if (SWCStringUtils.isNotEmpty((String)filterGridData)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterGridData, FilterCondition.class);
            filterGrid.SetValue(filterCondition);
        }
        this.initTips();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "donothing_opencfg": {
                this.operateCfg(Boolean.TRUE);
                break;
            }
            case "donothing_closecfg": {
                this.checkCfg();
                break;
            }
            case "donothing_save": {
                HashMap<String, Object> paySubjectScopeMap = new HashMap<String, Object>(16);
                if (!this.checkData(paySubjectScopeMap, args)) break;
                HashMap returnData = Maps.newHashMapWithExpectedSize((int)16);
                returnData.put("isOk", Boolean.TRUE);
                returnData.put("paySubjectScopeMap", paySubjectScopeMap);
                this.getView().returnDataToParent((Object)returnData);
                this.getPageCache().put("isClose", "1");
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey = args.getProperty().getName();
        ChangeData changeData = args.getChangeSet()[0];
        switch (fieldKey) {
            case "checkcfg": {
                this.setEntryFieldEnable(changeData);
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        String isClose = this.getView().getPageCache().get("isClose");
        if (!SWCStringUtils.equals((String)"1", (String)isClose) && !OperationStatus.VIEW.equals((Object)status)) {
            String msg = ResManager.loadKDString((String)"\u82e5\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"PaySubjectScopeEdit_BLUE_7", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"PaySubjectScopeEdit_BLUE_8", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"PaySubjectScopeEdit_BLUE_9", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            ConfirmCallBackListener listener = new ConfirmCallBackListener(CONFIRM_SAVE);
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, listener, btnNameMaps);
            event.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        MessageBoxResult result;
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (CONFIRM_SAVE.equals(callBackId) && (result = messageBoxClosedEvent.getResult()).equals((Object)MessageBoxResult.Yes)) {
            this.getView().getPageCache().put("isClose", "1");
            this.getView().close();
        }
    }

    private void setEntryFieldEnable(ChangeData changeData) {
        Object openCfg = changeData.getNewValue();
        if (null != openCfg) {
            if (((Boolean)openCfg).booleanValue()) {
                this.getView().invokeOperation(OPENCONFIG);
            } else {
                this.getView().invokeOperation(CLOSECONFIG);
            }
        }
    }

    private void initTips() {
        List promptString = (List)SWCMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSService", (String)"queryPromptForString", (Object[])new Object[]{this.getModel().getDataEntityType().getName(), "advancelab", this.getModel().getDataEntity()});
        String tipsValue = "";
        Iterator iterator = promptString.iterator();
        while (iterator.hasNext()) {
            String entry;
            tipsValue = entry = (String)iterator.next();
        }
        Label label = (Label)this.getControl("advancelab");
        label.setText(tipsValue);
    }

    private Map<String, String> getMap() {
        HashMap<String, String> filedNameLangMap = new HashMap<String, String>(16);
        String name = ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u7ec4", (String)"PaySubjectScopeEdit_BLUE_0", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
        filedNameLangMap.put("payrollgroup.name", name);
        name = ResManager.loadKDString((String)"\u7528\u5de5\u5173\u7cfb\u7c7b\u578b", (String)"PaySubjectScopeEdit_BLUE_1", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
        filedNameLangMap.put("hsas_empentrel.laborreltype.name", name);
        name = ResManager.loadKDString((String)"\u7528\u5de5\u5173\u7cfb\u72b6\u6001", (String)"PaySubjectScopeEdit_BLUE_2", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
        filedNameLangMap.put("hsas_empentrel.laborrelstatus.name", name);
        name = ResManager.loadKDString((String)"\u6240\u5c5e\u516c\u53f8", (String)"PaySubjectScopeEdit_BLUE_3", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
        filedNameLangMap.put("hsas_empposorgrelhr.company.name", name);
        name = ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7", (String)"PaySubjectScopeEdit_BLUE_4", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
        filedNameLangMap.put("hsas_empposorgrelhr.adminorg.name", name);
        name = ResManager.loadKDString((String)"\u6302\u9760\u884c\u653f\u7ec4\u7ec7", (String)"PaySubjectScopeEdit_BLUE_6", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
        filedNameLangMap.put("adminorg.name", name);
        return filedNameLangMap;
    }

    private void checkCfg() {
        boolean isHaveData;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection salaryItem = dataEntity.getDynamicObjectCollection("salaryitem");
        DynamicObjectCollection payMethod = dataEntity.getDynamicObjectCollection("paymethod");
        DynamicObjectCollection currency = dataEntity.getDynamicObjectCollection("currency");
        DynamicObjectCollection bankPurpose = dataEntity.getDynamicObjectCollection("bankpurpose");
        boolean bl = isHaveData = !salaryItem.isEmpty() || !payMethod.isEmpty() || !currency.isEmpty() || !bankPurpose.isEmpty();
        if (isHaveData) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9ad8\u7ea7\u914d\u7f6e\u4e3a\u7a7a\u65f6\u53ef\u6536\u8d77\u3002", (String)"PaySubjectScopeEdit_BLUE_5", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            this.getModel().setValue(CONFIG, (Object)Boolean.TRUE);
        } else {
            this.operateCfg(Boolean.FALSE);
        }
    }

    private void operateCfg(Boolean isShow) {
        this.getView().setVisible(isShow, new String[]{"advancedconfig"});
        this.getView().getPageCache().put("isShow", isShow.toString());
        this.getModel().setValue(CONFIG, (Object)isShow);
    }

    private boolean checkData(Map<String, Object> paySubjectScopeMap, BeforeDoOperationEventArgs args) {
        boolean isSave;
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition condition = filterGridState.getFilterCondition();
        List relFilters = condition.getFilterRow();
        String data = "";
        if (relFilters != null && relFilters.size() > 0) {
            if (this.isCompleteness(relFilters)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u9002\u7528\u4eba\u5458\u8303\u56f4-\u6761\u4ef6\u8bbe\u7f6e\u62ec\u53f7\u4e0d\u5b8c\u6574\uff0c\u5c06\u5bfc\u81f4\u53c2\u6570\u8bc6\u522b\u5931\u8d25\uff0c\u8bf7\u8c03\u6574\u3002", (String)"PaySubjectScopeEdit_BLUE_10", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return false;
            }
            data = SerializationUtils.toJsonString((Object)condition);
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Boolean isShow = Boolean.valueOf(this.getView().getPageCache().get("isShow"));
        DynamicObjectCollection salaryItem = dataEntity.getDynamicObjectCollection("salaryitem");
        DynamicObjectCollection payMethod = dataEntity.getDynamicObjectCollection("paymethod");
        DynamicObjectCollection currency = dataEntity.getDynamicObjectCollection("currency");
        DynamicObjectCollection bankPurpose = dataEntity.getDynamicObjectCollection("bankpurpose");
        paySubjectScopeMap.put("filterGridData", data);
        paySubjectScopeMap.put("salaryItem", salaryItem.stream().map(item -> item.getLong("fbasedataid_id")).collect(Collectors.toList()));
        paySubjectScopeMap.put("payMethod", payMethod.stream().map(dy -> dy.getLong("fbasedataid_id")).collect(Collectors.toList()));
        paySubjectScopeMap.put("currency", currency.stream().map(dy -> dy.getLong("fbasedataid_id")).collect(Collectors.toList()));
        paySubjectScopeMap.put("bankPurpose", bankPurpose.stream().map(dy -> dy.getLong("fbasedataid_id")).collect(Collectors.toList()));
        boolean bl = isSave = SWCStringUtils.isNotEmpty((String)data) || isShow != false && (!salaryItem.isEmpty() || !payMethod.isEmpty() || !currency.isEmpty() || !bankPurpose.isEmpty());
        if (!isSave) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u9002\u7528\u8303\u56f4\u3002", (String)"PaySubjectScopeEdit_BLUE_11", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
        return isSave;
    }

    private void setScopeData(Map<String, Object> paySubjectScopeMap) {
        List salaryItem = (List)paySubjectScopeMap.get("salaryItem");
        List payMethod = (List)paySubjectScopeMap.get("payMethod");
        List currency = (List)paySubjectScopeMap.get("currency");
        List bankPurpose = (List)paySubjectScopeMap.get("bankPurpose");
        this.getModel().setValue("salaryitem", (Object)salaryItem.toArray());
        this.getModel().setValue("paymethod", (Object)payMethod.toArray());
        this.getModel().setValue("currency", (Object)currency.toArray());
        this.getModel().setValue("bankpurpose", (Object)bankPurpose.toArray());
        this.operateCfg(!salaryItem.isEmpty() || !payMethod.isEmpty() || !currency.isEmpty() || !bankPurpose.isEmpty());
    }

    public boolean isCompleteness(List<SimpleFilterRow> relFilters) {
        Stack<Character> stack = new Stack<Character>();
        for (SimpleFilterRow relFilter : relFilters) {
            char[] chars;
            String rightBracket;
            String leftBracket = relFilter.getLeftBracket();
            if (!leftBracket.isEmpty()) {
                char[] chars2 = leftBracket.toCharArray();
                for (int i = 0; i < chars2.length; ++i) {
                    stack.push(Character.valueOf(chars2[i]));
                }
            }
            if ((rightBracket = relFilter.getRightBracket()).isEmpty()) continue;
            for (char aChar : chars = rightBracket.toCharArray()) {
                if (stack.isEmpty()) {
                    return true;
                }
                stack.pop();
            }
        }
        return !stack.isEmpty();
    }
}

