/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.basedata.salaryitem;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.area.AreaHelper;
import kd.swc.hsbp.business.cost.CostHelper;
import kd.swc.hsbp.business.taxservice.TaxCalServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.enums.DataTypeEnum;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;
import kd.swc.hsbs.business.statistictag.StatisticsTagHelper;

public class SalaryItemEdit
extends SWCDataBaseEdit
implements BeforeF7SelectListener {
    private static final String FIELD_DATATYPE = "datatype";
    private static final String FIELD_DATALENGTH = "datalength";
    private static final String FIELD_DATAPRECISION = "dataprecision";
    private static final String FIELD_DATAROUND = "dataround";
    private static final String FIELD_ISSYSPRESET = "issyspreset";
    private static final String FIELD_PRESETNAME = "presetname";
    private static final String FIELD_ISPAYOUTITEM = "ispayoutitem";
    private static final String FIELD_AREATYPE = "areatype";
    private static final String FIELD_SALARYITEMTYPE = "salaryitemtype";
    public static final String IS_COST_ALLOT = "iscostallot";
    private static final String[] mainFields = new String[]{"number", "datatype", "datalength", "salaryitemtype"};
    private static final String CALLBACK_AREATYPE = "areaType";
    private static final String FIELD_COUNTRY = "country";
    private static final String FIELD_STATISTICS_TAG = "statisticstag";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"costconfiglink"});
        BasedataEdit control = (BasedataEdit)this.getControl(FIELD_SALARYITEMTYPE);
        control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        control = (BasedataEdit)this.getControl(FIELD_STATISTICS_TAG);
        control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject eventObject) {
        long dataTypeId = this.getModel().getDataEntity().getLong("datatype.id");
        this.setDataTypeCtlSate(dataTypeId, false);
        Boolean isSysPreset = (Boolean)this.getModel().getValue(FIELD_ISSYSPRESET);
        if (!isSysPreset.booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FIELD_PRESETNAME});
        }
        this.cacheDataPrecisonScale();
        String enable = (String)this.getModel().getValue("enable");
        if (!SWCStringUtils.equals((String)"10", (String)enable)) {
            this.mainFieldSetEnable(false);
        } else {
            this.mainFieldSetEnable(true);
        }
        AreaHelper.initAreaTypeAndcountryStatus((IDataModel)this.getModel(), (IFormView)this.getView());
        this.setFieldEnableByTaxStatus("taxtag");
        if (1020L == dataTypeId) {
            this.setCostItemVisible();
        } else {
            this.isShowCostFlex(false);
        }
        this.setDatatypeEnable();
    }

    private void cacheDataPrecisonScale() {
        DynamicObject data = this.getModel().getDataEntity();
        long dataTypeId = data.getLong("datatype.id");
        if (DataTypeEnum.NUMBERIC.getDbId() == dataTypeId) {
            Integer scal = data.getInt("dataprecision.scale");
            SWCPageCache pageCache = new SWCPageCache(this.getView());
            pageCache.put("scale", (Object)scal);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operate.getOperateKey()) {
            case "save": 
            case "submit": {
                this.openConfirmPage(args, operate);
                break;
            }
        }
    }

    private void openConfirmPage(BeforeDoOperationEventArgs args, FormOperate operate) {
        int scal;
        DynamicObject data = this.getModel().getDataEntity();
        long dataTypeId = data.getLong("datatype.id");
        String enable = data.getString("enable");
        if (dataTypeId != DataTypeEnum.NUMBERIC.getDbId() || !"1".equals(enable)) {
            return;
        }
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        Integer dbScal = (Integer)pageCache.get("scale", Integer.class);
        if (dbScal == null) {
            dbScal = 0;
        }
        if ((scal = data.getInt("dataprecision.scale")) >= dbScal) {
            return;
        }
        RefObject afterConfirm = new RefObject();
        if (!operate.getOption().tryGetVariableValue(operate.getOperateKey(), afterConfirm)) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u6ce8\u610f\uff1a\u4fee\u6539\u540e\u5c06\u5f71\u54cd\u5386\u53f2\u6570\u636e\u7684\u5c0f\u6570\u4f4d\u5c55\u793a\uff0c\u5df2\u5b58\u50a8\u7684\u5386\u53f2\u6570\u636e\u4e0d\u4f1a\u4fee\u6539\uff0c\u53ef\u80fd\u5bfc\u81f4\u5408\u8ba1\u884c\u6570\u636e\u4e0e\u660e\u7ec6\u6c47\u603b\u6570\u636e\u4e0d\u76f8\u7b49\uff0c\u786e\u5b9a\u8981\u4fee\u6539\u7cbe\u5ea6\u5417\uff1f", (String)"SalaryItemEdit_7", (String)"swc-hsas-formplugin", (Object[])new Object[]{args.getListSelectedData().size()});
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(operate.getOperateKey());
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            this.getView().showConfirm(msg, options, confirmCallBacks);
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
        String operateKey = operate.getOperateKey();
        if (SWCStringUtils.equals((String)"unaudit", (String)operateKey)) {
            this.setEnableTaxField();
        }
        this.setDatatypeEnable();
        if (("save".equals(operateKey) || "submit".equals(operateKey)) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.cacheDataPrecisonScale();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String fieldKey;
        switch (fieldKey = arg0.getProperty().getName()) {
            case "salaryitemtype": {
                arg0.addCustomQFilter(this.getAreaTypeAndCountryFilter());
                break;
            }
            case "statisticstag": {
                DynamicObject country;
                ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
                DynamicObject createOrg = (DynamicObject)this.getModel().getValue("createorg");
                if (createOrg != null) {
                    arg0.getFormShowParameter().setCustomParam("createOrgId", (Object)createOrg.getString("id"));
                }
                if ((country = (DynamicObject)this.getModel().getValue(FIELD_COUNTRY)) != null) {
                    arg0.getFormShowParameter().setCustomParam("countryId", (Object)country.getString("id"));
                }
                filterList.add(this.getAreaTypeAndCountryFilter());
                arg0.getFormShowParameter().setCustomParam("isFromStatisticsTag", (Object)"0");
                QFilter dataFilter = StatisticsTagHelper.getTagLevelFilterForStatisticTag();
                if (dataFilter != null) {
                    filterList.add(dataFilter);
                }
                arg0.getCustomQFilters().addAll(filterList);
                break;
            }
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs args) {
        args.setFireAfterImportData(true);
    }

    public void afterImportData(ImportDataEventArgs args) {
        String countryNum;
        Map countryMap;
        super.afterImportData(args);
        Map dataMap = args.getSourceData();
        BillModel billModel = (BillModel)args.getSource();
        long dataTypeId = billModel.getDataEntity().getLong("dataType.id");
        if (!dataMap.containsKey(FIELD_DATALENGTH)) {
            if (1010L == dataTypeId || 1020L == dataTypeId || 1040L == dataTypeId) {
                billModel.setValue(FIELD_DATALENGTH, (Object)13);
            } else {
                billModel.setValue(FIELD_DATALENGTH, (Object)0);
            }
        }
        Boolean enableTaxCal = Boolean.FALSE;
        String areaType = (String)dataMap.get(FIELD_AREATYPE);
        if (!SWCStringUtils.isEmpty((String)areaType) && SWCStringUtils.equals((String)"2", (String)areaType) && (countryMap = (Map)dataMap.get(FIELD_COUNTRY)) != null && !SWCStringUtils.isEmpty((String)(countryNum = (String)countryMap.get("number")))) {
            enableTaxCal = TaxCalServiceHelper.getTaxCalEnableStatusByCountryNumber((String)countryNum);
        }
        this.showIsPayOutItem(enableTaxCal);
    }

    private void setTaxTagMustInput(boolean mustInput) {
        ComboEdit taxTagField = (ComboEdit)this.getView().getControl("taxtag");
        taxTagField.setMustInput(mustInput);
        this.getView().updateView("taxtag");
    }

    private void setFieldEnableByTaxStatus(String ... fields) {
        String areaType = (String)this.getModel().getValue(FIELD_AREATYPE);
        if (SWCStringUtils.isEmpty((String)areaType) || SWCStringUtils.equals((String)areaType, (String)"1")) {
            this.getView().setEnable(Boolean.FALSE, fields);
            this.setTaxTagMustInput(false);
            return;
        }
        DynamicObject countryObj = (DynamicObject)this.getModel().getValue(FIELD_COUNTRY);
        if (SWCObjectUtils.isEmpty((Object)countryObj)) {
            this.getView().setEnable(Boolean.FALSE, fields);
            this.setTaxTagMustInput(false);
            return;
        }
        long countryId = countryObj.getLong("id");
        Boolean enableTaxCal = TaxCalServiceHelper.getTaxCalEnableStatusByCountryId((long)countryId);
        this.showIsPayOutItem(enableTaxCal);
        if (enableTaxCal.booleanValue()) {
            this.getView().setEnable(Boolean.TRUE, fields);
            this.setTaxTagMustInput(true);
            return;
        }
        this.getView().setEnable(Boolean.FALSE, fields);
        this.setTaxTagMustInput(false);
    }

    private void setTaxTagValueByAreaOrCountryChange() {
        String areaType = (String)this.getModel().getValue(FIELD_AREATYPE);
        if (SWCStringUtils.isEmpty((String)areaType) || SWCStringUtils.equals((String)areaType, (String)"1")) {
            this.getModel().setValue("taxtag", (Object)"0");
            this.setTaxTagMustInput(false);
            return;
        }
        DynamicObject countryObj = (DynamicObject)this.getModel().getValue(FIELD_COUNTRY);
        if (SWCObjectUtils.isEmpty((Object)countryObj)) {
            this.getModel().setValue("taxtag", (Object)"0");
            this.setTaxTagMustInput(false);
            return;
        }
        long countryId = countryObj.getLong("id");
        Boolean enableTaxCal = TaxCalServiceHelper.getTaxCalEnableStatusByCountryId((long)countryId);
        if (enableTaxCal == null || !enableTaxCal.booleanValue()) {
            this.getModel().setValue("taxtag", (Object)"0");
            this.setTaxTagMustInput(false);
            this.getView().setEnable(Boolean.TRUE, new String[]{FIELD_ISPAYOUTITEM});
            return;
        }
        this.setTaxTagMustInput(true);
    }

    private void mainFieldSetEnable(boolean enableBoolean) {
        this.getView().setEnable(Boolean.valueOf(enableBoolean), mainFields);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName;
        super.propertyChanged(args);
        switch (propertyName = args.getProperty().getName()) {
            case "datatype": {
                ChangeData[] changeData = args.getChangeSet();
                DynamicObject dataObj = (DynamicObject)changeData[0].getNewValue();
                DynamicObject oldDataObj = (DynamicObject)changeData[0].getOldValue();
                this.cleanCostInfo(oldDataObj);
                long dataTypeId = 0L;
                if (!SWCObjectUtils.isEmpty((Object)dataObj)) {
                    dataTypeId = dataObj.getLong("id");
                }
                this.setDataTypeCtlSate(dataTypeId, true);
                if (1020L == dataTypeId) {
                    this.setCostItemVisible();
                    break;
                }
                this.isShowCostFlex(false);
                break;
            }
            case "ispayoutitem": {
                this.setDataTypeToMoney(propertyName, args);
                this.setDatatypeEnable();
                break;
            }
            case "areatype": {
                this.checkOpenConfirmPage(args.getChangeSet(), Boolean.TRUE);
                this.setFieldEnableByTaxStatus("taxtag");
                this.setTaxTagValueByAreaOrCountryChange();
                break;
            }
            case "country": {
                this.checkOpenConfirmPage(args.getChangeSet(), Boolean.FALSE);
                this.setFieldEnableByTaxStatus("taxtag");
                this.setTaxTagValueByAreaOrCountryChange();
                break;
            }
            case "iscostallot": {
                boolean isCostAllot = this.getModel().getDataEntity().getBoolean(IS_COST_ALLOT);
                this.getView().setVisible(Boolean.valueOf(isCostAllot), new String[]{"fieldgrouppanelap"});
                break;
            }
            case "taxtag": {
                Object[] changeData = args.getChangeSet();
                if (SWCArrayUtils.isEmpty((Object[])changeData)) break;
                DynamicObject countryObj = (DynamicObject)this.getModel().getValue(FIELD_COUNTRY);
                if (SWCObjectUtils.isEmpty((Object)countryObj)) {
                    this.showIsPayOutItem(Boolean.FALSE);
                    break;
                }
                long countryId = countryObj.getLong("id");
                Boolean enableTaxCal = TaxCalServiceHelper.getTaxCalEnableStatusByCountryId((long)countryId);
                this.showIsPayOutItem(enableTaxCal);
                break;
            }
            case "salaryitemtype": {
                this.salaryItemTypeChangeEvent(args);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String[] keys = new String[]{FIELD_SALARYITEMTYPE, FIELD_STATISTICS_TAG};
        String[] entryEntityKeys = new String[]{};
        if (CALLBACK_AREATYPE.equals(event.getCallBackId())) {
            AreaHelper.confirmAfterModifyAraeType((MessageBoxClosedEvent)event, (IDataModel)this.getModel(), (IFormView)this.getView(), (String[])keys, (String[])entryEntityKeys);
        } else if (FIELD_COUNTRY.equals(event.getCallBackId())) {
            AreaHelper.confirmAfterModifyCountry((MessageBoxClosedEvent)event, (IDataModel)this.getModel(), (IFormView)this.getView(), (String[])keys, (String[])entryEntityKeys);
        } else if (("save".equals(event.getCallBackId()) || "submit".equals(event.getCallBackId())) && MessageBoxResult.Yes.equals((Object)event.getResult())) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(event.getCallBackId(), "true");
            this.getView().invokeOperation(event.getCallBackId(), operateOption);
        }
    }

    private void salaryItemTypeChangeEvent(PropertyChangedArgs args) {
        DynamicObject salaryItemTypeObj = (DynamicObject)this.getModel().getValue(FIELD_SALARYITEMTYPE);
        if (salaryItemTypeObj == null) {
            this.getModel().setValue("calblock", null);
        } else {
            String calBlock = salaryItemTypeObj.getString("calblock");
            this.getModel().setValue("calblock", (Object)calBlock);
        }
    }

    private void checkOpenConfirmPage(ChangeData[] changeSets, Boolean isAraeType) {
        Object salaryItemType = this.getModel().getValue(FIELD_SALARYITEMTYPE);
        Object statisticsTag = this.getModel().getValue(FIELD_STATISTICS_TAG);
        if (salaryItemType == null && statisticsTag == null) {
            AreaHelper.setAreaTypeAndcountryStatus((IDataModel)this.getModel(), (IFormView)this.getView());
            return;
        }
        if (null == changeSets || changeSets.length == 0) {
            return;
        }
        String customValue = "";
        String callBack = "";
        if (isAraeType.booleanValue()) {
            ChangeData changeData = changeSets[0];
            Object oldValue = changeData.getOldValue();
            if (oldValue != null) {
                customValue = (String)changeData.getOldValue();
            }
            callBack = CALLBACK_AREATYPE;
        } else {
            ChangeData changeData = changeSets[0];
            Object oldValue = changeData.getOldValue();
            if (oldValue != null) {
                DynamicObject country = (DynamicObject)oldValue;
                Object countryId = country.get("id");
                customValue = String.valueOf(countryId);
            }
            callBack = FIELD_COUNTRY;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u540e\u5c06\u6e05\u7a7a\u201c\u85aa\u916c\u9879\u76ee\u7c7b\u522b\u201d\u53ca\u201c\u85aa\u916c\u9879\u76ee\u7edf\u8ba1\u7c7b\u522b\u201d\uff0c\u786e\u5b9a\u7ee7\u7eed\uff1f", (String)"SalaryItemEdit_6", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, null, new ConfirmCallBackListener(callBack), null, customValue);
    }

    private void cleanCostInfo(DynamicObject oldDataObj) {
        long oldDataTypeId;
        if (!SWCObjectUtils.isEmpty((Object)oldDataObj) && 1020L == (oldDataTypeId = oldDataObj.getLong("id"))) {
            this.getView().getModel().setValue(IS_COST_ALLOT, null);
            this.getView().getModel().setValue("isfixedcost", null);
        }
    }

    private void setDataTypeToMoney(String propertyName, PropertyChangedArgs args) {
        String ispayoutitem;
        String enable = (String)this.getModel().getValue("enable");
        long datatype = this.getModel().getDataEntity().getLong("datatype.id");
        if (propertyName.equals(FIELD_ISPAYOUTITEM) && SWCStringUtils.equals((String)"1", (String)(ispayoutitem = this.getModel().getDataEntity().getString(FIELD_ISPAYOUTITEM)))) {
            if (SWCStringUtils.equals((String)enable, (String)"1") && datatype != 1020L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b9e\u53d1\u9879\u76ee\u7684\u6570\u636e\u7c7b\u578b\u987b\u4e3a\u201c\u91d1\u989d\u201d\u7c7b\u578b\u3002", (String)"SalaryItemEdit_1", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(FIELD_ISPAYOUTITEM, (Object)"0");
            } else {
                this.getModel().setValue(FIELD_DATATYPE, (Object)1020L);
            }
        }
    }

    private void setDataTypeCtlSate(long dataTypeId, boolean setDefaultData) {
        if (1010L == dataTypeId) {
            this.setDataTypeCtlNum(setDefaultData);
        } else if (1020L == dataTypeId) {
            this.setDataTypeCtlAmount(setDefaultData);
        } else if (1030L == dataTypeId) {
            this.setDataTypeCtlText(setDefaultData);
        } else if (1040L == dataTypeId) {
            this.setDataTypeCtlInt(setDefaultData);
        } else if (1050L == dataTypeId) {
            this.setDataTypeCtlOther(setDefaultData);
        } else if (1060L == dataTypeId) {
            this.setDataTypeCtlOther(setDefaultData);
        } else {
            this.setDataTypeCtlNull(setDefaultData);
        }
    }

    private void showIsPayOutItem(Boolean enableTaxCal) {
        if (enableTaxCal.booleanValue()) {
            this.getModel().beginInit();
            String taxtag = this.getModel().getDataEntity().getString("taxtag");
            this.getView().setEnable(Boolean.TRUE, new String[]{FIELD_ISPAYOUTITEM});
            if (SWCStringUtils.equals((String)"2", (String)taxtag)) {
                this.getModel().setValue(FIELD_ISPAYOUTITEM, (Object)"0");
                this.setDatatypeEnable();
                this.getView().setEnable(Boolean.FALSE, new String[]{FIELD_ISPAYOUTITEM, "calblock"});
            } else if (SWCStringUtils.equals((String)"1", (String)taxtag)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"calblock"});
            }
            this.getModel().endInit();
            this.getView().updateView(FIELD_ISPAYOUTITEM);
        }
    }

    private void setCostItemVisible() {
        boolean enableCost = CostHelper.isEnableCost();
        this.isShowCostFlex(enableCost);
        boolean isCostAllot = this.getModel().getDataEntity().getBoolean(IS_COST_ALLOT);
        this.getView().setVisible(Boolean.valueOf(isCostAllot), new String[]{"fieldgrouppanelap"});
    }

    private void isShowCostFlex(boolean flag) {
        this.getView().setVisible(Boolean.valueOf(flag), new String[]{"costallotsetting"});
    }

    private void setEnableTaxField() {
        String enable = (String)this.getModel().getValue("enable");
        String status = (String)this.getModel().getValue("status");
        if ("A".equals(status) && "1".equals(enable)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"taxtag", "calblock"});
        }
    }

    private void setDatatypeEnable() {
        String enable = this.getModel().getDataEntity().getString("enable");
        String status = this.getModel().getDataEntity().getString("status");
        String isPayOutItem = this.getModel().getDataEntity().getString(FIELD_ISPAYOUTITEM);
        if (SWCStringUtils.equals((String)"10", (String)enable) && SWCStringUtils.equals((String)"A", (String)status)) {
            if (SWCStringUtils.equals((String)"1", (String)isPayOutItem)) {
                this.getModel().beginInit();
                this.getModel().setValue(FIELD_DATATYPE, (Object)1020L);
                this.getView().setEnable(Boolean.FALSE, new String[]{FIELD_DATATYPE});
                this.getModel().endInit();
                this.getView().updateView(FIELD_DATATYPE);
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{FIELD_DATATYPE});
            }
        }
    }

    private void setDataTypeCtlNum(boolean setDefaultData) {
        this.setDataTypeCtlState(false, true, true);
        this.getView().setEnable(Boolean.FALSE, new String[]{FIELD_DATALENGTH});
        if (setDefaultData) {
            this.getView().getModel().setValue(FIELD_DATALENGTH, (Object)13);
            if (this.getView().getModel().getValue(FIELD_DATAPRECISION) == null) {
                this.getView().getModel().setValue(FIELD_DATAPRECISION, (Object)1030L);
            }
            if (this.getView().getModel().getValue(FIELD_DATAROUND) == null) {
                this.getView().getModel().setValue(FIELD_DATAROUND, (Object)1010L);
            }
        }
    }

    private void setDataTypeCtlAmount(boolean setDefaultData) {
        this.setDataTypeCtlState(false, false, true);
        if (setDefaultData) {
            this.getView().getModel().setValue(FIELD_DATALENGTH, (Object)13);
            this.getView().getModel().setValue(FIELD_DATAPRECISION, null);
            if (this.getView().getModel().getValue(FIELD_DATAROUND) == null) {
                this.getView().getModel().setValue(FIELD_DATAROUND, (Object)1010L);
            }
        }
    }

    private void setDataTypeCtlInt(boolean setDefaultData) {
        this.setDataTypeCtlState(false, false, false);
        this.getView().setEnable(Boolean.FALSE, new String[]{FIELD_DATALENGTH});
        if (setDefaultData) {
            this.getView().getModel().setValue(FIELD_DATALENGTH, (Object)13);
            this.getView().getModel().setValue(FIELD_DATAPRECISION, null);
            this.getView().getModel().setValue(FIELD_DATAROUND, null);
        }
    }

    private void setDataTypeCtlText(boolean setDefaultData) {
        this.setDataTypeCtlState(true, false, false);
        this.getView().setEnable(Boolean.TRUE, new String[]{FIELD_DATALENGTH});
        if (setDefaultData) {
            this.getView().getModel().setValue(FIELD_DATALENGTH, (Object)200);
            this.getView().getModel().setValue(FIELD_DATAPRECISION, null);
            this.getView().getModel().setValue(FIELD_DATAROUND, null);
        }
    }

    private void setDataTypeCtlOther(boolean setDefaultData) {
        this.setDataTypeCtlState(false, false, false);
        if (setDefaultData) {
            this.getView().getModel().setValue(FIELD_DATALENGTH, null);
            this.getView().getModel().setValue(FIELD_DATAPRECISION, null);
            this.getView().getModel().setValue(FIELD_DATAROUND, null);
        }
    }

    private void setDataTypeCtlNull(boolean setDefaultData) {
        this.setDataTypeCtlState(true, true, true);
        if (setDefaultData) {
            this.getView().getModel().setValue(FIELD_DATALENGTH, null);
            this.getView().getModel().setValue(FIELD_DATAPRECISION, null);
            this.getView().getModel().setValue(FIELD_DATAROUND, null);
        }
    }

    private void setDataTypeCtlState(boolean datalengthCtlState, boolean dataprecisionCtlState, boolean dataroundCtlState) {
        DecimalEdit datalengthCtl = (DecimalEdit)this.getView().getControl(FIELD_DATALENGTH);
        BasedataEdit dataprecisionCtl = (BasedataEdit)this.getView().getControl(FIELD_DATAPRECISION);
        BasedataEdit dataroundCtl = (BasedataEdit)this.getView().getControl(FIELD_DATAROUND);
        datalengthCtl.setMustInput(datalengthCtlState);
        datalengthCtl.setVisible("", datalengthCtlState);
        dataprecisionCtl.setMustInput(dataprecisionCtlState);
        dataprecisionCtl.setVisible("", dataprecisionCtlState);
        dataroundCtl.setMustInput(dataroundCtlState);
        dataroundCtl.setVisible("", dataroundCtlState);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String clkKey = control.getKey();
        if ("costconfiglink".equals(clkKey)) {
            ListShowParameter show = new ListShowParameter();
            show.setBillFormId("pcs_costpayrollcalmap");
            show.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)show);
        }
    }

    private QFilter getAreaTypeAndCountryFilter() {
        DynamicObject salaryItemObj = this.getModel().getDataEntity();
        String areaType = salaryItemObj.getString(FIELD_AREATYPE);
        long countryId = salaryItemObj.getLong("country.id");
        QFilter filter = new QFilter(FIELD_AREATYPE, "=", (Object)areaType);
        if ("2".equals(areaType)) {
            filter.and(FIELD_COUNTRY, "=", (Object)countryId);
            QFilter areaTypeQFilter = new QFilter(FIELD_AREATYPE, "=", (Object)"1");
            filter.or(areaTypeQFilter);
        }
        return filter;
    }
}

