/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.basedata.salaryitem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseList;

public class SalaryItemList
extends SWCDataBaseList {
    private Map<Long, String> salartItemStruInsCategoryRel = new HashMap<Long, String>(16);
    private static final String STRUINSTAGTXT = "struinstagtxt";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"viewbystatistictag"});
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : filterColumnList) {
            if (!filterColumn.getFieldName().equals("enable")) continue;
            List comboItems = ((CommonFilterColumn)filterColumn).getComboItems();
            Collections.sort(comboItems, new Comparator<ComboItem>(){

                @Override
                public int compare(ComboItem o1, ComboItem o2) {
                    int diff = o1.getValue().compareTo(o2.getValue());
                    if (diff > 0) {
                        return -1;
                    }
                    if (diff < 0) {
                        return 1;
                    }
                    return 0;
                }
            });
            ((CommonFilterColumn)filterColumn).setComboItems(comboItems);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        if (this.isAssembleStruInsCategory()) {
            args.setListDataProvider((IListDataProvider)new ListDataProvider(){

                public DynamicObjectCollection getData(int start, int limit) {
                    DynamicObjectCollection rows = super.getData(start, limit);
                    if (rows.isEmpty()) {
                        return rows;
                    }
                    ArrayList<Long> salaryItemIds = new ArrayList<Long>(10);
                    for (DynamicObject row : rows) {
                        salaryItemIds.add(row.getLong("id"));
                    }
                    if (!salaryItemIds.isEmpty()) {
                        SalaryItemList.this.assembleSalaryItemStruInsCategoryRel(salaryItemIds);
                    }
                    return rows;
                }
            });
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        if (this.isAssembleStruInsCategory()) {
            List cols = args.getListColumns();
            cols.removeIf(col -> SWCStringUtils.equals((String)"struinstag.name", (String)col.getListFieldKey()));
        } else {
            List cols = args.getListColumns();
            cols.removeIf(col -> SWCStringUtils.equals((String)STRUINSTAGTXT, (String)col.getListFieldKey()));
        }
    }

    private boolean isAssembleStruInsCategory() {
        String isAssembleStruInsCategory = (String)this.getView().getFormShowParameter().getCustomParam("isAssembleStruInsCategory");
        return SWCStringUtils.equals((String)"true", (String)isAssembleStruInsCategory);
    }

    private void assembleSalaryItemStruInsCategoryRel(List<Long> salaryItemIds) {
        DynamicObject[] dyobjs;
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsbs_salaryitem");
        QFilter qFilter = new QFilter("id", "in", salaryItemIds);
        for (DynamicObject dyobj : dyobjs = serviceHelper.query("id, struinstag.struinscategoryl2.name, struinstag.struinscategory.name", new QFilter[]{qFilter})) {
            this.salartItemStruInsCategoryRel.put(dyobj.getLong("id"), String.format("%s_%s", dyobj.getString("struinstag.struinscategoryl2.name"), dyobj.getString("struinstag.struinscategory.name")));
        }
    }

    public void packageData(PackageDataEvent event) {
        String fieldKey;
        super.packageData(event);
        ColumnDesc columnDesc = (ColumnDesc)event.getSource();
        switch (fieldKey = columnDesc.getFieldKey()) {
            case "struinstagtxt": {
                this.struInsTagTxtPackageData(event);
                break;
            }
        }
    }

    private void struInsTagTxtPackageData(PackageDataEvent event) {
        String struInsCategory;
        Long salaryItemId = event.getRowData().getLong("id");
        if (null != salaryItemId && !SWCStringUtils.isEmpty((String)(struInsCategory = this.salartItemStruInsCategoryRel.get(salaryItemId)))) {
            event.setFormatValue((Object)struInsCategory);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        switch (args.getFieldName()) {
            case "salaryitemtype.id": 
            case "salaryitemtype.name": {
                QFilter orgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_salaryitemtype", (Long)Long.valueOf(this.getPageCache().get("createOrg")));
                if (orgFilter == null) break;
                args.addCustomQFilter(orgFilter);
                break;
            }
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        switch (args.getFieldName()) {
            case "salaryitemtype.id": 
            case "salaryitemtype.name": {
                String createOrg = this.getPageCache().get("createOrg");
                QFilter orgFilter = null;
                if (StringUtils.isNotBlank((CharSequence)createOrg)) {
                    orgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_salaryitemtype", (Long)Long.valueOf(createOrg));
                }
                if (orgFilter == null) break;
                args.addCustomQFilter(orgFilter);
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "viewbystatistictag": {
                this.openStatisticTagItemView();
                break;
            }
        }
    }

    private void openStatisticTagItemView() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("hsbs_statistictagtree");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setPageId(this.getView().getPageId() + "statistictagtree");
        showParameter.setCaption(ResManager.loadKDString((String)"\u6309\u7c7b\u522b\u67e5\u770b\u85aa\u916c\u9879\u76ee", (String)"SalaryItemList_0", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

