/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.basedata.salaryparameter;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.swc.hsbp.business.servicehelper.SWCSalaryParameterServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class FinanceParamPlugin
extends SWCDataBaseEdit {
    private static final String ENABLE_FINANCE = "enablefinance";
    private static final String OPKEY_SAVE = "save";
    private static final String OPKEY_EDIT = "edit";
    private static final String OPKEY_CANCEL = "cancel";
    private static final String BAR_SAVE = "barsave";
    private static final String BAR_EDIT = "baredit";
    private static final String BAR_CANCEL = "barcancel";
    private static final String CONFIRM_FINANCE_SAVE = "confirm_finance_save";
    private static final String PARAM_PAGEID = "PARAM_PAGEID";
    private static final String HSBS_FINANCE_PARAM = "hsbs_finance_param";
    private static final String FINANCE_SWC = "finance_swc";

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String nodeId = (String)showParameter.getCustomParam("id");
        this.initParameter(nodeId);
        this.getView().getPageCache().put("id", nodeId);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "save": {
                operate.getOption().setVariableValue("id", this.getView().getPageCache().get("id"));
                break;
            }
            case "edit": {
                this.changeViewStatus(OperationStatus.EDIT);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (args.getOperationResult().isSuccess()) {
            switch (operateKey) {
                case "save": {
                    this.changeViewStatus(OperationStatus.VIEW);
                    this.getModel().setDataChanged(false);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"FinanceParamPlugin_1", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                    FinanceParamPlugin.setFinanceCacheMap();
                    break;
                }
                case "cancel": {
                    if (this.checkDataChange()) break;
                    this.getView().updateView();
                    break;
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name;
        switch (name = args.getProperty().getName()) {
            case "enablefinance": {
                this.getModel().setDataChanged(true);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (CONFIRM_FINANCE_SAVE.equals(event.getCallBackId()) && event.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.changeViewStatus(OperationStatus.VIEW);
            this.getView().updateView();
        }
    }

    private void initParameter(String cfgId) {
        Map paramMap = SWCSalaryParameterServiceHelper.getSalaryParam((long)Long.parseLong(cfgId));
        IDataModel model = this.getModel();
        if (paramMap != null) {
            Boolean enableFinance = (Boolean)paramMap.get(ENABLE_FINANCE);
            model.setValue(ENABLE_FINANCE, (Object)enableFinance);
            this.changeViewStatus(OperationStatus.VIEW);
            this.getView().updateView("contentpanelap");
            this.getView().getParentView().getPageCache().put(PARAM_PAGEID, this.getView().getPageId());
            model.setDataChanged(false);
        } else {
            this.changeViewStatus(OperationStatus.VIEW);
        }
    }

    public static void setFinanceCacheMap() {
        Map paramMap = SWCSalaryParameterServiceHelper.getSalaryParam((String)FINANCE_SWC);
        ISWCAppCache appCache = SWCAppCache.get((String)HSBS_FINANCE_PARAM);
        appCache.put(HSBS_FINANCE_PARAM, (Object)paramMap);
    }

    private boolean checkDataChange() {
        boolean isChange = this.getView().getModel().getDataChanged();
        if (isChange) {
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"FinanceParamPlugin_2", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"FinanceParamPlugin_3", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"FinanceParamPlugin_4", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
            msg = msg.replaceAll("\\\\r\\\\n", "\r\n");
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CONFIRM_FINANCE_SAVE, (IFormPlugin)this);
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            this.getView().showConfirm(msg, this.getView().getModel().getChangeDesc(), options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        }
        return this.getView().getModel().getDataChanged();
    }

    private void changeViewStatus(OperationStatus status) {
        this.getView().setStatus(status);
        boolean isVisible = OperationStatus.VIEW.equals((Object)status);
        this.getView().setVisible(Boolean.valueOf(!isVisible), new String[]{BAR_SAVE, BAR_CANCEL});
        this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{BAR_EDIT});
    }
}

