/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.basedata.salaryparameter;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.swc.hsbp.business.servicehelper.SWCSalaryParameterServiceHelper;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class SalaryCalBatchParamPlugin
extends SWCDataBaseEdit {
    private static final String OPKEY_SAVE = "save";
    private static final String OPKEY_EDIT = "edit";
    private static final String OPKEY_CANCEL = "cancel";
    private static final String BAR_SAVE = "barsave";
    private static final String BAR_EDIT = "baredit";
    private static final String BAR_CANCEL = "barcancel";
    private static final String CONFIRM_TAX_SAVE = "confirm_tax_save";
    private static final String PARAM_PAGEID = "PARAM_PAGEID";

    public void beforeBindData(EventObject evt) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String cfgId = (String)showParameter.getCustomParam("id");
        Map paramDataMap = SWCSalaryParameterServiceHelper.getSalaryParam((long)Long.parseLong(cfgId));
        if (paramDataMap == null || paramDataMap.size() == 0) {
            this.changeViewStatus(OperationStatus.VIEW);
            this.getModel().setValue("threaddealcount", null);
            this.getModel().setValue("batchcount", null);
            this.getModel().setDataChanged(false);
            return;
        }
        String threadDealCount = (String)paramDataMap.get("threadDealCount");
        String batchCount = (String)paramDataMap.get("batchCount");
        this.getModel().setValue("threaddealcount", (Object)threadDealCount);
        this.getModel().setValue("batchcount", (Object)batchCount);
        this.getView().getParentView().getPageCache().put(PARAM_PAGEID, this.getView().getPageId());
        this.changeViewStatus(OperationStatus.VIEW);
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "save": {
                FormShowParameter showParameter = this.getView().getFormShowParameter();
                String cfgId = (String)showParameter.getCustomParam("id");
                operate.getOption().setVariableValue("id", cfgId);
                break;
            }
            case "edit": {
                this.changeViewStatus(OperationStatus.EDIT);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (args.getOperationResult().isSuccess()) {
            switch (operateKey) {
                case "save": {
                    this.changeViewStatus(OperationStatus.VIEW);
                    this.getModel().setDataChanged(false);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"SalarySlipParameterEdit_2", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "cancel": {
                    if (this.checkDataChange()) break;
                    this.getView().updateView();
                    break;
                }
            }
        }
    }

    private boolean checkDataChange() {
        boolean isChange = this.getView().getModel().getDataChanged();
        if (isChange) {
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"SalaryParameterTreePlugin_0", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"SalaryParameterTreePlugin_1", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"SalaryParameterTreePlugin_2", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
            msg = msg.replaceAll("\\\\r\\\\n", "\r\n");
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CONFIRM_TAX_SAVE, (IFormPlugin)this);
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            this.getView().showConfirm(msg, this.getView().getModel().getChangeDesc(), options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        }
        return this.getView().getModel().getDataChanged();
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (CONFIRM_TAX_SAVE.equals(event.getCallBackId()) && event.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.changeViewStatus(OperationStatus.VIEW);
            this.getView().updateView();
        }
    }

    private void changeViewStatus(OperationStatus status) {
        this.getView().setStatus(status);
        boolean isVisible = OperationStatus.VIEW.equals((Object)status);
        this.getView().setVisible(Boolean.valueOf(!isVisible), new String[]{BAR_SAVE, BAR_CANCEL});
        this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{BAR_EDIT});
    }
}

