/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.basedata.salaryparameter;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;
import org.apache.commons.lang3.StringUtils;

public class SalaryParameterTreePlugin
extends SWCDataBaseEdit
implements TreeNodeClickListener,
SearchEnterListener {
    private static final String CONTENT_PANEL = "contentpanel";
    private static final String TREE_VIEW = "treeview";
    private static final String KEY_SEARCH = "searchap";
    private static final String PARAM_PAGEID = "PARAM_PAGEID";
    private static final String CONFIRM_CALL_SAVE = "confirm_call_save";
    private static final String CONFIRM_CALL_CLOSE = "confirm_call_close";
    private static final String KEY_PARAMETER_NODE = "salaryparameternode";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getView().getControl(KEY_SEARCH);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.initTreeItem();
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Map TREE_NODE_MAP = (Map)SerializationUtils.fromJsonString((String)this.getView().getPageCache().get("TREE_NODE_MAP"), Map.class);
        String nodeId = evt.getNodeId().toString();
        if (TREE_NODE_MAP == null) {
            return;
        }
        this.openOrCloseNode(nodeId);
        TreeNode treeNode = this.changeTreeNodeObj(TREE_NODE_MAP.get(nodeId));
        String waitFormId = treeNode.getData() != null ? String.valueOf(treeNode.getData()) : null;
        this.getPageCache().put("waitFormId", waitFormId);
        this.getPageCache().put("waitNodeId", treeNode.getId());
        if (!this.checkDataChange(CONFIRM_CALL_SAVE)) {
            this.showNodeView();
        }
    }

    private void openOrCloseNode(String nodeId) {
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        Map nodeMap = (Map)swcPageCache.get(KEY_PARAMETER_NODE, Map.class);
        TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEW);
        if (nodeMap == null || nodeMap.isEmpty()) {
            treeView.collapse(nodeId);
            HashMap<String, String> newNodeMap = new HashMap<String, String>();
            newNodeMap.put(nodeId, "0");
            swcPageCache.put(KEY_PARAMETER_NODE, newNodeMap);
        } else {
            String result = (String)nodeMap.get(nodeId);
            if (result == null || "1".equals(result)) {
                treeView.collapse(nodeId);
                nodeMap.put(nodeId, "0");
            } else {
                treeView.expand(nodeId);
                nodeMap.put(nodeId, "1");
            }
            swcPageCache.put(KEY_PARAMETER_NODE, (Object)nodeMap);
        }
    }

    private TreeNode changeTreeNodeObj(Object treeNodeObj) {
        String nodeString = SerializationUtils.toJsonString((Object)treeNodeObj);
        TreeNode node = (TreeNode)SerializationUtils.fromJsonString((String)nodeString, TreeNode.class);
        return node;
    }

    private boolean checkDataChange(String callBackId) {
        String personPageId = this.getPageCache().get(PARAM_PAGEID);
        if (personPageId == null) {
            return false;
        }
        IFormView personView = this.getView().getView(personPageId);
        if (personView == null) {
            return false;
        }
        boolean isChange = personView.getModel().getDataChanged();
        if (isChange) {
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"SalaryParameterTreePlugin_0", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"SalaryParameterTreePlugin_1", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"SalaryParameterTreePlugin_2", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
            msg = msg.replaceAll("\\\\r\\\\n", "\r\n");
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(callBackId, (IFormPlugin)this);
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            this.getView().showConfirm(msg, personView.getModel().getChangeDesc(), options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        }
        return isChange;
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (CONFIRM_CALL_SAVE.equals(event.getCallBackId())) {
            if (event.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.showNodeView();
            } else {
                Map TREE_NODE_MAP = (Map)SerializationUtils.fromJsonString((String)this.getView().getPageCache().get("TREE_NODE_MAP"), Map.class);
                TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEW);
                treeView.focusNode(this.changeTreeNodeObj(TREE_NODE_MAP.get(this.getPageCache().get("lastNodeId"))));
            }
        } else if (CONFIRM_CALL_CLOSE.equals(event.getCallBackId()) && event.getResult().equals((Object)MessageBoxResult.Yes)) {
            String personPageId = this.getPageCache().get(PARAM_PAGEID);
            IFormView personView = this.getView().getView(personPageId);
            personView.getModel().setDataChanged(false);
            this.getView().close();
        }
    }

    public void search(SearchEnterEvent event) {
        String text = event.getText();
        Map TREE_NODE_MAP = (Map)SerializationUtils.fromJsonString((String)this.getView().getPageCache().get("TREE_NODE_MAP"), Map.class);
        for (Map.Entry treeNodeEntry : TREE_NODE_MAP.entrySet()) {
            TreeNode treeNode = this.changeTreeNodeObj(treeNodeEntry.getValue());
            String treeNodeText = treeNode.getText();
            if (!treeNodeText.contains(text)) continue;
            TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEW);
            treeView.focusNode(treeNode);
            treeView.expand(treeNode.getParentid());
            treeView.treeNodeClick(treeNode.getParentid(), treeNode.getId());
            break;
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        if (this.checkDataChange(CONFIRM_CALL_CLOSE)) {
            event.setCancel(true);
        }
    }

    private void initTreeItem() {
        DynamicObject[] twoObjects;
        HashMap<Object, TreeNode> TREE_NODE_MAP = new HashMap<Object, TreeNode>(16);
        ArrayList<TreeNode> ROOT_TREE_NODE_LIST = new ArrayList<TreeNode>(10);
        String appNumber = this.getAppNumber();
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_salaryparamcfg");
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and(new QFilter("status", "=", (Object)"C"));
        if (!StringUtils.isEmpty((CharSequence)appNumber)) {
            filter.and("app.number", "=", (Object)appNumber);
        }
        String orderBys = "index";
        DynamicObject[] rootObjects = helper.query("id,name,page", new QFilter[]{filter, new QFilter("level", "=", (Object)1)}, orderBys);
        if (rootObjects == null || rootObjects.length == 0) {
            this.getPageCache().put("TREE_NODE_MAP", SerializationUtils.toJsonString(TREE_NODE_MAP));
            return;
        }
        for (DynamicObject object : rootObjects) {
            DynamicObject[] id = object.getString("id");
            String name = object.getString("name");
            String page = object.getString("page");
            TreeNode node = new TreeNode();
            node.setId((String)id);
            node.setText(name);
            node.setData((Object)page);
            node.setExpend(true);
            node.setIsOpened(true);
            ROOT_TREE_NODE_LIST.add(node);
            TREE_NODE_MAP.put(id, node);
        }
        DynamicObject firstDynamicObject = rootObjects[0];
        String firstDynamicObjectId = firstDynamicObject.getString("id");
        TreeNode selectChildNode = null;
        filter.and("level", "=", (Object)2);
        filter.and("isleaf", "=", (Object)Boolean.TRUE);
        if (!StringUtils.isEmpty((CharSequence)appNumber)) {
            filter.and("app.number", "=", (Object)appNumber);
        }
        if ((twoObjects = helper.query("id,name,isleaf,parent,page", new QFilter[]{filter}, orderBys)) != null && twoObjects.length > 0) {
            for (DynamicObject object : twoObjects) {
                TreeNode parentNode;
                String id = object.getString("id");
                String name = object.getString("name");
                String page = object.getString("page");
                TreeNode node = new TreeNode();
                node.setId(id);
                node.setText(name);
                node.setData((Object)page);
                node.setExpend(true);
                node.setIsOpened(true);
                DynamicObject parent = object.getDynamicObject("parent");
                String parentId = parent.getString("id");
                if (SWCStringUtils.equals((String)firstDynamicObjectId, (String)parentId)) {
                    selectChildNode = node;
                }
                if ((parentNode = (TreeNode)TREE_NODE_MAP.get(parentId)) == null) continue;
                node.setParentid(parentId);
                parentNode.addChild(node);
                TREE_NODE_MAP.put(id, node);
            }
        }
        TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEW);
        treeView.addNodes(ROOT_TREE_NODE_LIST);
        if (selectChildNode == null) {
            selectChildNode = (TreeNode)ROOT_TREE_NODE_LIST.get(0);
        }
        treeView.setRootVisible(true);
        treeView.focusNode(selectChildNode);
        String waitFormId = selectChildNode.getData() != null ? String.valueOf(selectChildNode.getData()) : null;
        this.getPageCache().put("waitFormId", waitFormId);
        this.getPageCache().put("waitNodeId", selectChildNode.getId());
        this.showNodeView();
        this.getPageCache().put("TREE_NODE_MAP", SerializationUtils.toJsonString(TREE_NODE_MAP));
    }

    private void showNodeView() {
        this.getPageCache().remove(PARAM_PAGEID);
        String waitFormId = this.getPageCache().get("waitFormId");
        String waitNodeId = this.getPageCache().get("waitNodeId");
        if (SWCStringUtils.isNotEmpty((String)waitFormId) && waitNodeId != null) {
            this.getView().setVisible(Boolean.TRUE, new String[]{CONTENT_PANEL});
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(waitFormId);
            showParameter.setCustomParam("id", (Object)waitNodeId);
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.getOpenStyle().setTargetKey(CONTENT_PANEL);
            this.getView().showForm(showParameter);
            this.getPageCache().put("lastNodeId", waitNodeId);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{CONTENT_PANEL});
        }
    }

    private String getAppNumber() {
        return this.getView().getFormShowParameter().getAppId();
    }
}

