/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.basedata.salaryparameter;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCSalaryParameterServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class SalarySlipParameterEdit
extends SWCDataBaseEdit {
    private static final String SYSTEM_TYPE = "swc-hsbs-formplugin";
    private static final String SIMPLE_NAME = SalarySlipParameterEdit.class.getSimpleName();
    private static final String CONTENT_PANEL_AP = "contentpanelap";
    private static final String ENCRYPT_LEVEL_GROUP = "encryptlevelgroup";
    private static final String CONFIRM_CALL_EDIT = "confirm_call_edit";
    private static final String CONFIRM_CALL_SAVE = "confirm_call_save";
    private static final String CONFIRM_CALL_NOTSAVE = "confirm_call_not_save";
    private static final String BAR_SAVE = "barsave";
    private static final String OPKEY_SAVE = "save";
    private static final String BAR_RESET = "barreset";
    private static final String OPKEY_RESET = "reset";
    private static final String BAR_CANCEL = "barcancel";
    private static final String OPKEY_CANCEL = "cancel";
    private static final String PARAM_PAGEID = "PARAM_PAGEID";
    private static final String SALARY_SLIP_PARAMETER_LOCK = "salaryslipparameterlock";
    private static boolean isFirstSave = false;

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addItemClickListeners(new String[]{BAR_RESET, BAR_CANCEL});
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String nodeId = (String)showParameter.getCustomParam("id");
        this.initParameter(nodeId);
        this.getPageCache().put("id", nodeId);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        formOperate.getOption().setVariableValue("id", this.getPageCache().get("id"));
        switch (operateKey) {
            case "reset": {
                this.showConfirmMessage(CONFIRM_CALL_EDIT);
                break;
            }
            case "save": {
                if (!this.getView().getModel().getDataChanged()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53c2\u6570\u8bbe\u7f6e\u672a\u53d8\u5316\uff0c\u65e0\u9700\u4fdd\u5b58\u3002", (String)(SIMPLE_NAME + "_1"), (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                if (this.getReleaseCache()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u5de5\u8d44\u6761\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"SalarySlipParameterEdit_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                String isSave = "false";
                if (formOperate.getOption().containsVariable(OPKEY_SAVE)) {
                    isSave = formOperate.getOption().getVariableValue(OPKEY_SAVE);
                }
                if (Boolean.parseBoolean(isSave)) break;
                this.showConfirmMessage(CONFIRM_CALL_SAVE);
                args.setCancel(true);
                if (null != DLock.getLockInfo((String)SALARY_SLIP_PARAMETER_LOCK)) {
                    DLock.forceUnlock((String[])new String[]{SALARY_SLIP_PARAMETER_LOCK});
                }
                DLock lock = DLock.create((String)SALARY_SLIP_PARAMETER_LOCK);
                lock.lock();
                lock.close();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult().isSuccess()) {
            if (OPKEY_SAVE.equals(args.getOperateKey())) {
                this.toViewPage();
                this.getView().getModel().setDataChanged(false);
                if (isFirstSave) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)(SIMPLE_NAME + "_2"), (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    isFirstSave = false;
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u7f6e\u6210\u529f\uff0c\u5386\u53f2\u5de5\u8d44\u6761\u6570\u636e\u5c06\u88ab\u5168\u90e8\u6e05\u9664\uff0c\u53ef\u524d\u5f80\u85aa\u8d44\u6838\u7b97\u5e94\u7528-\u85aa\u8d44\u6838\u7b97-\u85aa\u8d44\u6838\u7b97\u4efb\u52a1\u8fdb\u884c\u5386\u53f2\u6570\u636e\u91cd\u63a8\u3002", (String)(SIMPLE_NAME + "_3"), (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
                if (null != DLock.getLockInfo((String)SALARY_SLIP_PARAMETER_LOCK)) {
                    DLock.forceUnlock((String[])new String[]{SALARY_SLIP_PARAMETER_LOCK});
                }
            } else if (OPKEY_CANCEL.equals(args.getOperateKey()) && !this.checkDataChange()) {
                this.toViewPage();
                this.getView().updateView();
            }
        }
    }

    private boolean checkDataChange() {
        boolean isChange = this.getView().getModel().getDataChanged();
        if (isChange) {
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"SalaryParameterTreePlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"SalaryParameterTreePlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"SalaryParameterTreePlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            msg = msg.replaceAll("\\\\r\\\\n", "\r\n");
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CONFIRM_CALL_NOTSAVE, (IFormPlugin)this);
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            this.getView().showConfirm(msg, this.getView().getModel().getChangeDesc(), options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        }
        return this.getView().getModel().getDataChanged();
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (CONFIRM_CALL_EDIT.equals(event.getCallBackId())) {
            if (event.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.toEditPage();
            }
        } else if (CONFIRM_CALL_NOTSAVE.equals(event.getCallBackId())) {
            if (event.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.toViewPage();
                this.getView().updateView();
            }
        } else if (CONFIRM_CALL_SAVE.equals(event.getCallBackId())) {
            if (event.getResult().equals((Object)MessageBoxResult.Yes)) {
                OperateOption operation = OperateOption.create();
                operation.setVariableValue(OPKEY_SAVE, "true");
                this.getView().invokeOperation(OPKEY_SAVE, operation);
            } else if (null != DLock.getLockInfo((String)SALARY_SLIP_PARAMETER_LOCK)) {
                DLock.forceUnlock((String[])new String[]{SALARY_SLIP_PARAMETER_LOCK});
            }
        }
    }

    private void toEditPage() {
        this.getView().setVisible(Boolean.FALSE, new String[]{BAR_RESET});
        this.getView().setVisible(Boolean.TRUE, new String[]{BAR_SAVE, BAR_CANCEL});
        this.getView().setStatus(OperationStatus.EDIT);
    }

    private void toViewPage() {
        this.getView().setVisible(Boolean.TRUE, new String[]{BAR_RESET});
        this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SAVE, BAR_CANCEL});
        this.getView().setStatus(OperationStatus.VIEW);
    }

    private void initParameter(String cfgId) {
        Map paramMap = SWCSalaryParameterServiceHelper.getSalaryParam((long)Long.parseLong(cfgId));
        IDataModel model = this.getModel();
        this.getView().getParentView().getPageCache().put(PARAM_PAGEID, this.getView().getPageId());
        if (paramMap != null && paramMap.get("encryptlevel") != null) {
            this.toViewPage();
            model.setValue(ENCRYPT_LEVEL_GROUP, paramMap.get("encryptlevel"));
            this.getView().updateView(CONTENT_PANEL_AP);
        } else {
            isFirstSave = true;
            this.toEditPage();
            model.setValue(ENCRYPT_LEVEL_GROUP, (Object)"");
            this.getView().updateView(CONTENT_PANEL_AP);
        }
        model.setDataChanged(false);
    }

    private void showConfirmMessage(String callBackId) {
        String message = ResManager.loadKDString((String)"\u91cd\u7f6e\u6210\u529f\u540e\uff0c\u5df2\u53d1\u5e03\u5de5\u8d44\u6761\u5c06\u4f1a\u5168\u90e8\u6e05\u9664\uff0c\u5458\u5de5\u5c06\u65e0\u6cd5\u67e5\u8be2\u5386\u53f2\u5de5\u8d44\u6761\u6570\u636e\u3002\u6b63\u5728\u53d1\u5e03\u7684\u5de5\u8d44\u6761\u5c06\u4f1a\u53d1\u5e03\u5931\u8d25\u3002\u8bf7\u8c28\u614e\u64cd\u4f5c\uff01\u786e\u5b9a\u7ee7\u7eed\uff1f", (String)(SIMPLE_NAME + "_0"), (String)SYSTEM_TYPE, (Object[])new Object[0]);
        this.getView().showConfirm(message, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(callBackId));
    }

    private boolean getReleaseCache() {
        DynamicObject[] dyobjs;
        SWCDataServiceHelper calRecordHelper = new SWCDataServiceHelper("hsas_calsalarysliprecord");
        QFilter filter = new QFilter("salarystatus", "=", (Object)"1");
        for (DynamicObject dynamicObject : dyobjs = calRecordHelper.query("id", new QFilter[]{filter})) {
            Long recordId = dynamicObject.getLong("id");
            ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CAL_SALARY_%s", recordId));
            if (appCache.get("calTaskIdList", List.class) == null) continue;
            return true;
        }
        return false;
    }
}

