/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.basedata.salaryparameter;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCSalaryParameterServiceHelper;
import kd.swc.hsbp.business.taxservice.TaxCalServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;
import kd.swc.hsbs.service.TaxCountryInfoPullService;

public class SalaryTaxParamPlugin
extends SWCDataBaseEdit {
    private static final Log logger = LogFactory.getLog(SalaryTaxParamPlugin.class);
    private static final String OPKEY_SAVE = "save";
    private static final String OPKEY_EDIT = "edit";
    private static final String OPKEY_CANCEL = "cancel";
    private static final String BAR_SAVE = "barsave";
    private static final String BAR_EDIT = "baredit";
    private static final String BAR_TAX_SYNC = "bartaxsync";
    private static final String TAX_SYNC_OP = "taxsync";
    private static final String BAR_CANCEL = "barcancel";
    private static final String CONFIRM_TAX_SAVE = "confirm_tax_save";
    private static final String PARAM_PAGEID = "PARAM_PAGEID";
    private static final String COUNTRY_ENTRYENTITY = "countryentryentity";

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String nodeId = (String)showParameter.getCustomParam("id");
        this.loadCountryEntry(nodeId);
        this.getPageCache().put("id", nodeId);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "save": {
                operate.getOption().setVariableValue("id", this.getPageCache().get("id"));
                break;
            }
            case "edit": {
                this.changeViewStatus(OperationStatus.EDIT);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String optKey = args.getProperty().getName();
        if (SWCStringUtils.equals((String)optKey, (String)"opentaxcal")) {
            this.openTaxCalChangeEvent(args);
        }
    }

    private void openTaxCalChangeEvent(PropertyChangedArgs args) {
        ChangeData[] changeDatas0 = args.getChangeSet();
        ChangeData data = changeDatas0[0];
        int rowIndex = data.getRowIndex();
        Boolean oldVal = (Boolean)data.getOldValue();
        Boolean newVal = (Boolean)data.getNewValue();
        if (oldVal == null || newVal == null) {
            return;
        }
        if (!oldVal.booleanValue() || newVal.booleanValue()) {
            return;
        }
        Object countryIdObj = this.getModel().getValue("countryid");
        long countryId = 0L;
        if (countryIdObj instanceof Integer) {
            countryId = Long.parseLong(String.valueOf(countryIdObj));
        } else if (countryIdObj instanceof Long) {
            countryId = (Long)countryIdObj;
        }
        boolean calPayRollTaskAllow = this.judgeCalPayRollTaskAllow(countryId);
        boolean calRuleAllow = this.judgeCalRuleAllow(countryId);
        if (!calPayRollTaskAllow || !calRuleAllow) {
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u56fd\u5bb6\u5730\u533a\u4e0b\u7684\u6240\u6709\u6838\u7b97\u4efb\u52a1\u7684\u4efb\u52a1\u72b6\u6001\u4e3a\u201c\u5df2\u5ba1\u6279\u901a\u8fc7\u201d\u3001\u201c\u5df2\u5e9f\u5f03\u201d\u4e14\u8be5\u56fd\u5bb6\u5730\u533a\u4e0b\u7684\u8ba1\u7b97\u89c4\u5219\u6240\u6709\u5f53\u524d\u751f\u6548\u4ee5\u53ca\u672a\u6765\u751f\u6548\u7684\u7248\u672c\u7684\u4e2a\u7a0e\u8ba1\u7b97\u5f00\u5173\u72b6\u6001\u4e3a\u201c\u5426\u201d\u624d\u53ef\u4ee5\u53d8\u66f4\u3002", (String)"SalaryTaxParamPlugin_1", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            this.getModel().setValue("opentaxcal", (Object)Boolean.TRUE, rowIndex);
            this.getModel().setDataChanged(false);
        }
    }

    private boolean judgeCalRuleAllow(long countryId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calrule");
        String field = "id";
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and("iscurrentversion", "=", (Object)Boolean.TRUE);
        filter.and("datastatus", "in", (Object)new String[]{"0", "1"});
        filter.and("opentaxcal", "=", (Object)"1");
        DynamicObject[] calRuleArray = helper.query(field, new QFilter[]{filter});
        return calRuleArray == null || calRuleArray.length == 0;
    }

    private boolean judgeCalPayRollTaskAllow(long countryId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        String field = "id";
        QFilter filter = new QFilter("country.id", "=", (Object)countryId);
        filter.and("taskstatus", "!=", (Object)"4");
        filter.and("taskstatus", "!=", (Object)"6");
        DynamicObject[] taskStatusArray = helper.query(field, new QFilter[]{filter});
        return taskStatusArray == null || taskStatusArray.length == 0;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (args.getOperationResult().isSuccess()) {
            switch (operateKey) {
                case "save": {
                    this.changeViewStatus(OperationStatus.VIEW);
                    this.getModel().setDataChanged(false);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"SalarySlipParameterEdit_2", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                    TaxCalServiceHelper.setTaxCalCacheMap();
                    break;
                }
                case "cancel": {
                    if (this.checkDataChange()) break;
                    this.getView().updateView();
                    break;
                }
                case "taxsync": {
                    this.taxInfoSync();
                    break;
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (CONFIRM_TAX_SAVE.equals(event.getCallBackId()) && event.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.changeViewStatus(OperationStatus.VIEW);
            this.getView().updateView();
        }
    }

    private void taxInfoSync() {
        TaxCountryInfoPullService service = new TaxCountryInfoPullService();
        List taxCountryList = service.getTaxCountryInfo();
        if (taxCountryList == null || taxCountryList.size() == 0) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f\u3002", (String)"SalaryTaxParamPlugin_0", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection entryDatas = this.getModel().getEntryEntity(COUNTRY_ENTRYENTITY);
        List<DynamicObject> increamentCountry = this.getIncreamentCountryData(taxCountryList, entryDatas);
        if (increamentCountry == null || increamentCountry.size() == 0) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f\u3002", (String)"SalaryTaxParamPlugin_0", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getView().getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("countryname", new Object[0]);
        setter.addField("opentaxcal", new Object[0]);
        setter.addField("operator", new Object[0]);
        setter.addField("operatetime", new Object[0]);
        setter.addField("countryid", new Object[0]);
        setter.addField("countrynumber", new Object[0]);
        if (entryDatas != null && entryDatas.size() > 0) {
            for (DynamicObject entryObj : entryDatas) {
                setter.addRow(new Object[]{entryObj.get("countryname"), entryObj.get("opentaxcal"), entryObj.get("operator"), entryObj.get("operatetime"), entryObj.get("countryid")});
            }
        }
        long operatorId = RequestContext.get().getCurrUserId();
        Date operateTime = new Date();
        boolean enableTaxCal = true;
        for (DynamicObject increamentObj : increamentCountry) {
            DynamicObject countryObj = increamentObj.getDynamicObject("country");
            String countryName = countryObj.getString("name");
            long countryId = countryObj.getLong("id");
            String countryNumber = countryObj.getString("number");
            setter.addRow(new Object[]{countryName, enableTaxCal, operatorId, operateTime, countryId, countryNumber});
        }
        model.deleteEntryData(COUNTRY_ENTRYENTITY);
        model.batchCreateNewEntryRow(COUNTRY_ENTRYENTITY, setter);
        model.endInit();
        this.getView().updateView(COUNTRY_ENTRYENTITY);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f\u3002", (String)"SalaryTaxParamPlugin_0", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
    }

    private List<DynamicObject> getIncreamentCountryData(List<DynamicObject> taxCountryList, DynamicObjectCollection entryDatas) {
        if (entryDatas == null || entryDatas.size() == 0) {
            return taxCountryList;
        }
        ArrayList<DynamicObject> retList = new ArrayList<DynamicObject>(10);
        HashMap<Long, DynamicObject> entryMap = new HashMap<Long, DynamicObject>(entryDatas.size());
        for (DynamicObject entryObj : entryDatas) {
            long countryId = entryObj.getLong("countryid");
            entryMap.put(countryId, entryObj);
        }
        for (DynamicObject taxCountryObj : taxCountryList) {
            DynamicObject countryObj = taxCountryObj.getDynamicObject("country");
            long taxCountryId = countryObj.getLong("id");
            if (entryMap.containsKey(taxCountryId)) continue;
            retList.add(taxCountryObj);
        }
        return retList;
    }

    private void loadCountryEntry(String cfgId) {
        String paramStr = SWCSalaryParameterServiceHelper.getSalaryParamData((long)Long.parseLong(cfgId));
        if (SWCStringUtils.isEmpty((String)paramStr)) {
            this.changeViewStatus(OperationStatus.VIEW);
            return;
        }
        JSONObject paramObj = JSONObject.parseObject((String)paramStr);
        if (paramObj == null || paramObj.size() == 0) {
            this.changeViewStatus(OperationStatus.VIEW);
            return;
        }
        JSONArray countryArray = paramObj.getJSONArray("countryInfo");
        if (countryArray == null || countryArray.size() == 0) {
            this.changeViewStatus(OperationStatus.VIEW);
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getView().getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("countryname", new Object[0]);
        setter.addField("opentaxcal", new Object[0]);
        setter.addField("operator", new Object[0]);
        setter.addField("operatetime", new Object[0]);
        setter.addField("countryid", new Object[0]);
        for (int i = 0; i < countryArray.size(); ++i) {
            JSONObject countryObj = countryArray.getJSONObject(i);
            String countryName = countryObj.getString("countryName");
            boolean enableTaxCal = countryObj.getBooleanValue("enableTaxCal");
            long operatorId = countryObj.getLongValue("operatorId");
            String operateTimeStr = countryObj.getString("operateTime");
            Date operateTime = null;
            try {
                operateTime = SWCDateTimeUtils.parseDate((String)operateTimeStr, (String)"yyyy-MM-dd HH:mm:ss");
            }
            catch (ParseException e) {
                logger.error(e.getMessage());
            }
            long countryId = countryObj.getLongValue("countryId");
            setter.addRow(new Object[]{countryName, enableTaxCal, operatorId, operateTime, countryId});
        }
        model.deleteEntryData(COUNTRY_ENTRYENTITY);
        model.batchCreateNewEntryRow(COUNTRY_ENTRYENTITY, setter);
        model.endInit();
        this.changeViewStatus(OperationStatus.VIEW);
        this.getView().updateView("contentpanelap");
        this.getView().getParentView().getPageCache().put(PARAM_PAGEID, this.getView().getPageId());
        model.setDataChanged(false);
    }

    private boolean checkDataChange() {
        boolean isChange = this.getView().getModel().getDataChanged();
        if (isChange) {
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"SalaryParameterTreePlugin_0", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"SalaryParameterTreePlugin_1", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"SalaryParameterTreePlugin_2", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
            msg = msg.replaceAll("\\\\r\\\\n", "\r\n");
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CONFIRM_TAX_SAVE, (IFormPlugin)this);
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            this.getView().showConfirm(msg, this.getView().getModel().getChangeDesc(), options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        }
        return this.getView().getModel().getDataChanged();
    }

    private void changeViewStatus(OperationStatus status) {
        this.getView().setStatus(status);
        boolean isVisible = OperationStatus.VIEW.equals((Object)status);
        this.getView().setVisible(Boolean.valueOf(!isVisible), new String[]{BAR_SAVE, BAR_CANCEL, BAR_TAX_SYNC});
        this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{BAR_EDIT});
    }
}

