/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.basedata.salaryparameter;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.business.servicehelper.SWCSalaryParameterServiceHelper;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class SingleParamBasePlugin
extends SWCDataBaseEdit {
    private static final String BAR_SAVE = "barsave";
    private static final String BAR_EDIT = "baredit";
    private static final String BAR_CANCEL = "barcancel";
    private static final String OPKEY_CANCEL = "cancel";
    private static final String CONFIRM_CANCEL = "confirm_cancel";
    private Set<String> propertyCodeSet;

    public void beforeBindData(EventObject evt) {
        Set<String> propertyCodeSet;
        super.beforeBindData(evt);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String nodeId = (String)showParameter.getCustomParam("id");
        Map paramMap = SWCSalaryParameterServiceHelper.getSalaryParam((long)Long.parseLong(nodeId));
        if (paramMap != null && !CollectionUtils.isEmpty(propertyCodeSet = this.getPropertyCodeSet())) {
            IDataModel model = this.getModel();
            for (String code : propertyCodeSet) {
                model.setValue(code, paramMap.get(code));
            }
        }
        this.changeViewStatus(OperationStatus.VIEW);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "save": {
                operate.getOption().setVariableValue("id", (String)this.getView().getFormShowParameter().getCustomParam("id"));
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (args.getOperationResult().isSuccess()) {
            switch (operateKey) {
                case "save": {
                    this.getModel().setDataChanged(false);
                    this.changeViewStatus(OperationStatus.VIEW);
                    break;
                }
                case "cancel": {
                    if (this.checkDataChange()) break;
                    this.getView().updateView();
                    break;
                }
                case "edit": {
                    this.changeViewStatus(OperationStatus.EDIT);
                    break;
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        Set<String> propertyCodes = this.getPropertyCodeSet();
        if (propertyCodes.contains(name)) {
            this.getModel().setDataChanged(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (CONFIRM_CANCEL.equals(event.getCallBackId()) && event.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.changeViewStatus(OperationStatus.VIEW);
            this.getView().updateView();
            this.getModel().setDataChanged(false);
        }
    }

    private boolean checkDataChange() {
        boolean isChange = this.getView().getModel().getDataChanged();
        if (isChange) {
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"TaxUnitParamBasePlugin_0", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"TaxUnitParamBasePlugin_1", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"TaxUnitParamBasePlugin_2", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
            msg = msg.replaceAll("\\\\r\\\\n", "\r\n");
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CONFIRM_CANCEL, (IFormPlugin)this);
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            this.getView().showConfirm(msg, this.getView().getModel().getChangeDesc(), options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        }
        return isChange;
    }

    private void changeViewStatus(OperationStatus status) {
        this.getView().setStatus(status);
        Boolean isVisible = OperationStatus.VIEW.equals((Object)status);
        this.getView().setVisible(Boolean.valueOf(isVisible == false), new String[]{BAR_SAVE, BAR_CANCEL});
        this.getView().setVisible(isVisible, new String[]{BAR_EDIT});
    }

    protected Set<String> getPropertyCodeSet() {
        DataEntityPropertyCollection properties;
        if (CollectionUtils.isEmpty(this.propertyCodeSet) && (properties = this.getModel().getDataEntityType().getProperties()) != null && properties.size() != 0) {
            this.propertyCodeSet = properties.stream().map(IMetadata::getName).collect(Collectors.toSet());
        }
        return this.propertyCodeSet;
    }

    protected void setText(String key, String content) {
        Label labelAp = (Label)this.getView().getControl(key);
        if (labelAp != null) {
            labelAp.setText(content);
        }
    }
}

