/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.basedata.salaryparameter;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.converter.util.CollectionUtils;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCSalaryParameterServiceHelper;
import kd.swc.hsbp.common.constants.WtcInteCfgConstants;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class WtcInteCfgParamPlugin
extends SWCDataBaseEdit
implements BeforeF7SelectListener {
    private static final String BAR_SAVE = "barsave";
    private static final String BAR_EDIT = "baredit";
    private static final String BAR_CANCEL = "barcancel";
    private static final String OPKEY_CANCEL = "cancel";
    private static final String CONFIRM_WTCINTEPARAM_SAVE = "confirm_wtcinteparam_save";
    private static final String KEY_ADD_ADMIN_ORG = "donothing_addadminorg";
    private static final String KEY_SCHEME_PANEL = "schemepanelap";
    private static final String KEY_MAP_RULE_PANEL = "maprulepanelap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit schemeEdit = (BasedataEdit)this.getControl("attintegmapscm");
        schemeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit adminOrgEdit = (BasedataEdit)this.getControl("adminorghr");
        adminOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String nodeId = (String)showParameter.getCustomParam("id");
        Map paramMap = SWCSalaryParameterServiceHelper.getSalaryParam((long)Long.parseLong(nodeId));
        if (paramMap != null) {
            this.initParam(paramMap);
            this.handleFlexByScheme((Boolean)this.getModel().getValue("isenablewtcinte"), Integer.valueOf((String)this.getModel().getValue("scheme")), true);
        } else {
            this.handleFlexByScheme(false, WtcInteCfgConstants.FIELD_SCHEME_ONE, true);
        }
        this.changeViewStatus(OperationStatus.VIEW);
        this.getModel().setDataChanged(false);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name;
        switch (name = beforeF7SelectEvent.getProperty().getName()) {
            case "attintegmapscm": {
                QFilter qFilter = new QFilter("enable", "=", (Object)"1");
                qFilter.and(new QFilter("status", "=", (Object)"C"));
                qFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
                this.setF7Filter(beforeF7SelectEvent, qFilter);
                break;
            }
            case "adminorghr": {
                QFilter qFilter = this.getAdminorgFilter();
                this.setF7Filter(beforeF7SelectEvent, qFilter);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "save": {
                operate.getOption().setVariableValue("id", (String)this.getView().getFormShowParameter().getCustomParam("id"));
                break;
            }
            case "donothing_addadminorg": {
                ListShowParameter showParameter = this.openF7("haos_adminorghr", "haos_orgtreelistf7");
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, operateKey));
                QFilter filter = this.getAdminorgFilter();
                showParameter.getListFilterParameter().getQFilters().add(filter);
                showParameter.setMultiSelect(true);
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("deleteentry".equals(operateKey)) {
            return;
        }
        if (args.getOperationResult().isSuccess()) {
            switch (operateKey) {
                case "save": {
                    this.getModel().setDataChanged(false);
                    this.handleFlexByScheme((Boolean)this.getModel().getValue("isenablewtcinte"), Integer.valueOf((String)this.getModel().getValue("scheme")), true);
                    this.changeViewStatus(OperationStatus.VIEW);
                    break;
                }
                case "cancel": {
                    if (this.checkDataChange()) break;
                    this.getView().updateView();
                    break;
                }
                case "edit": {
                    this.changeViewStatus(OperationStatus.EDIT);
                    break;
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name;
        switch (name = args.getProperty().getName()) {
            case "isenablewtcinte": {
                this.getModel().setDataChanged(true);
                this.handleFlexByScheme((Boolean)args.getChangeSet()[0].getNewValue(), WtcInteCfgConstants.FIELD_SCHEME_ONE, false);
                break;
            }
            case "scheme": {
                this.handleFlexByScheme((Boolean)this.getModel().getValue("isenablewtcinte"), Integer.valueOf((String)args.getChangeSet()[0].getNewValue()), false);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (CONFIRM_WTCINTEPARAM_SAVE.equals(event.getCallBackId()) && event.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.changeViewStatus(OperationStatus.VIEW);
            this.getView().updateView();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        switch (closedCallBackEvent.getActionId()) {
            case "donothing_addadminorg": {
                Object returnData;
                if (closedCallBackEvent.getReturnData() == null || !((returnData = closedCallBackEvent.getReturnData()) instanceof ListSelectedRowCollection)) break;
                ListSelectedRowCollection rows = (ListSelectedRowCollection)returnData;
                List<Object> adminOrgIdList = rows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
                this.newEntriesOperate(adminOrgIdList);
                break;
            }
        }
    }

    private void newEntriesOperate(List<Object> adminOrgIdList) {
        if (CollectionUtils.isEmpty(adminOrgIdList)) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter values = new TableValueSetter(new String[0]);
        values.addField("adminorghr", new Object[0]);
        for (Object adminOrgId : adminOrgIdList) {
            values.addRow(new Object[]{adminOrgId});
        }
        model.beginInit();
        model.batchCreateNewEntryRow("entryentity", values);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private boolean checkDataChange() {
        boolean isChange = this.getView().getModel().getDataChanged();
        if (isChange) {
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"WtcInteCfgParamPlugin_2", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"WtcInteCfgParamPlugin_3", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"WtcInteCfgParamPlugin_4", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
            msg = msg.replaceAll("\\\\r\\\\n", "\r\n");
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CONFIRM_WTCINTEPARAM_SAVE, (IFormPlugin)this);
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            this.getView().showConfirm(msg, this.getView().getModel().getChangeDesc(), options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        }
        return this.getView().getModel().getDataChanged();
    }

    private void changeViewStatus(OperationStatus status) {
        this.getView().setStatus(status);
        Boolean isVisible = OperationStatus.VIEW.equals((Object)status);
        this.getView().setVisible(Boolean.valueOf(isVisible == false), new String[]{BAR_SAVE, BAR_CANCEL, "deleteentry"});
        this.getView().setVisible(isVisible, new String[]{BAR_EDIT});
    }

    private void setF7Filter(BeforeF7SelectEvent event, QFilter qFilter) {
        ListShowParameter param = (ListShowParameter)event.getFormShowParameter();
        param.getListFilterParameter().setFilter(qFilter);
    }

    private ListShowParameter openF7(String billFormId, String f7FormId) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setBillFormId(billFormId);
        showParameter.setFormId(f7FormId);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("960px");
        styleCss.setHeight("580px");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        showParameter.setLookUp(true);
        showParameter.setMultiSelect(true);
        showParameter.setShowTitle(false);
        showParameter.setHasRight(true);
        return showParameter;
    }

    private void handleFlexByScheme(Boolean isenablewtcinte, Integer scheme, boolean isInit) {
        if (!isenablewtcinte.booleanValue()) {
            if (isInit) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"radiofield2"});
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_SCHEME_PANEL, KEY_MAP_RULE_PANEL});
            this.getModel().setValue("scheme", (Object)WtcInteCfgConstants.FIELD_SCHEME_ONE);
            this.getModel().deleteEntryData("entryentity");
        } else if (WtcInteCfgConstants.FIELD_SCHEME_ONE.equals(scheme)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_SCHEME_PANEL, KEY_MAP_RULE_PANEL});
            if (isInit) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"radiofield2"});
            }
        } else if (WtcInteCfgConstants.FIELD_SCHEME_THREE.equals(scheme)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_SCHEME_PANEL});
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_MAP_RULE_PANEL});
            this.getModel().deleteEntryData("entryentity");
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_MAP_RULE_PANEL});
            this.getModel().deleteEntryData("entryentity");
            if (isInit) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"radiofield2"});
            }
        }
    }

    private void initParam(Map<String, Object> paramMap) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        Boolean enableWtcInte = (Boolean)paramMap.get("enableWtcInte");
        model.setValue("isenablewtcinte", (Object)enableWtcInte);
        Integer scheme = (Integer)paramMap.getOrDefault("scheme", WtcInteCfgConstants.FIELD_SCHEME_THREE);
        model.setValue("scheme", (Object)scheme);
        List mapRuleList = (List)paramMap.get("mapRuleList");
        this.getModel().deleteEntryData("entryentity");
        if (CollectionUtils.isNotEmpty((Collection)mapRuleList)) {
            TableValueSetter values = new TableValueSetter(new String[0]);
            values.addField("adminorghr", new Object[0]);
            values.addField("containssub", new Object[0]);
            values.addField("attintegmapscm", new Object[0]);
            for (Map mapRule : mapRuleList) {
                values.addRow(new Object[]{mapRule.getOrDefault("adminorghr", 0L), mapRule.getOrDefault("containssub", "1"), mapRule.getOrDefault("attintegmapscm", 0L)});
            }
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", values);
            model.endInit();
        }
        this.getView().updateView("entryentity");
    }

    private QFilter getAdminorgFilter() {
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and(BaseDataHisHelper.getHisCurrFilter());
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        HashSet ignoreIds = Sets.newHashSet();
        for (DynamicObject entry : entrys) {
            Long adminOrgId = entry.getLong("adminorghr.id");
            ignoreIds.add(adminOrgId);
        }
        if (!CollectionUtils.isEmpty((Collection)ignoreIds)) {
            filter.and(new QFilter("id", "not in", (Object)ignoreIds));
        }
        return filter;
    }
}

