/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.basedata.schedule;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.field.CronField;
import com.cronutils.model.field.CronFieldName;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.field.expression.On;
import com.cronutils.model.field.value.SpecialChar;
import com.cronutils.model.field.value.SpecialCharFieldValue;
import com.cronutils.model.time.generator.FieldValueGeneratorFactory;
import com.cronutils.parser.CronParser;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.formplugin.CronStruct;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;
import kd.swc.hsbs.formplugin.web.basedata.schedule.bean.SchConfigCkBean;
import org.quartz.TriggerUtils;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.spi.OperableTrigger;

public class CopyFromSavePlugin
extends SWCDataBaseEdit {
    private static final String COMBDORW = "combdorw";
    private static final String SWC_HSBS_FORMPLUGIN = "swc-hsbs-formplugin";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String LOAD_DATA = "loadData";
    private static final String COMNO = "comno";
    private static final String REPEAT_MODE = "repeatmode";
    private static final String COM_WEEK = "comweek";
    private static final String COMNOBY_MONTH = "comnobymonth";
    private static final String COM_WEEKBY_MONTH = "comweekbymonth";
    private static final String TXTDESC = "txtdesc";
    private static final String SKDP = "_SKDP";
    private static final String STARTTIME = "starttime";
    private static final String ENDTIME = "endtime";
    private static final String CYCLE_NUM = "cyclenum";
    private static final String SAVE_PLUGIN_13 = "CopyFromSavePlugin_13";
    private static final String SAVE_PLUGIN_19 = "CopyFromSavePlugin_19";
    private static final String CKHOUR = "ckhour_";
    private static final String CKHOUR_0 = "ckhour_0";
    private static final String SAVE_PLUGIN_22 = "CopyFromSavePlugin_22";
    private static final String CKBY_WEEK = "ckbyweek";
    private static final String FLEXPBY_WEEK = "flexpbyweek";
    private static final String FLEXP_HOUR = "flexphour";
    private static final String JOBNUMBER = "jobnumber";
    private static final String JOB_STATUS = "jobstatus";
    private static final String RE_SCHEDULE = "reschedule";
    private static final String RUN_ORDER = "runorder";
    private static final String RUN_LANG = "runlang";
    private static final String RUN_ORG = "runorg";
    private static final String RUN_USER = "runuser";
    private static final String APPID = "appId";
    private static final String FLEXPDAYS = "flexpdays";
    private static final Log log = LogFactory.getLog((String)"kd.swc.hsbs.formplugin.web.basedata.schedule.CopyFromSavePlugin");
    private static final CronParser parser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
    private static final String[] CKMONTH = new String[]{"ckjan", "ckfeb", "ckmar", "ckapr", "ckmay", "ckjun", "ckjul", "ckaug", "cksep", "ckoct", "cknov", "ckdec"};
    private static final String[] CKDATE = new String[]{"ckone", "cktwo", "ckthree", "ckfour", "ckfive", "cksix", "ckseven", "ckeight", "cknine", "ckten", "ckeleven", "cktwelve", "ckthirteen", "ckfourteen", "ckfifteen", "cksixteen", "ckseventeen", "ckeighteen", "cknineteen", "cktwenty", "cktwentyone", "cktwentytwo", "cktwentythree", "cktwentyfour", "cktwentyfive", "cktwentysix", "cktwentyseven", "cktwentyeight", "cktwentynine", "ckthirty", "ckthirtyone"};
    private static final String[] CKWEEK = new String[]{"cksun", "ckmon", "cktues", "ckwed", "ckthur", "ckfri", "cksat"};
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String DEFINE = "def";
    private static final String NOREPEAT = "n";
    private static final String YEAR = "y";
    private static final String MONTH = "m";
    private static final String WEEK = "w";
    private static final String DAY = "d";
    private static final String HOUR = "h";
    private static final String MINUTE = "mi";
    private static final int GEN_DESC_TIME_NUM = 10;

    public void initialize() {
        super.initialize();
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener(tabselectevent -> {
            String key = tabselectevent.getTabKey();
            if ("tabweekpage".equals(key)) {
                this.getModel().setValue(COMBDORW, (Object)WEEK);
            } else {
                this.getModel().setValue(COMBDORW, (Object)DAY);
            }
        });
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        event.setSkipNoField(true);
    }

    public void afterBindData(EventObject eventObject) {
        String repeatMode;
        super.afterBindData(eventObject);
        if (this.dealCopyPage()) {
            String hourTemp;
            String cron;
            String[] cronTemp;
            Object repeatmode;
            this.adjustByRepeatMode();
            this.getPageCache().put(LOAD_DATA, "true");
            Tab tab = (Tab)this.getControl("tabap");
            Object combdorw = this.getModel().getValue(COMBDORW);
            if (combdorw != null && WEEK.equals(combdorw.toString())) {
                tab.activeTab("tabweekpage");
            }
            if ((repeatmode = this.getModel().getValue(REPEAT_MODE)) == null) {
                repeatmode = DEFINE;
            }
            if ((cronTemp = (cron = (String)this.getModel().getValue("plan")).split(" ")).length > 2 && (hourTemp = cronTemp[2]).contains("/") && !HOUR.equals(repeatmode)) {
                this.getModel().beginInit();
                this.getModel().setValue(REPEAT_MODE, (Object)DEFINE);
                this.getModel().endInit();
                this.getView().updateView(REPEAT_MODE);
            }
            if (DEFINE.equals(repeatmode.toString())) {
                this.getPageCache().remove(LOAD_DATA);
                this.getModel().setValue(TXTDESC, (Object)this.genDefDesc(repeatmode.toString(), 10));
                this.getModel().setDataChanged(false);
                return;
            }
            this.getPageCache().remove(LOAD_DATA);
            this.adjustByCron();
            String cronFromDB = (String)this.getModel().getValue("plan");
            String txtDesc = this.genDesc(false, 10);
            this.getModel().beginInit();
            this.getModel().setValue(TXTDESC, (Object)txtDesc);
            this.getModel().endInit();
            this.getView().updateView(TXTDESC);
            String cronFromConfiguration = (String)this.getModel().getValue("plan");
            if (!StringUtils.equals((CharSequence)cronFromDB, (CharSequence)cronFromConfiguration)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"cron\u8868\u8fbe\u5f0f\u4e0e\u8ba1\u5212\u65f6\u95f4\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fdd\u5b58\u66f4\u65b0\u6570\u636e\u3002", (String)"CopyFromSavePlugin_123", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
            }
        }
        if (DEFINE.equals(repeatMode = (String)this.getModel().getValue(REPEAT_MODE))) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"plan"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"plan"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"plan"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"plan"});
        }
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate oper;
        if (args.getSource() instanceof AbstractOperate && (oper = (AbstractOperate)args.getSource()).getOperateKey().equals("save")) {
            String desc;
            this.checkData();
            Object descObj = this.getModel().getValue(TXTDESC);
            if (descObj != null && (desc = (String)descObj).length() > 300) {
                desc = desc.substring(0, 300);
                this.getModel().setValue(TXTDESC, (Object)desc);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        IDataEntityProperty property = args.getProperty();
        String name = property.getName();
        if ((name.startsWith("comnoby") || name.startsWith("comweekby")) && this.getPageCache().get(LOAD_DATA) == null) {
            String no;
            String week;
            if (name.startsWith("comweekby")) {
                week = this.getComnoOrWeekValue(name);
                no = this.getComnoOrWeekValue(COMNO);
                if (StringUtils.equals((CharSequence)no, (CharSequence)"L") && StringUtils.equals((CharSequence)week, (CharSequence)"8")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8bbe\u7f6e\u6700\u540e\u4e00\u4e2a\u81ea\u7136\u65e5\u3002", (String)"CopyFromSavePlugin_131", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
                    this.setModelValue(name, "");
                    return;
                }
            }
            if (name.startsWith("comnoby")) {
                week = this.getComnoOrWeekValue(COM_WEEK);
                no = this.getComnoOrWeekValue(name);
                if (StringUtils.equals((CharSequence)no, (CharSequence)"L") && StringUtils.equals((CharSequence)week, (CharSequence)"8")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8bbe\u7f6e\u6700\u540e\u4e00\u4e2a\u81ea\u7136\u65e5\u3002", (String)"CopyFromSavePlugin_131", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
                    this.setModelValue(name, "");
                    return;
                }
            }
            this.getModel().beginInit();
            this.getModel().setValue(COMNO, this.getModel().getValue(name.replace(COM_WEEK, COMNO)));
            this.getModel().setValue(COM_WEEK, this.getModel().getValue(name.replace(COMNO, COM_WEEK)));
            this.getModel().endInit();
            Object commo = this.getModel().getValue(COMNO);
            Object comweek = this.getModel().getValue(COM_WEEK);
            if (name.endsWith("bymonth")) {
                if (commo != null && comweek != null && StringUtils.isNotBlank((CharSequence)commo.toString()) && StringUtils.isNotBlank((CharSequence)comweek.toString())) {
                    this.setModelValue(CKBY_WEEK, Boolean.TRUE);
                } else {
                    this.setModelValue(CKBY_WEEK, Boolean.FALSE);
                }
            }
        }
        if (name.equals("plan")) {
            String repeatmode = (String)this.getView().getModel().getValue(REPEAT_MODE);
            if (DEFINE.equalsIgnoreCase(repeatmode)) {
                this.setModelValue(TXTDESC, this.genDefDesc(name, 10));
            } else {
                this.setModelValue(TXTDESC, this.genDefDesc(DEFINE, 10));
            }
            return;
        }
        if (property.getName().equals(TXTDESC)) {
            return;
        }
        String repeatMode = "";
        if (name.equals(REPEAT_MODE)) {
            this.adjustByRepeatMode();
            repeatMode = (String)this.getModel().getValue(name);
        } else if (name.equals(COMBDORW)) {
            this.adjustByDayOrWeek();
        }
        boolean isMonth = false;
        for (String propMonth : CKMONTH) {
            if (!name.equals(propMonth)) continue;
            isMonth = true;
            break;
        }
        if (isMonth) {
            boolean changeMonth = false;
            for (String month : CKMONTH) {
                boolean isChangeMonth = Boolean.parseBoolean(this.getModel().getValue(month).toString());
                if (!isChangeMonth) continue;
                changeMonth = isChangeMonth;
                break;
            }
            this.getView().setVisible(Boolean.valueOf(changeMonth), new String[]{COMNOBY_MONTH});
            this.getView().setVisible(Boolean.valueOf(changeMonth), new String[]{COM_WEEKBY_MONTH});
        }
        if (repeatMode.equals(DEFINE)) {
            this.setModelValue(TXTDESC, this.genDefDesc(repeatMode, 10));
        } else {
            this.setModelValue(TXTDESC, this.genDesc(true, 10));
        }
    }

    public void afterCreateNewData(EventObject eventObject) {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status == OperationStatus.ADDNEW) {
            Calendar instance = Calendar.getInstance();
            this.getView().getModel().setValue(STARTTIME, (Object)instance.getTime());
            this.getView().getModel().setValue("createtime", (Object)instance.getTime());
            instance.set(2099, 11, 31, 23, 59, 59);
            this.getView().getModel().setValue(ENDTIME, (Object)instance.getTime());
            this.getModel().setValue(TXTDESC, (Object)this.genDesc(true, 10));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult == null) {
            return;
        }
        if (operationResult.isSuccess() && afterDoOperationEventArgs.getObjectId().equals("save")) {
            String repeatMode = (String)this.getModel().getValue(REPEAT_MODE);
            if (DEFINE.equals(repeatMode)) {
                this.setModelValue(TXTDESC, this.genDefDesc(repeatMode, 10));
            } else {
                this.setModelValue(TXTDESC, this.genDesc(false, 10));
            }
        }
    }

    private boolean checkData() {
        String blankField = this.checkBlank();
        if (StringUtils.isNotEmpty((CharSequence)blankField)) {
            this.getView().showErrorNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c%s\u201d\u3002", (String)"CopyFromSavePlugin_4", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]), blankField));
            return false;
        }
        Date startTime = (Date)this.getView().getModel().getValue(STARTTIME);
        Date endTime = (Date)this.getView().getModel().getValue(ENDTIME);
        String repeatmode = (String)this.getView().getModel().getValue(REPEAT_MODE);
        if (startTime != null && endTime != null && startTime.after(endTime)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u6548\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u5931\u6548\u65f6\u95f4\u3002", (String)"CopyFromSavePlugin_5", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
            return false;
        }
        String plan = this.getModel().getValue("plan").toString();
        try {
            if (DEFINE.equalsIgnoreCase(repeatmode)) {
                return this.checkCron(plan);
            }
            if (!StringUtils.equals((CharSequence)NOREPEAT, (CharSequence)repeatmode) && StringUtils.isNotBlank((CharSequence)plan)) {
                parser.parse(plan);
            }
        }
        catch (Throwable throwable) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u65f6\u95f4\u8bbe\u7f6e\u9519\u8bef\u3002", (String)"CopyFromSavePlugin_6", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
            log.error("Schedule***save schedule error", throwable);
            return false;
        }
        return true;
    }

    private String checkBlank() {
        DynamicObject obj = this.getView().getModel().getDataEntity();
        BasedataEntityType dataEntityType = (BasedataEntityType)this.getModel().getDataEntityType();
        if (StringUtils.isBlank((CharSequence)obj.getString(NUMBER))) {
            return this.appendBlankField(dataEntityType, NUMBER);
        }
        if (StringUtils.isBlank((CharSequence)obj.getString(NAME))) {
            return this.appendBlankField(dataEntityType, NAME);
        }
        if (StringUtils.isBlank((CharSequence)obj.getString(STARTTIME))) {
            return this.appendBlankField(dataEntityType, STARTTIME);
        }
        if (StringUtils.isBlank((CharSequence)obj.getString(ENDTIME))) {
            return this.appendBlankField(dataEntityType, ENDTIME);
        }
        if (StringUtils.isBlank((CharSequence)obj.getString(CYCLE_NUM)) || 0 == obj.getInt(CYCLE_NUM)) {
            return this.appendBlankField(dataEntityType, CYCLE_NUM);
        }
        return "";
    }

    private String appendBlankField(BasedataEntityType entityType, String fieldKey) {
        IDataEntityProperty property = entityType.findProperty(fieldKey);
        if (property != null) {
            return property.getDisplayName() != null ? property.getDisplayName().getLocaleValue() : fieldKey;
        }
        return fieldKey;
    }

    private Calendar getStartTime() {
        Date startTime = (Date)this.getView().getModel().getValue(STARTTIME);
        Calendar crStartTime = Calendar.getInstance();
        if (startTime != null) {
            crStartTime.setTimeInMillis(startTime.getTime());
        } else {
            this.getView().getModel().setValue(STARTTIME, (Object)crStartTime.getTime());
        }
        return crStartTime;
    }

    private String genDefDesc(String repeatMode, int genDescTimeNum) {
        String cron = (String)this.getModel().getValue("plan");
        Calendar crStartTime = this.getStartTime();
        StringBuilder descBuilder = new StringBuilder();
        String startTime = new SimpleDateFormat(DATE_TIME_FORMAT).format(crStartTime.getTime());
        String beginStr = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e8b\u4ef6\u5c06\u4e8e%s\u8d77\u5f00\u59cb\u3002", (String)"CopyFromSavePlugin_82", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]), startTime, "");
        descBuilder.append(beginStr).append('\uff0c');
        if (StringUtils.isBlank((CharSequence)cron) && DEFINE.equals(repeatMode)) {
            return descBuilder.toString();
        }
        if ("plan".equals(repeatMode) && !this.checkCron(cron)) {
            return "";
        }
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        Date endTime = dynamicObject.getDate(ENDTIME);
        try {
            descBuilder.append(ScheduleServiceHelper.genPlanDesc((String)cron, (Date)crStartTime.getTime(), (Date)endTime, (int)genDescTimeNum));
        }
        catch (KDException exception) {
            this.getView().showErrorNotification(exception.getErrorCode().getMessage());
        }
        return descBuilder.toString();
    }

    private boolean checkCron(String cron) {
        try {
            long leadTime;
            parser.parse(cron);
            CronTriggerImpl cronTriggerImpl = new CronTriggerImpl();
            cronTriggerImpl.setCronExpression(cron);
            List dates = TriggerUtils.computeFireTimes((OperableTrigger)cronTriggerImpl, null, (int)2);
            if (dates.size() > 1 && (leadTime = Math.abs(((Date)dates.get(1)).getTime() - ((Date)dates.get(0)).getTime())) < 60000L) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\"cron\u8868\u8fbe\u5f0f\"\u7684\u5468\u671f\u8bbe\u7f6e\u6709\u8bef\uff0c\u53ea\u652f\u6301\u5206\u949f\u7ea7\u522b\u7684\u5468\u671f\u3002", (String)"CopyFromSavePlugin_94", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
                return false;
            }
        }
        catch (Exception exception) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\"cron\u8868\u8fbe\u5f0f\"\u8bbe\u7f6e\u9519\u8bef\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CopyFromSavePlugin_93", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private String genDesc(boolean isCallByPropertyChanged, int genDescTimeNum) {
        Object cyclenumObj = this.getView().getModel().getValue(CYCLE_NUM);
        if (StringUtils.isBlank((Object)cyclenumObj) || Long.parseLong(cyclenumObj.toString()) == 0L) {
            return "";
        }
        CronStruct cron = new CronStruct();
        Calendar crStartTime = this.getStartTime();
        cron.setSeconds("0");
        cron.setMinutes(String.valueOf(crStartTime.get(12)));
        cron.setHours(String.valueOf(crStartTime.get(11)));
        cron.setDayOfMonth(String.valueOf(crStartTime.get(5)));
        cron.setMonth(String.valueOf(crStartTime.get(2) + 1));
        cron.setDayOfWeek("?");
        cron.setYear(String.valueOf(crStartTime.get(1)));
        String repeatMode = (String)this.getView().getModel().getValue(REPEAT_MODE);
        int cyclenum = (Integer)this.getView().getModel().getValue(CYCLE_NUM);
        String startTime = new SimpleDateFormat(DATE_TIME_FORMAT).format(crStartTime.getTime());
        String beginStr = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e8b\u4ef6\u5c06\u4e8e%s\u8d77\u5f00\u59cb\u3002", (String)"CopyFromSavePlugin_82", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]), startTime);
        cron.getDescBuf().append(beginStr).append('\uff0c');
        switch (repeatMode) {
            case "n": {
                cron.getDescBuf().setLength(0);
                crStartTime.set(13, 0);
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u4e8b\u4ef6\u4e8e", (String)"CopyFromSavePlugin_125", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0])).append(new SimpleDateFormat(DATE_TIME_FORMAT).format(crStartTime.getTime())).append(ResManager.loadKDString((String)"\u6267\u884c\u4e00\u6b21\u3002", (String)"CopyFromSavePlugin_126", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
                break;
            }
            case "mi": {
                cron = this.repeatByHour(cron, repeatMode);
                if (cyclenum > 1) {
                    if (cyclenum > 59) {
                        cyclenum = 59;
                        this.setModelValue(CYCLE_NUM, 59);
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5468\u671f\u4e3a\u5206\u949f\uff0c\u6700\u591a\u6bcf59\u5206\u949f\u91cd\u590d\u4e00\u6b21\u3002", (String)"CopyFromSavePlugin_134", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
                    }
                    cron.setMinutes("0/" + cyclenum);
                } else {
                    if (cyclenum < 0) {
                        cyclenum = 1;
                        this.setModelValue(CYCLE_NUM, cyclenum);
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u91cd\u590d\u5468\u671f\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"CopyFromSavePlugin_135", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
                    }
                    cron.setMinutes("*");
                }
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf", (String)SAVE_PLUGIN_13, (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0])).append(cyclenum).append(ResManager.loadKDString((String)"\u5206\u949f\u91cd\u590d\u3002", (String)"CopyFromSavePlugin_14", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
                cron.setDayOfMonth("*");
                cron.setMonth("*");
                cron.setDayOfWeek("?");
                cron.setYear(null);
                break;
            }
            case "h": {
                if (cyclenum > 1) {
                    if (cyclenum > 23) {
                        cyclenum = 23;
                        this.getModel().setValue(CYCLE_NUM, (Object)23);
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5468\u671f\u4e3a\u5c0f\u65f6\uff0c\u6700\u591a\u6bcf24\u5c0f\u65f6\u91cd\u590d\u4e00\u6b21\u3002", (String)"CopyFromSavePlugin_16", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
                    }
                    cron.setHours("0/" + cyclenum);
                } else {
                    if (cyclenum < 0) {
                        cyclenum = 1;
                        this.setModelValue(CYCLE_NUM, cyclenum);
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u91cd\u590d\u5468\u671f\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"CopyFromSavePlugin_135", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
                    }
                    cron.setHours("*");
                }
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf", (String)SAVE_PLUGIN_13, (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0])).append(cyclenum).append(ResManager.loadKDString((String)"\u5c0f\u65f6\u91cd\u590d\u3002", (String)"CopyFromSavePlugin_15", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
                cron.setDayOfMonth("*");
                cron.setMonth("*");
                cron.setDayOfWeek("?");
                cron.setYear(null);
                break;
            }
            case "d": {
                if (cyclenum > 1) {
                    if (cyclenum > 31) {
                        cyclenum = 31;
                        this.getModel().setValue(CYCLE_NUM, (Object)31);
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5468\u671f\u4e3a\u5929\uff0c\u6bcf31\u5929\u91cd\u590d\u4e00\u6b21\u3002", (String)"CopyFromSavePlugin_99", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
                    }
                    cron.setDayOfMonth("*/" + cyclenum);
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf\u67081\u65e5\u5f00\u59cb", (String)"CopyFromSavePlugin_88", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
                } else {
                    if (cyclenum < 0) {
                        cyclenum = 1;
                        this.setModelValue(CYCLE_NUM, cyclenum);
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u91cd\u590d\u5468\u671f\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"CopyFromSavePlugin_135", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
                    }
                    cron.setDayOfMonth("*");
                }
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf", (String)SAVE_PLUGIN_13, (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0])).append(cyclenum).append(ResManager.loadKDString((String)"\u5929", (String)"CopyFromSavePlugin_115", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
                cron = this.repeatByHour(cron, repeatMode);
                cron.setMonth("*");
                cron.setDayOfWeek("?");
                cron.setYear(null);
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u91cd\u590d\u3002", (String)SAVE_PLUGIN_19, (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
                break;
            }
            case "w": {
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf", (String)SAVE_PLUGIN_13, (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0])).append(cyclenum).append(ResManager.loadKDString((String)"\u5468", (String)"CopyFromSavePlugin_18", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
                cron.setDayOfMonth("*");
                cron.setMonth("*");
                cron.setYear(null);
                cron = this.repeatByWeek(cron);
                cron = this.repeatByHour(cron, repeatMode);
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u91cd\u590d\u3002", (String)SAVE_PLUGIN_19, (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
                break;
            }
            case "m": {
                if (cyclenum > 1) {
                    if (cyclenum > 12) {
                        cyclenum = 12;
                        this.getModel().setValue(CYCLE_NUM, (Object)12);
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5468\u671f\u4e3a\u6708\uff0c\u6700\u591a\u6bcf12\u6708\u91cd\u590d\u4e00\u6b21\u3002", (String)"CopyFromSavePlugin_100", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
                    }
                    cron.setMonth("*/" + cyclenum);
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u4ece\u6bcf\u5e741\u6708\u5f00\u59cb", (String)"CopyFromSavePlugin_91", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
                } else {
                    if (cyclenum < 0) {
                        cyclenum = 1;
                        this.setModelValue(CYCLE_NUM, cyclenum);
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u91cd\u590d\u5468\u671f\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"CopyFromSavePlugin_135", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
                    }
                    cron.setMonth("*");
                }
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf", (String)SAVE_PLUGIN_13, (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0])).append(cyclenum).append(ResManager.loadKDString((String)"\u6708", (String)"CopyFromSavePlugin_20", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
                cron.setYear(null);
                cron = this.repeatByMonthDay(cron, repeatMode);
                cron = this.repeatByHour(cron, repeatMode);
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u91cd\u590d\u3002", (String)SAVE_PLUGIN_19, (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
                break;
            }
            case "y": {
                if (cyclenum > 1 || cyclenum < 0) {
                    cyclenum = 1;
                    this.setModelValue(CYCLE_NUM, 1);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u53ea\u652f\u6301\u5468\u671f\u4e3a\u6bcf\u5e74", (String)"CopyFromSavePlugin_87", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
                }
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u6bcf", (String)SAVE_PLUGIN_13, (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0])).append(cyclenum).append(ResManager.loadKDString((String)"\u5e74", (String)"CopyFromSavePlugin_21", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
                cron.setYear(null);
                cron = this.repeatByMonthly(cron, isCallByPropertyChanged);
                cron = this.repeatByMonthDay(cron, repeatMode);
                cron = this.repeatByHour(cron, repeatMode);
                cron.getDescBuf().append(ResManager.loadKDString((String)"\u91cd\u590d\u3002", (String)SAVE_PLUGIN_19, (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
            }
        }
        String cronStr = "";
        if (DEFINE.equals(repeatMode)) {
            cronStr = (String)this.getModel().getValue("plan");
            this.checkCron(cronStr);
        } else {
            cronStr = cron.toString();
            try {
                parser.parse(cronStr);
            }
            catch (Throwable throwable) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u65f6\u95f4\u8bbe\u7f6e\u9519\u8bef\u3002", (String)"CopyFromSavePlugin_6", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
                log.error("Schedule***save schedule error", throwable);
            }
        }
        if (isCallByPropertyChanged) {
            this.setModelValue("plan", cronStr);
        }
        if (!NOREPEAT.equals(repeatMode)) {
            if (!isCallByPropertyChanged) {
                cronStr = String.valueOf(this.getModel().getValue("plan"));
            }
            DynamicObject dynamicObject = this.getModel().getDataEntity();
            Date endTime = dynamicObject.getDate(ENDTIME);
            try {
                cron.getDescBuf().append(ScheduleServiceHelper.genPlanDesc((String)cronStr, (Date)crStartTime.getTime(), (Date)endTime, (int)genDescTimeNum));
            }
            catch (KDException exception) {
                this.getView().showErrorNotification(exception.getErrorCode().getMessage());
            }
        }
        return cron.getDescBuf().toString();
    }

    private CronStruct repeatByHour(CronStruct cron, String repeatMode) {
        String hourCron;
        String[] crons;
        String plan;
        IDataModel dataModel = this.getView().getModel();
        StringBuilder cronExp = new StringBuilder();
        StringBuilder cronDesc = new StringBuilder();
        Stream.iterate(0, vx -> {
            vx = vx + 1;
            return vx;
        }).limit(24L).forEachOrdered(vh -> {
            String hour = vh < 10 ? CKHOUR_0 + vh : CKHOUR + vh;
            boolean checked = (Boolean)dataModel.getValue(hour);
            if (checked) {
                cronExp.append(vh).append(',');
                cronDesc.append(vh).append(ResManager.loadKDString((String)"\u65f6", (String)"CopyFromSavePlugin_92", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0])).append(',');
            }
        });
        if (this.getPageCache().get(LOAD_DATA) != null && StringUtils.isNotBlank((CharSequence)(plan = (String)this.getModel().getValue("plan"))) && (crons = plan.trim().split(" +")).length >= 6 && StringUtils.isNotEmpty((CharSequence)(hourCron = crons[2])) && !HOUR.equalsIgnoreCase(repeatMode) && !"*".equals(hourCron)) {
            String[] hours = hourCron.split(",");
            Arrays.stream(hours).forEach(vx -> {
                this.getModel().beginInit();
                String hour = Integer.parseInt(vx) < 10 ? CKHOUR_0 + vx : CKHOUR + vx;
                this.getModel().setValue(hour, (Object)"1");
                this.getModel().endInit();
                this.getView().updateView(hour);
            });
        }
        String cronExpStr = cronExp.toString();
        String cronDescStr = cronDesc.toString();
        if (cronExpStr.length() > 0) {
            cronExpStr = cronExpStr.substring(0, cronExpStr.length() - 1);
        } else {
            String string = cronExpStr = MINUTE.equals(repeatMode) ? "*" : cron.getHours();
        }
        if (cronDescStr.length() > 0) {
            cron.getDescBuf().append(cronDescStr.substring(0, cronDescStr.length() - 1));
        } else if (!StringUtils.equals((CharSequence)"*", (CharSequence)cronExpStr)) {
            cron = this.repeatByStartTimeHours(cron, cronExpStr);
        }
        cron.setHours(cronExpStr);
        return cron;
    }

    private CronStruct repeatByStartTimeHours(CronStruct cron, String hoursStr) {
        String[] hours = hoursStr.split(",");
        cron.getDescBuf().append(hours[0]).append(ResManager.loadKDString((String)"\u65f6", (String)"CopyFromSavePlugin_92", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
        return cron;
    }

    private CronStruct repeatByWeek(CronStruct cron) {
        IDataModel dataModel = this.getView().getModel();
        String conStr = ResManager.loadKDString((String)"\u7684", (String)SAVE_PLUGIN_22, (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]);
        String weekDays = "";
        if (((Boolean)dataModel.getValue("cksun")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u661f\u671f\u65e5", (String)"CopyFromSavePlugin_23", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
            conStr = ",";
            weekDays = "1,";
        }
        if (((Boolean)dataModel.getValue("ckmon")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u661f\u671f\u4e00", (String)"CopyFromSavePlugin_24", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
            conStr = ",";
            weekDays = weekDays + "2,";
        }
        if (((Boolean)dataModel.getValue("cktues")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u661f\u671f\u4e8c", (String)"CopyFromSavePlugin_25", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
            conStr = ",";
            weekDays = weekDays + "3,";
        }
        if (((Boolean)dataModel.getValue("ckwed")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u661f\u671f\u4e09", (String)"CopyFromSavePlugin_26", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
            conStr = ",";
            weekDays = weekDays + "4,";
        }
        if (((Boolean)dataModel.getValue("ckthur")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u661f\u671f\u56db", (String)"CopyFromSavePlugin_27", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
            conStr = ",";
            weekDays = weekDays + "5,";
        }
        if (((Boolean)dataModel.getValue("ckfri")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u661f\u671f\u4e94", (String)"CopyFromSavePlugin_28", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
            conStr = ",";
            weekDays = weekDays + "6,";
        }
        if (((Boolean)dataModel.getValue("cksat")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u661f\u671f\u516d", (String)"CopyFromSavePlugin_29", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
            weekDays = weekDays + "7,";
        }
        if (weekDays.length() == 0) {
            weekDays = StringUtils.isEmpty((CharSequence)cron.getDayOfWeek()) ? String.valueOf(this.getStartTime().get(7)) : cron.getDayOfWeek();
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u6bcf\u4e00\u5929", (String)"CopyFromSavePlugin_124", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
        } else {
            weekDays = weekDays.substring(0, weekDays.length() - 1);
        }
        if (!"?".equals(weekDays)) {
            cron.setDayOfMonth("?");
        }
        cron.setDayOfWeek(weekDays);
        return cron;
    }

    private CronStruct repeatByMonthDay(CronStruct cron, String repeatMode) {
        IDataModel dataModel = this.getView().getModel();
        String byDayOrWeek = (String)dataModel.getValue(COMBDORW);
        if (WEEK.equals(byDayOrWeek)) {
            cron = this.repeatByNoWeek(cron);
        } else {
            String conStr = ResManager.loadKDString((String)"\u7684", (String)SAVE_PLUGIN_22, (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]);
            Map<String, SchConfigCkBean> keyTips = this.initCkTipMap();
            String days = "";
            if (!StringUtils.equals((CharSequence)repeatMode, (CharSequence)YEAR)) {
                StringBuilder sbDays = new StringBuilder();
                if (((Boolean)dataModel.getValue("cklastday")).booleanValue()) {
                    cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u6700\u540e\u4e00\u65e5", (String)"CopyFromSavePlugin_81", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
                    sbDays.append("L,");
                } else {
                    for (Map.Entry<String, SchConfigCkBean> entry : keyTips.entrySet()) {
                        String key = entry.getKey();
                        SchConfigCkBean bean = entry.getValue();
                        if (!((Boolean)dataModel.getValue(key)).booleanValue()) continue;
                        cron.getDescBuf().append(conStr).append(bean.getTip());
                        conStr = ",";
                        sbDays.append(bean.getDays());
                    }
                }
                days = sbDays.toString();
            }
            if (days.length() == 0) {
                days = StringUtils.isEmpty((CharSequence)cron.getDayOfMonth()) ? String.valueOf(this.getStartTime().get(5)) : cron.getDayOfMonth();
                cron = this.repeatByStartTimeDayOfMonth(cron, days);
            } else {
                days = days.substring(0, days.length() - 1);
            }
            cron.setDayOfMonth(days);
            if (!"?".equals(days)) {
                cron.setDayOfWeek("?");
            }
        }
        return cron;
    }

    private Map<String, SchConfigCkBean> initCkTipMap() {
        LinkedHashMap<String, SchConfigCkBean> keyTips = new LinkedHashMap<String, SchConfigCkBean>(48);
        keyTips.put("ckone", new SchConfigCkBean(ResManager.loadKDString((String)"1\u65e5", (String)"CopyFromSavePlugin_30", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]), "1,"));
        keyTips.put("cktwo", new SchConfigCkBean(ResManager.loadKDString((String)"2\u65e5", (String)"CopyFromSavePlugin_31", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]), "2,"));
        keyTips.put("ckthree", new SchConfigCkBean(ResManager.loadKDString((String)"3\u65e5", (String)"CopyFromSavePlugin_32", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]), "3,"));
        keyTips.put("ckfour", new SchConfigCkBean(ResManager.loadKDString((String)"4\u65e5", (String)"CopyFromSavePlugin_33", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]), "4,"));
        keyTips.put("ckfive", new SchConfigCkBean(ResManager.loadKDString((String)"5\u65e5", (String)"CopyFromSavePlugin_34", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]), "5,"));
        keyTips.put("cksix", new SchConfigCkBean(ResManager.loadKDString((String)"6\u65e5", (String)"CopyFromSavePlugin_35", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]), "6,"));
        keyTips.put("ckseven", new SchConfigCkBean(ResManager.loadKDString((String)"7\u65e5", (String)"CopyFromSavePlugin_36", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]), "7,"));
        keyTips.put("ckeight", new SchConfigCkBean(ResManager.loadKDString((String)"8\u65e5", (String)"CopyFromSavePlugin_37", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]), "8,"));
        keyTips.put("cknine", new SchConfigCkBean(ResManager.loadKDString((String)"9\u65e5", (String)"CopyFromSavePlugin_38", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]), "9,"));
        keyTips.put("ckten", new SchConfigCkBean(ResManager.loadKDString((String)"10\u65e5", (String)"CopyFromSavePlugin_39", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]), "10,"));
        keyTips.put("ckeleven", new SchConfigCkBean(ResManager.loadKDString((String)"11\u65e5", (String)"CopyFromSavePlugin_40", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]), "11,"));
        keyTips.put("cktwelve", new SchConfigCkBean(ResManager.loadKDString((String)"12\u65e5", (String)"CopyFromSavePlugin_41", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]), "12,"));
        keyTips.put("ckthirteen", new SchConfigCkBean(ResManager.loadKDString((String)"13\u65e5", (String)"CopyFromSavePlugin_42", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]), "13,"));
        keyTips.put("ckfourteen", new SchConfigCkBean(ResManager.loadKDString((String)"14\u65e5", (String)"CopyFromSavePlugin_43", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]), "14,"));
        keyTips.put("ckfifteen", new SchConfigCkBean(ResManager.loadKDString((String)"15\u65e5", (String)"CopyFromSavePlugin_44", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]), "15,"));
        keyTips.put("cksixteen", new SchConfigCkBean(ResManager.loadKDString((String)"16\u65e5", (String)"CopyFromSavePlugin_45", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]), "16,"));
        keyTips.put("ckseventeen", new SchConfigCkBean(ResManager.loadKDString((String)"17\u65e5", (String)"CopyFromSavePlugin_46", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]), "17,"));
        keyTips.put("ckeighteen", new SchConfigCkBean(ResManager.loadKDString((String)"18\u65e5", (String)"CopyFromSavePlugin_47", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]), "18,"));
        keyTips.put("cknineteen", new SchConfigCkBean(ResManager.loadKDString((String)"19\u65e5", (String)"CopyFromSavePlugin_48", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]), "19,"));
        keyTips.put("cktwenty", new SchConfigCkBean(ResManager.loadKDString((String)"20\u65e5", (String)"CopyFromSavePlugin_49", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]), "20,"));
        keyTips.put("cktwentyone", new SchConfigCkBean(ResManager.loadKDString((String)"21\u65e5", (String)"CopyFromSavePlugin_50", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]), "21,"));
        keyTips.put("cktwentytwo", new SchConfigCkBean(ResManager.loadKDString((String)"22\u65e5", (String)"CopyFromSavePlugin_51", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]), "22,"));
        keyTips.put("cktwentythree", new SchConfigCkBean(ResManager.loadKDString((String)"23\u65e5", (String)"CopyFromSavePlugin_52", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]), "23,"));
        keyTips.put("cktwentyfour", new SchConfigCkBean(ResManager.loadKDString((String)"24\u65e5", (String)"CopyFromSavePlugin_53", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]), "24,"));
        keyTips.put("cktwentyfive", new SchConfigCkBean(ResManager.loadKDString((String)"25\u65e5", (String)"CopyFromSavePlugin_54", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]), "25,"));
        keyTips.put("cktwentysix", new SchConfigCkBean(ResManager.loadKDString((String)"26\u65e5", (String)"CopyFromSavePlugin_55", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]), "26,"));
        keyTips.put("cktwentyseven", new SchConfigCkBean(ResManager.loadKDString((String)"27\u65e5", (String)"CopyFromSavePlugin_56", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]), "27,"));
        keyTips.put("cktwentyeight", new SchConfigCkBean(ResManager.loadKDString((String)"28\u65e5", (String)"CopyFromSavePlugin_57", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]), "28,"));
        keyTips.put("cktwentynine", new SchConfigCkBean(ResManager.loadKDString((String)"29\u65e5", (String)"CopyFromSavePlugin_58", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]), "29,"));
        keyTips.put("ckthirty", new SchConfigCkBean(ResManager.loadKDString((String)"30\u65e5", (String)"CopyFromSavePlugin_59", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]), "30,"));
        keyTips.put("ckthirtyone", new SchConfigCkBean(ResManager.loadKDString((String)"31\u65e5", (String)"CopyFromSavePlugin_60", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]), "31,"));
        return keyTips;
    }

    private CronStruct repeatByNoWeek(CronStruct cron) {
        IDataModel dataModel = this.getView().getModel();
        String no = (String)dataModel.getValue(COMNO);
        String noWeek = (String)dataModel.getValue(COM_WEEK);
        if (StringUtils.isNotBlank((CharSequence)no) && StringUtils.isNotBlank((CharSequence)noWeek)) {
            switch (no) {
                case "1": {
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u7b2c\u4e00\u4e2a", (String)"CopyFromSavePlugin_61", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
                    break;
                }
                case "2": {
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u7b2c\u4e8c\u4e2a", (String)"CopyFromSavePlugin_62", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
                    break;
                }
                case "3": {
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u7b2c\u4e09\u4e2a", (String)"CopyFromSavePlugin_63", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
                    break;
                }
                case "4": {
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u7b2c\u56db\u4e2a", (String)"CopyFromSavePlugin_64", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
                    break;
                }
                case "5": {
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u7b2c\u4e94\u4e2a", (String)"CopyFromSavePlugin_65", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
                    break;
                }
                case "L": {
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u6700\u540e\u4e00\u4e2a", (String)"CopyFromSavePlugin_66", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
                }
            }
            switch (noWeek) {
                case "1": {
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u661f\u671f\u65e5", (String)"CopyFromSavePlugin_23", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
                    break;
                }
                case "2": {
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u661f\u671f\u4e00", (String)"CopyFromSavePlugin_24", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
                    break;
                }
                case "3": {
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u661f\u671f\u4e8c", (String)"CopyFromSavePlugin_25", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
                    break;
                }
                case "4": {
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u661f\u671f\u4e09", (String)"CopyFromSavePlugin_26", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
                    break;
                }
                case "5": {
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u661f\u671f\u56db", (String)"CopyFromSavePlugin_27", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
                    break;
                }
                case "6": {
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u661f\u671f\u4e94", (String)"CopyFromSavePlugin_28", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
                    break;
                }
                case "7": {
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u661f\u671f\u516d", (String)"CopyFromSavePlugin_29", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
                    break;
                }
                case "8": {
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u81ea\u7136\u65e5", (String)"CopyFromSavePlugin_67", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
                    break;
                }
                case "9": {
                    cron.getDescBuf().append(ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5", (String)"CopyFromSavePlugin_68", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
                }
            }
            if (noWeek.compareTo("1") >= 0 && noWeek.compareTo("8") < 0) {
                if (no.compareTo("1") >= 0 && no.compareTo("5") <= 0) {
                    cron.setDayOfWeek(noWeek + "#" + no);
                } else if (no.compareTo("L") == 0) {
                    cron.setDayOfWeek(noWeek + "L");
                }
                cron.setDayOfMonth("?");
            } else if (noWeek.equals("8")) {
                if (no.compareTo("1") >= 0 && no.compareTo("5") <= 0) {
                    cron.setDayOfMonth(no);
                } else if (no.compareTo("L") == 0) {
                    cron.setDayOfMonth("1L");
                }
                cron.setDayOfWeek("?");
            } else if (noWeek.equals("9")) {
                if (no.compareTo("1") >= 0 && no.compareTo("5") <= 0) {
                    String workday = String.valueOf(Integer.parseInt(no) + 1);
                    cron.setDayOfWeek(workday + "#" + no);
                } else if (no.compareTo("L") == 0) {
                    cron.setDayOfWeek("6L");
                }
                cron.setDayOfMonth("?");
            }
        } else {
            String days = "";
            days = StringUtils.isEmpty((CharSequence)cron.getDayOfMonth()) ? String.valueOf(this.getStartTime().get(5)) : cron.getDayOfMonth();
            cron = this.repeatByStartTimeDayOfMonth(cron, days);
        }
        return cron;
    }

    private CronStruct repeatByMonthly(CronStruct cron, boolean isCallByProperyChanged) {
        IDataModel dataModel = this.getView().getModel();
        String conStr = ResManager.loadKDString((String)"\u7684", (String)SAVE_PLUGIN_22, (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]);
        String months = "";
        if (((Boolean)dataModel.getValue("ckjan")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u4e00\u6708", (String)"CopyFromSavePlugin_69", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
            conStr = ",";
            months = months + "1,";
        }
        if (((Boolean)dataModel.getValue("ckfeb")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u4e8c\u6708", (String)"CopyFromSavePlugin_70", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
            conStr = ",";
            months = months + "2,";
        }
        if (((Boolean)dataModel.getValue("ckmar")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u4e09\u6708", (String)"CopyFromSavePlugin_71", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
            conStr = ",";
            months = months + "3,";
        }
        if (((Boolean)dataModel.getValue("ckapr")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u56db\u6708", (String)"CopyFromSavePlugin_72", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
            conStr = ",";
            months = months + "4,";
        }
        if (((Boolean)dataModel.getValue("ckmay")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u4e94\u6708", (String)"CopyFromSavePlugin_73", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
            conStr = ",";
            months = months + "5,";
        }
        if (((Boolean)dataModel.getValue("ckjun")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u516d\u6708", (String)"CopyFromSavePlugin_74", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
            conStr = ",";
            months = months + "6,";
        }
        if (((Boolean)dataModel.getValue("ckjul")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u4e03\u6708", (String)"CopyFromSavePlugin_75", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
            conStr = ",";
            months = months + "7,";
        }
        if (((Boolean)dataModel.getValue("ckaug")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u516b\u6708", (String)"CopyFromSavePlugin_76", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
            conStr = ",";
            months = months + "8,";
        }
        if (((Boolean)dataModel.getValue("cksep")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u4e5d\u6708", (String)"CopyFromSavePlugin_77", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
            conStr = ",";
            months = months + "9,";
        }
        if (((Boolean)dataModel.getValue("ckoct")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u5341\u6708", (String)"CopyFromSavePlugin_78", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
            conStr = ",";
            months = months + "10,";
        }
        if (((Boolean)dataModel.getValue("cknov")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u5341\u4e00\u6708", (String)"CopyFromSavePlugin_79", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
            conStr = ",";
            months = months + "11,";
        }
        if (((Boolean)dataModel.getValue("ckdec")).booleanValue()) {
            cron.getDescBuf().append(conStr).append(ResManager.loadKDString((String)"\u5341\u4e8c\u6708", (String)"CopyFromSavePlugin_80", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
            conStr = ",";
            months = months + "12,";
        }
        if (months.length() == 0) {
            months = StringUtils.isEmpty((CharSequence)cron.getMonth()) ? String.valueOf(this.getStartTime().get(2) + 1) : cron.getMonth();
            cron = this.repeatByStartTimeMonth(cron, months);
        } else {
            months = months.substring(0, months.length() - 1);
        }
        cron.setMonth(months);
        if (((Boolean)dataModel.getValue(CKBY_WEEK)).booleanValue()) {
            cron = this.repeatByNoWeek(cron);
        } else if (isCallByProperyChanged) {
            String days = "";
            days = StringUtils.isEmpty((CharSequence)cron.getDayOfMonth()) ? String.valueOf(this.getStartTime().get(5)) : cron.getDayOfMonth();
            cron = this.repeatByStartTimeDayOfMonth(cron, days);
        }
        return cron;
    }

    private CronStruct repeatByStartTimeMonth(CronStruct cron, String monthsStr) {
        String[] months = monthsStr.split(",");
        cron.getDescBuf().append(ResManager.loadKDString((String)"\u7684", (String)SAVE_PLUGIN_22, (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0])).append(months[0]).append(ResManager.loadKDString((String)"\u6708", (String)"CopyFromSavePlugin_20", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
        return cron;
    }

    private CronStruct repeatByStartTimeDayOfMonth(CronStruct cron, String daysStr) {
        String[] days = daysStr.split(",");
        cron.getDescBuf().append(ResManager.loadKDString((String)"\u7684", (String)SAVE_PLUGIN_22, (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0])).append(days[0]).append(ResManager.loadKDString((String)"\u65e5", (String)"CopyFromSavePlugin_90", (String)SWC_HSBS_FORMPLUGIN, (Object[])new Object[0]));
        return cron;
    }

    private String getComnoOrWeekValue(String key) {
        String value = "";
        Object valueObj = this.getModel().getValue(key);
        if (valueObj != null) {
            value = String.valueOf(valueObj);
        }
        return value;
    }

    private void adjustByDayOrWeek() {
        String byDayOrWeek = (String)this.getModel().getValue(COMBDORW);
        DynamicObject planObj = this.getModel().getDataEntity();
        if (WEEK.equals(byDayOrWeek)) {
            for (String ckDay : CKDATE) {
                this.setModelValue(ckDay, "0");
            }
        } else {
            this.setModelValue("comnobyweek", "");
            this.setModelValue("comweekbyweek", "");
            planObj.set(COMNO, (Object)"");
            planObj.set(COM_WEEK, (Object)"");
        }
    }

    private void adjustByWeek() {
        boolean byWeek = (Boolean)this.getModel().getValue(CKBY_WEEK);
        this.getView().setVisible(Boolean.valueOf(byWeek), new String[]{FLEXPBY_WEEK});
    }

    private void adjustByRepeatMode() {
        String repeatMode = (String)this.getModel().getValue(REPEAT_MODE);
        if (repeatMode == null) {
            repeatMode = REPEAT_MODE;
        }
        IFormView formView = this.getView();
        formView.setVisible(Boolean.FALSE, new String[]{"flexpweek", "flexpworday", "flexpmonths", FLEXPDAYS, FLEXPBY_WEEK, FLEXP_HOUR, CYCLE_NUM});
        boolean enableEditPlan = false;
        FieldEdit txtCycleNum = (FieldEdit)formView.getControl(CYCLE_NUM);
        txtCycleNum.setEnable("", true, -1);
        if ("".equals(repeatMode)) {
            this.getModel().beginInit();
            this.getModel().setValue(REPEAT_MODE, (Object)DEFINE);
            this.getModel().endInit();
            this.getView().updateView(REPEAT_MODE);
        }
        Calendar startTime = this.getStartTime();
        DynamicObject planObj = this.getModel().getDataEntity();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        switch (repeatMode) {
            case "mi": {
                formView.setVisible(Boolean.TRUE, new String[]{FLEXP_HOUR, CYCLE_NUM});
                this.initHourValue(planObj, startTime, status);
                this.updateCycleNumRangeByRepeatMode(0, 59);
                break;
            }
            case "h": {
                formView.setVisible(Boolean.FALSE, new String[]{FLEXP_HOUR});
                formView.setVisible(Boolean.TRUE, new String[]{CYCLE_NUM});
                this.updateCycleNumRangeByRepeatMode(0, 23);
                break;
            }
            case "d": {
                formView.setVisible(Boolean.TRUE, new String[]{FLEXP_HOUR, CYCLE_NUM});
                this.initHourValue(planObj, startTime, status);
                this.updateCycleNumRangeByRepeatMode(0, 31);
                break;
            }
            case "w": {
                formView.setVisible(Boolean.TRUE, new String[]{"flexpweek", FLEXP_HOUR, CYCLE_NUM});
                this.getModel().setValue(CYCLE_NUM, (Object)1);
                txtCycleNum.setEnable("", false, -1);
                this.initHourValue(planObj, startTime, status);
                this.initWeekValue(planObj, startTime, status);
                this.updateCycleNumRangeByRepeatMode(0, 3);
                break;
            }
            case "m": {
                formView.setVisible(Boolean.TRUE, new String[]{"flexpworday", FLEXPDAYS, FLEXP_HOUR, CYCLE_NUM});
                this.adjustByDayOrWeek();
                this.initHourValue(planObj, startTime, status);
                this.initDayValue(planObj, startTime, status);
                this.updateCycleNumRangeByRepeatMode(0, 12);
                break;
            }
            case "y": {
                this.getModel().setValue(CYCLE_NUM, (Object)1);
                txtCycleNum.setEnable("", true, -1);
                formView.setVisible(Boolean.TRUE, new String[]{"flexpmonths", FLEXP_HOUR, CYCLE_NUM, COMNOBY_MONTH, COM_WEEKBY_MONTH});
                this.initMonthValue(planObj, startTime, status);
                this.updateCycleNumRangeByRepeatMode(0, 59);
                break;
            }
            case "n": {
                txtCycleNum.setEnable("", false, -1);
                break;
            }
            case "def": {
                enableEditPlan = true;
                txtCycleNum.setEnable("", false, -1);
                break;
            }
        }
        if (DEFINE.equals(repeatMode)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"plan"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"plan"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"plan"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"plan"});
        }
        this.getView().setEnable(Boolean.valueOf(enableEditPlan), new String[]{"plan"});
    }

    private void updateCycleNumRangeByRepeatMode(int min, int max) {
        HashMap<String, Integer> itemStyle = new HashMap<String, Integer>();
        itemStyle.put("max", max);
        itemStyle.put("min", min);
        HashMap<String, HashMap<String, Integer>> cycleNumStyle = new HashMap<String, HashMap<String, Integer>>();
        cycleNumStyle.put("item", itemStyle);
        this.getView().updateControlMetadata(CYCLE_NUM, cycleNumStyle);
    }

    private void adjustByCron() {
        String[] crons;
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        String repeatMode = (String)this.getModel().getValue(REPEAT_MODE);
        String cron = (String)this.getModel().getValue("plan");
        if (this.dealCopyPage() && StringUtils.isNotEmpty((CharSequence)cron) && (crons = cron.split(" ")).length >= 6) {
            String hourCron = crons[2];
            if (StringUtils.isNotEmpty((CharSequence)hourCron) && !HOUR.equalsIgnoreCase(repeatMode)) {
                List<String> hoursList = null;
                if (!StringUtils.equals((CharSequence)"*", (CharSequence)hourCron)) {
                    hoursList = Arrays.asList(hourCron.split(","));
                }
                for (int h = 0; h < 24; ++h) {
                    String hour = h < 10 ? CKHOUR_0 + h : CKHOUR + h;
                    this.getModel().beginInit();
                    if (hoursList != null && hoursList.contains(String.valueOf(h))) {
                        this.getModel().setValue(hour, (Object)"1");
                    } else {
                        this.getModel().setValue(hour, (Object)"0");
                    }
                    this.getModel().endInit();
                    this.getView().updateView(hour);
                }
            }
            this.adjustByCron(repeatMode, cron);
        }
    }

    private void adjustByCron(String repeatMode, String cron) {
        boolean parseResult = true;
        Map<CronFieldName, Object> cronFieldValues = Collections.emptyMap();
        try {
            cronFieldValues = this.parseCron(cron);
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
            parseResult = false;
        }
        if (parseResult) {
            switch (repeatMode) {
                case "m": {
                    this.adjustByMonthMode(cronFieldValues);
                    break;
                }
                case "w": {
                    this.adjustByWeekMode(cronFieldValues);
                    break;
                }
                case "y": {
                    this.adjustByYearMode(cronFieldValues);
                    break;
                }
            }
        } else {
            log.info("cron\u89e3\u6790\u5931\u8d25");
        }
    }

    private void adjustByWeekMode(Map<CronFieldName, Object> cronFieldValues) {
        for (Map.Entry<CronFieldName, Object> it : cronFieldValues.entrySet()) {
            if (it.getValue() == null || it.getKey() != CronFieldName.DAY_OF_WEEK) continue;
            Object[] filedValue = (Object[])it.getValue();
            List weeks = (List)filedValue[0];
            for (int week = 1; week <= 7; ++week) {
                if (weeks.contains(week)) {
                    this.setModelValue(CKWEEK[week - 1], 1);
                    continue;
                }
                this.setModelValue(CKWEEK[week - 1], 0);
            }
        }
    }

    private void adjustByYearMode(Map<CronFieldName, Object> cronFieldValues) {
        for (Map.Entry<CronFieldName, Object> it : cronFieldValues.entrySet()) {
            List days;
            if (it.getValue() == null) continue;
            if (it.getKey() == CronFieldName.DAY_OF_WEEK) {
                Object[] filedValue = (Object[])it.getValue();
                List weeks = (List)filedValue[0];
                for (Integer week : weeks) {
                    this.setModelValue(COM_WEEKBY_MONTH, week);
                    this.setModelValue(COM_WEEK, week);
                }
                if (!CollectionUtils.isEmpty((Collection)weeks) && filedValue[1] != null) {
                    this.setModelValue(CKBY_WEEK, Boolean.TRUE);
                }
                if (filedValue[1] == null) continue;
                int nth = (Integer)filedValue[1];
                if (nth == -1) {
                    this.setModelValue(COMNOBY_MONTH, "L");
                    this.setModelValue(COMNO, "L");
                    continue;
                }
                this.setModelValue(COMNOBY_MONTH, nth);
                this.setModelValue(COMNO, nth);
                continue;
            }
            if (it.getKey() == CronFieldName.MONTH) {
                List months = (List)it.getValue();
                if (!CollectionUtils.isEmpty((Collection)months)) {
                    this.setModelValue(CKBY_WEEK, Boolean.FALSE);
                }
                for (int month = 1; month <= 12; ++month) {
                    if (months.contains(month)) {
                        this.setModelValue(CKMONTH[month - 1], 1);
                        continue;
                    }
                    this.setModelValue(CKMONTH[month - 1], 0);
                }
                continue;
            }
            if (it.getKey() != CronFieldName.DAY_OF_MONTH || CollectionUtils.isEmpty((Collection)(days = (List)it.getValue()))) continue;
            for (int day = 1; day <= 31; ++day) {
                if (days.contains(day)) {
                    this.setModelValue(CKDATE[day - 1], 1);
                    continue;
                }
                this.setModelValue(CKDATE[day - 1], 0);
            }
        }
    }

    private void adjustByMonthMode(Map<CronFieldName, Object> cronFieldValues) {
        for (Map.Entry<CronFieldName, Object> it : cronFieldValues.entrySet()) {
            if (it.getValue() == null) continue;
            if (it.getKey() == CronFieldName.DAY_OF_MONTH) {
                List days = (List)it.getValue();
                if (!CollectionUtils.isEmpty((Collection)days) && days.size() == 1 && (Integer)days.get(0) == -1) {
                    this.setModelValue("cklastday", 1);
                    this.setModelValue(COMBDORW, DAY);
                    for (int day = 1; day <= 31; ++day) {
                        this.setModelValue(CKDATE[day - 1], 0);
                    }
                    continue;
                }
                if (CollectionUtils.isEmpty((Collection)days)) continue;
                this.setModelValue("cklastday", 0);
                this.setModelValue(COMBDORW, DAY);
                for (int day = 1; day <= 31; ++day) {
                    if (days.contains(day)) {
                        this.setModelValue(CKDATE[day - 1], 1);
                        continue;
                    }
                    this.setModelValue(CKDATE[day - 1], 0);
                }
                continue;
            }
            if (it.getKey() != CronFieldName.DAY_OF_WEEK) continue;
            Object[] filedValue = (Object[])it.getValue();
            List weeks = (List)filedValue[0];
            for (Integer week : weeks) {
                this.setModelValue("comweekbyweek", week);
                this.setModelValue(COM_WEEK, week);
            }
            if (!CollectionUtils.isEmpty((Collection)weeks) && filedValue[1] != null) {
                Tab tab = (Tab)this.getControl("tabap");
                tab.activeTab("tabweekpage");
            }
            if (filedValue[1] == null) continue;
            int nth = (Integer)filedValue[1];
            if (nth == -1) {
                this.setModelValue("comnobyweek", "L");
                this.setModelValue(COMNO, "L");
                continue;
            }
            this.setModelValue("comnobyweek", nth);
            this.setModelValue(COMNO, nth);
        }
    }

    private Map<CronFieldName, Object> parseCron(String cronexpress) {
        CronParser cronParser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
        Cron cron = cronParser.parse(cronexpress);
        log.info("cron\u53cd\u89e3\u6790 cronexpress={}", (Object)cronexpress);
        Map items = cron.retrieveFieldsAsMap();
        EnumMap<CronFieldName, Object> cronFieldValues = new EnumMap<CronFieldName, Object>(CronFieldName.class);
        for (Map.Entry it : items.entrySet()) {
            CronFieldName fieldName = (CronFieldName)it.getKey();
            CronField cronField = (CronField)it.getValue();
            if (fieldName == CronFieldName.MONTH) {
                cronFieldValues.put(fieldName, (Object)FieldValueGeneratorFactory.forCronField((CronField)cronField).generateCandidates(1, 12));
                continue;
            }
            if (fieldName == CronFieldName.MINUTE) {
                cronFieldValues.put(fieldName, (Object)FieldValueGeneratorFactory.forCronField((CronField)cronField).generateCandidates(0, 59));
                continue;
            }
            if (fieldName == CronFieldName.HOUR) {
                cronFieldValues.put(fieldName, (Object)FieldValueGeneratorFactory.forCronField((CronField)cronField).generateCandidates(0, 23));
                continue;
            }
            if (fieldName == CronFieldName.SECOND) {
                cronFieldValues.put(fieldName, (Object)FieldValueGeneratorFactory.forCronField((CronField)cronField).generateCandidates(0, 59));
                continue;
            }
            if (fieldName == CronFieldName.DAY_OF_MONTH) {
                try {
                    cronFieldValues.put(fieldName, (Object)FieldValueGeneratorFactory.forCronField((CronField)cronField).generateCandidates(0, 31));
                }
                catch (IllegalArgumentException exception) {
                    if (!(cronField.getExpression() instanceof On) || ((On)cronField.getExpression()).getSpecialChar().getValue() != SpecialChar.L) continue;
                    ArrayList<Integer> lastday = new ArrayList<Integer>();
                    lastday.add(-1);
                    cronFieldValues.put(fieldName, (Object)lastday);
                }
                continue;
            }
            if (fieldName == CronFieldName.DAY_OF_WEEK) {
                Object[] value = new Object[2];
                try {
                    value[0] = FieldValueGeneratorFactory.forCronField((CronField)cronField).generateCandidates(1, 7);
                    value[1] = null;
                    cronFieldValues.put(fieldName, (Object)value);
                    continue;
                }
                catch (Exception exception) {
                    if (!(cronField.getExpression() instanceof On)) {
                        throw exception;
                    }
                    On dayofweekExpression = (On)cronField.getExpression();
                    SpecialChar weekSpecialChar = dayofweekExpression.getSpecialChar().getValue();
                    value = new Object[2];
                    if (weekSpecialChar == SpecialChar.L) {
                        On withoutL = new On(dayofweekExpression.getTime(), new SpecialCharFieldValue(SpecialChar.NONE), dayofweekExpression.getNth());
                        value[1] = -1;
                        value[0] = FieldValueGeneratorFactory.forCronField((CronField)new CronField(cronField.getField(), (FieldExpression)withoutL, cronField.getConstraints())).generateCandidates(1, 7);
                        cronFieldValues.put(fieldName, (Object)value);
                        continue;
                    }
                    if (weekSpecialChar == SpecialChar.HASH) {
                        On withoutSeq = new On(((On)cronField.getExpression()).getTime(), new SpecialCharFieldValue(SpecialChar.NONE), dayofweekExpression.getNth());
                        value[1] = dayofweekExpression.getNth().getValue();
                        value[0] = FieldValueGeneratorFactory.forCronField((CronField)new CronField(cronField.getField(), (FieldExpression)withoutSeq, cronField.getConstraints())).generateCandidates(1, 7);
                        cronFieldValues.put(fieldName, (Object)value);
                        continue;
                    }
                    throw exception;
                }
            }
            if (fieldName != CronFieldName.DAY_OF_YEAR && fieldName != CronFieldName.YEAR) continue;
        }
        return cronFieldValues;
    }

    private void initHourValue(DynamicObject planObj, Calendar startTime, OperationStatus status) {
        if (status == OperationStatus.ADDNEW) {
            int hour = startTime.get(11);
            String currentHour = hour < 10 ? CKHOUR_0 + hour : CKHOUR + hour;
            planObj.set(currentHour, (Object)"1");
            this.getView().updateView(currentHour);
        }
    }

    private void initDayValue(DynamicObject planObj, Calendar startTime, OperationStatus status) {
        if (status == OperationStatus.ADDNEW) {
            int currentDay = startTime.get(5);
            planObj.set(CKDATE[currentDay - 1], (Object)"1");
            this.getView().updateView(CKDATE[currentDay - 1]);
        }
    }

    private void initMonthValue(DynamicObject planObj, Calendar startTime, OperationStatus status) {
        if (status == OperationStatus.ADDNEW) {
            int currentMonth = startTime.get(2);
            planObj.set(CKMONTH[currentMonth], (Object)"1");
            this.getView().updateView(CKMONTH[currentMonth]);
        }
    }

    private void initWeekValue(DynamicObject planObj, Calendar startTime, OperationStatus status) {
        if (status == OperationStatus.ADDNEW) {
            int currentWeek = startTime.get(7);
            planObj.set(CKWEEK[currentWeek - 1], (Object)"1");
            this.getView().updateView(CKWEEK[currentWeek - 1]);
        }
    }

    private void setModelValue(String key, Object value) {
        this.getModel().beginInit();
        this.getModel().setValue(key, value);
        this.getModel().endInit();
        this.getView().updateView(key);
    }

    private boolean isCopyPage() {
        Object isCopy = this.getView().getFormShowParameter().getCustomParam("iscopy");
        return isCopy instanceof Boolean && (Boolean)isCopy != false;
    }

    private boolean dealCopyPage() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        return status != OperationStatus.ADDNEW || this.isCopyPage();
    }
}

