/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.basedata.schedule;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;
import kd.swc.hsbs.business.basedata.schedule.SchConfigCheckQuoteData;

public class SchConfigEdit
extends SWCDataBaseEdit {
    private static final String KEY_SCHEDULE = "schedule";
    private static final String KEY_USEOBJ = "useobj";
    private static final String SCH_SCHEDULE = "sch_schedule";
    private static final String SCH_JOB = "sch_job";
    private static final String IS_COPY_PAGE_SAVED = "is_copy_page_saved";
    private static final long KEY_SCH_JOB_USER_ID = 100L;
    private static final String ERROR_NUM_PREFIX = "SWC_ERROR_BIZ_";
    private static final Set<String> SWC_BIZ_FIELDS = new HashSet<String>(16);
    private static final Set<String> MUL_LANGUAGE_FIELDS = new HashSet<String>(16);

    public void afterCopyData(EventObject evt) {
        this.initSchPlan();
        this.getModel().setValue(KEY_SCHEDULE, null);
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        this.initSchPlan();
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        this.setFieldEnable();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            if (!this.validateInputData()) {
                args.setCancel(true);
                return;
            }
            String schId = this.getModel().getDataEntity().getString(KEY_SCHEDULE);
            try {
                if (this.isSchIdEmpty(schId)) {
                    this.saveSchInfoToSysDb();
                } else {
                    this.updateSchInfoToSysDb();
                }
            }
            catch (Exception exc) {
                args.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u5ea6\u8ba1\u5212\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25\u3002", (String)"SchConfigEdit_0", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            }
        }
        if ("unaudit".equals(operateKey) || "disable".equals(operateKey)) {
            if (formOperate.getOption() != null && formOperate.getOption().tryGetVariableValue("isAfterConfirm", new RefObject())) {
                return;
            }
            if (!SchConfigCheckQuoteData.checkQuoteDataById((IFormView)this.getView(), (String)operateKey, (Object)this.getModel().getDataEntity().getLong("id"), (String)this.getPluginName())) {
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "unaudit": 
            case "unsubmit": {
                this.setFieldEnable();
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if ("disable_schConfig".equals(event.getCallBackId())) {
            this.invokeOpAfterConfirm("disable", event.getResult());
        } else if ("unaudit_schConfig".equals(event.getCallBackId())) {
            this.invokeOpAfterConfirm("unaudit", event.getResult());
        }
    }

    private void invokeOpAfterConfirm(String op, MessageBoxResult result) {
        if (MessageBoxResult.Yes.equals((Object)result)) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("isAfterConfirm", "true");
            this.getView().invokeOperation(op, operateOption);
        }
    }

    private void setFieldEnable() {
        String enable = (String)this.getModel().getValue("enable");
        if (!"10".equals(enable)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number", KEY_USEOBJ});
        }
    }

    private boolean validateInputData() {
        Date endTime;
        if (this.isBlank()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u5fc5\u586b\u9879\u3002", (String)"SchConfigEdit_1", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject dataEntity = this.getView().getModel().getDataEntity();
        Date startTime = dataEntity.getDate("starttime");
        if (startTime.after(endTime = dataEntity.getDate("endtime"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u6548\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u5931\u6548\u65f6\u95f4\u3002", (String)"SchConfigEdit_2", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            return false;
        }
        String schId = dataEntity.getString(KEY_SCHEDULE);
        if (this.isSchIdEmpty(schId)) {
            String planNumber = this.genJobOrPlanNumber(false);
            QFilter q1 = new QFilter("number", "=", (Object)planNumber);
            boolean exists = QueryServiceHelper.exists((String)SCH_SCHEDULE, (QFilter[])new QFilter[]{q1});
            if (exists) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u5ea6\u8ba1\u5212\u201c\u7f16\u7801\u201d\uff1a{0} \u5df2\u7ecf\u5b58\u5728\u3002", (String)"SchConfigEdit_3", (String)"swc-hsbs-formplugin", (Object[])new Object[]{planNumber}));
                return false;
            }
            String jobNumber = this.genJobOrPlanNumber(true);
            QFilter q2 = new QFilter("number", "=", (Object)jobNumber);
            boolean schJobExists = QueryServiceHelper.exists((String)SCH_JOB, (QFilter[])new QFilter[]{q2});
            if (schJobExists) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u5ea6\u4f5c\u4e1a\u201c\u7f16\u7801\u201d\uff1a{0} \u5df2\u7ecf\u5b58\u5728\u3002", (String)"SchConfigEdit_4", (String)"swc-hsbs-formplugin", (Object[])new Object[]{jobNumber}));
                return false;
            }
        }
        return true;
    }

    private boolean isSchIdEmpty(String schId) {
        return StringUtils.isEmpty((CharSequence)schId) || !new SWCDataServiceHelper(SCH_SCHEDULE).isExists((Object)schId);
    }

    private boolean isBlank() {
        DynamicObject obj = this.getView().getModel().getDataEntity();
        if (StringUtils.isBlank((CharSequence)obj.getString("number"))) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)obj.getString("name"))) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)obj.getString("starttime"))) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)obj.getString("endtime"))) {
            return true;
        }
        return StringUtils.isBlank((CharSequence)obj.getString("cyclenum")) || 0 == obj.getInt("cyclenum");
    }

    private void initSchPlan() {
        String schId = this.getModel().getDataEntity().getString(KEY_SCHEDULE);
        if (!StringUtils.isEmpty((CharSequence)schId)) {
            DynamicObject schPlan = new SWCDataServiceHelper(SCH_SCHEDULE).queryOne((Object)schId);
            if (schPlan != null) {
                this.setSysDbValueToPage(schPlan);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u5ea6\u8ba1\u5212\uff1a\u201c{0}\u201d\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u3002", (String)"SchConfigEdit_5", (String)"swc-hsbs-formplugin", (Object[])new Object[]{this.genJobOrPlanNumber(false)}));
            }
        }
    }

    private void setSysDbValueToPage(DynamicObject schPlan) {
        DataEntityPropertyCollection properties = this.getModel().getDataEntity().getDynamicObjectType().getProperties();
        HashSet<String> curPropertyNames = new HashSet<String>(16);
        for (IDataEntityProperty property : properties) {
            curPropertyNames.add(property.getName());
        }
        this.getModel().beginInit();
        for (IDataEntityProperty property : schPlan.getDataEntityType().getProperties()) {
            String propertyName = property.getName();
            if (!curPropertyNames.contains(propertyName) || SWC_BIZ_FIELDS.contains(propertyName)) continue;
            this.getView().getModel().setValue(propertyName, schPlan.get(propertyName));
        }
        this.getModel().endInit();
    }

    private void setPageValueToSysDb(DynamicObject schPlan) {
        DynamicObject curPageSchInfo = this.getModel().getDataEntity();
        DataEntityPropertyCollection properties = schPlan.getDynamicObjectType().getProperties();
        HashSet<String> sysPropertyNames = new HashSet<String>(120);
        for (IDataEntityProperty property : properties) {
            sysPropertyNames.add(property.getName());
        }
        for (IDataEntityProperty property : curPageSchInfo.getDataEntityType().getProperties()) {
            String propertyName = property.getName();
            if (!sysPropertyNames.contains(propertyName) || MUL_LANGUAGE_FIELDS.contains(propertyName) || propertyName.startsWith("job")) continue;
            schPlan.set(propertyName, curPageSchInfo.get(propertyName));
        }
    }

    private void updateSchInfoToSysDb() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(SCH_SCHEDULE);
        DynamicObject curPageSchInfo = this.getModel().getDataEntity();
        String scheduleId = curPageSchInfo.getString(KEY_SCHEDULE);
        DynamicObject sysSchInfo = helper.queryOne((Object)scheduleId);
        if (sysSchInfo == null) {
            return;
        }
        sysSchInfo.set("name", (Object)this.genJobOrPlanName(false));
        sysSchInfo.set("number", (Object)this.genJobOrPlanNumber(false));
        DynamicObject schJob = sysSchInfo.getDynamicObject("job");
        if (schJob == null) {
            DynamicObject jobDy = this.saveJobInfo(curPageSchInfo.getString("useobj.taskdefine.classname"), curPageSchInfo.getString("useobj.taskdefine.id"));
            sysSchInfo.set("job", (Object)jobDy);
        }
        sysSchInfo.set("status", (Object)"0");
        this.setPageValueToSysDb(sysSchInfo);
        helper.saveOne(sysSchInfo);
    }

    private String genJobOrPlanName(boolean isJob) {
        String name;
        DynamicObject curPageSchInfo = this.getModel().getDataEntity();
        String entityName = curPageSchInfo.getString("useobj.entity");
        if (StringUtils.isEmpty((CharSequence)entityName)) {
            String msg = ResManager.loadKDString((String)"\u9002\u7528\u5bf9\u8c61\u7684\u5b9e\u4f53\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SchConfigEdit_6", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            throw new KDBizException(msg);
        }
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        if (mainEntityType == null) {
            String msg = ResManager.loadKDString((String)"\u9002\u7528\u5bf9\u8c61\u7684\u5bf9\u5e94\u9875\u9762\u4e0d\u5b58\u5728\u3002", (String)"SchConfigEdit_9", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            throw new KDBizException(msg);
        }
        LocaleString entityCaption = mainEntityType.getDisplayName();
        if (entityCaption == null) {
            String msg = ResManager.loadKDString((String)"\u9002\u7528\u5bf9\u8c61\u7684\u5bf9\u5e94\u9875\u9762\u6ca1\u6709\u663e\u793a\u540d\u79f0\u3002", (String)"SchConfigEdit_10", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            throw new KDBizException(msg);
        }
        String suffix = ResManager.loadKDString((String)"\u8c03\u5ea6\u8ba1\u5212", (String)"SchConfigEdit_8", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
        if (isJob) {
            suffix = ResManager.loadKDString((String)"\u8c03\u5ea6\u4f5c\u4e1a", (String)"SchConfigEdit_7", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
        }
        if ((name = entityCaption.getLocaleValue() + suffix).length() > 100) {
            return ERROR_NUM_PREFIX + suffix;
        }
        return name;
    }

    private String genJobOrPlanNumber(boolean isJob) {
        String suffix;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String entity = dataEntity.getString("useobj.entity");
        String string = suffix = isJob ? "JOB" : "PLAN";
        if (StringUtils.isEmpty((CharSequence)entity)) {
            return ERROR_NUM_PREFIX + suffix;
        }
        String prefix = StringUtils.upperCase((String)entity, (Locale)Locale.ROOT);
        String number = prefix + "_" + dataEntity.getString("number") + suffix;
        if (number.length() > 80) {
            String tmp = prefix + "_" + suffix;
            int bizNumberLen = 80 - tmp.length();
            if (bizNumberLen <= 0) {
                return ERROR_NUM_PREFIX + suffix;
            }
            return prefix + "_" + dataEntity.getString("number").substring(0, bizNumberLen) + suffix;
        }
        return number;
    }

    private void saveSchInfoToSysDb() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(SCH_SCHEDULE);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject schInfoCp = helper.generateEmptyDynamicObject();
        schInfoCp.set("name", (Object)this.genJobOrPlanName(false));
        schInfoCp.set("number", (Object)this.genJobOrPlanNumber(false));
        DynamicObject schJob = schInfoCp.getDynamicObject("job");
        if (schJob == null) {
            DynamicObject jobInfo = this.saveJobInfo(dataEntity.getString("useobj.taskdefine.classname"), dataEntity.getString("useobj.taskdefine.id"));
            schInfoCp.set("job", (Object)jobInfo);
        }
        schInfoCp.set("status", (Object)"0");
        this.setPageValueToSysDb(schInfoCp);
        helper.saveOne(schInfoCp);
        dataEntity.set(KEY_SCHEDULE, (Object)String.valueOf(schInfoCp.get("id")));
    }

    private DynamicObject saveJobInfo(String taskClassName, String taskDefineId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(SCH_JOB);
        DynamicObject jobInfo = helper.generateEmptyDynamicObject();
        jobInfo.set("name", (Object)this.genJobOrPlanName(true));
        jobInfo.set("number", (Object)this.genJobOrPlanNumber(true));
        jobInfo.set("jobtype", (Object)"BIZ");
        jobInfo.set("classname", (Object)taskClassName);
        jobInfo.set("taskclassname", (Object)taskDefineId);
        HashMap<String, String> scheduleParams = new HashMap<String, String>(16);
        scheduleParams.put("useEntityCode", this.getModel().getDataEntity().getString("useobj.entity"));
        jobInfo.set("params", (Object)SerializationUtils.toJsonString(scheduleParams));
        jobInfo.set("status", (Object)"1");
        jobInfo.set("runbyuser", (Object)100L);
        jobInfo.set("runmode", (Object)"0");
        jobInfo.set("runconcurrent", (Object)false);
        jobInfo.set("strategy", (Object)"1");
        jobInfo.set("creator", (Object)RequestContext.get().getCurrUserId());
        jobInfo.set("createtime", (Object)new Date());
        helper.saveOne(jobInfo);
        return jobInfo;
    }

    static {
        SWC_BIZ_FIELDS.add("id");
        SWC_BIZ_FIELDS.add("number");
        SWC_BIZ_FIELDS.add("name");
        SWC_BIZ_FIELDS.add("status");
        SWC_BIZ_FIELDS.add("creator");
        SWC_BIZ_FIELDS.add("modifier");
        SWC_BIZ_FIELDS.add("enable");
        SWC_BIZ_FIELDS.add("createtime");
        SWC_BIZ_FIELDS.add("modifytime");
        SWC_BIZ_FIELDS.add("masterid");
        SWC_BIZ_FIELDS.add("simplename");
        SWC_BIZ_FIELDS.add("description");
        SWC_BIZ_FIELDS.add("index");
        SWC_BIZ_FIELDS.add("issyspreset");
        SWC_BIZ_FIELDS.add("disable");
        SWC_BIZ_FIELDS.add("disabledate");
        SWC_BIZ_FIELDS.add("initdatasource");
        SWC_BIZ_FIELDS.add("initstatus");
        SWC_BIZ_FIELDS.add("initbatch");
        SWC_BIZ_FIELDS.add("orinumber");
        SWC_BIZ_FIELDS.add("oriname");
        SWC_BIZ_FIELDS.add("oristatus");
        SWC_BIZ_FIELDS.add(KEY_USEOBJ);
        SWC_BIZ_FIELDS.add(KEY_SCHEDULE);
        SWC_BIZ_FIELDS.add("multilanguagetext");
        MUL_LANGUAGE_FIELDS.add("name");
        MUL_LANGUAGE_FIELDS.add("number");
        MUL_LANGUAGE_FIELDS.add("description");
        MUL_LANGUAGE_FIELDS.add("simplename");
        MUL_LANGUAGE_FIELDS.add("status");
        MUL_LANGUAGE_FIELDS.add("id");
        MUL_LANGUAGE_FIELDS.add("multilanguagetext");
    }
}

