/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.basedata.schedule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.formplugin.web.SWCDataBaseList;
import kd.swc.hsbs.business.basedata.schedule.SchConfigCheckQuoteData;

public class SchConfigList
extends SWCDataBaseList {
    private Map<Object, String> refStatusMap = new HashMap<Object, String>(16);
    private static final String KEY_REF_STATUS = "refstatus";
    private static final String REF_STATUS_NOREF = "0";
    private static final String REF_STATUS_REFD = "1";

    public void beforePackageData(BeforePackageDataEvent event) {
        DynamicObjectCollection pageDatas = event.getPageData();
        ArrayList<Long> pkIdList = new ArrayList<Long>(pageDatas.size());
        for (DynamicObject pageData : pageDatas) {
            if (!pageData.getDynamicObjectType().getProperties().tryGetValue("id", new RefObject())) {
                return;
            }
            pkIdList.add(pageData.getLong("id"));
        }
        this.queryBaseDataReference(pkIdList);
    }

    public void packageData(PackageDataEvent event) {
        super.packageData(event);
        String fieldKey = ((ColumnDesc)event.getSource()).getFieldKey();
        if (KEY_REF_STATUS.equals(fieldKey)) {
            DynamicObject rowData = event.getRowData();
            Long pkId = rowData.getLong("id");
            if (this.refStatusMap.get(pkId) != null) {
                event.setFormatValue((Object)this.refStatusMap.get(pkId));
            } else {
                event.setFormatValue((Object)REF_STATUS_NOREF);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (opKey = formOperate.getOperateKey()) {
            case "unaudit": 
            case "disable": {
                if (formOperate.getOption() != null && formOperate.getOption().tryGetVariableValue("isAfterConfirm", new RefObject())) {
                    return;
                }
                BillList billList = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                if (selectedRows == null || selectedRows.size() != 1 || SchConfigCheckQuoteData.checkQuoteDataById((IFormView)this.getView(), (String)opKey, (Object)selectedRows.get(0).getPrimaryKeyValue(), (String)this.getPluginName())) break;
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if ("disable_schConfig".equals(event.getCallBackId())) {
            this.invokeOpAfterConfirm("disable", event.getResult());
        } else if ("unaudit_schConfig".equals(event.getCallBackId())) {
            this.invokeOpAfterConfirm("unaudit", event.getResult());
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if ("useobj.name".equals(args.getFieldName())) {
            args.addCustomParam("callFromRefBillEdit", (Object)Boolean.TRUE);
        }
    }

    private void invokeOpAfterConfirm(String op, MessageBoxResult result) {
        if (MessageBoxResult.Yes.equals((Object)result)) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("isAfterConfirm", "true");
            this.getView().invokeOperation(op, operateOption);
        }
    }

    private void queryBaseDataReference(List<Long> pkIdList) {
        SWCDataServiceHelper schPlanHelper = new SWCDataServiceHelper("hsbs_schplancfg");
        DynamicObjectCollection schPlanDys = schPlanHelper.queryOriginalCollection("id,useobj.entity,useobj.fieldkey", new QFilter[]{new QFilter("id", "in", pkIdList)});
        if (schPlanDys == null || schPlanDys.isEmpty()) {
            return;
        }
        HashMap<String, ArrayList<Long>> entityIdMap = new HashMap<String, ArrayList<Long>>(16);
        HashMap<String, String> entityFieldKeyMap = new HashMap<String, String>(16);
        for (DynamicObject schPlanDy : schPlanDys) {
            String entityCode = schPlanDy.getString("useobj.entity");
            String fieldKey = schPlanDy.getString("useobj.fieldkey");
            ArrayList<Long> pkIds = (ArrayList<Long>)entityIdMap.get(entityCode);
            if (pkIds == null) {
                pkIds = new ArrayList<Long>(10);
            }
            pkIds.add(schPlanDy.getLong("id"));
            entityIdMap.put(entityCode, pkIds);
            entityFieldKeyMap.put(entityCode, fieldKey);
        }
        StringBuilder sbMsg = new StringBuilder();
        for (Map.Entry entity : entityIdMap.entrySet()) {
            schPlanHelper.setEntityName((String)entity.getKey());
            String bizSchConfigFieldKey = (String)entityFieldKeyMap.get(entity.getKey());
            try {
                DynamicObjectCollection refDyColl = schPlanHelper.queryOriginalCollection("id, " + bizSchConfigFieldKey + ".id", new QFilter(bizSchConfigFieldKey, "in", entity.getValue()).toArray());
                if (refDyColl == null || refDyColl.isEmpty()) continue;
                for (DynamicObject refDy : refDyColl) {
                    this.refStatusMap.put(refDy.getLong(bizSchConfigFieldKey + ".id"), REF_STATUS_REFD);
                }
            }
            catch (Exception exc) {
                sbMsg.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u67e5\u5230\u5b9e\u4f53\u6807\u8bc6\u4e3a%s\u7684\u9002\u7528\u5bf9\u8c61\u914d\u7f6e\u5f02\u5e38\uff0c\u65e0\u6cd5\u67e5\u8be2\u5f15\u7528\u72b6\u6001\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SchConfigList_0", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), entity.getKey())).append("\r\n");
            }
        }
        if (sbMsg.length() > 0) {
            this.getView().showTipNotification(sbMsg.toString());
        }
    }
}

