/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.basedata.standarditem;

import java.util.Arrays;
import java.util.EventObject;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class StandardItemEdit
extends SWCDataBaseEdit {
    private static final String BIZTYPE_KEY = "biztype";
    private static final String BIZTYPE_ASSIGN = "1";
    private static final String FIXEDITEM_KEY = "fixeditem";
    private static final String AREATYPE_KEY = "areatype";
    private static final String AREATYPE_ASSIGN = "2";
    private static final String COUNTRY_KEY = "country";
    private static final String FIXED_ITEM_CONFIRM_CALL_BACK_ID = "fixed_item_confirm_call_back_id";

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.initFiledEdit();
        this.setCountryFiledVisible();
        this.setFixeditemFiledVisible();
        this.getModel().setDataChanged(false);
    }

    public void beforePropertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        if (FIXEDITEM_KEY.equals(name)) {
            Object newValue = args.getChangeSet()[0].getNewValue();
            Object oldValue = args.getChangeSet()[0].getOldValue();
            long id = this.getModel().getDataEntity().getLong("id");
            if (newValue == null || oldValue == null || id == 0L) {
                return;
            }
            String sql = "SELECT COUNT(1) FCOUNTA FROM T_HCDM_SALARYSTDITEM WHERE FSALARYITEMID = ?";
            int countO = (Integer)SWCDbUtil.query((DBRoute)new DBRoute("hcdm"), (String)sql, (Object[])new Object[]{id}, rs -> {
                int count = 0;
                while (rs.next()) {
                    count = rs.getInt("FCOUNTA");
                }
                return count;
            });
            if (countO <= 0) {
                return;
            }
            QFilter qFilter = new QFilter("id", "=", (Object)id);
            qFilter.and(FIXEDITEM_KEY, "=", newValue);
            if (new SWCDataServiceHelper("hsbs_standarditem").isExists(qFilter.toArray())) {
                return;
            }
            String tips = ResManager.loadKDString((String)"\u5b9a\u8c03\u85aa\u9879\u76ee\u7684\u201c\u56fa\u5b9a\u85aa\u916c\u201d\u53d1\u751f\u53d8\u5316\u4e14\u5df2\u88ab\u85aa\u916c\u6807\u51c6\u8868\u5f15\u7528\uff0c\u8bf7\u53ca\u65f6\u66f4\u65b0\u6807\u51c6\u8868\u5e76\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"StandardItemEdit_1", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(tips, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(FIXED_ITEM_CONFIRM_CALL_BACK_ID));
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name;
        switch (name = args.getProperty().getName()) {
            case "areatype": {
                this.setCountryFiledVisible();
                break;
            }
            case "biztype": {
                this.setFixeditemFiledVisible();
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if (FIXED_ITEM_CONFIRM_CALL_BACK_ID.equals(callBackId) && MessageBoxResult.Cancel.equals((Object)evt.getResult())) {
            this.getModel().beginInit();
            String newVal = this.getModel().getDataEntity().getString(FIXEDITEM_KEY);
            String oldVal = BIZTYPE_ASSIGN.equals(newVal) ? "0" : BIZTYPE_ASSIGN;
            this.getModel().setValue(FIXEDITEM_KEY, (Object)oldVal);
            this.getModel().endInit();
            this.getView().updateView(FIXEDITEM_KEY);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey = args.getOperateKey();
        if (SWCStringUtils.equals((String)opKey, (String)"unaudit")) {
            this.getView().updateView();
        }
    }

    private void initFiledEdit() {
        String enable = this.getModel().getDataEntity().getString("enable");
        if (!SWCStringUtils.equals((String)enable, (String)"10")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{FIXEDITEM_KEY});
        }
    }

    private void setCountryFiledVisible() {
        String areatype = this.getModel().getDataEntity().getString(AREATYPE_KEY);
        FieldEdit fixedItem = (FieldEdit)this.getControl(COUNTRY_KEY);
        if (SWCStringUtils.equals((String)areatype, (String)AREATYPE_ASSIGN)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{COUNTRY_KEY});
            fixedItem.setMustInput(true);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{COUNTRY_KEY});
            this.getModel().setValue(COUNTRY_KEY, null);
            fixedItem.setMustInput(false);
        }
    }

    private void setFixeditemFiledVisible() {
        String biztype = this.getModel().getDataEntity().getString(BIZTYPE_KEY);
        if (SWCStringUtils.isEmpty((String)biztype)) {
            return;
        }
        Set bizTypes = Arrays.stream(biztype.split(",")).filter(biz -> SWCStringUtils.isNotEmpty((String)biz)).collect(Collectors.toSet());
        FieldEdit fixedItem = (FieldEdit)this.getControl(FIXEDITEM_KEY);
        if (bizTypes.contains(BIZTYPE_ASSIGN)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FIXEDITEM_KEY});
            this.getView().setEnable(Boolean.TRUE, new String[]{FIXEDITEM_KEY});
            fixedItem.setMustInput(true);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{FIXEDITEM_KEY});
            this.getModel().setValue(FIXEDITEM_KEY, null);
            fixedItem.setMustInput(false);
        }
    }
}

