/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.basedata.statisticstag;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbs.business.statistictag.StatisticsTagHelper;
import org.jetbrains.annotations.NotNull;

public class StatisticTagTreeList
extends AbstractTreeListPlugin
implements SearchEnterListener,
TreeNodeClickListener {
    private static final String KEY_TREEVIEW = "treeviewap";
    private static final String CACHE_TREE = "treenode";
    private static final String CACHE_SEARCH_TEXT = "cachesearchtext";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void setFilter(SetFilterEvent event) {
        List filters = event.getQFilters();
        List<String> orgFields = Arrays.asList("useorg.id", "createorg.id");
        List orgFilters = filters.stream().filter(single -> orgFields.contains(single.getProperty())).collect(Collectors.toList());
        if (SWCListUtils.isEmpty(orgFilters)) {
            filters.add(new QFilter("statisticstag.id", ">", (Object)0L));
            return;
        }
        QFilter filter = (QFilter)orgFilters.get(0);
        ArrayList<Long> orgIdList = new ArrayList<Long>(10);
        if (filter != null) {
            Object filterValue = filter.getValue();
            if (filterValue instanceof Long) {
                orgIdList.add(Long.parseLong(filterValue + ""));
            } else if (filterValue instanceof ArrayList) {
                orgIdList = (List)filterValue;
            }
        }
        List validStatisticsTagObjs = StatisticsTagHelper.getValidStatisticsObjs(orgIdList);
        List statisticsTagIdList = validStatisticsTagObjs.stream().map(single -> single.getLong("id")).collect(Collectors.toList());
        filters.add(new QFilter("statisticstag.id", "in", statisticsTagIdList));
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        swcPageCache.put("orgId", orgIdList);
        this.initTree(orgIdList);
        if (SWCStringUtils.isEmpty((String)event.getOrderBy())) {
            event.setOrderBy("statisticstag.longnumber asc, number asc");
        }
    }

    public void search(SearchEnterEvent evt) {
        String searchText = evt.getText();
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        swcPageCache.put(CACHE_SEARCH_TEXT, (Object)searchText);
        swcPageCache.put("isTreeClick", (Object)"0");
        List orgIdList = (List)swcPageCache.get("orgIdList", List.class);
        if (SWCStringUtils.isEmpty((String)searchText)) {
            this.initTree(orgIdList);
        } else {
            ArrayList<TreeNode> checkNodeList = new ArrayList<TreeNode>(10);
            List tagTreeNodes = StatisticsTagHelper.getStatisticsTagTreeNode((List)orgIdList);
            List<TreeNode> matchNode = this.getMatchNode(checkNodeList, searchText, tagTreeNodes);
            this.rebuildTree(matchNode, checkNodeList);
        }
    }

    public void treeNodeClick(TreeNodeEvent event) {
        String nodeId = (String)event.getNodeId();
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        swcPageCache.put("isTreeClick", (Object)"1");
        String allTreeNodeStr = (String)swcPageCache.get(CACHE_TREE, String.class);
        Map nodeMap = (Map)SerializationUtils.deSerializeFromBase64((String)allTreeNodeStr);
        if (nodeMap == null || nodeMap.isEmpty()) {
            return;
        }
        TreeNode node = (TreeNode)nodeMap.get(nodeId);
        ArrayList<String> dataIdList = (ArrayList<String>)node.getData();
        if (dataIdList == null) {
            dataIdList = new ArrayList<String>(1);
        }
        if (!SWCStringUtils.equals((String)"root", (String)nodeId)) {
            dataIdList.add(nodeId);
        }
        node.setIsOpened(true);
        this.reloadItemGrid(dataIdList);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        if (SWCListUtils.isEmpty((List)commonFilterColumnList)) {
            return;
        }
        long userOrgId = RequestContext.get().getOrgId();
        for (FilterColumn column : commonFilterColumnList) {
            CommonFilterColumn commFilter = (CommonFilterColumn)column;
            String fieldName = commFilter.getFieldName();
            if (!SWCStringUtils.equals((String)"useorg.id", (String)fieldName)) continue;
            commFilter.setDefaultValues(new Object[]{userOrgId + ""});
            commFilter.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4f7f\u7528\u7ec4\u7ec7", (String)"StatisticTagTreeList_0", (String)"swc-hsbs-formplugin", (Object[])new Object[0])));
        }
    }

    @NotNull
    private List<TreeNode> getMatchNode(List<TreeNode> checkNodeList, String searchText, List<TreeNode> tagTreeNodes) {
        ArrayList<TreeNode> matchNode = new ArrayList<TreeNode>(10);
        Map<String, TreeNode> nodeMap = tagTreeNodes.stream().collect(Collectors.toMap(TreeNode::getId, Function.identity()));
        for (TreeNode node : tagTreeNodes) {
            if (SWCStringUtils.equals((String)"root", (String)node.getId())) {
                matchNode.add(node);
                continue;
            }
            String nodeText = node.getText();
            if (SWCStringUtils.isEmpty((String)searchText)) {
                this.addMatchNode(searchText, matchNode, node, nodeMap);
                continue;
            }
            if (!nodeText.contains(searchText)) continue;
            checkNodeList.add(node);
            node.setIsOpened(true);
            this.addMatchNode(searchText, matchNode, node, nodeMap);
        }
        return matchNode;
    }

    private void addMatchNode(String searchText, List<TreeNode> matchNode, TreeNode node, Map<String, TreeNode> nodeMap) {
        String parentNodeId = node.getParentid();
        if (SWCStringUtils.isEmpty((String)parentNodeId)) {
            return;
        }
        if (!SWCStringUtils.equals((String)"root", (String)parentNodeId) && nodeMap.get(parentNodeId) != null) {
            this.addMatchNode(searchText, matchNode, nodeMap.get(parentNodeId), nodeMap);
        }
        if (!matchNode.contains(node)) {
            if (SWCStringUtils.isNotEmpty((String)searchText)) {
                node.setIsOpened(true);
            }
            matchNode.add(node);
        }
    }

    private void reloadItemGrid(List<String> dataIdList) {
        BillList billList = (BillList)this.getControl("billlistap");
        if (SWCListUtils.isEmpty(dataIdList)) {
            return;
        }
        List idList = dataIdList.stream().map(single -> Long.parseLong(single)).collect(Collectors.toList());
        QFilter filter = new QFilter("statisticstag.id", "in", idList);
        billList.setFilter(filter);
        this.getView().updateView("billlistap");
    }

    private void rebuildTree(List<TreeNode> matchNode, List<TreeNode> checkNodeList) {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        treeView.deleteAllNodes();
        treeView.addNodes(matchNode);
        treeView.checkNodes(checkNodeList);
    }

    private void initTree(List<Long> orgIdList) {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        String isTreeClick = (String)pageCache.get("isTreeClick", String.class);
        if (SWCStringUtils.equals((String)"1", (String)isTreeClick)) {
            return;
        }
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        treeView.deleteAllNodes();
        List tagTreeNodes = StatisticsTagHelper.getStatisticsTagTreeNode(orgIdList);
        Map treeNodeMap = tagTreeNodes.stream().collect(Collectors.toMap(TreeNode::getId, Function.identity()));
        String searchText = (String)pageCache.get(CACHE_SEARCH_TEXT, String.class);
        ArrayList<TreeNode> checkNodeList = new ArrayList<TreeNode>(10);
        List<TreeNode> matchNode = this.getMatchNode(checkNodeList, searchText, tagTreeNodes);
        pageCache.put(CACHE_TREE, (Object)SerializationUtils.serializeToBase64(treeNodeMap));
        treeView.addNodes(matchNode);
        treeView.checkNodes(checkNodeList);
    }

    private Long getUseOrgId() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.getFilter();
        return 0L;
    }
}

