/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.basedata.statisticstag;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.swc.hsbp.business.area.AreaHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class StatisticsTagEdit
extends SWCDataBaseEdit
implements BeforeF7SelectListener {
    private static final String KEY_PARENT_TAG = "parent";
    private static final String KEY_TAG_LEVEL = "taglevel";
    private static final String KEY_LEVEL = "level";
    private static final String KEY_ENABLE_ADD_JUNIOR = "enableaddjunior";
    private static final String KEY_IS_LEAF = "isleaf";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit control = (BasedataEdit)this.getControl(KEY_PARENT_TAG);
        control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        AreaHelper.initAreaTypeAndcountryStatus((IDataModel)this.getModel(), (IFormView)this.getView());
        this.setParentTagByTagLevel();
        Boolean isLeaf = (Boolean)this.getModel().getValue(KEY_IS_LEAF);
        if (Boolean.FALSE.equals(isLeaf)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_TAG_LEVEL, KEY_ENABLE_ADD_JUNIOR});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{KEY_TAG_LEVEL, KEY_ENABLE_ADD_JUNIOR});
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName;
        switch (propertyName = args.getProperty().getName()) {
            case "areatype": {
                this.confirmAreaTypeAndCountryChange(true, args.getChangeSet());
                break;
            }
            case "country": {
                this.confirmAreaTypeAndCountryChange(false, args.getChangeSet());
                break;
            }
            case "taglevel": {
                if (this.getModel().getValue(KEY_PARENT_TAG) != null) {
                    DynamicObject oldTagLevel = (DynamicObject)args.getChangeSet()[0].getOldValue();
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u540e\u5c06\u6e05\u9664\u201c\u4e0a\u7ea7\u7c7b\u522b\u201d\uff0c\u786e\u5b9a\u7ee7\u7eed\uff1f", (String)"StatisticsTagEdit_0", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, null, new ConfirmCallBackListener(KEY_TAG_LEVEL), null, oldTagLevel == null ? null : String.valueOf(oldTagLevel.getLong("id")));
                    break;
                }
                this.setParentTagByTagLevel();
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey = event.getProperty().getName();
        if (KEY_PARENT_TAG.equals(fieldKey)) {
            if (!AreaHelper.checkArea((DynamicObject)this.getModel().getDataEntity())) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u56fd\u5bb6/\u5730\u533a\u540e\u518d\u9009\u62e9\u201c\u4e0a\u7ea7\u7c7b\u522b\u201d\u3002", (String)"StatisticsTagEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                event.setCancel(true);
                return;
            }
            DynamicObject tagLevel = (DynamicObject)this.getModel().getValue(KEY_TAG_LEVEL);
            int level = tagLevel.getInt(KEY_LEVEL);
            ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
            filterList.add(new QFilter("taglevel.level", "=", (Object)(level - 1)));
            DynamicObject createOrg = (DynamicObject)this.getModel().getValue("createorg");
            List superiorOrgIdList = null;
            if (createOrg != null) {
                Long createOrgId = createOrg.getLong("id");
                superiorOrgIdList = OrgUnitServiceHelper.getAllSuperiorOrgs((String)"29", (long)createOrgId);
                superiorOrgIdList.add(createOrgId);
                filterList.add(new QFilter("createorg", "in", (Object)superiorOrgIdList));
            }
            QFilter areaFilter = new QFilter("areatype", "=", (Object)"1");
            DynamicObject country = (DynamicObject)this.getModel().getValue("country");
            if (country != null) {
                areaFilter.or(new QFilter("country", "=", (Object)country.getLong("id")));
                event.getFormShowParameter().setCustomParam("countryId", (Object)country.getString("id"));
            }
            filterList.add(areaFilter);
            filterList.add(new QFilter(KEY_ENABLE_ADD_JUNIOR, "=", (Object)"1"));
            event.getFormShowParameter().setCustomParam("isFromStatisticsTag", (Object)"1");
            event.getFormShowParameter().setCustomParam(KEY_LEVEL, (Object)(level - 1));
            event.getFormShowParameter().setCustomParam("createOrgIdList", (Object)superiorOrgIdList);
            event.getCustomQFilters().addAll(filterList);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId;
        super.confirmCallBack(event);
        String[] keys = new String[]{KEY_PARENT_TAG};
        String[] entryEntityKeys = new String[]{};
        switch (callBackId = event.getCallBackId()) {
            case "areatype": {
                AreaHelper.confirmAfterModifyAraeType((MessageBoxClosedEvent)event, (IDataModel)this.getModel(), (IFormView)this.getView(), (String[])keys, (String[])entryEntityKeys);
                break;
            }
            case "country": {
                AreaHelper.confirmAfterModifyCountry((MessageBoxClosedEvent)event, (IDataModel)this.getModel(), (IFormView)this.getView(), (String[])keys, (String[])entryEntityKeys);
                break;
            }
            case "taglevel": {
                if (MessageBoxResult.Cancel.equals((Object)event.getResult())) {
                    this.getModel().beginInit();
                    String oldTagLevelId = event.getCustomVaule();
                    if (SWCStringUtils.isEmpty((String)oldTagLevelId)) {
                        this.getModel().setValue(KEY_TAG_LEVEL, null);
                    } else {
                        this.getModel().setValue(KEY_TAG_LEVEL, (Object)Long.valueOf(oldTagLevelId));
                    }
                    this.getModel().endInit();
                    this.getView().updateView(KEY_TAG_LEVEL);
                    break;
                }
                this.getModel().setValue(KEY_PARENT_TAG, null);
                this.setParentTagByTagLevel();
                break;
            }
        }
    }

    private void confirmAreaTypeAndCountryChange(boolean isAreaType, ChangeData[] changeDataSets) {
        String callBack;
        if (this.getModel().getValue(KEY_PARENT_TAG) == null) {
            AreaHelper.setAreaTypeAndcountryStatus((IDataModel)this.getModel(), (IFormView)this.getView());
            return;
        }
        String customValue = "";
        ChangeData changeData = changeDataSets[0];
        Object oldValue = changeData.getOldValue();
        if (isAreaType) {
            if (oldValue != null) {
                customValue = (String)changeData.getOldValue();
            }
            callBack = "areatype";
        } else {
            if (oldValue != null) {
                DynamicObject country = (DynamicObject)oldValue;
                Object countryId = country.get("id");
                customValue = String.valueOf(countryId);
            }
            callBack = "country";
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u540e\u5c06\u6e05\u9664\u201c\u4e0a\u7ea7\u7c7b\u522b\u201d\uff0c\u786e\u5b9a\u7ee7\u7eed\uff1f", (String)"StatisticsTagEdit_0", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, null, new ConfirmCallBackListener(callBack), null, customValue);
    }

    private void setParentTagByTagLevel() {
        DynamicObject tagLevel = (DynamicObject)this.getModel().getValue(KEY_TAG_LEVEL);
        if (tagLevel == null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_PARENT_TAG});
            this.getModel().setValue(KEY_PARENT_TAG, null);
            FieldEdit parentTagField = (FieldEdit)this.getControl(KEY_PARENT_TAG);
            parentTagField.setMustInput(true);
        } else if (tagLevel.getInt(KEY_LEVEL) == 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_PARENT_TAG});
            this.getModel().setValue(KEY_PARENT_TAG, null);
            FieldEdit parentTagField = (FieldEdit)this.getControl(KEY_PARENT_TAG);
            parentTagField.setMustInput(false);
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{KEY_PARENT_TAG});
            FieldEdit parentTagField = (FieldEdit)this.getControl(KEY_PARENT_TAG);
            parentTagField.setMustInput(true);
        }
        this.getView().updateView(KEY_PARENT_TAG);
    }
}

