/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.basedata.statisticstag;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbs.business.statistictag.StatisticsTagHelper;

public class StatisticsTagList
extends AbstractTreeListPlugin {
    private static final String KEY_IS_LEAF = "isleaf";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"viewbystatistictag"});
    }

    public void initializeTree(EventObject eventObject) {
        super.initializeTree(eventObject);
        QFilter treeFilter = this.buildTreeFilter();
        if (treeFilter != null) {
            this.getTreeModel().getTreeFilter().clear();
            this.getTreeModel().getTreeFilter().add(treeFilter);
        }
        TreeListModel model = (TreeListModel)this.getTreeModel();
        model.getQueryParas().put("order", "longnumber asc, number asc");
    }

    public void setFilter(SetFilterEvent event) {
        if (SWCStringUtils.isEmpty((String)event.getOrderBy())) {
            event.setOrderBy("longnumber asc, number asc");
        }
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent event) {
        DynamicObject[] datas = event.getQueryValues();
        if (datas.length == 0) {
            return;
        }
        List idSet = Arrays.stream(datas).map(data -> data.getLong("id")).collect(Collectors.toList());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_statisticstag");
        DynamicObjectCollection queryDatas = helper.queryOriginalCollection("id,parent.number", new QFilter[]{new QFilter("id", "in", idSet)});
        HashMap<Long, String> parentTagNumberMap = new HashMap<Long, String>(idSet.size());
        for (DynamicObject queryData : queryDatas) {
            parentTagNumberMap.put(queryData.getLong("id"), queryData.getString("parent.number"));
        }
        for (DynamicObject data2 : datas) {
            if (!data2.containsProperty("parenttagnumber")) continue;
            data2.set("parenttagnumber", parentTagNumberMap.get(data2.getLong("id")));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        switch (evt.getItemKey()) {
            case "tbldisable": {
                BillList list = (BillList)this.getView().getControl("billlistap");
                ListSelectedRowCollection selectedRows = list.getSelectedRows();
                Object[] pkIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray();
                SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_statisticstag");
                DynamicObjectCollection tags = helper.queryOriginalCollection("number,isleaf", new QFilter[]{new QFilter("id", "in", (Object)pkIds)});
                StringBuilder tagNumberBuilder = new StringBuilder();
                for (DynamicObject tag : tags) {
                    if (tag.getBoolean(KEY_IS_LEAF)) continue;
                    if (tagNumberBuilder.length() > 0) {
                        tagNumberBuilder.append(',');
                    }
                    tagNumberBuilder.append(tag.getString("number"));
                }
                if (tagNumberBuilder.length() <= 0) break;
                String confimMsg = ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee\u7edf\u8ba1\u7c7b\u522b\u201c{0}\u201d\u5b58\u5728\u4e0b\u7ea7\u7edf\u8ba1\u7c7b\u522b\uff0c\u7981\u7528\u540e\u5c06\u540c\u65f6\u7981\u7528\u5176\u57fa\u7840\u8d44\u6599\u53ca\u6240\u6709\u4e0b\u7ea7\u57fa\u7840\u8d44\u6599\uff0c\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"StatisticsTagList_0", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
                confimMsg = MessageFormat.format(confimMsg, tagNumberBuilder.toString());
                this.getView().showConfirm(confimMsg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("disable", (IFormPlugin)this));
                evt.setCancel(true);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        if ("disable".equals(callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            this.getView().invokeOperation("disable");
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "viewbystatistictag": {
                this.openStatisticTagItemView();
                break;
            }
        }
    }

    private void openStatisticTagItemView() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("hsbs_statistictagtree");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setPageId(this.getView().getPageId() + "statistictagtree");
        showParameter.setCaption(ResManager.loadKDString((String)"\u6309\u7c7b\u522b\u67e5\u770b\u85aa\u916c\u9879\u76ee", (String)"StatisticsTagList_1", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private QFilter buildTreeFilter() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (SWCStringUtils.isEmpty((String)((String)formShowParameter.getCustomParam("isFromStatisticsTag")))) {
            return null;
        }
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        String countryIdStr = (String)formShowParameter.getCustomParam("countryId");
        QFilter areaFilter = new QFilter("areatype", "=", (Object)"1");
        if (SWCStringUtils.isNotEmpty((String)countryIdStr)) {
            areaFilter.or(new QFilter("country", "=", (Object)Long.valueOf(countryIdStr)));
        }
        filter.and(areaFilter);
        boolean isFromStatisticsTag = "1".equals(formShowParameter.getCustomParam("isFromStatisticsTag"));
        ArrayList<QFilter> dataFilterList = new ArrayList<QFilter>(2);
        QFilter countryDataFilter = StatisticsTagHelper.getCountryFilterForStatisticTag();
        if (countryDataFilter != null) {
            dataFilterList.add(countryDataFilter);
        }
        if (isFromStatisticsTag) {
            List createOrgIdList;
            filter.and(new QFilter("enableaddjunior", "=", (Object)"1"));
            Integer level = (Integer)formShowParameter.getCustomParam("level");
            if (level != null) {
                filter.and(new QFilter("taglevel.level", "=", (Object)level));
            }
            if (!CollectionUtils.isEmpty((Collection)(createOrgIdList = (List)formShowParameter.getCustomParam("createOrgIdList")))) {
                filter.and(new QFilter("createorg", "in", (Object)createOrgIdList));
            }
        } else {
            QFilter dataFilter;
            String createOrgIdStr = (String)formShowParameter.getCustomParam("createOrgId");
            if (SWCStringUtils.isNotEmpty((String)createOrgIdStr)) {
                filter.and(SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_statisticstag", (Long)Long.valueOf(createOrgIdStr)));
            }
            if ((dataFilter = StatisticsTagHelper.getTagLevelFilterForStatisticTag()) != null) {
                dataFilterList.add(dataFilter);
            }
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_statisticstag");
        dataFilterList.add(filter);
        DynamicObjectCollection allDatas = helper.queryOriginalCollection("id,longnumber", dataFilterList.toArray(new QFilter[0]));
        if (CollectionUtils.isEmpty((Collection)allDatas)) {
            return new QFilter("1", "!=", (Object)1);
        }
        HashSet<String> numberSet = new HashSet<String>(10);
        for (DynamicObject data : allDatas) {
            String longNumber = data.getString("longnumber");
            if (!longNumber.contains(".")) {
                numberSet.add(longNumber);
                continue;
            }
            String[] numbers = longNumber.split("\\.");
            numberSet.addAll(Arrays.asList(numbers));
        }
        return new QFilter("number", "in", numberSet);
    }
}

