/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.basedata.supportitem;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.business.area.AreaHelper;
import kd.swc.hsbp.business.item.utils.ItemDataUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class SupportItemEdit
extends SWCDataBaseEdit {
    private static Log logger = LogFactory.getLog(SupportItemEdit.class);
    public static final String AREATYPE = "areatype";
    public static final String DATATYPE = "datatype";
    public static final String TEXTDEFAULTVALUE = "textdefaultvalue";
    public static final String DATEDEFAULTVALUE = "datedefaultvalue";
    public static final String NUMDEFAULTVALUE = "numdefaultvalue";
    public static final String DEFAULTVALUE = "defaultvalue";

    public void afterBindData(EventObject eventObject) {
        String defaultValue;
        AreaHelper.initAreaTypeAndcountryStatus((IDataModel)this.getModel(), (IFormView)this.getView());
        DynamicObject data = this.getModel().getDataEntity();
        long dataTypeId = data.getLong("datatype.id");
        this.setFieldProp(dataTypeId, true);
        String enable = data.getString("enable");
        if (!SWCStringUtils.equals((String)enable, (String)"10")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number", DATATYPE});
        }
        if (SWCStringUtils.isNotEmpty((String)(defaultValue = data.getString(DEFAULTVALUE)))) {
            if (dataTypeId == 1010L) {
                this.getModel().setValue(NUMDEFAULTVALUE, (Object)new BigDecimal(defaultValue));
                this.getModel().setValue(TEXTDEFAULTVALUE, null);
                this.getModel().setValue(DATEDEFAULTVALUE, null);
            } else if (dataTypeId == 1030L) {
                this.getModel().setValue(TEXTDEFAULTVALUE, (Object)defaultValue);
                this.getModel().setValue(DATEDEFAULTVALUE, null);
                this.getModel().setValue(NUMDEFAULTVALUE, null);
            } else if (dataTypeId == 1050L) {
                try {
                    this.getModel().setValue(DATEDEFAULTVALUE, (Object)SWCDateTimeUtils.parseDate((String)defaultValue));
                    this.getModel().setValue(TEXTDEFAULTVALUE, null);
                    this.getModel().setValue(NUMDEFAULTVALUE, null);
                }
                catch (ParseException e1) {
                    logger.error((Throwable)e1);
                }
            }
        }
        this.getModel().setDataChanged(false);
    }

    private void setFieldProp(long dataTypeId, boolean isInitFlag) {
        BasedataEdit dataprecision = (BasedataEdit)this.getControl("dataprecision");
        BasedataEdit dataround = (BasedataEdit)this.getControl("dataround");
        TextEdit datalength = (TextEdit)this.getControl("datalength");
        if (dataTypeId == 1010L) {
            this.getModel().setValue("datalength", null);
            this.getView().setVisible(Boolean.TRUE, new String[]{"dataprecision", "dataround", NUMDEFAULTVALUE});
            this.getView().setVisible(Boolean.FALSE, new String[]{"datalength", TEXTDEFAULTVALUE, DATEDEFAULTVALUE});
            dataprecision.setMustInput(true);
            dataround.setMustInput(true);
            datalength.setMustInput(false);
        } else if (dataTypeId == 1030L) {
            this.getModel().setValue("dataprecision", null);
            this.getModel().setValue("dataround", null);
            this.getView().setVisible(Boolean.TRUE, new String[]{"datalength", TEXTDEFAULTVALUE});
            this.getView().setVisible(Boolean.FALSE, new String[]{"dataprecision", "dataround", DATEDEFAULTVALUE, NUMDEFAULTVALUE});
            dataprecision.setMustInput(false);
            dataround.setMustInput(false);
            datalength.setMustInput(true);
            if (!isInitFlag) {
                this.getModel().setValue("datalength", (Object)200);
            }
        } else if (dataTypeId == 1050L) {
            this.getModel().setValue("dataprecision", null);
            this.getModel().setValue("datalength", null);
            this.getModel().setValue("dataround", null);
            this.getView().setVisible(Boolean.FALSE, new String[]{"dataprecision", "dataround", "datalength", NUMDEFAULTVALUE, TEXTDEFAULTVALUE});
            this.getView().setVisible(Boolean.TRUE, new String[]{DATEDEFAULTVALUE});
            dataprecision.setMustInput(false);
            dataround.setMustInput(false);
            datalength.setMustInput(false);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey = args.getProperty().getName();
        DynamicObject data = this.getModel().getDataEntity();
        long dataTypeId = data.getLong("datatype.id");
        switch (fieldKey) {
            case "areatype": {
                AreaHelper.setAreaTypeAndcountryStatus((IDataModel)this.getModel(), (IFormView)this.getView());
                break;
            }
            case "datatype": {
                if (dataTypeId == 0L) break;
                this.setFieldProp(dataTypeId, false);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (SWCStringUtils.equals((String)"save", (String)operateKey) || SWCStringUtils.equals((String)"submit", (String)operateKey)) {
            source.getOption().setVariableValue("save", Boolean.TRUE.toString());
            this.setDefaultValue(args);
        }
    }

    private void setDefaultValue(BeforeDoOperationEventArgs args) {
        DynamicObject obj = this.getModel().getDataEntity();
        long dataTypeId = obj.getLong("datatype.id");
        if (1050L == dataTypeId) {
            Date dateValue = obj.getDate(DATEDEFAULTVALUE);
            if (dateValue == null) {
                this.getModel().setValue(DEFAULTVALUE, (Object)" ");
            } else {
                this.getModel().setValue(DEFAULTVALUE, (Object)SWCDateTimeUtils.format((Date)dateValue, (String)"yyyy-MM-dd"));
            }
        } else if (1010L == dataTypeId) {
            BigDecimal numValue = obj.getBigDecimal(NUMDEFAULTVALUE);
            if (numValue == null) {
                this.getModel().setValue(DEFAULTVALUE, (Object)" ");
            } else {
                numValue = numValue.setScale(obj.getInt("dataprecision.scale"), ItemDataUtils.getRoundingMode((long)obj.getLong("dataround.id")));
                this.getModel().setValue(DEFAULTVALUE, (Object)numValue.toPlainString());
            }
        } else {
            String value = obj.getString(TEXTDEFAULTVALUE);
            int dataLength = obj.getInt("datalength");
            if (SWCStringUtils.isNotEmpty((String)value) && dataLength > 0 && value.length() > dataLength) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9ed8\u8ba4\u503c\u4e0d\u80fd\u8d85\u8fc7\u652f\u6301\u9879\u76ee\u8bbe\u7f6e\u7684\u6570\u636e\u957f\u5ea6\u3002", (String)"SupportItemEdit_0", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.getModel().setValue(DEFAULTVALUE, (Object)value);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operatekey = args.getOperateKey();
        if (SWCStringUtils.equals((String)operatekey, (String)"audit")) {
            this.getView().invokeOperation("refresh");
        } else if (SWCStringUtils.equals((String)operatekey, (String)"save") || SWCStringUtils.equals((String)operatekey, (String)"submit")) {
            this.getView().updateView();
        }
    }
}

